(function(){var P$=Clazz.newPackage("jalview.util"),I$=[[0,'java.net.URI','java.net.URL','jalview.util.LaunchUtils','jalview.util.ErrorLog']],I$0=I$[0],$I$=function(i,n,m){return m?$I$(i)[n].apply(null,m):((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "HttpUtils");

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

Clazz.newMeth(C$, 'isPlausibleUri$S',  function (s) {
if (s == null ) {
return false;
}if (C$.startsWithHttpOrHttps$S(s) || C$.isJalviewSchemeUri$S(s) ) {
return true;
}try {
var u=Clazz.new_($I$(1,1).c$$S,[s]);
if (s.startsWith$S("file:/")) {
return true;
}} catch (e) {
if (Clazz.exceptionOf(e,"java.net.URISyntaxException")){
return false;
} else {
throw e;
}
}
return false;
}, 1);

Clazz.newMeth(C$, 'isValidUrl$S',  function (url) {
var is=null;
try {
is=C$.openStream$java_net_URL(Clazz.new_($I$(2,1).c$$S,[url]));
if (is != null ) {
return true;
}} catch (x) {
if (Clazz.exceptionOf(x,"java.io.IOException")){
return false;
} else {
throw x;
}
} finally {
if (is != null ) {
try {
is.close$();
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
} else {
throw e;
}
}
}}
return false;
}, 1);

Clazz.newMeth(C$, 'startsWithHttpOrHttps$S',  function (file) {
return file.startsWith$S("http://") || file.startsWith$S("https://") ;
}, 1);

Clazz.newMeth(C$, 'checkUrlAvailable$java_net_URL$I',  function (url, readTimeout) {
var connection=url.openConnection$();
connection.setRequestMethod$S("HEAD");
connection.setDoInput$Z(true);
connection.setUseCaches$Z(false);
connection.setConnectTimeout$I(300);
connection.setReadTimeout$I(readTimeout);
var conn=C$.followConnection$java_net_HttpURLConnection(connection);
return conn.getResponseCode$() == 200;
}, 1);

Clazz.newMeth(C$, 'followConnection$java_net_HttpURLConnection',  function (conn0) {
return C$.followConnection$java_net_HttpURLConnection$Z(conn0, false);
}, 1);

Clazz.newMeth(C$, 'followConnection$java_net_HttpURLConnection$Z',  function (conn0, followAnyway) {
var url=conn0.getURL$();
if (url == null ) {
return conn0;
}if (!conn0.getInstanceFollowRedirects$()) {
return conn0;
}if (!"http".equals$O(url.getProtocol$()) && !followAnyway ) {
return conn0;
}var checkConn=url.openConnection$();
C$.httpURLConnectionCopyAttributes$java_net_HttpURLConnection$java_net_HttpURLConnection(conn0, checkConn);
var redirectToHttps=false;
var response=checkConn.getResponseCode$();
checkConn.disconnect$();
if (response >= 300 && response < 400 ) {
var loc=Clazz.new_([conn0.getHeaderField$S("Location")],$I$(2,1).c$$S);
if (loc != null  && "https".equals$O(loc.getProtocol$()) ) {
redirectToHttps=true;
url=loc;
}} else if (followAnyway) {
url=checkConn.getURL$();
}if (!redirectToHttps && !followAnyway ) {
return conn0;
}var conn=url.openConnection$();
C$.httpURLConnectionCopyAttributes$java_net_HttpURLConnection$java_net_HttpURLConnection(conn0, conn);
return conn;
}, 1);

Clazz.newMeth(C$, 'httpURLConnectionCopyAttributes$java_net_HttpURLConnection$java_net_HttpURLConnection',  function (conn0, conn1) {
conn1.setRequestMethod$S(conn0.getRequestMethod$());
conn1.setDoInput$Z(conn0.getDoInput$());
conn1.setUseCaches$Z(conn0.getUseCaches$());
conn1.setConnectTimeout$I(conn0.getConnectTimeout$());
conn1.setReadTimeout$I(conn0.getReadTimeout$());
conn1.setInstanceFollowRedirects$Z(conn0.getInstanceFollowRedirects$());
}, 1);

Clazz.newMeth(C$, 'openConnection$java_net_URL',  function (url) {
return C$.openConnection$java_net_URL$Z(url, false);
}, 1);

Clazz.newMeth(C$, 'openConnection$java_net_URL$Z',  function (url, followAnyway) {
if (url == null ) {
$I$(3,"syserr$Z$Z$S",[false, true, "HttpUtils.openConnection(url) called with null url"]);
return null;
}$I$(3,"syserr$Z$Z$S",[false, true, "HttpUtils.openConnection(url) called with url=" + url.toString()]);
var conn=null;
var protocol=url.getProtocol$();
if ("http".equals$O(protocol) || "https".equals$O(protocol) ) {
var conn0=url.openConnection$();
if (conn0 != null ) {
conn=C$.followConnection$java_net_HttpURLConnection$Z(conn0, followAnyway);
} else {
conn=conn0;
}} else {
conn=url.openConnection$();
}return conn;
}, 1);

Clazz.newMeth(C$, 'openStream$java_net_URL',  function (url) {
return C$.openStream$java_net_URL$Z(url, false);
}, 1);

Clazz.newMeth(C$, 'openStream$java_net_URL$Z',  function (url, followAnyway) {
if (url == null ) {
return null;
}var is=null;
var protocol=url.getProtocol$();
if ("http".equals$O(protocol) || "https".equals$O(protocol) ) {
var conn=C$.followConnection$java_net_HttpURLConnection$Z(url.openConnection$(), followAnyway);
if (conn != null ) {
is=conn.getInputStream$();
}} else {
is=url.openStream$();
}return is;
}, 1);

Clazz.newMeth(C$, 'isJalviewSchemeUri$S',  function (jalviewUriString) {
if (jalviewUriString == null ) {
return false;
}var jalviewUri;
try {
jalviewUri=Clazz.new_($I$(1,1).c$$S,[jalviewUriString]);
} catch (e) {
if (Clazz.exceptionOf(e,"java.net.URISyntaxException")){
return false;
} else {
throw e;
}
}
var scheme=jalviewUri.getScheme$();
if (scheme == null  || !scheme.startsWith$S("jalview") ) {
return false;
}var jspl="jalview".length$();
return scheme.length$() == jspl || scheme.length$() == jspl + 1  || scheme.substring$I(jspl).equals$O("http")  || scheme.substring$I(jspl).equals$O("https") ;
}, 1);

Clazz.newMeth(C$, 'equivalentJalviewUrl$S',  function (jalviewUriString) {
if (!C$.isJalviewSchemeUri$S(jalviewUriString)) {
return jalviewUriString;
}var jalviewUri;
try {
jalviewUri=Clazz.new_($I$(1,1).c$$S,[jalviewUriString]);
} catch (e) {
if (Clazz.exceptionOf(e,"java.net.URISyntaxException")){
return null;
} else {
throw e;
}
}
var scheme=jalviewUri.getScheme$();
var host=jalviewUri.getHost$();
if (host != null  && host.length$() > 0  || scheme.substring$I("jalview".length$()).startsWith$S("http") ) {
var newUri;
try {
newUri=Clazz.new_([scheme.equals$O("jalviewhttp") ? "http" : "https", jalviewUri.getUserInfo$(), host, jalviewUri.getPort$(), jalviewUri.getPath$(), jalviewUri.getQuery$(), jalviewUri.getFragment$()],$I$(1,1).c$$S$S$S$I$S$S$S);
return newUri.toURL$().toString();
} catch (e) {
if (Clazz.exceptionOf(e,"java.net.URISyntaxException") || Clazz.exceptionOf(e,"java.net.MalformedURLException")){
$I$(4).errPrintln$S("Trying to convert '" + jalviewUriString + "' to URL failed" );
} else {
throw e;
}
}
} else {
return jalviewUri.getPath$();
}return null;
}, 1);

Clazz.newMeth(C$);
})();
;Clazz.setTVer('3.3.1-v1');//Created 2025-12-08 15:28:56 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
