(function(){var P$=Clazz.newPackage("jalview.analysis"),p$1={},I$=[[0,'jalview.math.MiscMath','java.util.Arrays','java.util.ArrayList','java.util.TreeMap','java.util.Comparator','jalview.math.Matrix','jalview.bin.Console',['jalview.analysis.ccAnalysis','.TrustRegion'],'org.apache.commons.math3.linear.SingularValueDecomposition','org.apache.commons.math3.linear.Array2DRowRealMatrix']],I$0=I$[0],$I$=function(i,n,m){return m?$I$(i)[n].apply(null,m):((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "ccAnalysis", function(){
Clazz.newInstance(this, arguments,0,C$);
});
C$.$classes$=[['TrustRegion',2]];

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
this.dim=($b$[0] = 0, $b$[0]);
},1);

C$.$fields$=[['B',['dim'],'O',['scoresOld','jalview.math.MatrixI']]]

Clazz.newMeth(C$, 'c$$jalview_math_MatrixI$B',  function (scores, dim) {
;C$.$init$.apply(this);
for (var i=0; i < scores.height$(); i++) {
for (var j=0; j < scores.width$(); j++) {
if (!Double.isNaN$D(scores.getValue$I$I(i, j))) {
scores.setValue$I$I$D(i, j, Long.$dval(Math.round$D(scores.getValue$I$I(i, j) * 10000)) / 10000);
}}
}
this.scoresOld=scores;
this.dim=dim;
}, 1);

Clazz.newMeth(C$, 'initialiseDistrusts$BA$jalview_math_MatrixI',  function (hSigns, scores) {
var distrustScores=Clazz.array(Integer.TYPE, [scores.width$()]);
for (var i=0; i < scores.width$(); i++) {
var hASign=hSigns[i];
var conHypNum=0;
var proHypNum=0;
for (var j=0; j < scores.width$(); j++) {
var cell=scores.getRow$I(i)[j];
var hBSign=hSigns[j];
if (!Double.isNaN$D(cell)) {
var cellSign=($b$[0] = Math.signum(cell), $b$[0]);
if (cellSign == hASign * hBSign) {
++proHypNum;
} else {
++conHypNum;
}}}
distrustScores[i]=conHypNum - proHypNum;
}
return distrustScores;
}, p$1);

Clazz.newMeth(C$, 'optimiseHypothesis$BA$IA$jalview_math_MatrixI',  function (hSigns, distrustScores, scores) {
var maxes=$I$(1).findMax$IA(distrustScores);
var maxDistrustIndex=maxes[0];
var maxDistrust=maxes[1];
if (maxDistrust > 0) {
hSigns[$k$=maxDistrustIndex]=(hSigns[$k$]*(-1)|0);
distrustScores[maxDistrustIndex]*=-1;
var hASign=hSigns[maxDistrustIndex];
for (var NOTmaxDistrustIndex=0; NOTmaxDistrustIndex < distrustScores.length; NOTmaxDistrustIndex++) {
if (NOTmaxDistrustIndex != maxDistrustIndex) {
var hBSign=hSigns[NOTmaxDistrustIndex];
var cell=scores.getValue$I$I(maxDistrustIndex, NOTmaxDistrustIndex);
if (!Double.isNaN$D(cell)) {
var cellSign=($b$[0] = Math.signum(cell), $b$[0]);
if (cellSign == hASign * hBSign) {
distrustScores[NOTmaxDistrustIndex]-=2;
} else {
distrustScores[NOTmaxDistrustIndex]+=2;
}}}}
return p$1.optimiseHypothesis$BA$IA$jalview_math_MatrixI.apply(this, [hSigns, distrustScores, scores]);
} else {
return hSigns;
}}, p$1);

Clazz.newMeth(C$, 'run$',  function () {
var eigenMatrix=this.scoresOld.copy$();
var repMatrix=this.scoresOld.copy$();
try {
System.out.println$S("Input correlation matrix:");
eigenMatrix.print$java_io_PrintStream$S(System.out, "%1.4f ");
var matrixWidth=eigenMatrix.width$();
var matrixElementsTotal=(Math.pow(matrixWidth, 2)|0);
var correctionFactor=(matrixElementsTotal - eigenMatrix.countNaN$()) / matrixElementsTotal;
var hSigns=Clazz.array(Byte.TYPE, [matrixWidth]);
$I$(2).fill$BA$B(hSigns, 1);
hSigns=p$1.optimiseHypothesis$BA$IA$jalview_math_MatrixI.apply(this, [hSigns, p$1.initialiseDistrusts$BA$jalview_math_MatrixI.apply(this, [hSigns, eigenMatrix]), eigenMatrix]);
var hAbs=$I$(1,"sqrt$DA",[eigenMatrix.absolute$().meanRow$()]);
var hValues=$I$(1).elementwiseMultiply$BA$DA(hSigns, hAbs);
var estimatedPositions=Clazz.new_($I$(3,1));
for (var rowIndex=0; rowIndex < matrixWidth - 1; rowIndex++) {
for (var columnIndex=rowIndex + 1; columnIndex < matrixWidth; columnIndex++) {
var cell=eigenMatrix.getValue$I$I(rowIndex, columnIndex);
if (Double.isNaN$D(cell)) {
cell=hValues[rowIndex] * hValues[columnIndex];
eigenMatrix.setValue$I$I$D(rowIndex, columnIndex, cell);
eigenMatrix.setValue$I$I$D(columnIndex, rowIndex, cell);
estimatedPositions.add$O(Clazz.array(Integer.TYPE, -1, [rowIndex, columnIndex]));
}}
}
for (var diagonalIndex=0; diagonalIndex < matrixWidth; diagonalIndex++) {
var cell=Math.pow(hValues[diagonalIndex], 2);
eigenMatrix.setValue$I$I$D(diagonalIndex, diagonalIndex, cell);
estimatedPositions.add$O(Clazz.array(Integer.TYPE, -1, [diagonalIndex, diagonalIndex]));
}
System.out.print$S("initial values: [ ");
for (var h, $h = 0, $$h = hValues; $h<$$h.length&&((h=($$h[$h])),1);$h++) {
System.out.print$S(String.format$S$OA("%1.4f, ", Clazz.array(java.lang.Object, -1, [Double.valueOf$D(h)])));
}
System.out.println$S(" ]");
var hValuesOld=Clazz.array(Double.TYPE, [matrixWidth]);
var iterationCount=0;
while (true){
for (var hIndex=0; hIndex < matrixWidth; hIndex++) {
var newH=$I$(2,"stream$DA",[$I$(1,"elementwiseMultiply$DA$DA",[hValues, eigenMatrix.getRow$I(hIndex)])]).sum$() / $I$(2,"stream$DA",[$I$(1).elementwiseMultiply$DA$DA(hValues, hValues)]).sum$();
hValues[hIndex]=newH;
}
System.out.print$S(String.format$S$OA("iteration %d: [ ", Clazz.array(java.lang.Object, -1, [Integer.valueOf$I(iterationCount)])));
for (var h, $h = 0, $$h = hValues; $h<$$h.length&&((h=($$h[$h])),1);$h++) {
System.out.print$S(String.format$S$OA("%1.4f, ", Clazz.array(java.lang.Object, -1, [Double.valueOf$D(h)])));
}
System.out.println$S(" ]");
for (var pair, $pair = estimatedPositions.iterator$(); $pair.hasNext$()&&((pair=($pair.next$())),1);) {
var newVal=hValues[pair[0]] * hValues[pair[1]];
eigenMatrix.setValue$I$I$D(pair[0], pair[1], newVal);
eigenMatrix.setValue$I$I$D(pair[1], pair[0], newVal);
}
++iterationCount;
if ($I$(1).allClose$DA$DA$D$D$Z(hValues, hValuesOld, 0.0, 1.0E-5, false)) {
break;
}System.arraycopy$O$I$O$I$I(hValues, 0, hValuesOld, 0, hValues.length);
}
eigenMatrix.tred$();
eigenMatrix.tqli$();
System.out.println$S("eigenmatrix");
eigenMatrix.print$java_io_PrintStream$S(System.out, "%8.2f");
System.out.println$();
System.out.println$S("uncorrected eigenvalues");
eigenMatrix.printD$java_io_PrintStream$S(System.out, "%2.4f ");
System.out.println$();
var eigenVals=eigenMatrix.getD$();
var eigenPairs=Clazz.new_([$I$(5).reverseOrder$()],$I$(4,1).c$$java_util_Comparator);
for (var i=0; i < eigenVals.length; i++) {
eigenPairs.put$O$O(Double.valueOf$D(eigenVals[i]), Integer.valueOf$I(i));
}
var _repMatrix=Clazz.array(Double.TYPE, [eigenVals.length, this.dim]);
var _oldMatrix=Clazz.array(Double.TYPE, [eigenVals.length, this.dim]);
var correctedEigenValues=Clazz.array(Double.TYPE, [this.dim]);
var l=0;
for (var pair, $pair = eigenPairs.entrySet$().iterator$(); $pair.hasNext$()&&((pair=($pair.next$())),1);) {
var eigenValue=(pair.getKey$()).valueOf();
var column=(pair.getValue$()).$c();
var eigenVector=eigenMatrix.getColumn$I(column);
if (l >= 1) {
eigenValue/=correctionFactor;
}correctedEigenValues[l]=eigenValue;
for (var j=0; j < eigenVector.length; j++) {
_repMatrix[j][l]=(eigenValue < 0 ) ? 0.0 : -Math.sqrt(eigenValue) * eigenVector[j];
var tmpOldScore=this.scoresOld.getColumn$I(column)[j];
_oldMatrix[j][this.dim - l - 1 ]=(Double.isNaN$D(tmpOldScore)) ? 0.0 : tmpOldScore;
}
++l;
if (l >= this.dim) {
break;
}}
System.out.println$S("correctedEigenValues");
$I$(1).print$DA$S(correctedEigenValues, "%2.4f ");
repMatrix=Clazz.new_($I$(6,1).c$$DAA,[_repMatrix]);
repMatrix.setD$DA(correctedEigenValues);
var oldMatrix=Clazz.new_($I$(6,1).c$$DAA,[_oldMatrix]);
var dotMatrix=repMatrix.postMultiply$jalview_math_MatrixI(repMatrix.transpose$());
var rmsd=this.scoresOld.rmsd$jalview_math_MatrixI(dotMatrix);
System.out.println$S("iteration, rmsd, maxDiff, rmsdDiff");
System.out.println$S(String.format$S$OA("0, %8.5f, -, -", Clazz.array(java.lang.Object, -1, [Double.valueOf$D(rmsd)])));
for (var iteration=1; iteration < 21; iteration++) {
var repMatrixOLD=repMatrix.copy$();
var dotMatrixOLD=dotMatrix.copy$();
for (var hAIndex=0; hAIndex < oldMatrix.height$(); hAIndex++) {
var row=oldMatrix.getRow$I(hAIndex);
var hA=repMatrix.getRow$I(hAIndex);
hAIndex=hAIndex;
var hAlsm=p$1.leastSquaresOptimisation$jalview_math_MatrixI$jalview_math_MatrixI$I.apply(this, [repMatrix, this.scoresOld, hAIndex]);
for (var j=0; j < repMatrix.width$(); j++) {
repMatrix.setValue$I$I$D(hAIndex, j, hAlsm[j]);
}
}
dotMatrix=repMatrix.postMultiply$jalview_math_MatrixI(repMatrix.transpose$());
rmsd=this.scoresOld.rmsd$jalview_math_MatrixI(dotMatrix);
var diff=repMatrix.subtract$jalview_math_MatrixI(repMatrixOLD).absolute$();
var maxDiff=0.0;
for (var i=0; i < diff.height$(); i++) {
for (var j=0; j < diff.width$(); j++) {
maxDiff=(diff.getValue$I$I(i, j) > maxDiff ) ? diff.getValue$I$I(i, j) : maxDiff;
}
}
var rmsdDiff=dotMatrix.rmsd$jalview_math_MatrixI(dotMatrixOLD);
System.out.println$S(String.format$S$OA("%d, %8.5f, %8.5f, %8.5f", Clazz.array(java.lang.Object, -1, [Integer.valueOf$I(iteration), Double.valueOf$D(rmsd), Double.valueOf$D(maxDiff), Double.valueOf$D(rmsdDiff)])));
if (!(Math.abs(maxDiff) > 1.0E-6 )) {
repMatrix=repMatrixOLD.copy$();
break;
}}
} catch (q) {
if (Clazz.exceptionOf(q,"Exception")){
$I$(7,"error$S",["Error computing cc_analysis:  " + q.getMessage$()]);
q.printStackTrace$();
} else {
throw q;
}
}
System.out.println$S("final coordinates:");
repMatrix.print$java_io_PrintStream$S(System.out, "%1.8f ");
return repMatrix;
});

Clazz.newMeth(C$, 'originalToEquasionSystem$DA$jalview_math_MatrixI$jalview_math_MatrixI$I',  function (hA, repMatrix, scoresOld, hAIndex) {
var originalRow=scoresOld.getRow$I(hAIndex);
var nans=$I$(1).countNaN$DA(originalRow);
var result=Clazz.array(Double.TYPE, [originalRow.length - nans]);
var resultIndex=0;
for (var hBIndex=0; hBIndex < originalRow.length; hBIndex++) {
var pairwiseCC=originalRow[hBIndex];
if (!Double.isNaN$D(pairwiseCC)) {
var hB=repMatrix.getRow$I(hBIndex);
result[resultIndex++]=$I$(1,"sum$DA",[$I$(1).elementwiseMultiply$DA$DA(hA, hB)]) - pairwiseCC;
} else {
}}
return result;
}, p$1);

Clazz.newMeth(C$, 'approximateDerivative$jalview_math_MatrixI$jalview_math_MatrixI$I',  function (repMatrix, scoresOld, hAIndex) {
var hA=repMatrix.getRow$I(hAIndex);
var f0=p$1.originalToEquasionSystem$DA$jalview_math_MatrixI$jalview_math_MatrixI$I.apply(this, [hA, repMatrix, scoresOld, hAIndex]);
var signX0=Clazz.array(Double.TYPE, [hA.length]);
var xAbs=Clazz.array(Double.TYPE, [hA.length]);
for (var i=0; i < hA.length; i++) {
signX0[i]=(hA[i] >= 0 ) ? 1 : -1;
xAbs[i]=(Math.abs(hA[i]) >= 1.0 ) ? Math.abs(hA[i]) : 1.0;
}
var rstep=Math.pow(Math.ulp$D(1.0), 0.5);
var h=Clazz.array(Double.TYPE, [hA.length]);
for (var i=0; i < hA.length; i++) {
h[i]=rstep * signX0[i] * xAbs[i] ;
}
var m=f0.length;
var n=hA.length;
var jTransposed=Clazz.array(Double.TYPE, [n, m]);
for (var i=0; i < h.length; i++) {
var x=Clazz.array(Double.TYPE, [h.length]);
System.arraycopy$O$I$O$I$I(hA, 0, x, 0, h.length);
x[i]+=h[i];
var dx=x[i] - hA[i];
var df=p$1.originalToEquasionSystem$DA$jalview_math_MatrixI$jalview_math_MatrixI$I.apply(this, [x, repMatrix, scoresOld, hAIndex]);
for (var j=0; j < df.length; j++) {
df[j]-=f0[j];
jTransposed[i][j]=df[j] / dx;
}
}
var J=Clazz.new_($I$(6,1).c$$DAA,[jTransposed]).transpose$();
return J;
}, p$1);

Clazz.newMeth(C$, 'phiAndDerivative$D$DA$DA$D',  function (alpha, suf, s, Delta) {
var denom=$I$(1,"elementwiseAdd$DA$D",[$I$(1).elementwiseMultiply$DA$DA(s, s), alpha]);
var pNorm=$I$(1,"norm$DA",[$I$(1).elementwiseDivide$DA$DA(suf, denom)]);
var phi=pNorm - Delta;
var phiPrime=-$I$(1,"sum$DA",[$I$(1,"elementwiseDivide$DA$DA",[$I$(1).elementwiseMultiply$DA$DA(suf, suf), $I$(1,"elementwiseMultiply$DA$DA",[$I$(1).elementwiseMultiply$DA$DA(denom, denom), denom])])]) / pNorm;
return Clazz.array(Double.TYPE, -1, [phi, phiPrime]);
}, p$1);

Clazz.newMeth(C$, 'solveLsqTrustRegion$I$I$DA$DA$jalview_math_MatrixI$D$D',  function (n, m, uf, s, V, Delta, alpha) {
var suf=$I$(1).elementwiseMultiply$DA$DA(s, uf);
var fullRank=false;
if (m >= n) {
var threshold=s[0] * Math.ulp$D(1.0) * m ;
fullRank=s[s.length - 1] > threshold ;
}if (fullRank) {
var p=$I$(1,"elementwiseMultiply$DA$D",[V.sumProduct$DA($I$(1).elementwiseDivide$DA$DA(uf, s)), -1]);
if ($I$(1).norm$DA(p) <= Delta ) {
var result=Clazz.new_($I$(8,1).c$$DA$D$I,[this, null, p, 0.0, 0]);
return result;
}}var alphaUpper=$I$(1).norm$DA(suf) / Delta;
var alphaLower=0.0;
if (fullRank) {
var phiAndPrime=p$1.phiAndDerivative$D$DA$DA$D.apply(this, [0.0, suf, s, Delta]);
alphaLower=-phiAndPrime[0] / phiAndPrime[1];
}alpha=(!fullRank && alpha == 0.0  ) ? alpha=Math.max(0.001 * alphaUpper, Math.pow(alphaLower * alphaUpper, 0.5)) : alpha;
var iteration=0;
while (iteration < 10){
alpha=(alpha < alphaLower  || alpha > alphaUpper  ) ? alpha=Math.max(0.001 * alphaUpper, Math.pow(alphaLower * alphaUpper, 0.5)) : alpha;
var phiAndPrime=p$1.phiAndDerivative$D$DA$DA$D.apply(this, [alpha, suf, s, Delta]);
var phi=phiAndPrime[0];
var phiPrime=phiAndPrime[1];
alphaUpper=(phi < 0 ) ? alpha : alphaUpper;
var ratio=phi / phiPrime;
alphaLower=Math.max(alphaLower, alpha - ratio);
alpha-=(phi + Delta) * ratio / Delta;
if (Math.abs(phi) < 0.01 * Delta ) {
break;
}++iteration;
}
var tmp=$I$(1,"elementwiseDivide$DA$DA",[suf, $I$(1,"elementwiseAdd$DA$D",[$I$(1).elementwiseMultiply$DA$DA(s, s), alpha])]);
var p=$I$(1,"elementwiseMultiply$DA$D",[V.sumProduct$DA(tmp), -1]);
p=$I$(1,"elementwiseMultiply$DA$D",[p, Delta / $I$(1).norm$DA(p)]);
var result=Clazz.new_($I$(8,1).c$$DA$D$I,[this, null, p, alpha, iteration + 1]);
return result;
}, p$1);

Clazz.newMeth(C$, 'evaluateQuadratic$jalview_math_MatrixI$DA$DA',  function (J, g, s) {
var Js=J.sumProduct$DA(s);
var q=$I$(1).dot$DA$DA(Js, Js);
var l=$I$(1).dot$DA$DA(s, g);
return 0.5 * q + l;
}, p$1);

Clazz.newMeth(C$, 'updateTrustRegionRadius$D$D$D$D$Z',  function (Delta, actualReduction, predictedReduction, stepNorm, boundHit) {
var ratio=0;
if (predictedReduction > 0 ) {
ratio=actualReduction / predictedReduction;
} else if (predictedReduction == 0  && actualReduction == 0  ) {
ratio=1;
} else {
ratio=0;
}if (ratio < 0.25 ) {
Delta=0.25 * stepNorm;
} else if (ratio > 0.75  && boundHit ) {
Delta*=2.0;
}return Clazz.array(Double.TYPE, -1, [Delta, ratio]);
}, p$1);

Clazz.newMeth(C$, 'trf$jalview_math_MatrixI$jalview_math_MatrixI$I$jalview_math_MatrixI',  function (repMatrix, scoresOld, index, J) {
var hA=repMatrix.getRow$I(index);
var f0=p$1.originalToEquasionSystem$DA$jalview_math_MatrixI$jalview_math_MatrixI$I.apply(this, [hA, repMatrix, scoresOld, index]);
var nfev=1;
var m=J.height$();
var n=J.width$();
var cost=0.5 * $I$(1).dot$DA$DA(f0, f0);
var g=J.transpose$().sumProduct$DA(f0);
var Delta=$I$(1).norm$DA(hA);
var maxNfev=hA.length * 100;
var alpha=0.0;
var gNorm=0;
var terminationStatus=false;
var iteration=0;
while (true){
gNorm=$I$(1).norm$DA(g);
if (terminationStatus || nfev == maxNfev ) {
break;
}var svd=Clazz.new_([Clazz.new_([J.asArray$()],$I$(10,1).c$$DAA)],$I$(9,1).c$$org_apache_commons_math3_linear_RealMatrix);
var U=Clazz.new_([svd.getU$().getData$()],$I$(6,1).c$$DAA);
var s=svd.getSingularValues$();
var V=Clazz.new_([svd.getV$().getData$()],$I$(6,1).c$$DAA).transpose$();
var uf=U.transpose$().sumProduct$DA(f0);
var actualReduction=-1;
var xNew=Clazz.array(Double.TYPE, [hA.length]);
var fNew=Clazz.array(Double.TYPE, [f0.length]);
var costNew=0;
var stepHnorm=0;
while (actualReduction <= 0  && nfev < maxNfev ){
var trustRegion=p$1.solveLsqTrustRegion$I$I$DA$DA$jalview_math_MatrixI$D$D.apply(this, [n, m, uf, s, V, Delta, alpha]);
var stepH=trustRegion.getStep$();
alpha=trustRegion.getAlpha$();
var nIterations=trustRegion.getIteration$();
var predictedReduction=-(p$1.evaluateQuadratic$jalview_math_MatrixI$DA$DA.apply(this, [J, g, stepH]));
xNew=$I$(1).elementwiseAdd$DA$DA(hA, stepH);
fNew=p$1.originalToEquasionSystem$DA$jalview_math_MatrixI$jalview_math_MatrixI$I.apply(this, [xNew, repMatrix, scoresOld, index]);
++nfev;
stepHnorm=$I$(1).norm$DA(stepH);
if ($I$(1).countNaN$DA(fNew) > 0) {
Delta=0.25 * stepHnorm;
continue;
}costNew=0.5 * $I$(1).dot$DA$DA(fNew, fNew);
actualReduction=cost - costNew;
var updatedTrustRegion=p$1.updateTrustRegionRadius$D$D$D$D$Z.apply(this, [Delta, actualReduction, predictedReduction, stepHnorm, stepHnorm > (0.95 * Delta) ]);
var DeltaNew=updatedTrustRegion[0];
var ratio=updatedTrustRegion[1];
var ftolSatisfied=actualReduction < (1.0E-8 * cost)  && ratio > 0.25  ;
var xtolSatisfied=stepHnorm < (1.0E-8 * (1.0E-8 + $I$(1).norm$DA(hA))) ;
terminationStatus=ftolSatisfied || xtolSatisfied ;
if (terminationStatus) {
break;
}alpha*=Delta / DeltaNew;
Delta=DeltaNew;
}
if (actualReduction > 0 ) {
hA=xNew;
f0=fNew;
cost=costNew;
J=p$1.approximateDerivative$jalview_math_MatrixI$jalview_math_MatrixI$I.apply(this, [repMatrix, scoresOld, index]);
g=J.transpose$().sumProduct$DA(f0);
} else {
stepHnorm=0;
actualReduction=0;
}++iteration;
}
return hA;
}, p$1);

Clazz.newMeth(C$, 'leastSquaresOptimisation$jalview_math_MatrixI$jalview_math_MatrixI$I',  function (repMatrix, scoresOld, index) {
var J=p$1.approximateDerivative$jalview_math_MatrixI$jalview_math_MatrixI$I.apply(this, [repMatrix, scoresOld, index]);
var result=p$1.trf$jalview_math_MatrixI$jalview_math_MatrixI$I$jalview_math_MatrixI.apply(this, [repMatrix, scoresOld, index, J]);
return result;
}, p$1);
var $b$ = new Int8Array(1);
var $k$;
;
(function(){/*c*/var C$=Clazz.newClass(P$.ccAnalysis, "TrustRegion", function(){
Clazz.newInstance(this, arguments[0],true,C$);
});

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

C$.$fields$=[['D',['alpha'],'I',['iteration'],'O',['step','double[]']]]

Clazz.newMeth(C$, 'c$$DA$D$I',  function (step, alpha, iteration) {
;C$.$init$.apply(this);
this.step=step;
this.alpha=alpha;
this.iteration=iteration;
}, 1);

Clazz.newMeth(C$, 'getStep$',  function () {
return this.step;
});

Clazz.newMeth(C$, 'getAlpha$',  function () {
return this.alpha;
});

Clazz.newMeth(C$, 'getIteration$',  function () {
return this.iteration;
});

Clazz.newMeth(C$);
})()

Clazz.newMeth(C$);
})();
;Clazz.setTVer('3.3.1-v1');//Created 2025-12-03 14:13:43 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
