(function(){var P$=Clazz.newPackage("jalview.util"),I$=[[0,'jalview.bin.Cache','jalview.bin.Console','java.util.ArrayList','jalview.datamodel.SequenceI']],I$0=I$[0],$I$=function(i,n){return((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "Comparison");

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

C$.$fields$=[[]
,['Z',['NUCLEOTIDE_AMBIGUITY_DETECTION'],'I',['NUCLEOTIDE_COUNT_PERCENT','NUCLEOTIDE_COUNT_LONG_SEQUENCE_AMBIGUITY_PERCENT','NUCLEOTIDE_COUNT_SHORT_SEQUENCE','NUCLEOTIDE_COUNT_VERY_SHORT_SEQUENCE'],'S',['GapChars']]]

Clazz.newMeth(C$, 'compare$jalview_datamodel_SequenceI$jalview_datamodel_SequenceI',  function (ii, jj) {
return C$.compare$jalview_datamodel_SequenceI$jalview_datamodel_SequenceI$I$I(ii, jj, 0, ii.getLength$() - 1);
}, 1);

Clazz.newMeth(C$, 'compare$jalview_datamodel_SequenceI$jalview_datamodel_SequenceI$I$I',  function (ii, jj, start, end) {
var si=ii.getSequenceAsString$();
var sj=jj.getSequenceAsString$();
var ilen=si.length$() - 1;
var jlen=sj.length$() - 1;
while (C$.isGap$C(si.charAt$I(start + ilen))){
--ilen;
}
while (C$.isGap$C(sj.charAt$I(start + jlen))){
--jlen;
}
var match=0;
var pid=-1;
if (ilen > jlen) {
for (var j=0; j < jlen; j++) {
if (si.substring$I$I(start + j, start + j + 1 ).equals$O(sj.substring$I$I(start + j, start + j + 1 ))) {
++match;
}}
pid=match / ilen * 100;
} else {
for (var j=0; j < jlen; j++) {
if (si.substring$I$I(start + j, start + j + 1 ).equals$O(sj.substring$I$I(start + j, start + j + 1 ))) {
++match;
}}
pid=match / jlen * 100;
}return pid;
}, 1);

Clazz.newMeth(C$, 'PID$S$S',  function (seq1, seq2) {
return C$.PID$S$S$I$I(seq1, seq2, 0, seq1.length$());
}, 1);

Clazz.newMeth(C$, 'PID$S$S$I$I',  function (seq1, seq2, start, end) {
return C$.PID$S$S$I$I$Z$Z(seq1, seq2, start, end, true, false);
}, 1);

Clazz.newMeth(C$, 'PID$S$S$I$I$Z$Z',  function (seq1, seq2, start, end, wcGaps, ungappedOnly) {
var s1len=seq1.length$();
var s2len=seq2.length$();
var len=Math.min(s1len, s2len);
if (end < len) {
len=end;
}if (len < start) {
start=len - 1;
}var elen=len - start;
var bad=0;
var chr1;
var chr2;
var agap;
for (var i=start; i < len; i++) {
chr1=seq1.charAt$I(i);
chr2=seq2.charAt$I(i);
agap=C$.isGap$C(chr1) || C$.isGap$C(chr2) ;
if ("a" <= chr1 && chr1 <= "z" ) {
chr1 = String.fromCharCode(chr1.$c()- 32);
}if ("a" <= chr2 && chr2 <= "z" ) {
chr2 = String.fromCharCode(chr2.$c()- 32);
}if (chr1 != chr2) {
if (agap) {
if (ungappedOnly) {
--elen;
} else if (!wcGaps) {
++bad;
}} else {
++bad;
}}}
if (elen < 1) {
return 0.0;
}return (100.0 * (elen - bad)) / elen;
}, 1);

Clazz.newMeth(C$, 'isGap$C',  function (c) {
return c == "-" || c == "."  || c == " " ;
}, 1);

Clazz.newMeth(C$, 'isNucleotide$jalview_datamodel_SequenceI',  function (seq) {
if (seq == null  || seq.getLength$() == 0 ) {
return false;
}var ntCount=0;
var aaCount=0;
var nCount=0;
var xCount=0;
var ntaCount=0;
var len=seq.getLength$();
for (var i=0; i < len; i++) {
var c=seq.getCharAt$I(i);
if (C$.isNucleotide$C(c)) {
(ntCount=Long.$inc(ntCount,1));
} else if (!C$.isGap$C(c)) {
(aaCount=Long.$inc(aaCount,1));
if (C$.isN$C(c)) {
(nCount=Long.$inc(nCount,1));
} else {
if (C$.isX$C(c)) {
(xCount=Long.$inc(xCount,1));
}if (C$.isNucleotideAmbiguity$C(c)) {
(ntaCount=Long.$inc(ntaCount,1));
}}}}
var allCount=Long.$add(ntCount,aaCount);
if (C$.NUCLEOTIDE_AMBIGUITY_DETECTION) {
$I$(2).debug$S("Performing new nucleotide detection routine");
if (Long.$gt(allCount,C$.NUCLEOTIDE_COUNT_SHORT_SEQUENCE )) {
return Long.$ge(Long.$mul(ntCount,100),Long.$mul(C$.NUCLEOTIDE_COUNT_PERCENT,allCount) ) && Long.$ge(Long.$mul(100,(Long.$add(ntCount,nCount , ntaCount ))),Long.$mul(C$.NUCLEOTIDE_COUNT_LONG_SEQUENCE_AMBIGUITY_PERCENT,allCount) ) ;
} else if (Long.$gt(allCount,C$.NUCLEOTIDE_COUNT_VERY_SHORT_SEQUENCE )) {
if (Long.$ge(Long.$mul(ntCount,100),Long.$mul(C$.NUCLEOTIDE_COUNT_PERCENT,allCount) ) && (Long.$eq(nCount,aaCount ) || Long.$eq(xCount,aaCount ) ) ) {
return true;
}return C$.myShortSequenceNucleotideProportionCount$J$J(ntCount, allCount) && Long.$eq(Long.$add(nCount,ntaCount),aaCount ) ;
} else {
return Long.$gt(ntCount,0 ) && Long.$eq(ntCount,allCount ) ;
}} else {
$I$(2).debug$S("Performing old nucleotide detection routine");
if (Long.$gt(Long.$mul((Long.$add(ntCount,nCount)),100),Long.$mul(85,allCount) )) {
return Long.$gt(ntCount,0 );
}}return false;
}, 1);

Clazz.newMeth(C$, 'myShortSequenceNucleotideProportionCount$J$J',  function (ntCount, allCount) {
var LHS=Long.$mul(100,allCount * (C$.NUCLEOTIDE_COUNT_SHORT_SEQUENCE - C$.NUCLEOTIDE_COUNT_VERY_SHORT_SEQUENCE) , (Long.$add(Long.$sub(ntCount,allCount),1)) );
var RHS=Long.$mul(allCount,(Long.$sub(allCount,C$.NUCLEOTIDE_COUNT_VERY_SHORT_SEQUENCE)) , (Long.$add(Long.$sub(Long.$mul(allCount,C$.NUCLEOTIDE_COUNT_PERCENT),Long.$mul(100,allCount)),100)) );
return Long.$ge(LHS,RHS );
}, 1);

Clazz.newMeth(C$, 'isNucleotide$jalview_datamodel_SequenceIA',  function (seqs) {
if (seqs == null ) {
return false;
}var na=false;
for (var seq, $seq = 0, $$seq = seqs; $seq<$$seq.length&&((seq=($$seq[$seq])),1);$seq++) {
if (seq == null ) {
continue;
}na=true;
if (seq.isProtein$()) {
return false;
}}
return na;
}, 1);

Clazz.newMeth(C$, 'isNucleotide$C',  function (c) {
return C$.isNucleotide$C$Z(c, false);
}, 1);

Clazz.newMeth(C$, 'isNucleotide$C$Z',  function (c, includeAmbiguity) {
var C=Character.toUpperCase$C(c);
switch (C.$c()) {
case 65:
case 67:
case 71:
case 84:
case 85:
return true;
}
if (includeAmbiguity) {
var ambiguity=C$.isNucleotideAmbiguity$C(C);
if (ambiguity) return true;
}return false;
}, 1);

Clazz.newMeth(C$, 'isNucleotideAmbiguity$C',  function (c) {
switch ((Character.toUpperCase$C(c)).$c()) {
case 73:
case 88:
case 82:
case 89:
case 87:
case 83:
case 77:
case 75:
case 66:
case 72:
case 68:
case 86:
return true;
case 78:
}
return false;
}, 1);

Clazz.newMeth(C$, 'isN$C',  function (c) {
return "n" == Character.toLowerCase$C(c);
}, 1);

Clazz.newMeth(C$, 'isX$C',  function (c) {
return "x" == Character.toLowerCase$C(c);
}, 1);

Clazz.newMeth(C$, 'isNucleotideSequence$S$Z',  function (s, allowGaps) {
return C$.isNucleotideSequence$S$Z$Z(s, allowGaps, false);
}, 1);

Clazz.newMeth(C$, 'isNucleotideSequence$S$Z$Z',  function (s, allowGaps, includeAmbiguous) {
if (s == null ) {
return false;
}for (var i=0; i < s.length$(); i++) {
var c=s.charAt$I(i);
if (!C$.isNucleotide$C$Z(c, includeAmbiguous)) {
if (!allowGaps || !C$.isGap$C(c) ) {
return false;
}}}
return true;
}, 1);

Clazz.newMeth(C$, 'isNucleotide$jalview_datamodel_SequenceIAA',  function (seqs) {
if (seqs == null ) {
return false;
}var flattened=Clazz.new_($I$(3,1));
for (var ss, $ss = 0, $$ss = seqs; $ss<$$ss.length&&((ss=($$ss[$ss])),1);$ss++) {
for (var s, $s = 0, $$s = ss; $s<$$s.length&&((s=($$s[$s])),1);$s++) {
flattened.add$O(s);
}
}
var oneDArray=flattened.toArray$OA(Clazz.array($I$(4), [flattened.size$()]));
return C$.isNucleotide$jalview_datamodel_SequenceIA(oneDArray);
}, 1);

Clazz.newMeth(C$, 'isSameResidue$C$C$Z',  function (c1, c2, caseSensitive) {
return caseSensitive ? c1 == c2 : Character.toUpperCase$C(c1) == Character.toUpperCase$C(c2);
}, 1);

C$.$static$=function(){C$.$static$=0;
C$.GapChars= String.instantialize(Clazz.array(Character.TYPE, -1, [" ", ".", "-"]));
{
C$.NUCLEOTIDE_COUNT_PERCENT=$I$(1).getDefault$S$I("NUCLEOTIDE_COUNT_PERCENT", 55);
C$.NUCLEOTIDE_COUNT_LONG_SEQUENCE_AMBIGUITY_PERCENT=$I$(1).getDefault$S$I("NUCLEOTIDE_COUNT_LONG_SEQUENCE_AMBIGUITY_PERCENT", 95);
C$.NUCLEOTIDE_COUNT_SHORT_SEQUENCE=$I$(1).getDefault$S$I("NUCLEOTIDE_COUNT_SHORT", 100);
C$.NUCLEOTIDE_COUNT_VERY_SHORT_SEQUENCE=$I$(1).getDefault$S$I("NUCLEOTIDE_COUNT_VERY_SHORT", 4);
C$.NUCLEOTIDE_AMBIGUITY_DETECTION=$I$(1).getDefault$S$Z("NUCLEOTIDE_AMBIGUITY_DETECTION", true);
};
};

Clazz.newMeth(C$);
})();
;Clazz.setTVer('3.3.1-v1');//Created 2025-11-20 11:18:09 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
