package uk.ac.dundee.compbio.slivkaclient;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class MainSlivkaTest {

  static SlivkaClient client = SlivkaClient.newInstance(
      URI.create("http://www.compbio.dundee.ac.uk/slivka/"));

  public static void main(String[] args) throws Throwable {
    SlivkaService service = client.getService("example");
    printf("service %s found%n", service.name);
    for (Parameter param : service.getParameters()) {
      println(param.id);
      println(param.description);
      if (param.getType().equals("text")) {
        println((String) param.defaultValue);
      }
    }
    var req = new RequestValues();
    req.addData("rep", "value1");
    req.addData("rep", "value2");
    req.addData("arg", "argument");
    String jobId = client.submitJob(service, req);
    println(jobId);
    var executor = Executors.newSingleThreadScheduledExecutor();

    class MyRunnable implements Runnable {
      @Override public void run() {
        println("polling job");
        try {
          var status =  client.fetchJobStatus(jobId);
          printf("status is %s%n", status);
          if (status != Job.Status.COMPLETED) {
            executor.schedule(this, 500, TimeUnit.MILLISECONDS);
          }
          else {
            processResults(client.fetchFilesList(jobId));
            executor.shutdown();
          }
        } catch (IOException e) {
          e.printStackTrace();
        }
      }
    }
    executor.schedule(new MyRunnable(), 500, TimeUnit.MILLISECONDS);
  }

  public static void processResults(Collection<RemoteFile> files) throws IOException {
    for (RemoteFile file : files) {
      println(file.getLabel());
    }
  }



  public static void println(Object obj) {
    System.out.println(obj);
  }

  public static void printf(String fmt, Object...objects) {
    System.out.format(fmt, objects);
  }
}
