# How to add a web service backend to Jalview's web services UI

### Document Status: *Work in progress !*

There are two phases to services.

 *Discovery* threads are started by jalview.gui.Desktop (or other UI components or the CLI if they are headless services accessible via commandline). Your service discovery thread registers discovered instances so they can be accessed by the user.

 *Access* most services are accessed by selecting a menu item, option, or specifying a nickname for the service instance as a Jalview command line parameter. Different access patterns are used for the various services: seqeunce data source, sequence feature annotation source, multiple sequence alignment, multiple alignment annotation source, etc. There should be no need for your code to create UI components (if there is then Jalview's UI needs to be refactored to avoid this).

## Discovery

*jalview.gui.Desktop*
- start a discovery thread to discover services provided by your framework. The discoverer should generate a list of objects that either implement WsMenuEntryProviderI or provide another mechanism to add themselves to Jalview's menus (via jalview.gui.AlignFrame.BuildWebServiceMenu() below)

*jalview.gui.AlignFrame*
- BuildWebServiceMenu()
 This method creates a runnable that's called when the available set of web services changes (e.g. when a discovery thread completes). Add code to the Runnable's run method to create Menu Items in the web services menu via jalview.ws.WSMenuEntryProviderI instances generated by your discoverer. 


## Types of service

### Services that create new alignments or windows, optionally with a progress log

The pattern for these services requires a Client that initates a thread which creates, and montors one or more jobs based on input data.

jalview.ws.MsaWSClient -- currently does double duty with Jaba services for alignment analysis and instantiation of alignment services.

jalview.ws.gui.MSAThread -- UI model and controller for a running MSA service. Instantiated with an instance of jalview.ws.MultipleSequenceAlignmentI provided by the service endpoint factory.


## Other classes of interest

### jalview.ws.api

Interfaces and base classes to be implemented and used by a service endpoint.

 jalview.ws.api.CancellableI.java - implement if the service is cancellable
 jalview.ws.api.JalviewWebServiceI.java - base service interface
 jalview.ws.api.JobId.java - a timestamped job id that can be saved in a Jalview project

#### submission interfaces
jalview.ws.api.MsaI.java
jalview.ws.api.MsaWithGuideTreeI.java


#### result interfaces
jalview.ws.api.MsaResultI.java
jalview.ws.api.TreeResultI.java
jalview.ws.api.DistanceMatrixResultI.java


#### minimal composed interfaces for a complete functional analysis 

jalview.ws.api.MultipleSequenceAlignmentI.java


#### base class for a service endpoint instance - to be materialised by service discoverers

jalview.ws.api.UIinfo.java - basic information 
jalview.ws.api.ServiceWithParameters.java

jalview.ws.api.JalviewServiceEndpointProviderI - implemented by service endpoint factories (typically extended from UIinfo or ServiceWithParameters).


## Analysis services

These have not yet been refactored. Feel free to look at how jalview.ws.jws2.AACons and Disorder clients operate and adapt the pattern for your own services. The Groovy example in the help [[help/html/groovy/featuresCounter.html]] for creating custom annotation tracks uses the same basic 'alignment analysis worker' mechanism to provide dynamically executed alignment analysis calculations that result in annotation tracks displayed below the alginment.
