# public interface JalviewJSApi

## full list of available methods (from JalviewLiteJsApi):

  public boolean addPdbFile(AlignFrame alFrame, String sequenceId, String pdbEntryString, String pdbFile);
  public String getAlignment(String format);
  public String getAlignment(String format, String suffix);
  public String getAlignmentFrom(AlignFrame alf, String format);
  public String getAlignmentFrom(AlignFrame alf, String format, String suffix);
  public String getAlignmentOrder();
  public String getAlignmentOrderFrom(AlignFrame alf);
  public String getAlignmentOrderFrom(AlignFrame alf, String sep);
  public String getAnnotation();
  public String getAnnotationFrom(AlignFrame alf);
  public Object getAppletParameter(String name, boolean asString);
  public URL getCodeBase();
  public URL getDocumentBase();
  public String getFeatureGroups();
  public String getFeatureGroupsOfState(boolean visible);
  public String getFeatureGroupsOfStateOn(AlignFrame alf, boolean visible);
  public String getFeatureGroupsOn(AlignFrame alf);
  public String getFeatures(String format);
  public String getFeaturesFrom(AlignFrame alf, String format);
  public Object getFrameForSource(VamsasSource source);
  public String getParameter(String name);
  public String getSelectedSequences();
  public String getSelectedSequences(String sep);
  public String getSelectedSequencesAsAlignment(String format, String suffix);
  public String getSelectedSequencesAsAlignmentFrom(AlignFrame alf, String format, String suffix);
  public String getSelectedSequencesFrom(AlignFrame alf);
  public String getSelectedSequencesFrom(AlignFrame alf, String sep);
  public String getSeparator();
  public AlignViewportI getViewport();
  public void highlight(String sequenceId, String position, String alignedPosition);
  public void highlightIn(AlignFrame alf, String sequenceId, String position, String alignedPosition);
  public AlignFrame loadAlignment(String text, String title);
  public void loadAnnotation(String annotation);
  public void loadAnnotationFrom(AlignFrame alf, String annotation);
  public void loadFeatures(String features, boolean autoenabledisplay);
  public boolean loadFeaturesFrom(AlignFrame alf, String features, boolean autoenabledisplay);
  public boolean loadScoreFile(String sScoreFile) throws IOException;
  public void newFeatureSettings();
  public void newStructureView(PDBEntry pdb, SequenceI[] seqs, String[] chains, DataSourceType protocol);
  public Object openPcaPanel(AlignFrame af, String modelName);
  public Object openTreePanel(AlignFrame af, String treeType, String modelName);
  public String orderAlignmentBy(AlignFrame alf, String order, String undoName, String sep);
  public String orderBy(String order, String undoName);
  public String orderBy(String order, String undoName, String sep);
  public Object parseArguments(String[] args);
  public boolean parseFeaturesFile(String param, DataSourceType protocol);
  public void removeSelectionListener(AlignFrame af, String listener);
  public void scrollViewToColumnIn(AlignFrame alf, String leftHandColumn);
  public void scrollViewToIn(AlignFrame alf, String topRow, String leftHandColumn);
  public void scrollViewToRowIn(AlignFrame alf, String topRow);
  public void select(String sequenceIds, String columns);
  public void select(String sequenceIds, String columns, String sep);
  public void selectIn(AlignFrame alf, String sequenceIds, String columns);
  public void selectIn(AlignFrame alf, String sequenceIds, String columns, String sep);
  public void setFeatureGroupState(String groups, boolean state);
  public void setFeatureGroupState(String[] groups, boolean state);
  public void setFeatureGroupStateOn(AlignFrame alf, String groups, boolean state);
  public void setSelectionListener(AlignFrame af, String listener);
  public void setSelectionListener(String listener);
  public void setSeparator(String separator);
  public void showOverview();
  public void updateForAnnotations();

## addition available methods (from JalviewLite):

  public static String getBuildDate()
  public static String getInstallation()
  public static String getVersion()



## proposed alias list:
 
- remove overloaded methods
- indicate null options
- use standard arrays; no need for special separators
- possibly return more actual objects, not just strings
- moves AlignFrame to last parameter, as it is likely to be unnecessary

public boolean addPdbFile(String sequenceId, String pdbId, String pdbFile, AlignFrame alFrame);
public String getAlignment(String format, boolean addSuffix, AlignFrame alf);
public String[] getAlignmentOrder(AlignFrame alf);
public String getAnnotation(AlignFrame alf);
public URL getCodeBase();
public URL getDocumentBase();
public String[] getFeatureGroups(AlignFrame alf);
public String[] getFeatureGroupsOfState(boolean visible, AlignFrame alf);
public String getFeatures(String format, AlignFrame alf);
public String getParameter(String name);
public Object getParameterAsObject(String name);
public SequenceI[] getSelectedSequences(AlignFrame alf);
public AlignFrame newView();
public AlignFrame newView(String name);
public AlignFrame newViewFrom(AlignFrame alf);
public AlignFrame newViewFrom(AlignFrame alf, String name);
public String getSelectedSequencesAsAlignment(String format, boolean addSuffix, AlignFrame alf);
public void highlight(String sequenceId, String position, String alignedPosition, AlignFrame alf);
public AlignFrame loadAlignment(String data, String title, int width, int height);
public void loadAnnotation(String annotation, AlignFrame alf);
public boolean loadFeatures(String features, boolean autoenabledisplay, AlignFrame alf);
public boolean loadScoreFile(String sScoreFile, AlignFrame alf);
public Object openPcaPanel(String modelName, AlignFrame alf);
public Object openTreePanel(String treeType, String modelName, AlignFrame alf);
public boolean orderAlignment(String[] ids, String undoName, AlignFrame alf);
public Object parseArguments(String[] args);
public void removeSelectionListener(String listener, AlignFrame af);
public void scrollViewTo(int topRow, int leftHandColumn, AlignFrame alf);
public void select(String[] sequenceIds, String[] columns, AlignFrame alf);
public void setFeatureGroupState(String[] groups, boolean state, AlignFrame alf);
public void setSelectionListener(String listener, AlignFrame alf);
public void showOverview();
public void showStructure(String pdbID, String fileType, AlignFrame alf);

 
# unknown methods/shouldn't be in interface?

  public Object getFrameForSource(VamsasSource source);
  public void setSeparator(String separator);
  