(function(){var P$=Clazz.newPackage("jalview.util"),I$=[[0,'java.io.File','java.util.ArrayList','java.nio.file.Paths','java.nio.file.FileSystems','java.nio.file.Files','java.util.EnumSet','java.nio.file.FileVisitOption','java.nio.file.FileVisitResult','java.nio.file.SimpleFileVisitor','java.util.Collections','java.util.stream.Collectors','StringBuilder','jalview.util.LaunchUtils','jalview.util.HttpUtils','java.net.URL','java.nio.file.attribute.FileAttribute','java.util.HashSet','jalview.util.ErrorLog','java.util.Arrays','jalview.util.FileUtils']],I$0=I$[0],$I$=function(i,n,m){return m?$I$(i)[n].apply(null,m):((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "FileUtils");

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

Clazz.newMeth(C$, 'getFilesFromGlob$S',  function (pattern) {
return C$.getFilesFromGlob$S$Z(pattern, true);
}, 1);

Clazz.newMeth(C$, 'getFilesFromGlob$S$Z',  function (pattern, allowSingleFilenameThatDoesNotExist) {
pattern=C$.substituteHomeDir$S(pattern);
var relativePattern=pattern.startsWith$S($I$(1).separator) ? null : pattern;
var files=Clazz.new_($I$(2,1));
var firstGlobChar=-1;
var foundGlobChar=false;
for (var c, $c = 0, $$c = Clazz.array(Character.TYPE, -1, ["*", "{", "?"]); $c<$$c.length&&((c=($$c[$c])),1);$c++) {
if (pattern.indexOf$I(c) > -1 && (pattern.indexOf$I(c) < firstGlobChar || !foundGlobChar ) ) {
firstGlobChar=pattern.indexOf$I(c);
foundGlobChar=true;
}}
var lastFS=pattern.lastIndexOf$I$I($I$(1).separatorChar, firstGlobChar);
if (foundGlobChar) {
var pS=pattern.substring$I$I(0, lastFS + 1);
var rest=pattern.substring$I(lastFS + 1);
if ("".equals$O(pS)) {
pS=".";
}var parentDir=$I$(3,"get$S$SA",[pS, Clazz.array(String, -1, [])]);
if (parentDir.toFile$().exists$()) {
try {
var glob="glob:" + parentDir.toString() + $I$(1).separator + rest ;
if (System.getProperty$S("os.name").indexOf$S("Win") >= 0) {
glob=glob.replaceAll$S$S("\\\\", "\\\\\\\\");
}var pm=$I$(4).getDefault$().getPathMatcher$S(glob);
var maxDepth=rest.contains$CharSequence("**") ? 1028 : Long.$ival((rest.chars$().filter$java_util_function_IntPredicate((P$.FileUtils$lambda1$||(P$.FileUtils$lambda1$=(((P$.FileUtils$lambda1||
(function(){/*m*/var C$=Clazz.newClass(P$, "FileUtils$lambda1", function(){Clazz.newInstance(this, arguments[0],1,C$);}, null, 'java.util.function.IntPredicate', 1);

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);
/*lambda_E*/
Clazz.newMeth(C$, ['test$I','test$O'],  function (ch) { return (ch == $I$(1).separatorChar.$c() );});
})()
), Clazz.new_(P$.FileUtils$lambda1.$init$,[this, null])))))).count$())) + 1;
$I$(5,"walkFileTree$java_nio_file_Path$java_util_Set$I$java_nio_file_FileVisitor",[parentDir, $I$(6,"of$Enum",[$I$(7).FOLLOW_LINKS]), maxDepth, ((P$.FileUtils$1||
(function(){/*a*/var C$=Clazz.newClass(P$, "FileUtils$1", function(){Clazz.newInstance(this, arguments[0],1,C$);}, Clazz.load('java.nio.file.SimpleFileVisitor'), null, 1);

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

Clazz.newMeth(C$, ['visitFile$java_nio_file_Path$java_nio_file_attribute_BasicFileAttributes','visitFile$O$java_nio_file_attribute_BasicFileAttributes'],  function (path, attrs) {
if (this.$finals$.pm.matches$java_nio_file_Path(path)) {
this.$finals$.files.add$O(path.toFile$());
}return $I$(8).CONTINUE;
});

Clazz.newMeth(C$, ['visitFileFailed$java_nio_file_Path$java_io_IOException','visitFileFailed$O$java_io_IOException'],  function (file, exc) {
return $I$(8).CONTINUE;
});
})()
), Clazz.new_($I$(9,1),[this, {pm:pm,files:files}],P$.FileUtils$1))]);
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
e.printStackTrace$();
} else {
throw e;
}
}
}} else {
var f=Clazz.new_($I$(1,1).c$$S,[pattern]);
if (allowSingleFilenameThatDoesNotExist || f.exists$() ) {
files.add$O(f);
}}$I$(10).sort$java_util_List(files);
return files;
}, 1);

Clazz.newMeth(C$, 'getFilenamesFromGlob$S',  function (pattern) {
return C$.getFilesFromGlob$S(pattern).stream$().map$java_util_function_Function((P$.FileUtils$lambda2$||(P$.FileUtils$lambda2$=(((P$.FileUtils$lambda2||
(function(){/*m*/var C$=Clazz.newClass(P$, "FileUtils$lambda2", function(){Clazz.newInstance(this, arguments[0],1,C$);}, null, 'java.util.function.Function', 1);

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);
/*lambda_E*/
Clazz.newMeth(C$, ['apply$java_io_File','apply$O'],  function (f) { return (f.getPath$());});
})()
), Clazz.new_(P$.FileUtils$lambda2.$init$,[this, null])))))).collect$java_util_stream_Collector($I$(11).toList$());
}, 1);

Clazz.newMeth(C$, 'substituteHomeDir$S',  function (path) {
return path.startsWith$S("~" + $I$(1).separator) ? System.getProperty$S("user.home") + path.substring$I(1) : path;
}, 1);

Clazz.newMeth(C$, 'getBasename$java_io_File',  function (file) {
return C$.getBasenameOrExtension$java_io_File$Z(file, false);
}, 1);

Clazz.newMeth(C$, 'getExtension$java_io_File',  function (file) {
return C$.getBasenameOrExtension$java_io_File$Z(file, true);
}, 1);

Clazz.newMeth(C$, 'getBasenameOrExtension$java_io_File$Z',  function (file, extension) {
if (file == null ) return null;
var value=null;
var filename=file.getName$();
var lastDot=filename.lastIndexOf$I(".");
if (lastDot > 0) {
value=extension ? filename.substring$I(lastDot + 1) : filename.substring$I$I(0, lastDot);
} else {
value=extension ? "" : filename;
}return value;
}, 1);

Clazz.newMeth(C$, 'getDirname$java_io_File',  function (file) {
if (file == null ) return null;
var dirname=null;
var p=file.getParentFile$();
if (p == null ) {
p=Clazz.new_($I$(1,1).c$$S,["."]);
}var d=Clazz.new_([C$.substituteHomeDir$S(p.getPath$())],$I$(1,1).c$$S);
dirname=d.getPath$();
return dirname;
}, 1);

Clazz.newMeth(C$, 'convertWildcardsToPath$S$S$S$S',  function (value, wildcard, dirname, basename) {
if (value == null ) {
return null;
}var path=Clazz.new_($I$(12,1));
var lastFileSeparatorIndex=value.lastIndexOf$I($I$(1).separatorChar);
var wildcardBeforeIndex=value.indexOf$S(wildcard);
if (lastFileSeparatorIndex > wildcard.length$() - 1 && wildcardBeforeIndex < lastFileSeparatorIndex ) {
path.append$S(value.substring$I$I(0, wildcardBeforeIndex));
path.append$S(dirname);
path.append$S(value.substring$I$I(wildcardBeforeIndex + wildcard.length$(), lastFileSeparatorIndex + 1));
} else {
path.append$S(value.substring$I$I(0, lastFileSeparatorIndex + 1));
}var wildcardAfterIndex=value.indexOf$S$I(wildcard, lastFileSeparatorIndex);
if (wildcardAfterIndex > lastFileSeparatorIndex) {
path.append$S(value.substring$I$I(lastFileSeparatorIndex + 1, wildcardAfterIndex));
path.append$S(basename);
path.append$S(value.substring$I(wildcardAfterIndex + wildcard.length$()));
} else {
path.append$S(value.substring$I(lastFileSeparatorIndex + 1));
}return path.toString();
}, 1);

Clazz.newMeth(C$, 'getParentDir$java_io_File',  function (file) {
if (file == null ) {
return null;
}var parentDir=file.getAbsoluteFile$().getParentFile$();
return parentDir;
}, 1);

Clazz.newMeth(C$, 'checkParentDir$java_io_File$Z',  function (file, mkdirs) {
if (file == null ) {
return false;
}var parentDir=C$.getParentDir$java_io_File(file);
if (parentDir.exists$()) {
return true;
}if (!mkdirs) {
return false;
}var path=file.toPath$();
for (var i=0; i < path.getNameCount$(); i++) {
var p=path.getName$I(i);
if ("..".equals$O(p.toString())) {
$I$(13,"syserr$Z$Z$S",[true, false, "Cautiously not running mkdirs on " + file.toString() + " because the path to be made contains '..'" ]);
return false;
}}
return C$.mkdirs$java_io_File(parentDir);
}, 1);

Clazz.newMeth(C$, 'getExtension$S',  function (filename) {
return C$.getBaseOrExtension$S$Z(filename, true);
}, 1);

Clazz.newMeth(C$, 'getBase$S',  function (filename) {
return C$.getBaseOrExtension$S$Z(filename, false);
}, 1);

Clazz.newMeth(C$, 'getBaseOrExtension$S$Z',  function (filename0, extension) {
if (filename0 == null ) {
return null;
}var filename=filename0;
var isUrl=false;
if ($I$(14).startsWithHttpOrHttps$S(filename)) {
try {
var url=Clazz.new_($I$(15,1).c$$S,[filename]);
filename=url.getPath$();
isUrl=true;
} catch (e) {
if (Clazz.exceptionOf(e,"java.net.MalformedURLException")){
} else {
throw e;
}
}
}var dot=filename.lastIndexOf$I(".");
var slash=filename.lastIndexOf$I("/");
if (!$I$(1).separator.equals$O("/") && !isUrl ) {
slash=filename.lastIndexOf$S($I$(1).separator);
}var hasExtension=dot > slash + 1;
if (extension) {
return hasExtension ? filename.substring$I(dot + 1) : null;
} else {
dot=filename0.lastIndexOf$I(".");
return hasExtension ? filename0.substring$I$I(0, dot + 1) : filename0;
}}, 1);

Clazz.newMeth(C$, 'getCanonicalPath$java_nio_file_Path',  function (path) {
return path.normalize$();
}, 1);

Clazz.newMeth(C$, 'getCanonicalPath$java_io_File',  function (file) {
return C$.getCanonicalPath$java_nio_file_Path(file.toPath$());
}, 1);

Clazz.newMeth(C$, 'getCanonicalPath$S',  function (pathString) {
return C$.getCanonicalPath$java_nio_file_Path($I$(3,"get$S$SA",[pathString, Clazz.array(String, -1, [])]));
}, 1);

Clazz.newMeth(C$, 'getCanonicalFile$java_io_File',  function (file) {
return C$.getCanonicalPath$java_io_File(file).toFile$();
}, 1);

Clazz.newMeth(C$, 'getCanonicalFile$S',  function (pathString) {
return C$.getCanonicalPath$java_nio_file_Path($I$(3,"get$S$SA",[pathString, Clazz.array(String, -1, [])])).toFile$();
}, 1);

Clazz.newMeth(C$, 'mkdirs$java_io_File',  function (file) {
try {
$I$(5,"createDirectories$java_nio_file_Path$java_nio_file_attribute_FileAttributeA",[C$.getCanonicalPath$java_io_File(file), Clazz.array($I$(16), -1, [])]);
return file.exists$();
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
$I$(13,"syserr$Z$Z$S",[true, false, "Failed to make directory " + file + "\n" + e.getStackTrace$() ]);
} else {
throw e;
}
}
return false;
}, 1);

Clazz.newMeth(C$, 'getMatchingVersionedFiles$SA$SA$SA$SA$S$Z',  function (templates, roots, versionWhitelist, versionBlacklist, versionSeparator, exists) {
var matchingFiles=Clazz.new_($I$(17,1));
if (templates == null ) {
$I$(18).errPrintln$S("getMatchingVersionedFiles called with a null template array");
var files=Clazz.new_($I$(2,1));
files.addAll$java_util_Collection(matchingFiles);
return files;
}for (var template, $template = 0, $$template = templates; $template<$$template.length&&((template=($$template[$template])),1);$template++) {
$I$(18).errPrintln$S("Using template '" + template + "'" );
for (var root, $root = 0, $$root = roots; $root<$$root.length&&((root=($$root[$root])),1);$root++) {
$I$(18).errPrintln$S("Using root '" + root + "'" );
if (versionBlacklist != null ) {
var globMatch=String.format$S$OA(template, Clazz.array(java.lang.Object, -1, [root, "*"]));
$I$(18).errPrintln$S("Using glob '" + globMatch + "'" );
var foundFiles=C$.getFilesFromGlob$S$Z(globMatch, false);
for (var found, $found = foundFiles.iterator$(); $found.hasNext$()&&((found=($found.next$())),1);) {
$I$(18,"errPrintln$S",["Checking " + found.getPath$() + " is okay" ]);
var add=true;
for (var notVersion, $notVersion = 0, $$notVersion = versionBlacklist; $notVersion<$$notVersion.length&&((notVersion=($$notVersion[$notVersion])),1);$notVersion++) {
var vSB=Clazz.new_($I$(12,1));
if (versionSeparator != null ) {
vSB.append$S(versionSeparator);
}vSB.append$S(notVersion);
var versionString=vSB.toString();
if (String.format$S$OA(template, Clazz.array(java.lang.Object, -1, [root, versionString])).equals$O(found.getPath$())) {
add=false;
$I$(18,"errPrintln$S",["Not adding " + found.getPath$() + ": version '" + notVersion + "' is in the blacklist" ]);
break;
}}
if (add) {
$I$(18,"errPrintln$S",["Adding " + found.getPath$() + " to list" ]);
matchingFiles.add$O(found);
}}
if (versionSeparator != null ) {
var nonVersioned=String.format$S$OA(template, Clazz.array(java.lang.Object, -1, [root, ""]));
matchingFiles.addAll$java_util_Collection(C$.getFilesFromGlob$S$Z(nonVersioned, false));
}}if (versionWhitelist != null ) {
$I$(18).errPrintln$S("Adding " + versionWhitelist.length + " whitelist versions" );
for (var addVersion, $addVersion = 0, $$addVersion = versionWhitelist; $addVersion<$$addVersion.length&&((addVersion=($$addVersion[$addVersion])),1);$addVersion++) {
var vSB=Clazz.new_($I$(12,1));
if (versionSeparator != null ) {
vSB.append$S(versionSeparator);
}vSB.append$S(addVersion);
var versionString=vSB.toString();
var versionPath=String.format$S$OA(template, Clazz.array(java.lang.Object, -1, [root, versionString]));
$I$(18).errPrintln$S("Adding whitelist path '" + versionPath + "'" );
var file=Clazz.new_($I$(1,1).c$$S,[versionPath]);
if (file.exists$() || !exists ) {
matchingFiles.add$O(file);
}}
if (versionSeparator != null ) {
var nonVersioned=String.format$S$OA(template, Clazz.array(java.lang.Object, -1, [root, ""]));
var file=Clazz.new_($I$(1,1).c$$S,[nonVersioned]);
if (file.exists$() || !exists ) {
matchingFiles.add$O(file);
}}}}
}
var files=Clazz.new_($I$(2,1));
files.addAll$java_util_Collection(matchingFiles);
return files;
}, 1);

Clazz.newMeth(C$, 'getExecutable$S$S',  function (cmd, binaryPath) {
var file=Clazz.new_($I$(1,1).c$$S$S,[binaryPath, cmd]);
if (!file.canExecute$()) {
file=Clazz.new_($I$(1,1).c$$S$S,[binaryPath, cmd + ".exe"]);
{
if (!file.canExecute$()) {
file=null;
}}}return file;
}, 1);

Clazz.newMeth(C$, 'getPathTo$S',  function (cmd) {
var paths=System.getenv$S("PATH");
for (var path, $path = 0, $$path = paths.split$S("\\" + $I$(1).pathSeparator); $path<$$path.length&&((path=($$path[$path])),1);$path++) {
if (C$.getExecutable$S$S(cmd, path) != null ) {
return path;
}}
return null;
}, 1);

Clazz.newMeth(C$, 'createTempFile$S$S',  function (prefix, suffix) {
var f=$I$(1).createTempFile$S$S(prefix, suffix);
f.deleteOnExit$();
return f;
}, 1);

Clazz.newMeth(C$, 'findMatchingPaths$java_nio_file_Path$S',  function (from, pattern) {
var matches=Clazz.new_($I$(2,1));
var pathMatcher=$I$(4).getDefault$().getPathMatcher$S("regex:" + pattern);
try {
$I$(5,"walk$java_nio_file_Path$java_nio_file_FileVisitOptionA",[from, Clazz.array($I$(7), -1, [])]).filter$java_util_function_Predicate((function($$){((
(function(){/*m*/var C$=Clazz.newClass(P$, "FileUtils$lambda3", function(){Clazz.newInstance(this, arguments[0],1,C$);}, null, 'java.util.function.Predicate', 1);

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);
/*lambda_M*/
Clazz.newMeth(C$, 'test$O',  function (t) { return $$.matches$java_nio_file_Path.apply($$,[t])});
})()
)); return Clazz.new_(P$.FileUtils$lambda3.$init$,[this, null])})(pathMatcher)).forEach$java_util_function_Consumer(((P$.FileUtils$lambda4||
(function(){/*m*/var C$=Clazz.newClass(P$, "FileUtils$lambda4", function(){Clazz.newInstance(this, arguments[0],1,C$);}, null, 'java.util.function.Consumer', 1);

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);
/*lambda_E*/
Clazz.newMeth(C$, ['accept$java_nio_file_Path','accept$O'],  function (m) { return (this.$finals$.matches.add$O(m.toString()));});
})()
), Clazz.new_(P$.FileUtils$lambda4.$init$,[this, {matches:matches}])));
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
System.err.println$S("Error searching for " + pattern + " : " + e.toString() );
} else {
throw e;
}
}
return matches;
}, 1);

Clazz.newMeth(C$, 'findMatches$S$S',  function (root, pattern) {
var results=Clazz.new_($I$(2,1));
try {
var from=$I$(3,"get$S$SA",[root, Clazz.array(String, -1, [])]);
C$.findMatches$java_util_List$java_nio_file_Path$java_util_List(results, from, $I$(19,"asList$OA",[pattern.split$S("/")]));
} catch (e) {
System.err.println$S(String.format$S$OA("Error searching %s for %s: %s", Clazz.array(java.lang.Object, -1, [root, pattern, e.toString()])));
}
return results;
}, 1);

Clazz.newMeth(C$, 'findMatches$java_util_List$java_nio_file_Path$java_util_List',  function (results, from, patterns) {
if (patterns.isEmpty$()) {
results.add$O(from.toString());
return;
}var pattern=patterns.get$I(0);
try {
var dirStream=$I$(5).newDirectoryStream$java_nio_file_Path$S(from, pattern);
try {
dirStream.forEach$java_util_function_Consumer(((P$.FileUtils$lambda5||
(function(){/*m*/var C$=Clazz.newClass(P$, "FileUtils$lambda5", function(){Clazz.newInstance(this, arguments[0],1,C$);}, null, 'java.util.function.Consumer', 1);

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);
/*lambda_E*/
Clazz.newMeth(C$, ['accept$java_nio_file_Path','accept$O'],  function (p) {
var subList=this.$finals$.patterns.subList$I$I(1, this.$finals$.patterns.size$());
if (subList.isEmpty$() || p.toFile$().isDirectory$() ) {
$I$(20).findMatches$java_util_List$java_nio_file_Path$java_util_List(this.$finals$.results, p, subList);
}});
})()
), Clazz.new_(P$.FileUtils$lambda5.$init$,[this, {patterns:patterns,results:results}])));

}finally{/*res*/dirStream&&dirStream.close$&&dirStream.close$();}
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
System.err.println$S(String.format$S$OA("Error searching %s: %s", Clazz.array(java.lang.Object, -1, [pattern, e.toString()])));
} else {
throw e;
}
}
}, 1);

Clazz.newMeth(C$);
})();
;Clazz.setTVer('3.3.1-v1');//Created 2026-01-05 21:54:01 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
