(function(){var P$=Clazz.newPackage("jalview.analysis"),I$=[[0,'java.util.Optional',['jalview.analysis.SeqsetUtils','.SequenceInfo'],'java.util.ArrayList','java.util.Vector','jalview.bin.Console','jalview.datamodel.HiddenMarkovModel','java.util.HashMap','jalview.analysis.SequenceIdMatcher','String','StringBuilder','jalview.analysis.AlignSeq','jalview.util.Comparison','jalview.datamodel.SequenceI']],I$0=I$[0],$I$=function(i,n,m){return m?$I$(i)[n].apply(null,m):((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "SeqsetUtils", function(){
Clazz.newInstance(this, arguments,0,C$);
});
C$.$classes$=[['SequenceInfo',9]];

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

Clazz.newMeth(C$, 'SeqCharacterHash$jalview_datamodel_SequenceI',  function (seq) {
var sqinfo=Clazz.new_([seq.getName$(), seq.getStart$(), seq.getEnd$()],$I$(2,1).c$$S$I$I);
sqinfo.description=$I$(1,"ofNullable$O",[seq.getDescription$()]);
sqinfo.dataset=$I$(1,"ofNullable$O",[seq.getDatasetSequence$()]);
if (!sqinfo.dataset.isPresent$()) {
var feats=Clazz.new_([seq.getFeatures$().getAllFeatures$SA(Clazz.array(String, -1, []))],$I$(3,1).c$$java_util_Collection);
sqinfo.features=$I$(1).of$O(feats);
var pdbEntries=seq.getAllPDBEntries$();
sqinfo.pdbId=$I$(1,"of$O",[pdbEntries != null  ? pdbEntries : Clazz.new_($I$(3,1))]);
}if (seq.hasHMMProfile$()) {
sqinfo.hmm=$I$(1,"of$O",[seq.getHMM$()]);
}sqinfo.searchScores=$I$(1,"ofNullable$O",[seq.getAnnotation$S("Search Scores")]);
return sqinfo;
}, 1);

Clazz.newMeth(C$, 'filterSequence$CA$java_util_BitSet',  function (sequence, mask) {
mask=mask.get$I$I(0, sequence.length);
var result=Clazz.array(Character.TYPE, [mask.cardinality$()]);
for (var i=mask.nextSetBit$I(0), j=0; i >= 0; ) {
result[j++]=sequence[i];
if (i == 2147483647) break;
i=mask.nextSetBit$I(i + 1);
}
return result;
}, 1);

Clazz.newMeth(C$, 'SeqCharacterUnhash$jalview_datamodel_SequenceI$jalview_analysis_SeqsetUtils_SequenceInfo',  function (sq, sqinfo) {
if (sqinfo == null ) {
return false;
}if (sqinfo.name != null ) {
sq.setName$S(sqinfo.name);
}sq.setStart$I(sqinfo.start);
sq.setEnd$I(sqinfo.end);
if (sqinfo.pdbId.isPresent$() && !sqinfo.pdbId.get$().isEmpty$() ) sq.setPDBId$java_util_Vector(Clazz.new_([sqinfo.pdbId.get$()],$I$(4,1).c$$java_util_Collection));
if (sqinfo.features.isPresent$() && !sqinfo.features.get$().isEmpty$() ) sq.setSequenceFeatures$java_util_List(sqinfo.features.get$());
if (sqinfo.description.isPresent$()) sq.setDescription$S(sqinfo.description.get$());
if (sqinfo.dataset.isPresent$()) {
if (sqinfo.features.isPresent$()) {
$I$(5).warn$S("Setting dataset sequence for a sequence which has sequence features. Dataset sequence features will not be visible.");
Clazz.assert(C$, this, function(){return false});
}sq.setDatasetSequence$jalview_datamodel_SequenceI(sqinfo.dataset.get$());
}if (sqinfo.hmm.isPresent$()) sq.setHMM$jalview_datamodel_HiddenMarkovModel(Clazz.new_([sqinfo.hmm.get$(), sq],$I$(6,1).c$$jalview_datamodel_HiddenMarkovModel$jalview_datamodel_SequenceI));
if (sqinfo.searchScores.isPresent$()) {
for (var score, $score = 0, $$score = sqinfo.searchScores.get$(); $score<$$score.length&&((score=($$score[$score])),1);$score++) {
sq.addAlignmentAnnotation$jalview_datamodel_AlignmentAnnotation(score);
}
}return sqinfo.name != null ;
}, 1);

Clazz.newMeth(C$, 'unique_name$I',  function (i) {
return String.format$S$OA("Sequence%d", Clazz.array(java.lang.Object, -1, [Integer.valueOf$I(i)]));
}, 1);

Clazz.newMeth(C$, 'uniquify$jalview_datamodel_SequenceIA$Z',  function (sequences, write_names) {
var map=Clazz.new_($I$(7,1));
for (var i=0; i < sequences.length; i++) {
var safename=C$.unique_name$I(i);
map.put$O$O(safename, C$.SeqCharacterHash$jalview_datamodel_SequenceI(sequences[i]));
if (write_names) {
sequences[i].setName$S(safename);
}}
return map;
}, 1);

Clazz.newMeth(C$, 'deuniquify$java_util_Map$jalview_datamodel_SequenceIA',  function (map, sequences) {
return C$.deuniquify$java_util_Map$jalview_datamodel_SequenceIA$Z(map, sequences, true);
}, 1);

Clazz.newMeth(C$, 'deuniquify$java_util_Map$jalview_datamodel_SequenceIA$Z',  function (map, sequences, quiet) {
var matcher=Clazz.new_($I$(8,1).c$$jalview_datamodel_SequenceIA,[sequences]);
var msq=null;
var keys=map.keySet$().iterator$();
var unmatched=Clazz.new_($I$(4,1));
for (var i=0, j=sequences.length; i < j; i++) {
unmatched.addElement$O(sequences[i]);
}
while (keys.hasNext$()){
var key=keys.next$();
try {
if ((msq=matcher.findIdMatch$S(key)) != null ) {
var sqinfo=map.get$O(key);
unmatched.removeElement$O(msq);
C$.SeqCharacterUnhash$jalview_datamodel_SequenceI$jalview_analysis_SeqsetUtils_SequenceInfo(msq, sqinfo);
} else {
if (!quiet) {
$I$(5,"warn$S",[$I$(9,"format$S$OA",["Can\'t find \'%s\' in uniquified alignment", Clazz.array(java.lang.Object, -1, [key])])]);
}}} catch (ccastex) {
if (Clazz.exceptionOf(ccastex,"ClassCastException")){
if (!quiet) {
$I$(5,"error$S",["Unexpected object in SeqSet map : " + key.getClass$()]);
}} else {
throw ccastex;
}
}
}
if (unmatched.size$() > 0 && !quiet ) {
var sb=Clazz.new_($I$(10,1).c$$S,["Did not find match for sequences: "]);
var i=unmatched.elements$();
sb.append$S(i.nextElement$().getName$());
for (; i.hasMoreElements$(); ) {
sb.append$S(", " + i.nextElement$().getName$());
}
$I$(5,"warn$S",[sb.toString()]);
return false;
}return true;
}, 1);

Clazz.newMeth(C$, 'getNonEmptySequenceSet$jalview_datamodel_SequenceIA',  function (sequences) {
var ungapped=Clazz.array(Boolean.TYPE, [sequences.length]);
var msflen=0;
for (var i=0, j=sequences.length; i < j; i++) {
var tempseq=$I$(11,"extractGaps$S$S",[$I$(12).GapChars, sequences[i].getSequenceAsString$()]);
if (tempseq.length$() == 0) {
ungapped[i]=false;
} else {
ungapped[i]=true;
++msflen;
}}
if (msflen == 0) {
return null;
}var mset=Clazz.array($I$(13), [msflen]);
for (var i=0, j=sequences.length, k=0; i < j; i++) {
if (ungapped[i]) {
mset[k++]=sequences[i];
}}
ungapped=null;
return mset;
}, 1);

C$.$static$=function(){C$.$static$=0;
C$.$_ASSERT_ENABLED_ = ClassLoader.getClassAssertionStatus$(C$);
};
;
(function(){/*c*/var C$=Clazz.newClass(P$.SeqsetUtils, "SequenceInfo", function(){
Clazz.newInstance(this, arguments[0],false,C$);
});

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
this.description=$I$(1).empty$();
this.features=$I$(1).empty$();
this.pdbId=$I$(1).empty$();
this.dataset=$I$(1).empty$();
this.hmm=$I$(1).empty$();
this.searchScores=$I$(1).empty$();
},1);

C$.$fields$=[['I',['start','end'],'S',['name'],'O',['description','java.util.Optional','+features','+pdbId','+dataset','+hmm','+searchScores']]]

Clazz.newMeth(C$, 'c$$S$I$I',  function (name, start, end) {
;C$.$init$.apply(this);
this.name=name;
this.start=start;
this.end=end;
}, 1);

Clazz.newMeth(C$);
})()

Clazz.newMeth(C$);
})();
;Clazz.setTVer('3.3.1-v1');//Created 2026-01-05 21:53:44 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
