(function(){var P$=Clazz.newPackage("jalview.util"),I$=[[0,'jalview.util.ChannelProperties','java.io.File','java.util.Properties','java.io.FileInputStream','jalview.util.ErrorLog','java.net.URL','jalview.util.HttpUtils','java.util.ArrayList','java.lang.management.ManagementFactory','java.util.HashSet','java.util.Arrays','ProcessBuilder','java.util.concurrent.TimeUnit','java.util.Locale','java.util.jar.JarInputStream',['java.util.jar.Attributes','.Name']]],I$0=I$[0],$I$=function(i,n,m){return m?$I$(i)[n].apply(null,m):((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "LaunchUtils");

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

C$.$fields$=[[]
,['Z',['isMac','isWindows','isJS'],'I',['JAVA_COMPILE_VERSION','JAVA_VERSION'],'O',['userPreferences','java.util.Properties']]]

Clazz.newMeth(C$, 'loadChannelProps$java_io_File',  function (dir) {
$I$(1).loadProps$java_io_File(dir);
}, 1);

Clazz.newMeth(C$, 'getUserPreference$S',  function (key) {
if (C$.userPreferences == null ) {
var channelPrefsFilename=$I$(1).getProperty$S("preferences.filename");
if (channelPrefsFilename == null ) {
return null;
}var propertiesFile=Clazz.new_([System.getProperty$S("user.home"), channelPrefsFilename],$I$(2,1).c$$S$S);
if (!propertiesFile.exists$()) {
return null;
}try {
C$.userPreferences=Clazz.new_($I$(3,1));
C$.userPreferences.load$java_io_InputStream(Clazz.new_($I$(4,1).c$$java_io_File,[propertiesFile]));
} catch (e$$) {
if (Clazz.exceptionOf(e$$,"java.io.FileNotFoundException")){
var e = e$$;
{
return null;
}
} else if (Clazz.exceptionOf(e$$,"java.io.IOException")){
var e = e$$;
{
$I$(5,"errPrintln$S",[e.getMessage$()]);
return null;
}
} else {
throw e$$;
}
}
}return C$.userPreferences.getProperty$S(key);
}, 1);

Clazz.newMeth(C$, 'getBooleanUserPreference$S',  function (key) {
return Boolean.parseBoolean$S(C$.getUserPreference$S(key));
}, 1);

Clazz.newMeth(C$, 'getJavaCompileVersion$',  function () {
if (C$.isJS) {
return -1;
} else if (C$.JAVA_COMPILE_VERSION > 0) {
return C$.JAVA_COMPILE_VERSION;
}var buildDetails="jar:".concat$S(Clazz.getClass(C$).getProtectionDomain$().getCodeSource$().getLocation$().toString().concat$S("!/.build_properties"));
try {
var localFileURL=Clazz.new_($I$(6,1).c$$S,[buildDetails]);
var $in=$I$(7).openStream$java_net_URL(localFileURL);
var buildProperties=Clazz.new_($I$(3,1));
buildProperties.load$java_io_InputStream($in);
$in.close$();
var JCV=buildProperties.getProperty$S$S("JAVA_COMPILE_VERSION", null);
if (JCV == null ) {
$I$(5).errPrintln$S("Could not obtain JAVA_COMPILE_VERSION for comparison");
return -2;
}C$.JAVA_COMPILE_VERSION=Integer.parseInt$S(JCV);
} catch (e$$) {
if (Clazz.exceptionOf(e$$,"java.net.MalformedURLException")){
var e = e$$;
{
$I$(5).errPrintln$S("Could not find " + buildDetails);
return -3;
}
} else if (Clazz.exceptionOf(e$$,"java.io.IOException")){
var e = e$$;
{
$I$(5).errPrintln$S("Could not load " + buildDetails);
return -4;
}
} else if (Clazz.exceptionOf(e$$,"NumberFormatException")){
var e = e$$;
{
$I$(5).errPrintln$S("Could not parse JAVA_COMPILE_VERSION");
return -5;
}
} else {
throw e$$;
}
}
return C$.JAVA_COMPILE_VERSION;
}, 1);

Clazz.newMeth(C$, 'getJavaVersion$',  function () {
if (C$.isJS) {
return -1;
} else if (C$.JAVA_VERSION > 0) {
return C$.JAVA_VERSION;
}try {
var JV=System.getProperty$S("java.version");
if (JV == null ) {
$I$(5).errPrintln$S("Could not obtain java.version for comparison");
return -2;
}if (JV.startsWith$S("1.")) {
JV=JV.substring$I(2);
}C$.JAVA_VERSION=JV.indexOf$S(".") == -1 ? Integer.parseInt$S(JV) : Integer.parseInt$S(JV.substring$I$I(0, JV.indexOf$S(".")));
} catch (e) {
if (Clazz.exceptionOf(e,"NumberFormatException")){
$I$(5).errPrintln$S("Could not parse java.version");
return -3;
} else {
throw e;
}
}
return C$.JAVA_VERSION;
}, 1);

Clazz.newMeth(C$, 'getJarPath$Class',  function (c) {
try {
return c.getProtectionDomain$().getCodeSource$().getLocation$().toURI$().getPath$();
} catch (e) {
if (Clazz.exceptionOf(e,"java.net.URISyntaxException")){
$I$(5).errPrintln$S("Problem with class source location");
return null;
} else {
throw e;
}
}
}, 1);

Clazz.newMeth(C$, 'checkJavaVersion$',  function () {
if (C$.isJS) {
return true;
}var buildDetails="jar:".concat$S(Clazz.getClass(C$).getProtectionDomain$().getCodeSource$().getLocation$().toString().concat$S("!/.build_properties"));
var java_compile_version=C$.getJavaCompileVersion$();
var java_version=C$.getJavaVersion$();
if (java_compile_version <= 0 || java_version <= 0 ) {
$I$(5).errPrintln$S("Could not make Java version check");
return true;
}if (java_version >= 11 && java_compile_version < 11 ) {
return false;
}return true;
}, 1);

Clazz.newMeth(C$, 'findJavaBin$Z',  function (winConsole) {
return C$.findJavaBin$S$Z$Z$Z(System.getProperty$S("java.home"), winConsole, true, true);
}, 1);

Clazz.newMeth(C$, 'findJavaBin$Z$Z$Z',  function (winConsole, applicationName, generic) {
return C$.findJavaBin$S$Z$Z$Z(System.getProperty$S("java.home"), winConsole, applicationName, generic);
}, 1);

Clazz.newMeth(C$, 'findJavaBin$S$Z$Z$Z',  function (javaHome, winConsole, applicationName, generic) {
var javaBin=null;
var javaExe=winConsole ? "java.exe" : "javaw.exe";
var java="java";
if (javaHome != null ) {
var propertyAppName=null;
var appName=null;
if (applicationName) {
propertyAppName=System.getProperty$S("channel.app_name");
appName=(propertyAppName != null  && propertyAppName.length$() > 0 ) ? propertyAppName : $I$(1).getProperty$S("app_name");
}var javaBinDir=javaHome + $I$(2).separator + "bin" + $I$(2).separator ;
var potentialJavaBin=Clazz.new_($I$(8,1));
if (applicationName) {
if (appName != null ) {
potentialJavaBin.add$O(appName);
}if ("Jalview" != null ) {
potentialJavaBin.add$O("Jalview");
}}potentialJavaBin.add$O("java");
potentialJavaBin.add$O(javaExe);
for (var name, $name = potentialJavaBin.iterator$(); $name.hasNext$()&&((name=($name.next$())),1);) {
if (name == null ) {
continue;
}if (C$.checkJVMSymlink$S$Z(javaBinDir + name, winConsole)) {
javaBin=javaBinDir + name;
break;
}}
}if (javaBin == null  && generic ) {
javaBin=C$.isWindows ? javaExe : "java";
}return javaBin;
}, 1);

Clazz.newMeth(C$, 'checkJVMSymlink$S$Z',  function (testBin, winConsole) {
var testBinFile=Clazz.new_($I$(2,1).c$$S,[testBin]);
if (!testBinFile.exists$()) {
return false;
}var targetFile=null;
try {
targetFile=testBinFile.getCanonicalFile$();
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
return false;
} else {
throw e;
}
}
var javaExe=winConsole ? "java.exe" : "javaw.exe";
if (targetFile != null  && ("java".equals$O(targetFile.getName$()) || javaExe.equals$O(targetFile.getName$()) ) ) {
return true;
}return false;
}, 1);

Clazz.newMeth(C$, 'startNewJvm$S$java_util_List$java_util_List$java_util_List$java_util_List$java_util_List$S$java_util_List$java_util_List$java_util_List$Z$Z$Z$Z$Z',  function (javaBinary, removeJvmArguments, addJvmArguments, prependToClasspath, appendToClasspath, removeFromClasspath, startClass, removeAppArguments, addAppArguments, appArguments, launcherprint, launcherwait, launcherstop, debug, quiet) {
if (javaBinary == null ) {
javaBinary=C$.findJavaBin$Z$Z$Z(false, true, true);
}var classpathDirs=Clazz.new_($I$(8,1));
if (prependToClasspath != null ) {
classpathDirs.addAll$java_util_Collection(prependToClasspath);
}var classpath=$I$(9).getRuntimeMXBean$().getClassPath$();
if (removeFromClasspath != null ) {
var removeCp=Clazz.new_($I$(10,1));
for (var dcp, $dcp = removeFromClasspath.iterator$(); $dcp.hasNext$()&&((dcp=($dcp.next$())),1);) {
try {
var canPath=Clazz.new_($I$(2,1).c$$S,[dcp]).getCanonicalPath$();
removeCp.add$O(canPath);
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
$I$(5,"errPrintln$S",["Problem getting canonical path. " + e.getMessage$()]);
} else {
throw e;
}
}
}
for (var cp, $cp = 0, $$cp = classpath.split$S($I$(2).pathSeparator); $cp<$$cp.length&&((cp=($$cp[$cp])),1);$cp++) {
try {
var canPath=Clazz.new_($I$(2,1).c$$S,[cp]).getCanonicalPath$();
if (!removeCp.contains$O(canPath)) {
classpathDirs.add$O(cp);
}} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
$I$(5,"errPrintln$S",["Problem getting canonical path. " + e.getMessage$()]);
} else {
throw e;
}
}
}
} else {
classpathDirs.addAll$java_util_Collection($I$(11,"asList$OA",[classpath.split$S($I$(2).pathSeparator)]));
}if (appendToClasspath != null ) {
classpathDirs.addAll$java_util_Collection(appendToClasspath);
}var jvmArguments=Clazz.new_($I$(8,1));
var originalJvmArguments=$I$(9).getRuntimeMXBean$().getInputArguments$();
if (removeJvmArguments != null  && removeJvmArguments.size$() > 0 ) {
for (var jvmArg, $jvmArg = originalJvmArguments.iterator$(); $jvmArg.hasNext$()&&((jvmArg=($jvmArg.next$())),1);) {
var addArg=true;
for (var rmArg, $rmArg = removeJvmArguments.iterator$(); $rmArg.hasNext$()&&((rmArg=($rmArg.next$())),1);) {
if (jvmArg.startsWith$S(rmArg)) {
addArg=false;
break;
}}
if (addArg) {
jvmArguments.add$O(jvmArg);
}}
} else {
jvmArguments.addAll$java_util_Collection(originalJvmArguments);
}if (addJvmArguments != null ) {
jvmArguments.addAll$java_util_Collection(addJvmArguments);
}if (startClass == null ) {
startClass=System.getProperty$S("sun.java.command");
}var applicationArguments=Clazz.new_($I$(8,1));
if (removeAppArguments != null  && removeAppArguments.size$() > 0 ) {
var removeArgs=Clazz.new_($I$(10,1).c$$java_util_Collection,[removeAppArguments]);
for (var appArg, $appArg = appArguments.iterator$(); $appArg.hasNext$()&&((appArg=($appArg.next$())),1);) {
if (!removeArgs.contains$O(appArg)) {
applicationArguments.add$O(appArg);
}}
} else {
applicationArguments.addAll$java_util_Collection(appArguments);
}if (addAppArguments != null ) {
applicationArguments.addAll$java_util_Collection(addAppArguments);
}var command=Clazz.new_($I$(8,1));
command.add$O(javaBinary);
command.add$O("-cp");
command.add$O(String.join$CharSequence$Iterable($I$(2).pathSeparator, classpathDirs));
command.addAll$java_util_Collection(jvmArguments);
command.add$O(startClass);
command.addAll$java_util_Collection(applicationArguments);
return C$.runProcess$java_util_List$Z$Z$Z$Z$Z(command, launcherprint, launcherwait, launcherstop, debug, quiet);
}, 1);

Clazz.newMeth(C$, 'runProcess$java_util_List$Z$Z$Z$Z$Z',  function (command, launcherprint, launcherwait, launcherstop, debug, quiet) {
var builder=Clazz.new_($I$(12,1).c$$java_util_List,[command]);
var p=null;
var exitValue=-1;
if (Boolean.parseBoolean$S(System.getProperty$S$S("launcherprint", "false")) || launcherprint ) {
C$.syserr$Z$Z$S(debug, quiet, "COMMAND : \"" + String.join$CharSequence$Iterable("\" \"", builder.command$()) + "\"" );
}if (Boolean.parseBoolean$S(System.getProperty$S$S("launcherstop", "false")) || (debug && launcherstop ) ) {
C$.syserr$Z$Z$S(debug, quiet, "System property \'launcherstop\' is set and not \'false\'. Exiting.");
System.exit$I(0);
}try {
builder.inheritIO$();
var process=builder.start$();
p=process;
if (launcherwait) {
C$.syserr$Z$Z$S(debug, quiet, "Launching application process");
exitValue=process.waitFor$();
C$.syserr$Z$Z$S(debug, quiet, "Application process return with value " + exitValue);
} else {
var waitInt=0;
C$.syserr$Z$Z$S(debug, quiet, "Wait time for application process is " + waitInt + "ms" );
if (process.waitFor$J$java_util_concurrent_TimeUnit(waitInt, $I$(13).MILLISECONDS)) {
exitValue=process.exitValue$();
} else {
exitValue=-2;
}}C$.syserr$Z$Z$S(debug, quiet, "Launcher process ending");
} catch (e$$) {
if (Clazz.exceptionOf(e$$,"java.io.IOException")){
var e = e$$;
{
if (e.getMessage$().toLowerCase$java_util_Locale($I$(14).ROOT).contains$CharSequence("memory")) {
C$.syserr$Z$Z$S(true, quiet, "Caught a memory exception: " + e.getMessage$());
var commandNoMem=Clazz.new_($I$(8,1));
for (var i=0; i < command.size$(); i++) {
if (!command.get$I(i).startsWith$S("-Xmx")) {
commandNoMem.add$O(command.get$I(i));
}}
var builderNoMem=Clazz.new_($I$(12,1).c$$java_util_List,[commandNoMem]);
C$.syserr$Z$Z$S(true, quiet, "Command without memory setting: " + String.join$CharSequence$Iterable(" ", builderNoMem.command$()));
try {
builderNoMem.inheritIO$();
var processNoMem=builderNoMem.start$();
p=processNoMem;
exitValue=processNoMem.waitFor$();
} catch (ex) {
if (Clazz.exceptionOf(ex,"Exception")){
ex.printStackTrace$();
} else {
throw ex;
}
}
} else {
e.printStackTrace$();
}}
} else if (Clazz.exceptionOf(e$$,"Exception")){
var e = e$$;
{
e.printStackTrace$();
}
} else {
throw e$$;
}
}
try {
p.getOutputStream$().flush$();
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
} else {
throw e;
}
}
return exitValue;
}, 1);

Clazz.newMeth(C$, 'compareGetdownLauncherJarVersions$java_io_File$java_io_File',  function (f0, f1) {
var v0=f0.exists$() ? C$.getJarImplementationVersion$java_io_File(f0) : null;
return C$.compareGetdownLauncherJarVersions$S$java_io_File(v0, f1);
}, 1);

Clazz.newMeth(C$, 'compareGetdownLauncherJarVersions$S$java_io_File',  function (v0, f1) {
var v1=f1.exists$() ? C$.getJarImplementationVersion$java_io_File(f1) : null;
return C$.compareGetdownLauncherJarVersions$S$S(v0, v1);
}, 1);

Clazz.newMeth(C$, 'compareGetdownLauncherJarVersions$S$S',  function (v0, v1) {
C$.syserr$Z$Z$S(v0 != null  && !v0.equals$O(v1) , false, "Got launcher versions '" + v0 + "' and '" + v1 + "'" );
if (v0 == null  && v1 == null  ) {
return 0;
}if (v0 == null ) {
return -1;
}if (v1 == null ) {
return 1;
}if (v0.endsWith$S("JVL")) {
v0=v0.substring$I$I(0, v0.lastIndexOf$I("_"));
}if (v1.endsWith$S("JVL")) {
v1=v1.substring$I$I(0, v1.lastIndexOf$I("_"));
}var v0parts=v0.split$S("-");
var v1parts=v1.split$S("-");
var compare=0;
for (var j=0; j < Math.min(v0parts.length, v1parts.length); j++) {
compare=C$.compareVersions$S$S(v0parts[j], v1parts[j]);
if (compare != 0) {
return compare;
}}
return v0parts.length - v1parts.length;
}, 1);

Clazz.newMeth(C$, 'compareVersions$S$S',  function (v0, v1) {
if (v0 == null  && v1 == null  ) {
return 0;
}if (v0 == null ) {
return -1;
}if (v1 == null ) {
return 1;
}var v0dots=v0.split$S("\\.");
var v1dots=v1.split$S("\\.");
var compare=0;
for (var i=0; i < Math.min(v0dots.length, v1dots.length); i++) {
if (!v0dots[i].equals$O(v1dots[i])) {
try {
compare=Integer.parseInt$S(v0dots[i]) - Integer.parseInt$S(v1dots[i]);
} catch (e) {
if (Clazz.exceptionOf(e,"NumberFormatException")){
C$.syserr$Z$Z$S(true, false, "Couldn't parse one of '" + v0dots[i] + "' or '" + v1dots[i] + "': " + e.getMessage$() );
C$.syserr$Z$Z$S(true, false, "Comparing as strings.");
compare=v0dots[i].compareTo$S(v1dots[i]);
} else {
throw e;
}
}
if (compare != 0) {
return compare;
}}}
return v0dots.length - v1dots.length;
}, 1);

Clazz.newMeth(C$, 'getJarImplementationVersion$java_io_File',  function (jarFile) {
var implementationVersion=null;
try {
var j0=Clazz.new_([Clazz.new_($I$(4,1).c$$java_io_File,[jarFile])],$I$(15,1).c$$java_io_InputStream);
var m0=j0.getManifest$();
if (m0 == null ) {
System.err.println$S("No manifest in " + jarFile.getAbsolutePath$());
} else {
implementationVersion=m0.getMainAttributes$().getValue$java_util_jar_Attributes_Name($I$(16).IMPLEMENTATION_VERSION);
}} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
System.err.println$S("Exception opening " + jarFile.getAbsolutePath$() + " to check version: " + e.getMessage$() );
} else {
throw e;
}
}
return implementationVersion;
}, 1);

Clazz.newMeth(C$, 'syserr$Z$Z$S',  function (debug, quiet, message) {
if (debug && !quiet ) {
$I$(5).errPrintln$S("DEBUG - " + message);
}}, 1);

C$.$static$=function(){C$.$static$=0;
C$.isMac=System.getProperty$S("os.name").indexOf$S("Mac") > -1;
C$.isWindows=System.getProperty$S("os.name").indexOf$S("Win") > -1;
C$.isJS=true ||false;
C$.userPreferences=null;
C$.JAVA_COMPILE_VERSION=0;
C$.JAVA_VERSION=0;
};

Clazz.newMeth(C$);
})();
;Clazz.setTVer('3.3.1-v1');//Created 2025-12-10 08:19:32 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
