(function(){var P$=Clazz.newPackage("jalview.util"),I$=[[0,'java.util.HashMap','java.util.Random','java.awt.Color','java.util.Locale',['jalview.util.ColorUtils','.ColourScheme'],'jalview.bin.Console','jalview.util.StringUtils']],I$0=I$[0],$I$=function(i,n,m){return m?$I$(i)[n].apply(null,m):((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "ColorUtils", function(){
Clazz.newInstance(this, arguments,0,C$);
});
C$.$classes$=[['ColourScheme',25]];

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

C$.$fields$=[[]
,['F',['HSB_DISTANCE_THRESHOLD'],'O',['myColours','java.util.Map','+myHSBSpacedColours']]]

Clazz.newMeth(C$, 'generateRandomColor$java_awt_Color',  function (mix) {
var random=Clazz.new_($I$(2,1));
var red=random.nextInt$I(256);
var green=random.nextInt$I(256);
var blue=random.nextInt$I(256);
if (mix != null ) {
red=((red + mix.getRed$())/2|0);
green=((green + mix.getGreen$())/2|0);
blue=((blue + mix.getBlue$())/2|0);
}var color=Clazz.new_($I$(3,1).c$$I$I$I,[red, green, blue]);
return color;
}, 1);

Clazz.newMeth(C$, 'getARandomColor$',  function () {
var col=Clazz.new_([((Math.random() * 255)|0), ((Math.random() * 255)|0), ((Math.random() * 255)|0)],$I$(3,1).c$$I$I$I);
return col;
}, 1);

Clazz.newMeth(C$, 'getColorForIndex$I',  function (index) {
var hue=(index * 0.618034) % 1.0;
return $I$(3).getHSBColor$F$F$F(hue, 0.75, 0.9);
}, 1);

Clazz.newMeth(C$, 'toTkCode$java_awt_Color',  function (colour) {
var colstring="#" + ((colour.getRed$() < 16) ? "0" : "") + Integer.toHexString$I(colour.getRed$()) + ((colour.getGreen$() < 16) ? "0" : "") + Integer.toHexString$I(colour.getGreen$()) + ((colour.getBlue$() < 16) ? "0" : "") + Integer.toHexString$I(colour.getBlue$()) ;
return colstring;
}, 1);

Clazz.newMeth(C$, 'darkerThan$java_awt_Color',  function (col) {
return col == null  ? null : col.darker$().darker$().darker$();
}, 1);

Clazz.newMeth(C$, 'brighterThan$java_awt_Color',  function (col) {
return col == null  ? null : col.brighter$().brighter$().brighter$();
}, 1);

Clazz.newMeth(C$, 'getGraduatedColour$F$F$java_awt_Color$F$java_awt_Color',  function (value, minValue, minColour, maxValue, maxColour) {
if (minValue == maxValue ) {
return minColour;
}if (value < minValue ) {
value=minValue;
}if (value > maxValue ) {
value=maxValue;
}var prop=(value - minValue) / (maxValue - minValue);
var r=minColour.getRed$() + prop * (maxColour.getRed$() - minColour.getRed$());
var g=minColour.getGreen$() + prop * (maxColour.getGreen$() - minColour.getGreen$());
var b=minColour.getBlue$() + prop * (maxColour.getBlue$() - minColour.getBlue$());
return Clazz.new_($I$(3,1).c$$F$F$F,[r / 255, g / 255, b / 255]);
}, 1);

Clazz.newMeth(C$, 'bleachColour$java_awt_Color$F',  function (colour, bleachFactor) {
if (bleachFactor >= 1.0 ) {
return $I$(3).WHITE;
}if (bleachFactor <= -1.0 ) {
return $I$(3).BLACK;
}if (bleachFactor == 0.0 ) {
return colour;
}var red=colour.getRed$();
var green=colour.getGreen$();
var blue=colour.getBlue$();
if (bleachFactor > 0 ) {
red=(red+((255 - red) * bleachFactor)|0);
green=(green+((255 - green) * bleachFactor)|0);
blue=(blue+((255 - blue) * bleachFactor)|0);
return Clazz.new_($I$(3,1).c$$I$I$I,[red, green, blue]);
} else {
var factor=1 + bleachFactor;
red=(red*(factor)|0);
green=(green*(factor)|0);
blue=(blue*(factor)|0);
return Clazz.new_($I$(3,1).c$$I$I$I,[red, green, blue]);
}}, 1);

Clazz.newMeth(C$, 'parseColourString$S',  function (colour) {
if (colour == null ) {
return null;
}colour=colour.trim$();
var col=null;
if ("random".equals$O(colour)) {
return C$.generateRandomColor$java_awt_Color(null);
}try {
var value=Integer.parseInt$S$I(colour, 16);
col=Clazz.new_($I$(3,1).c$$I,[value]);
} catch (ex) {
if (Clazz.exceptionOf(ex,"NumberFormatException")){
} else {
throw ex;
}
}
if (col == null ) {
col=C$.getAWTColorFromName$S(colour);
}if (col == null ) {
try {
var tokens=colour.split$S(",");
if (tokens.length == 3) {
var r=Integer.parseInt$S(tokens[0].trim$());
var g=Integer.parseInt$S(tokens[1].trim$());
var b=Integer.parseInt$S(tokens[2].trim$());
col=Clazz.new_($I$(3,1).c$$I$I$I,[r, g, b]);
}} catch (ex) {
if (Clazz.exceptionOf(ex,"IllegalArgumentException")){
} else {
throw ex;
}
}
}return col;
}, 1);

Clazz.newMeth(C$, 'createColourFromName$S',  function (name) {
if (name == null ) {
return $I$(3).white;
}if (C$.myColours.containsKey$O(name)) {
return C$.myColours.get$O(name);
}var lsize=name.length$();
var start=0;
var end=(lsize/3|0);
var rgbOffset=Math.abs(name.hashCode$() % 10) * 15;
var r=Math.abs(name.substring$I$I(start, end).hashCode$() + rgbOffset) % 210 + 20;
start=end;
end+=(lsize/3|0);
if (end > lsize) {
end=lsize;
}var g=Math.abs(name.substring$I$I(start, end).hashCode$() + rgbOffset) % 210 + 20;
var b=Math.abs(name.substring$I(end).hashCode$() + rgbOffset) % 210 + 20;
var color=Clazz.new_($I$(3,1).c$$I$I$I,[r, g, b]);
if (C$.myColours.size$() < 1729) {
C$.myColours.put$O$O(name, color);
}return color;
}, 1);

Clazz.newMeth(C$, 'getAWTColorFromName$S',  function (name) {
if (name == null ) {
return null;
}var col=null;
name=name.toLowerCase$java_util_Locale($I$(4).ROOT);
switch (name) {
case "black":
col=$I$(3).black;
break;
case "blue":
col=$I$(3).blue;
break;
case "cyan":
col=$I$(3).cyan;
break;
case "darkgray":
col=$I$(3).darkGray;
break;
case "gray":
col=$I$(3).gray;
break;
case "green":
col=$I$(3).green;
break;
case "lightgray":
col=$I$(3).lightGray;
break;
case "magenta":
col=$I$(3).magenta;
break;
case "orange":
col=$I$(3).orange;
break;
case "pink":
col=$I$(3).pink;
break;
case "red":
col=$I$(3).red;
break;
case "white":
col=$I$(3).white;
break;
case "yellow":
col=$I$(3).yellow;
break;
}
return col;
}, 1);

Clazz.newMeth(C$, 'getHSBRanges$S',  function (colourScheme) {
var Hmin=0.0;
var Hmax=1.0;
var Smin=0.6;
var Smax=1.0;
var Bmin=0.6;
var Bmax=1.0;
if (!colourScheme.contains$CharSequence($I$(5).NONE.name$())) {
for (var scheme, $scheme = 0, $$scheme = colourScheme.split$S(","); $scheme<$$scheme.length&&((scheme=($$scheme[$scheme])),1);$scheme++) {
$I$(6).debug$S("Applying colourScheme component " + scheme);
var cs;
try {
cs=$I$(5).valueOf$S(scheme);
} catch (e) {
if (Clazz.exceptionOf(e,"IllegalArgumentException") || Clazz.exceptionOf(e,"NullPointerException")){
$I$(6).warn$S("Did not recognise something in the colour scheme '" + colourScheme + "'" );
return Clazz.array(Float.TYPE, -1, [Hmin, Hmax, Smin, Smax, Bmin, Bmax]);
} else {
throw e;
}
}
switch (cs) {
case $I$(5).AVOID_RED:
Hmin=0.15;
Hmax=0.85;
break;
case $I$(5).AVOID_GREEN:
Hmin=0.48;
Hmax=0.18;
break;
case $I$(5).AVOID_BLUE:
Hmin=0.81;
Hmax=0.51;
break;
case $I$(5).SATURATED:
Smin=1.0;
Smax=1.0;
break;
case $I$(5).DESATURATED:
Smin=0.2;
Smax=0.6;
break;
case $I$(5).GREYISH:
Smin=0.0;
Smax=0.2;
case $I$(5).GREYSCALE:
Smin=0.0;
Smax=0.0;
Bmin=0.1;
Bmax=0.9;
break;
case $I$(5).BRIGHT:
Bmin=1.0;
Bmax=1.0;
break;
case $I$(5).MEDIUM:
Bmin=0.6;
Bmax=0.8;
case $I$(5).DARK:
Bmin=0.1;
Bmax=0.4;
break;
case $I$(5).NONE:
break;
}
}
}return Clazz.array(Float.TYPE, -1, [Hmin, Hmax, Smin, Smax, Bmin, Bmax]);
}, 1);

Clazz.newMeth(C$, 'getHSBColourSpacedCacheKey$S$S',  function (name, colourScheme) {
return name.hashCode$() + "::" + colourScheme ;
}, 1);

Clazz.newMeth(C$, 'restoreMyHSBSpacedColours$java_util_Map',  function (colorMap) {
for (var entry, $entry = colorMap.entrySet$().iterator$(); $entry.hasNext$()&&((entry=($entry.next$())),1);) {
var cacheKey=C$.getHSBColourSpacedCacheKey$S$S(entry.getKey$(), "NONE");
C$.myHSBSpacedColours.put$O$O(cacheKey, entry.getValue$());
}
}, 1);

Clazz.newMeth(C$, 'getColourFromNameAndScheme$S$S',  function (name, colourScheme) {
var cacheKey=C$.getHSBColourSpacedCacheKey$S$S(name, colourScheme);
if (C$.myHSBSpacedColours.containsKey$O(cacheKey)) {
return C$.myHSBSpacedColours.get$O(cacheKey);
}var vals=C$.getHSBRanges$S(colourScheme);
var col=null;
if (vals.length > 5) {
col=C$.getHSBColourspacedColourFromName$S$F$F$F$F$F$F(name, vals[0], vals[1], vals[2], vals[3], vals[4], vals[5]);
var iterationCounter=0;
C$.HSB_DISTANCE_THRESHOLD=0.5;
while (!C$.isColorDistinct$java_awt_Color(col)){
col=C$.adjustColor$java_awt_Color(col);
++iterationCounter;
if (iterationCounter > 100) {
C$.HSB_DISTANCE_THRESHOLD=C$.HSB_DISTANCE_THRESHOLD - 0.01;
iterationCounter=0;
}}
C$.myHSBSpacedColours.put$O$O(cacheKey, col);
}return col;
}, 1);

Clazz.newMeth(C$, 'getHSBColourspacedColourFromName$S$F$F$F$F$F$F',  function (name, Hmin, Hmax, Smin, Smax, Bmin, Bmax) {
if (name == null ) {
return $I$(3).white;
}var hash=$I$(7).getHashedBytes$S(name);
var b=hash.length > 0 ? Byte.toUnsignedInt$B(hash[0]) : 0;
var g=hash.length > 1 ? Byte.toUnsignedInt$B(hash[1]) : 0;
var r=hash.length > 2 ? Byte.toUnsignedInt$B(hash[2]) : 0;
var hsbf=$I$(3).RGBtoHSB$I$I$I$FA(r, g, b, null);
if (hsbf.length < 3) {
$I$(6).warn$S("Unexpected short length of HSB float array");
}var h0=hsbf.length > 0 ? hsbf[0] : 0.0;
var s0=hsbf.length > 1 ? hsbf[1] : 0.0;
var b0=hsbf.length > 2 ? hsbf[2] : 0.0;
var h1=0.0;
if (Hmin > Hmax ) {
Hmax+=1.0;
}h1=Hmin + (Hmax - Hmin) * h0;
if (h1 > 1.0 ) {
h1-=1.0;
}var s1=Smin + (Smax - Smin) * s0;
var b1=Bmin + (Bmax - Bmin) * b0;
$I$(6,"debug$S",["Setting new colour for '" + name + "' with H=" + new Float(h1).toString() + ", S=" + new Float(s1).toString() + ", B=" + new Float(b1).toString() ]);
return $I$(3).getHSBColor$F$F$F(h1, s1, b1);
}, 1);

Clazz.newMeth(C$, 'isColorDistinct$java_awt_Color',  function (newColor) {
var newHSB=C$.convertRGBColorToHSB$java_awt_Color(newColor);
for (var existingColor, $existingColor = C$.myHSBSpacedColours.values$().iterator$(); $existingColor.hasNext$()&&((existingColor=($existingColor.next$())),1);) {
var existingHSB=C$.convertRGBColorToHSB$java_awt_Color(existingColor);
var distanceFromExistingColor=C$.hsbDistance$FA$FA(newHSB, existingHSB);
if (distanceFromExistingColor < C$.HSB_DISTANCE_THRESHOLD ) {
return false;
}}
return true;
}, 1);

Clazz.newMeth(C$, 'adjustColor$java_awt_Color',  function (col) {
var hsbComponents=C$.convertRGBColorToHSB$java_awt_Color(col);
hsbComponents[0]=((hsbComponents[0] + 0.6180339887) % 1.0);
if (hsbComponents[0] > 1.0 ) {
hsbComponents[0]-=1.0;
}hsbComponents[1]=0.4 + (hsbComponents[0] * 0.5);
hsbComponents[2]=0.5 + (hsbComponents[0] * 0.4);
var adjustedColor=$I$(3).getHSBColor$F$F$F(hsbComponents[0], hsbComponents[1], hsbComponents[2]);
return adjustedColor;
}, 1);

Clazz.newMeth(C$, 'convertRGBColorToHSB$java_awt_Color',  function (color) {
var hsb=Clazz.array(Float.TYPE, [3]);
$I$(3,"RGBtoHSB$I$I$I$FA",[color.getRed$(), color.getGreen$(), color.getBlue$(), hsb]);
return hsb;
}, 1);

Clazz.newMeth(C$, 'hsbDistance$FA$FA',  function (hsbX, hsbY) {
var diffH=Math.abs(hsbX[0] - hsbY[0]);
if (diffH > 0.5 ) {
diffH=1.0 - diffH;
}var diffS=hsbX[1] - hsbY[1];
var diffB=hsbX[2] - hsbY[2];
return Math.sqrt(diffH * diffH + diffS * diffS + diffB * diffB);
}, 1);

C$.$static$=function(){C$.$static$=0;
C$.myColours=Clazz.new_($I$(1,1));
C$.myHSBSpacedColours=Clazz.new_($I$(1,1));
C$.HSB_DISTANCE_THRESHOLD=0.5;
};
;
(function(){/*e*/var C$=Clazz.newClass(P$.ColorUtils, "ColourScheme", function(){
Clazz.newInstance(this, arguments[0],false,C$);
}, 'Enum');

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

C$.$static$=function(){C$.$static$=0;
$vals=Clazz.array(C$,[0]);
Clazz.newEnumConst($vals, C$.c$, "NONE", 0, []);
Clazz.newEnumConst($vals, C$.c$, "AVOID_RED", 1, []);
Clazz.newEnumConst($vals, C$.c$, "AVOID_GREEN", 2, []);
Clazz.newEnumConst($vals, C$.c$, "AVOID_BLUE", 3, []);
Clazz.newEnumConst($vals, C$.c$, "SATURATED", 4, []);
Clazz.newEnumConst($vals, C$.c$, "MEDIUM_SATURATION", 5, []);
Clazz.newEnumConst($vals, C$.c$, "DESATURATED", 6, []);
Clazz.newEnumConst($vals, C$.c$, "GREYISH", 7, []);
Clazz.newEnumConst($vals, C$.c$, "GREYSCALE", 8, []);
Clazz.newEnumConst($vals, C$.c$, "BRIGHT", 9, []);
Clazz.newEnumConst($vals, C$.c$, "MEDIUM", 10, []);
Clazz.newEnumConst($vals, C$.c$, "DARK", 11, []);
};

Clazz.newMeth(C$);
var $vals=[];
Clazz.newMeth(C$, 'values$', function() { return $vals }, 1);
Clazz.newMeth(C$, 'valueOf$S', function(name) { for (var val in $vals){ if ($vals[val].name == name) return $vals[val]} return null }, 1);
})()

Clazz.newMeth(C$);
})();
;Clazz.setTVer('3.3.1-v1');//Created 2025-12-10 08:03:07 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
