(function(){var P$=Clazz.newPackage("jalview.ws.slivkaws"),p$1={},I$=[[0,'java.util.List','java.util.concurrent.CopyOnWriteArraySet','java.util.concurrent.Executors','java.util.Vector','java.util.concurrent.CompletableFuture','jalview.bin.Console','java.util.Collections','java.util.ArrayList','uk.ac.dundee.compbio.slivkaclient.SlivkaClient','jalview.ws.slivkaws.RNAalifoldServiceInstance','jalview.ws.slivkaws.SlivkaAnnotationServiceInstance','jalview.ws.slivkaws.SlivkaMsaServiceInstance','java.util.concurrent.Future','jalview.bin.Cache','java.net.URL']],I$0=I$[0],$I$=function(i,n,m){return m?$I$(i)[n].apply(null,m):((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "SlivkaWSDiscoverer", null, null, 'jalview.ws.WSDiscovererI');

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
this.services=$I$(1).of$();
this.serviceListeners=Clazz.new_($I$(2,1));
this.executor=$I$(3).newSingleThreadExecutor$();
this.discoveryTasks=Clazz.new_($I$(4,1));
},1);

C$.$fields$=[['O',['services','java.util.List','serviceListeners','java.util.Set','executor','java.util.concurrent.ExecutorService','discoveryTasks','java.util.Vector']]
,['O',['instance','jalview.ws.slivkaws.SlivkaWSDiscoverer']]]

Clazz.newMeth(C$, 'c$',  function () {
;C$.$init$.apply(this);
}, 1);

Clazz.newMeth(C$, 'getInstance$',  function () {
if (C$.instance == null ) {
C$.instance=Clazz.new_(C$);
}return C$.instance;
}, 1);

Clazz.newMeth(C$, 'addServiceChangeListener$jalview_ws_ServiceChangeListener',  function (l) {
this.serviceListeners.add$O(l);
});

Clazz.newMeth(C$, 'removeServiceChangeListener$jalview_ws_ServiceChangeListener',  function (l) {
this.serviceListeners.remove$O(l);
});

Clazz.newMeth(C$, 'notifyServiceListeners$java_util_List',  function (services) {
for (var listener, $listener = this.serviceListeners.iterator$(); $listener.hasNext$()&&((listener=($listener.next$())),1);) {
listener.servicesChanged$jalview_ws_WSDiscovererI$java_util_Collection(this, services);
}
});

Clazz.newMeth(C$, 'startDiscoverer$',  function () {
var task=$I$(5,"supplyAsync$java_util_function_Supplier$java_util_concurrent_Executor",[((P$.SlivkaWSDiscoverer$lambda1||
(function(){/*m*/var C$=Clazz.newClass(P$, "SlivkaWSDiscoverer$lambda1", function(){Clazz.newInstance(this, arguments[0],1,C$);}, null, 'java.util.function.Supplier', 1);

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);
/*lambda_E*/
Clazz.newMeth(C$, 'get$',  function () {
p$1.reloadServices.apply(this.b$['jalview.ws.slivkaws.SlivkaWSDiscoverer'], []);
return this.b$['jalview.ws.slivkaws.SlivkaWSDiscoverer'];
});
})()
), Clazz.new_(P$.SlivkaWSDiscoverer$lambda1.$init$,[this, null])), this.executor]);
this.discoveryTasks.add$O(task);
return task;
});

Clazz.newMeth(C$, 'reloadServices',  function () {
$I$(6).info$S("Reloading Slivka services");
this.notifyServiceListeners$java_util_List($I$(7).emptyList$());
var instances=Clazz.new_($I$(8,1));
for (var url, $url = this.getServiceUrls$().iterator$(); $url.hasNext$()&&((url=($url.next$())),1);) {
var client=$I$(9).newInstance$S(url);
var services;
try {
services=client.getServices$();
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
e.printStackTrace$();
continue;
} else {
throw e;
}
}
for (var service, $service = services.iterator$(); $service.hasNext$()&&((service=($service.next$())),1);) {
var newInstance=null;
for (var classifier, $classifier = service.classifiers.iterator$(); $classifier.hasNext$()&&((classifier=($classifier.next$())),1);) {
var path=classifier.split$S("\\s*::\\s*");
if (path.length >= 3 && path[0].toLowerCase$().equals$O("operation")  && path[1].toLowerCase$().equals$O("analysis") ) {
switch (path[path.length - 1].toLowerCase$()) {
case "rna secondary structure prediction":
newInstance=Clazz.new_($I$(10,1).c$$uk_ac_dundee_compbio_slivkaclient_SlivkaClient$uk_ac_dundee_compbio_slivkaclient_SlivkaService$S,[client, service, "Secondary Structure Prediction"]);
break;
case "sequence alignment analysis (conservation)":
newInstance=Clazz.new_($I$(11,1).c$$uk_ac_dundee_compbio_slivkaclient_SlivkaClient$uk_ac_dundee_compbio_slivkaclient_SlivkaService$S,[client, service, "Conservation"]);
break;
case "protein sequence analysis":
newInstance=Clazz.new_($I$(11,1).c$$uk_ac_dundee_compbio_slivkaclient_SlivkaClient$uk_ac_dundee_compbio_slivkaclient_SlivkaService$S,[client, service, "Protein Disorder"]);
break;
case "protein secondary structure prediction":
newInstance=Clazz.new_($I$(11,1).c$$uk_ac_dundee_compbio_slivkaclient_SlivkaClient$uk_ac_dundee_compbio_slivkaclient_SlivkaService$S,[client, service, "Secondary Structure Prediction"]);
break;
case "multiple sequence alignment":
newInstance=Clazz.new_($I$(12,1).c$$uk_ac_dundee_compbio_slivkaclient_SlivkaClient$uk_ac_dundee_compbio_slivkaclient_SlivkaService$S,[client, service, "Alignment"]);
break;
}
}if (newInstance != null ) break;
}
if (newInstance != null ) instances.add$O(newInstance);
}
}
this.services=instances;
$I$(6).info$S("Slivka services reloading finished");
this.notifyServiceListeners$java_util_List(instances);
return instances;
}, p$1);

Clazz.newMeth(C$, 'getServices$',  function () {
return this.services;
});

Clazz.newMeth(C$, 'hasServices$',  function () {
return !this.isRunning$() && this.services.size$() > 0 ;
});

Clazz.newMeth(C$, 'isRunning$',  function () {
return !this.discoveryTasks.stream$().allMatch$java_util_function_Predicate((function($$){((
(function(){/*m*/var C$=Clazz.newClass(P$, "SlivkaWSDiscoverer$lambda2", function(){Clazz.newInstance(this, arguments[0],1,C$);}, null, 'java.util.function.Predicate', 1);

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);
/*lambda_M*/
Clazz.newMeth(C$, 'test$O',  function (t) { return t.isDone$.apply(t,[])});
})()
)); return Clazz.new_(P$.SlivkaWSDiscoverer$lambda2.$init$,[this, null])})($I$(13)));
});

Clazz.newMeth(C$, 'setServiceUrls$java_util_List',  function (wsUrls) {
if (wsUrls != null  && !wsUrls.isEmpty$() ) {
$I$(14,"setProperty$S$S",["SLIVKAHOSTURLS", String.join$CharSequence$Iterable(",", wsUrls)]);
} else {
$I$(14).removeProperty$S("SLIVKAHOSTURLS");
}});

Clazz.newMeth(C$, 'getServiceUrls$',  function () {
var surls=$I$(14).getDefault$S$S("SLIVKAHOSTURLS", "https://www.compbio.dundee.ac.uk/slivka/");
var urls=surls.split$S(",");
var valid=Clazz.new_($I$(8,1).c$$I,[urls.length]);
for (var url, $url = 0, $$url = urls; $url<$$url.length&&((url=($$url[$url])),1);$url++) {
try {
Clazz.new_($I$(15,1).c$$S,[url]);
valid.add$O(url);
} catch (e) {
if (Clazz.exceptionOf(e,"java.net.MalformedURLException")){
$I$(6,"warn$S",["Problem whilst trying to make a URL from '" + ((url != null ) ? url : "<null>") + "'" ]);
$I$(6,"warn$S",["This was probably due to a malformed comma separated list in the SLIVKAHOSTURLS entry of $(HOME)/.jalview_properties)"]);
$I$(6).debug$S$Throwable("Exception was ", e);
} else {
throw e;
}
}
}
return valid;
});

Clazz.newMeth(C$, 'testServiceUrl$java_net_URL',  function (url) {
return this.getServerStatusFor$S(url.toString()) == 1;
});

Clazz.newMeth(C$, 'getServerStatusFor$S',  function (url) {
try {
var services=$I$(9).newInstance$S(url).getServices$();
return services.isEmpty$() ? 0 : 1;
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException") || Clazz.exceptionOf(e,"org.json.JSONException")){
$I$(6).error$S$Throwable("Slivka could not retrieve services list", e);
return -1;
} else {
throw e;
}
}
});

Clazz.newMeth(C$, 'getErrorMessages$',  function () {
return "";
});

C$.$static$=function(){C$.$static$=0;
C$.instance=null;
};
})();
;Clazz.setTVer('3.3.1-v1');//Created 2026-01-06 01:58:10 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
