(function(){var P$=Clazz.newPackage("jalview.util"),I$=[[0,'java.util.ArrayList','java.util.HashMap','java.util.Random','java.io.BufferedReader','java.io.FileReader','java.io.PrintWriter','java.io.File','java.util.Scanner','jalview.schemes.ResidueProperties','jalview.io.FileParse','jalview.io.DataSourceType','jalview.io.StockholmFile','jalview.io.HMMFile','StringBuilder','java.io.FileOutputStream','Runtime','Thread','java.io.InputStreamReader']],I$0=I$[0],$I$=function(i,n){return((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "HMMProbabilityDistributionAnalyser");

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
this.reference=null;
this.raw=Clazz.new_($I$(1,1));
this.binned=Clazz.new_($I$(2,1));
this.families="/media/sf_Shared_Folder/PFAM/Family/SeedFamilies.seed";
this.hmms="/media/sf_Shared_Folder/PFAM/HMMs/Pfam-A.hmm";
this.currentFilePosition=0;
this.generator=Clazz.new_($I$(3,1));
this.keepRaw=false;
},1);

C$.$fields$=[['Z',['keepRaw'],'I',['currentFilePosition'],'S',['families','hmms','currentFolder'],'O',['reference','jalview.datamodel.AlignmentAnnotation','sequences','java.util.Vector','hmm','jalview.datamodel.HiddenMarkovModel','raw','java.util.List','binned','java.util.Map','generator','java.util.Random']]]

Clazz.newMeth(C$, 'setFolder$S',  function (path) {
this.currentFolder=path;
});

Clazz.newMeth(C$, 'moveLocationBy$I$java_io_BufferedReader',  function (index, br) {
for (var i=0; i < index; i++) {
var line=br.readLine$();
while (!"//".equals$O(line)){
line=br.readLine$();
}
}
});

Clazz.newMeth(C$, 'run$I$Z',  function (increments, keepRawData) {
this.keepRaw=keepRawData;
try {
this.readPreviousData$S(this.currentFolder);
var posReader=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.currentFolder + "/CurrentPosition.txt"])],$I$(4,1).c$$java_io_Reader);
var line=posReader.readLine$();
posReader.close$();
this.currentFilePosition=Integer.parseInt$S(line);
} catch (e) {
if (Clazz.exceptionOf(e,"Exception")){
System.out.println$S("No previous data found");
} else {
throw e;
}
}
var inputSTO=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.families])],$I$(4,1).c$$java_io_Reader);
var inputHMM=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.hmms])],$I$(4,1).c$$java_io_Reader);
this.moveLocationBy$I$java_io_BufferedReader(this.currentFilePosition, inputHMM);
this.moveLocationBy$I$java_io_BufferedReader(this.currentFilePosition, inputSTO);
var filesRead=0;
var i=0;
while (filesRead < increments){
this.readStockholm$java_io_BufferedReader(inputSTO);
this.readHMM$java_io_BufferedReader(inputHMM);
var count=this.countValidResidues$();
this.processData$I(count);
++filesRead;
++this.currentFilePosition;
System.out.println$I(i);
++i;
}
var p=Clazz.new_([Clazz.new_($I$(7,1).c$$S,[this.currentFolder + "/CurrentPosition.txt"])],$I$(6,1).c$$java_io_File);
p.print$I(this.currentFilePosition);
p.close$();
this.exportData$S(this.currentFolder);
this.raw.clear$();
this.binned.clear$();
});

Clazz.newMeth(C$, 'runToEnd$I$I$Z$Z',  function (minCount, maxCount, keepRawData, forClans) {
this.keepRaw=keepRawData;
var inputSTO=null;
var inputHMM=null;
var size=0;
var files=1;
try {
if (forClans) {
files=603;
}var filesRead=0;
for (var clan=0; clan < files; clan++) {
System.out.println$I(clan);
var clanPath="";
var numberOfFamilies=0;
if (forClans) {
clanPath=this.currentFolder + "/Clan" + clan ;
if (!Clazz.new_($I$(7,1).c$$S,[clanPath]).exists$()) {
continue;
}var famCountReader=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[clanPath + "/NumberOfFamilies.txt"])],$I$(4,1).c$$java_io_Reader);
numberOfFamilies=Integer.parseInt$S(famCountReader.readLine$());
} else {
numberOfFamilies=1;
}for (var fam=0; fam < numberOfFamilies; fam++) {
if (forClans) {
this.families=clanPath + "/Families/Fam" + fam + ".sto" ;
this.hmms=clanPath + "/HMMs/HMM" + fam + ".hmm" ;
}inputSTO=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.families])],$I$(4,1).c$$java_io_Reader);
inputHMM=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.hmms])],$I$(4,1).c$$java_io_Reader);
var i=0;
var endReached=this.atEnd$java_io_BufferedReader(inputSTO);
while (!endReached){
this.readStockholm$java_io_BufferedReader(inputSTO);
this.readHMM$java_io_BufferedReader(inputHMM);
var count=this.countValidResidues$();
if (count >= minCount && count < maxCount ) {
this.processData$I(count);
}++filesRead;
System.out.println$I(filesRead);
endReached=this.atEnd$java_io_BufferedReader(inputSTO);
}
}
}
} catch (e) {
if (Clazz.exceptionOf(e,"Exception")){
e.printStackTrace$();
} else {
throw e;
}
} finally {
this.exportData$S(this.currentFolder);
this.raw.clear$();
this.binned.clear$();
}
});

Clazz.newMeth(C$, 'readPreviousData$S',  function (source) {
this.readBinned$S(source);
if (this.keepRaw) {
this.readRaw$S(source);
}});

Clazz.newMeth(C$, 'readBinned$S',  function (source) {
var input=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[source + "/Binned.csv"])],$I$(4,1).c$$java_io_Reader);
var line=input.readLine$();
this.binned=Clazz.new_($I$(2,1));
while (!("".equals$O(line) || line == null  )){
var scanner=Clazz.new_($I$(8,1).c$$S,[line]);
scanner.useDelimiter$S(",");
var key=scanner.next$();
var value=scanner.next$();
this.binned.put$O$O(key, Double.valueOf$S(value));
scanner.close$();
line=input.readLine$();
}
input.close$();
});

Clazz.newMeth(C$, 'readRaw$S',  function (source) {
var input=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[source + "/Raw.csv"])],$I$(4,1).c$$java_io_Reader);
var line=input.readLine$();
if (line == null ) {
input.close$();
return;
}var numberScanner=Clazz.new_($I$(8,1).c$$S,[line]);
numberScanner.useDelimiter$S(",");
this.raw=Clazz.new_($I$(1,1));
while (numberScanner.hasNext$()){
numberScanner.next$();
this.raw.add$O(Clazz.new_($I$(1,1)));
}
numberScanner.close$();
line=input.readLine$();
while (!("".equals$O(line) || line == null  )){
var scanner=Clazz.new_($I$(8,1).c$$S,[line]);
scanner.useDelimiter$S(",");
var i=0;
while (scanner.hasNext$()){
var value;
value=scanner.next$();
if (!value.equals$O("EMPTY")) {
this.raw.get$I(i).add$O(Double.valueOf$D(Double.parseDouble$S(value)));
} else {
this.raw.get$I(i).add$O(null);
}++i;
}
scanner.close$();
line=input.readLine$();
}
input.close$();
});

Clazz.newMeth(C$, 'countValidResidues$',  function () {
var count=0;
for (var width=0; width < this.sequences.size$(); width++) {
for (var length=1; length < this.hmm.getLength$() + 1; length++) {
var symbol;
var alignPos;
alignPos=this.hmm.getNodeMapPosition$I(length);
symbol=this.sequences.get$I(width).getCharAt$I(alignPos);
if ($I$(9).backgroundFrequencies.get$O("amino").containsKey$O(Character.valueOf$C(symbol))) {
++count;
}}
}
return count;
});

Clazz.newMeth(C$, 'processData$I',  function (count) {
var rawPos=0;
if (this.keepRaw) {
this.raw.add$O(Clazz.new_($I$(1,1)));
rawPos=this.raw.size$() - 1;
}var total=Double.valueOf$D(0.0);
for (var width=0; width < this.sequences.size$(); width++) {
for (var length=1; length < this.hmm.getLength$() + 1; length++) {
var symbol;
var alignPos;
alignPos=this.hmm.getNodeMapPosition$I(length);
symbol=this.sequences.get$I(width).getCharAt$I(alignPos);
if ($I$(9).backgroundFrequencies.get$O("amino").containsKey$O(Character.valueOf$C(symbol))) {
var prob;
var bfreq;
var llr;
prob=Double.valueOf$D(this.hmm.getMatchEmissionProbability$I$C(alignPos, symbol));
bfreq=$I$(9).backgroundFrequencies.get$O("amino").get$O(Character.valueOf$C(symbol));
if ((prob).$c() === 0  || (bfreq).$c() === 0  ) {
System.out.println$S("error");
}llr=Double.valueOf$D(Math.log((prob).$c() / (bfreq).$c()));
if (this.keepRaw) {
this.raw.get$I(rawPos).add$O(llr);
}var output;
output=String.format$S$OA("%.1f", Clazz.array(java.lang.Object, -1, [llr]));
total=Double.valueOf$D((total).valueOf()+(Double.parseDouble$S(output)));
if ("-0.0".equals$O(output)) {
output="0.0";
}if (this.binned.containsKey$O(output)) {
var prev=(this.binned.get$O(output)).valueOf();
prev+=(1.0 / count);
this.binned.put$O$O(output, Double.valueOf$D(prev));
} else {
this.binned.put$O$O(output, Double.valueOf$D(1.0 / count));
}}}
}
System.out.println$D((total).$c() / count);
});

Clazz.newMeth(C$, 'readStockholm$java_io_BufferedReader',  function (inputSTO) {
var parserSTO=Clazz.new_([inputSTO, "", $I$(11).FILE],$I$(10,1).c$$java_io_BufferedReader$S$jalview_io_DataSourceType);
var file=Clazz.new_($I$(12,1).c$$jalview_io_FileParse,[parserSTO]);
var annots=file.getAnnotations$();
for (var annot, $annot = annots.iterator$(); $annot.hasNext$()&&((annot=($annot.next$())),1);) {
if (annot.label.contains$CharSequence("Reference")) {
this.reference=annot;
}}
this.sequences=file.getSeqs$();
});

Clazz.newMeth(C$, 'readHMM$java_io_BufferedReader',  function (inputHMM) {
var parserHMM=Clazz.new_([inputHMM, "", $I$(11).FILE],$I$(10,1).c$$java_io_BufferedReader$S$jalview_io_DataSourceType);
var file=Clazz.new_($I$(13,1).c$$jalview_io_FileParse,[parserHMM]);
this.hmm=file.getHMM$();
});

Clazz.newMeth(C$, 'exportData$S',  function (location) {
var writerBin=Clazz.new_([Clazz.new_($I$(7,1).c$$S,[location + "/Binned.csv"])],$I$(6,1).c$$java_io_File);
for (var entry, $entry = this.binned.entrySet$().iterator$(); $entry.hasNext$()&&((entry=($entry.next$())),1);) {
writerBin.println$S(entry.getKey$() + "," + entry.getValue$().toString() );
}
writerBin.close$();
if (this.keepRaw) {
var writerRaw=Clazz.new_([Clazz.new_($I$(7,1).c$$S,[location + "/Raw.csv"])],$I$(6,1).c$$java_io_File);
var identifier=Clazz.new_($I$(14,1));
for (var i=1; i < this.raw.size$() + 1; i++) {
identifier.append$S("Fam " + i + "," );
}
writerRaw.println$O(identifier);
var rowIsEmpty=false;
var row=0;
while (!rowIsEmpty){
rowIsEmpty=true;
var string=Clazz.new_($I$(14,1));
for (var column=0; column < this.raw.size$(); column++) {
if (this.raw.get$I(column).size$() <= row) {
string.append$S("EMPTY,");
} else {
string.append$S(this.raw.get$I(column).get$I(row).toString() + ",");
rowIsEmpty=false;
}}
++row;
writerRaw.println$O(string);
}
writerRaw.close$();
}});

Clazz.newMeth(C$, 'printFam$I',  function (index) {
var br=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.families])],$I$(4,1).c$$java_io_Reader);
this.moveLocationBy$I$java_io_BufferedReader(index, br);
var line=br.readLine$();
while (!"//".equals$O(line)){
System.out.println$S(line);
line=br.readLine$();
}
System.out.println$S(line);
br.close$();
});

Clazz.newMeth(C$, 'printHMM$I',  function (index) {
var br=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.hmms])],$I$(4,1).c$$java_io_Reader);
this.moveLocationBy$I$java_io_BufferedReader(index, br);
var line=br.readLine$();
while (!"//".equals$O(line)){
System.out.println$S(line);
line=br.readLine$();
}
System.out.println$S(line);
br.close$();
});

Clazz.newMeth(C$, 'exportFam$I$S',  function (index, location) {
var br=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.families])],$I$(4,1).c$$java_io_Reader);
this.moveLocationBy$I$java_io_BufferedReader(index, br);
var line=br.readLine$();
var writer=Clazz.new_([Clazz.new_([Clazz.new_($I$(7,1).c$$S,[location]), true],$I$(15,1).c$$java_io_File$Z)],$I$(6,1).c$$java_io_OutputStream);
while (!"//".equals$O(line)){
writer.println$S(line);
line=br.readLine$();
}
writer.println$S(line);
writer.close$();
br.close$();
});

Clazz.newMeth(C$, 'exportFile$java_io_BufferedReader$S$Z',  function (br, location, append) {
var line=br.readLine$();
var writer=Clazz.new_([Clazz.new_($I$(15,1).c$$S$Z,[location, append])],$I$(6,1).c$$java_io_OutputStream);
while (!"//".equals$O(line)){
writer.println$S(line);
line=br.readLine$();
}
writer.println$S(line);
writer.close$();
});

Clazz.newMeth(C$, 'getHMMName$I',  function (index) {
var name;
var nameFinder=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.hmms])],$I$(4,1).c$$java_io_Reader);
this.moveLocationBy$I$java_io_BufferedReader(index, nameFinder);
nameFinder.readLine$();
var scanner=Clazz.new_([nameFinder.readLine$()],$I$(8,1).c$$S);
name=scanner.next$();
name=scanner.next$();
scanner.close$();
return name;
});

Clazz.newMeth(C$, 'getFamilyName$I',  function (index) {
var name;
var nameFinder=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.families])],$I$(4,1).c$$java_io_Reader);
this.moveLocationBy$I$java_io_BufferedReader(index, nameFinder);
nameFinder.readLine$();
var scanner=Clazz.new_([nameFinder.readLine$()],$I$(8,1).c$$S);
name=scanner.next$();
name=scanner.next$();
name=scanner.next$();
scanner.close$();
return name;
});

Clazz.newMeth(C$, 'exportHMM$I$S',  function (index, location) {
var br=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.hmms])],$I$(4,1).c$$java_io_Reader);
this.moveLocationBy$I$java_io_BufferedReader(index, br);
var line=br.readLine$();
var writer=Clazz.new_([Clazz.new_([Clazz.new_($I$(7,1).c$$S,[location]), true],$I$(15,1).c$$java_io_File$Z)],$I$(6,1).c$$java_io_OutputStream);
while (!"//".equals$O(line)){
writer.println$S(line);
line=br.readLine$();
}
writer.println$S(line);
writer.close$();
br.close$();
});

Clazz.newMeth(C$, 'clear$',  function () {
var pos=Clazz.new_($I$(6,1).c$$S,[this.currentFolder + "/CurrentPosition.txt"]);
pos.println$S("0");
var raw=Clazz.new_($I$(6,1).c$$S,[this.currentFolder + "/Raw.csv"]);
var bin=Clazz.new_($I$(6,1).c$$S,[this.currentFolder + "/Binned.csv"]);
pos.close$();
bin.close$();
raw.close$();
});

Clazz.newMeth(C$, 'sortIntoClans$S',  function (directory) {
var clanFinder=Clazz.new_([Clazz.new_($I$(5,1).c$$S,["/media/sf_Shared_Folder/PFAM/Family/Clanlinks.dat"])],$I$(4,1).c$$java_io_Reader);
var familyReader=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.families])],$I$(4,1).c$$java_io_Reader);
var hmmReader=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[this.hmms])],$I$(4,1).c$$java_io_Reader);
var families=0;
var clanIndexes=Clazz.new_($I$(2,1));
var familyCounts=Clazz.new_($I$(1,1));
var filePos=0;
var clanCount=0;
var line;
line=clanFinder.readLine$();
while (!"".equals$O(line) && !" ".equals$O(line) && line != null   ){
var clanName;
var inClan=false;
while (!(line.indexOf$S("//") > -1)){
if (line.indexOf$S("#=GF CL") > -1) {
++families;
System.out.println$I(families);
inClan=true;
var scanner=Clazz.new_($I$(8,1).c$$S,[line]);
scanner.next$();
scanner.next$();
clanName=scanner.next$();
scanner.close$();
if (!clanIndexes.containsKey$O(clanName)) {
clanIndexes.put$O$O(clanName, Integer.valueOf$I(clanCount));
++clanCount;
familyCounts.add$O(Integer.valueOf$I(0));
}var clanI=clanIndexes.get$O(clanName);
var clanPath=directory + "/Clan" + clanI.toString() ;
this.createFolders$S(clanPath);
var index=(clanIndexes.get$O(clanName)).$c();
this.exportFile$java_io_BufferedReader$S$Z(familyReader, clanPath + "/Families/Fam" + familyCounts.get$I(index) + ".sto" , false);
this.exportFile$java_io_BufferedReader$S$Z(hmmReader, clanPath + "/HMMs/HMM" + familyCounts.get$I(index) + ".hmm" , false);
var count=(familyCounts.get$I(index)).$c();
++count;
familyCounts.set$I$O(index, Integer.valueOf$I(count));
}line=clanFinder.readLine$();
}
if (!inClan) {
this.moveLocationBy$I$java_io_BufferedReader(1, familyReader);
this.moveLocationBy$I$java_io_BufferedReader(1, hmmReader);
}++filePos;
line=clanFinder.readLine$();
}
clanFinder.close$();
for (var clan=0; clan < clanCount; clan++) {
var writer=Clazz.new_($I$(6,1).c$$S,[directory + "/Clan" + clan + "/NumberOfFamilies.txt" ]);
var count=(familyCounts.get$I(clan)).$c();
writer.print$I(count);
writer.close$();
}
});

Clazz.newMeth(C$, 'getFamilies$',  function () {
return this.families;
});

Clazz.newMeth(C$, 'setFamilies$S',  function (families) {
this.families=this.currentFolder + families;
});

Clazz.newMeth(C$, 'getHmms$',  function () {
return this.hmms;
});

Clazz.newMeth(C$, 'setHmms$S',  function (hmms) {
this.hmms=this.currentFolder + hmms;
});

Clazz.newMeth(C$, 'alignWithinClan$S$S',  function (exportLocation, clansLocation) {
var alignmentsExported=0;
for (var clan=0; clan < 604; clan++) {
System.out.println$I(clan);
var famCount=0;
var clanPath=clansLocation + "/Clan" + clan ;
var numberOfFamilies;
var br=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[clanPath + "/NumberOfFamilies.txt"])],$I$(4,1).c$$java_io_Reader);
var line=br.readLine$();
numberOfFamilies=Integer.parseInt$S(line);
br.close$();
if (numberOfFamilies == 1) {
continue;
}var commandExportLocation=exportLocation + "/Clan" + clan ;
this.createFolders$S(commandExportLocation);
for (var family=0; family < numberOfFamilies; family++) {
++famCount;
var indexes=Clazz.new_($I$(1,1));
for (var i=0; i < numberOfFamilies; i++) {
if (i != family) {
indexes.add$O(Integer.valueOf$I(i));
}}
var hmmIndex=this.getRandom$java_util_ArrayList(indexes);
var famPath=clanPath + "/Families/Fam" + family + ".sto" ;
var hmmPath=clanPath + "/HMMs/HMM" + hmmIndex + ".hmm" ;
var command="/media/sf_Shared_Folder/hmmer/binaries/hmmalign --mapali " + clanPath + "/Families/Fam" + hmmIndex + ".sto" + " --trim " ;
command+=hmmPath + " ";
command+=famPath;
var familyIndex=family;
var p=$I$(16).getRuntime$().exec$S(command);
Clazz.new_([((P$.HMMProbabilityDistributionAnalyser$1||
(function(){/*a*/var C$=Clazz.newClass(P$, "HMMProbabilityDistributionAnalyser$1", function(){Clazz.newInstance(this, arguments[0],1,C$);}, null, 'Runnable', 1);

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

Clazz.newMeth(C$, 'run$',  function () {
var input=Clazz.new_([Clazz.new_([this.$finals$.p.getInputStream$()],$I$(18,1).c$$java_io_InputStream)],$I$(4,1).c$$java_io_Reader);
var line=null;
try {
var writer=Clazz.new_($I$(6,1).c$$S,[this.$finals$.commandExportLocation + "/Families/Fam" + this.$finals$.familyIndex + ".sto" ]);
var lastLine="";
var dataFound=false;
while ((line=input.readLine$()) != null ){
if (line.contains$CharSequence("#=GR") && !dataFound ) {
writer.println$S(lastLine);
dataFound=true;
}if (line.contains$CharSequence("#") || dataFound || " ".equals$O(line) || "".equals$O(line) || "//".equals$O(line)  ) {
writer.println$S(line);
}lastLine=line;
}
writer.close$();
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
e.printStackTrace$();
} else {
throw e;
}
}
});
})()
), Clazz.new_(P$.HMMProbabilityDistributionAnalyser$1.$init$,[this, {commandExportLocation:commandExportLocation,p:p,familyIndex:familyIndex}]))],$I$(17,1).c$$Runnable).start$();
p.waitFor$();
var hmmExporter=Clazz.new_([Clazz.new_($I$(5,1).c$$S,[hmmPath])],$I$(4,1).c$$java_io_Reader);
this.exportFile$java_io_BufferedReader$S$Z(hmmExporter, commandExportLocation + "/HMMs/HMM" + family + ".hmm" , false);
++alignmentsExported;
}
var writer=Clazz.new_($I$(6,1).c$$S,[commandExportLocation + "/NumberOfFamilies.txt"]);
writer.print$I(famCount);
writer.close$();
}
});

Clazz.newMeth(C$, 'atEnd$java_io_BufferedReader',  function (br) {
var end=false;
br.mark$I(80);
var line=br.readLine$();
if ("".equals$O(line) || line == null  ) {
end=true;
}br.reset$();
return end;
});

Clazz.newMeth(C$, 'getRandom$java_util_ArrayList',  function (list) {
if (!(list.size$() > 0)) {
System.out.println$S("Error - size = " + list.size$());
}var index=this.generator.nextInt$I(list.size$());
var value=(list.get$I(index)).$c();
list.remove$I(index);
return value;
});

Clazz.newMeth(C$, 'createFolders$S',  function (clanPath) {
var clanFolder=Clazz.new_($I$(7,1).c$$S,[clanPath]);
if (!clanFolder.exists$()) {
clanFolder.mkdir$();
}var famFolder=Clazz.new_($I$(7,1).c$$S,[clanPath + "/Families"]);
var hmmFolder=Clazz.new_($I$(7,1).c$$S,[clanPath + "/HMMs"]);
if (!famFolder.exists$()) {
famFolder.mkdir$();
hmmFolder.mkdir$();
}});

Clazz.newMeth(C$);
})();
;Clazz.setTVer('3.3.1-v1');//Created 2026-01-06 01:58:06 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
