(function(){var P$=Clazz.newPackage("jalview.hmmer"),p$1={},I$=[[0,'jalview.bin.Console','jalview.util.MessageManager','jalview.util.FileUtils','jalview.gui.JvOptionPane','java.util.ArrayList','java.io.BufferedReader','java.io.FileReader','javax.swing.JOptionPane','jalview.io.StockholmFile','jalview.io.FileParse','jalview.io.DataSourceType','jalview.datamodel.SequenceI','jalview.datamodel.Alignment','jalview.gui.AlignFrame','jalview.gui.Desktop','java.util.Collections','jalview.ws.params.simple.Option','jalview.ws.params.simple.BooleanOption','jalview.hmmer.HMMAlign']],I$0=I$[0],$I$=function(i,n,m){return m?$I$(i)[n].apply(null,m):((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "HMMSearch", null, 'jalview.hmmer.Search');

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
this.$realign=false;
this.$trim=false;
this.returnNoOfNewSeqs=false;
this.seqsToReturn=2147483647;
},1);

C$.$fields$=[['Z',['$realign','$trim','returnNoOfNewSeqs'],'I',['seqsToReturn']]]

Clazz.newMeth(C$, 'c$$jalview_gui_AlignFrame$java_util_List',  function (af, args) {
;C$.superclazz.c$$jalview_gui_AlignFrame$java_util_List.apply(this,[af, args]);C$.$init$.apply(this);
}, 1);

Clazz.newMeth(C$, 'run$',  function () {
var hmm=this.getHmmProfile$();
if (hmm == null ) {
$I$(1).error$S("Error: no hmm for hmmsearch");
return;
}var hmmSeq=hmm.getConsensusSequence$();
var msgId=System.currentTimeMillis$();
this.af.setProgressBar$S$J($I$(2).getString$S("status.running_search"), msgId);
try {
var hmmFile=$I$(3).createTempFile$S$S("hmm", ".hmm");
var hitsAlignmentFile=$I$(3).createTempFile$S$S("hitAlignment", ".sto");
var searchOutputFile=$I$(3).createTempFile$S$S("searchOutput", ".sto");
this.exportHmm$jalview_datamodel_HiddenMarkovModel$java_io_File(hmm, hmmFile.getAbsoluteFile$());
var ran=p$1.runCommand$java_io_File$java_io_File$java_io_File.apply(this, [searchOutputFile, hitsAlignmentFile, hmmFile]);
if (!ran) {
$I$(4,"showInternalMessageDialog$java_awt_Component$O",[this.af, $I$(2,"formatMessage$S$OA",["warn.command_failed", Clazz.array(java.lang.Object, -1, ["hmmsearch"])])]);
return;
}p$1.importData$jalview_datamodel_SequenceI$java_io_File$java_io_File$java_io_File.apply(this, [hmmSeq, hitsAlignmentFile, hmmFile, searchOutputFile]);
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException") || Clazz.exceptionOf(e,"InterruptedException")){
e.printStackTrace$();
} else {
throw e;
}
} finally {
this.af.setProgressBar$S$J("", msgId);
}
});

Clazz.newMeth(C$, 'runCommand$java_io_File$java_io_File$java_io_File',  function (searchOutputFile, hitsAlignmentFile, hmmFile) {
var command=this.getCommandPath$S("hmmsearch");
if (command == null ) {
return false;
}var args=Clazz.new_($I$(5,1));
args.add$O(command);
this.buildArguments$java_util_List$java_io_File$java_io_File$java_io_File(args, searchOutputFile, hitsAlignmentFile, hmmFile);
return this.runCommand$java_util_List(args);
}, p$1);

Clazz.newMeth(C$, 'importData$jalview_datamodel_SequenceI$java_io_File$java_io_File$java_io_File',  function (hmmSeq, inputAlignmentTemp, hmmTemp, searchOutputFile) {
var br=Clazz.new_([Clazz.new_($I$(7,1).c$$java_io_File,[inputAlignmentTemp])],$I$(6,1).c$$java_io_Reader);
try {
if (br.readLine$() == null ) {
$I$(8,"showMessageDialog$java_awt_Component$O",[this.af, $I$(2).getString$S("label.no_sequences_found")]);
return;
}var file=Clazz.new_([Clazz.new_([inputAlignmentTemp.getAbsolutePath$(), $I$(11).FILE],$I$(10,1).c$$O$jalview_io_DataSourceType)],$I$(9,1).c$$jalview_io_FileParse);
this.seqs=file.getSeqsAsArray$();
this.readDomainTable$java_io_File$Z(searchOutputFile, false);
if (this.searchAlignment) {
this.recoverSequences$java_util_Map$jalview_datamodel_SequenceIA(this.sequencesHash, this.seqs);
}var modelpos=null;
var ppcons=null;
for (var aa, $aa = file.getAnnotations$().iterator$(); $aa.hasNext$()&&((aa=($aa.next$())),1);) {
if (aa.sequenceRef == null ) {
if (aa.label.equals$O("Reference Positions")) {
modelpos=aa;
}if (aa.label.equals$O("Posterior Probability")) {
ppcons=aa;
}}}
var seqCount=Math.min(this.seqs.length, this.seqsToReturn);
var hmmAndSeqs=Clazz.array($I$(12), [seqCount + 1]);
hmmSeq=hmmSeq.deriveSequence$();
hmmAndSeqs[0]=hmmSeq;
System.arraycopy$O$I$O$I$I(this.seqs, 0, hmmAndSeqs, 1, seqCount);
if (modelpos != null ) {
hmmSeq.setSequence$S(hmmSeq.getDatasetSequence$().getSequenceAsString$());
var refpos=modelpos.annotations;
var gc=0;
var lcol=0;
for (var c=0; c < refpos.length; c++) {
if (refpos[c] != null  && ("x".equals$O(refpos[c].displayCharacter)) ) {
if (gc > 0) {
hmmSeq.insertCharAt$I$I$C(lcol + 1, gc, "-");
}gc=0;
lcol=c;
} else {
++gc;
}}
}if (this.$realign) {
this.realignResults$jalview_datamodel_SequenceIA(hmmAndSeqs);
} else {
var al=Clazz.new_($I$(13,1).c$$jalview_datamodel_SequenceIA,[hmmAndSeqs]);
if (ppcons != null ) {
al.addAnnotation$jalview_datamodel_AlignmentAnnotation(ppcons);
}if (modelpos != null ) {
al.addAnnotation$jalview_datamodel_AlignmentAnnotation(modelpos);
}var alignFrame=Clazz.new_($I$(14,1).c$$jalview_datamodel_AlignmentI$I$I,[al, 700, 500]);
var ttl="hmmSearch of " + this.databaseName + " using " + hmmSeq.getName$() ;
$I$(15).addInternalFrame$javax_swing_JInternalFrame$S$I$I(alignFrame, ttl, 700, 500);
if (this.returnNoOfNewSeqs) {
var nNew=p$1.checkForNewSequences.apply(this, []);
$I$(4,"showMessageDialog$java_awt_Component$S",[this.af.alignPanel, nNew + " " + $I$(2).getString$S("label.new_returned") ]);
}}hmmTemp.delete$();
inputAlignmentTemp.delete$();
searchOutputFile.delete$();
} finally {
if (br != null ) {
br.close$();
}}
}, p$1);

Clazz.newMeth(C$, 'checkForNewSequences',  function () {
var nNew=this.seqs.length;
for (var resultSeq, $resultSeq = 0, $$resultSeq = this.seqs; $resultSeq<$$resultSeq.length&&((resultSeq=($$resultSeq[$resultSeq])),1);$resultSeq++) {
for (var aliSeq, $aliSeq = 0, $$aliSeq = this.alignment.getSequencesArray$(); $aliSeq<$$aliSeq.length&&((aliSeq=($$aliSeq[$aliSeq])),1);$aliSeq++) {
if (resultSeq.getName$().equals$O(aliSeq.getName$())) {
--nNew;
break;
}}
}
return nNew;
}, p$1);

Clazz.newMeth(C$, 'realignResults$jalview_datamodel_SequenceIA',  function (hmmAndSeqs) {
var al=Clazz.new_($I$(13,1).c$$jalview_datamodel_SequenceIA,[hmmAndSeqs]);
var frame=Clazz.new_($I$(14,1).c$$jalview_datamodel_AlignmentI$I$I,[al, 1, 1]);
var alignArgs=Clazz.new_($I$(5,1));
var alignTo=hmmAndSeqs[0].getName$();
var options=$I$(16).singletonList$O(alignTo);
var option=Clazz.new_([$I$(2).getString$S("label.use_hmm"), "", true, alignTo, alignTo, options, null],$I$(17,1).c$$S$S$Z$S$S$java_util_List$java_net_URL);
alignArgs.add$O(option);
if (this.$trim) {
alignArgs.add$O(Clazz.new_([$I$(2).getString$S("label.trim_termini"), $I$(2).getString$S("label.trim_termini_desc"), true, Boolean.valueOf$Z(true), Boolean.valueOf$Z(true), null],$I$(18,1).c$$S$S$Z$Boolean$Boolean$java_net_URL));
}var hmmalign=Clazz.new_($I$(19,1).c$$jalview_gui_AlignFrame$java_util_List,[frame, alignArgs]);
hmmalign.run$();
if (this.returnNoOfNewSeqs) {
var nNew=p$1.checkForNewSequences.apply(this, []);
$I$(4,"showMessageDialog$java_awt_Component$S",[frame.alignPanel, nNew + " " + $I$(2).getString$S("label.new_returned") ]);
}});

Clazz.newMeth(C$);
})();
;Clazz.setTVer('3.3.1-v1');//Created 2026-01-06 01:58:02 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
