(function(){var P$=Clazz.newPackage("jalview.ws2.actions.annotation"),I$=[[0,'java.util.ArrayList','java.util.HashMap','java.util.BitSet','jalview.analysis.SeqsetUtils','jalview.datamodel.Sequence','jalview.analysis.AlignSeq','jalview.util.Comparison','jalview.schemes.ResidueProperties','java.util.Arrays']],I$0=I$[0],$I$=function(i,n,m){return m?$I$(i)[n].apply(null,m):((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "AnnotationJob", null, 'jalview.ws2.actions.BaseJob');

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

C$.$fields$=[['I',['regionStart','regionEnd','minSize'],'O',['gapMap','boolean[]','seqNames','java.util.Map']]]

Clazz.newMeth(C$, 'c$$java_util_List$ZA$java_util_Map$I$I$I',  function (inputSeqs, gapMap, seqNames, start, end, minSize) {
;C$.superclazz.c$$java_util_List.apply(this,[inputSeqs]);C$.$init$.apply(this);
this.gapMap=gapMap;
this.seqNames=seqNames;
this.regionStart=start;
this.regionEnd=end;
this.minSize=minSize;
}, 1);

Clazz.newMeth(C$, 'isInputValid$',  function () {
var nvalid=0;
for (var sq, $sq = this.getInputSequences$().iterator$(); $sq.hasNext$()&&((sq=($sq.next$())),1);) if (sq.getStart$() <= sq.getEnd$()) ++nvalid;

return nvalid >= this.minSize;
});

Clazz.newMeth(C$, 'create$jalview_datamodel_SequenceCollectionI$Z$Z$Z$Z$I',  function (inputSeqs, bySequence, submitGaps, requireAligned, filterNonStandardResidues, minSize) {
var sequences=Clazz.new_($I$(1,1));
var minlen=10;
var width=0;
var namesMap=bySequence ? Clazz.new_($I$(2,1)) : null;
var residueMap=Clazz.new_($I$(3,1));
var start=inputSeqs.getStartRes$();
var end=inputSeqs.getEndRes$();
for (var sq, $sq = inputSeqs.getSequences$().iterator$(); $sq.hasNext$()&&((sq=($sq.next$())),1);) {
var sqLen=(bySequence) ? sq.findPosition$I(end + 1) - sq.findPosition$I(start + 1) : sq.getEnd$() - sq.getStart$();
if (sqLen < minlen) continue;
width=Math.max(width, sq.getLength$());
var newName=$I$(4,"unique_name$I",[sequences.size$() + 1]);
if (namesMap != null ) namesMap.put$O$O(newName, sq);
var seqChars=sq.getSequence$I$I(start, end + 1);
if (filterNonStandardResidues) C$.replaceNonStandardResidues$CA$C$Z(seqChars, "-", sq.isProtein$());
var seq;
if (submitGaps) {
seq=Clazz.new_($I$(5,1).c$$S$CA,[newName, seqChars]);
C$.updateResidueMap$java_util_BitSet$jalview_datamodel_SequenceI(residueMap, seq);
} else {
seq=Clazz.new_([newName, $I$(6,"extractGaps$S$S",[$I$(7).GapChars,  String.instantialize(seqChars)])],$I$(5,1).c$$S$S);
}sequences.add$O(seq);
}
var gapMapArray=null;
if (submitGaps) {
C$.adjustColumns$java_util_List$java_util_BitSet$Z(sequences, residueMap, requireAligned);
gapMapArray=Clazz.array(Boolean.TYPE, [width]);
for (var i=0; i < width; i++) gapMapArray[i]=residueMap.get$I(i);

}return Clazz.new_(C$.c$$java_util_List$ZA$java_util_Map$I$I$I,[sequences, gapMapArray, namesMap, start, end, minSize]);
}, 1);

Clazz.newMeth(C$, 'replaceNonStandardResidues$CA$C$Z',  function (seq, replacement, isProtein) {
for (var i=0; i < seq.length; i++) {
var chr=seq[i];
if (isProtein ? $I$(8).aaIndex[chr.$c()] >= 20 : $I$(8).nucleotideIndex[chr.$c()] >= 5) {
seq[i]=replacement;
}}
}, 1);

Clazz.newMeth(C$, 'updateResidueMap$java_util_BitSet$jalview_datamodel_SequenceI',  function (residueMap, seq) {
var gaps=seq.gapBitset$();
gaps.flip$I$I(0, seq.getLength$());
residueMap.or$java_util_BitSet(gaps);
}, 1);

Clazz.newMeth(C$, 'adjustColumns$java_util_List$java_util_BitSet$Z',  function (sequences, mask, padToLength) {
var width=mask.cardinality$();
for (var seq, $seq = sequences.iterator$(); $seq.hasNext$()&&((seq=($seq.next$())),1);) {
var chars=$I$(4,"filterSequence$CA$java_util_BitSet",[seq.getSequence$(), mask]);
if (padToLength && chars.length < width ) {
var limit=chars.length;
chars=$I$(9).copyOf$CA$I(chars, width);
$I$(9).fill$CA$I$I$C(chars, limit, chars.length, "-");
}seq.setEnd$I(seq.getStart$());
seq.setSequence$CA(chars);
}
}, 1);

Clazz.newMeth(C$);
})();
;Clazz.setTVer('3.3.1-v1');//Created 2026-01-06 03:20:04 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
