(function(){var P$=Clazz.newPackage("jalview.ws.dbsources"),I$=[[0,'java.util.HashMap','com.stevesoft.pat.Regex','java.net.URL','jalview.util.Platform','jalview.bin.Console','java.io.File','jalview.ws.utils.UrlDownloadClient','jalview.util.MessageManager','java.io.FileInputStream','jalview.structure.StructureSelectionManager','jalview.gui.Desktop','jalview.ws.datamodel.alphafold.PAEContactMatrix','jalview.io.FileFormat',['jalview.structure.StructureImportSettings','.TFType'],'jalview.io.FormatAdapter','jalview.io.DataSourceType','java.util.ArrayList','jalview.datamodel.DBRefEntry','jalview.datamodel.SequenceFeature','jalview.io.PDBFeatureSettings']],I$0=I$[0],$I$=function(i,n,m){return m?$I$(i)[n].apply(null,m):((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "EBIAlfaFold", null, 'jalview.ws.dbsources.EbiFileRetrievedProxy');

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

C$.$fields$=[[]
,['S',['AF_VERSION'],'O',['paeDownloadCache','java.util.Map']]]

Clazz.newMeth(C$, 'c$',  function () {
;C$.superclazz.c$.apply(this,[]);C$.$init$.apply(this);
}, 1);

Clazz.newMeth(C$, 'getAccessionSeparator$',  function () {
return null;
});

Clazz.newMeth(C$, 'getAccessionValidator$',  function () {
var validator=Clazz.new_(["(AF-[A-Z]+[0-9]+[A-Z0-9]+-F1)"],$I$(2,1).c$$S);
validator.setIgnoreCase$Z(true);
return validator;
});

Clazz.newMeth(C$, 'getDbSource$',  function () {
return "ALPHAFOLD";
});

Clazz.newMeth(C$, 'getDbVersion$',  function () {
return "1";
});

Clazz.newMeth(C$, 'pingAPIVersion$',  function () {
if (C$.AF_VERSION != null ) {
return C$.AF_VERSION;
}{
if (C$.AF_VERSION != null ) {
return C$.AF_VERSION;
}var Version=null;
try {
var ping=Clazz.new_($I$(3,1).c$$S,["https://alphafold.ebi.ac.uk/api/prediction/Q5VSL9"]);
var resp=$I$(4,"parseJSON$java_io_InputStream",[ping.openStream$()]);
if (resp != null  && Clazz.instanceOf(resp, "org.json.simple.JSONArray") ) {
Version=(((resp).get$I(0)).get$O("latestVersion")).toString();
C$.AF_VERSION=Version;
}} catch (x) {
$I$(5).errPrintln$O("Couldn\'t get EBI AlphaFold DB latest version!");
$I$(5).errPrintln$O(x);
}
return Version;
}}, 1);

Clazz.newMeth(C$, 'getAlphaFoldCifDownloadUrl$S$S',  function (id, vnum) {
if (vnum == null  || vnum.length$() == 0 ) {
C$.pingAPIVersion$();
vnum=C$.AF_VERSION;
}return "https://alphafold.ebi.ac.uk/files/" + id + "-model_v" + vnum + ".cif" ;
}, 1);

Clazz.newMeth(C$, 'getAlphaFoldPaeDownloadUrl$S$S',  function (id, vnum) {
if (vnum == null  || vnum.length$() == 0 ) {
C$.pingAPIVersion$();
vnum=C$.AF_VERSION;
}return "https://alphafold.ebi.ac.uk/files/" + id + "-predicted_aligned_error_v" + vnum + ".json" ;
}, 1);

Clazz.newMeth(C$, 'getSequenceRecords$S',  function (queries) {
return this.getSequenceRecords$S$S(queries, null);
});

Clazz.newMeth(C$, 'getSequenceRecords$S$S',  function (queries, retrievalUrl) {
var pdbAlignment=null;
var chain=null;
var id=null;
if (queries.indexOf$S(":") > -1) {
chain=queries.substring$I(queries.indexOf$S(":") + 1);
id=queries.substring$I$I(0, queries.indexOf$S(":"));
} else {
id=queries;
}if (!this.isValidReference$S(id)) {
$I$(5,"errPrintln$O",["(AFClient) Ignoring invalid alphafold query: '" + id + "'" ]);
this.stopQuery$();
return null;
}var alphaFoldCif=C$.getAlphaFoldCifDownloadUrl$S$S(id, C$.AF_VERSION);
if (retrievalUrl != null ) {
alphaFoldCif=retrievalUrl;
}try {
var tmpFile=$I$(6).createTempFile$S$S(id, ".cif");
$I$(5).debug$S("Retrieving structure file for " + id + " from " + alphaFoldCif );
$I$(7).download$S$java_io_File(alphaFoldCif, tmpFile);
this.file=tmpFile.getAbsolutePath$();
if (this.file == null ) {
return null;
}pdbAlignment=C$.importDownloadedStructureFromUrl$S$java_io_File$S$S$S$S(alphaFoldCif, tmpFile, id, chain, this.getDbSource$(), this.getDbVersion$());
if (pdbAlignment == null  || pdbAlignment.getHeight$() < 1 ) {
throw Clazz.new_(Clazz.load('Exception').c$$S,[$I$(8,"formatMessage$S$SA",["exception.no_pdb_records_for_chain", Clazz.array(String, -1, [id, ((chain == null ) ? "\' \'" : chain)])])]);
}} catch (ex) {
if (Clazz.exceptionOf(ex,"Exception")){
this.stopQuery$();
throw (ex);
} else {
throw ex;
}
}
return pdbAlignment;
});

Clazz.newMeth(C$, 'fetchAlphaFoldPAE$S$S',  function (id, retrievalUrl) {
$I$(5,"debug$S",["Fetching PAE for " + id + " from " + ((retrievalUrl == null ) ? "AlphaFoldDB" : retrievalUrl) ]);
var paeURL=null;
if (retrievalUrl != null ) {
paeURL=retrievalUrl.replace$CharSequence$CharSequence("model", "predicted_aligned_error").replace$CharSequence$CharSequence(".cif", ".json");
} else {
$I$(5).trace$S("Resolving PAE URL...");
paeURL=C$.getAlphaFoldPaeDownloadUrl$S$S(id, C$.AF_VERSION);
$I$(5).trace$S("Resolved : " + paeURL);
}return C$.fetchAPAE_from$S$S(id, paeURL);
}, 1);

Clazz.newMeth(C$, 'fetchAPAE_from$S$S',  function (id, paeURL) {
$I$(5).debug$S("fetchAPAE called for " + id + " from '" + paeURL + "'" );
var pae=C$.paeDownloadCache.get$O(paeURL);
if (pae != null  && pae.exists$()  && Long.$lt((Long.$sub(Clazz.new_(java.util.Date).getTime$(),pae.lastModified$())),86400000 ) ) {
$I$(5).debug$S("Using existing file in PAE cache for '" + paeURL + "'" );
return pae;
}try {
pae=$I$(6,"createTempFile$S$S",[id == null  ? "af_pae" : id, "pae_json"]);
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
e.printStackTrace$();
} else {
throw e;
}
}
$I$(5,"debug$S",["Downloading pae from " + paeURL + " to " + pae.toString() + "" ]);
try {
$I$(7).download$S$java_io_File(paeURL, pae);
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
throw e;
} else {
throw e;
}
}
C$.paeDownloadCache.put$O$O(paeURL, pae);
return pae;
}, 1);

Clazz.newMeth(C$, 'retrieve_AlphaFold_pAE$S$jalview_datamodel_AlignmentI$S',  function (id, pdbAlignment, retrievalUrl) {
var pae=C$.fetchAlphaFoldPAE$S$S(id, retrievalUrl);
C$.addAlphaFoldPAE$jalview_datamodel_AlignmentI$java_io_File$I$S$Z$Z$S(pdbAlignment, pae, 0, null, false, false, null);
}, 1);

Clazz.newMeth(C$, 'addAlphaFoldPAE$jalview_datamodel_AlignmentI$java_io_File$I$S$Z$Z$S',  function (pdbAlignment, pae, index, id, isStruct, isStructId, label) {
var paeInput=null;
try {
paeInput=Clazz.new_($I$(9,1).c$$java_io_File,[pae]);
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.FileNotFoundException")){
$I$(5,"error$S$Throwable",["Could not find pAE file '" + pae.getAbsolutePath$() + "'" , e]);
return;
} else {
throw e;
}
}
if (isStruct) {
var ssm=$I$(10,"getStructureSelectionManager$jalview_api_StructureSelectionManagerProvider",[$I$(11).getInstance$()]);
if (ssm != null ) {
var structFilename=isStructId ? ssm.findFileForPDBId$S(id) : id;
C$.addPAEToStructure$jalview_structure_StructureSelectionManager$S$java_io_File$S(ssm, structFilename, pae, label);
}} else {
try {
if (!C$.importPaeJSONAsContactMatrixToSequence$jalview_datamodel_AlignmentI$java_io_InputStream$I$S$S(pdbAlignment, paeInput, index, id, label)) {
$I$(5,"warn$S",["Could not import contact matrix from '" + pae.getAbsolutePath$() + "' to sequence." ]);
}} catch (e$$) {
if (Clazz.exceptionOf(e$$,"java.io.IOException")){
var e1 = e$$;
{
$I$(5,"error$S$Throwable",["Error when importing pAE file '" + pae.getAbsolutePath$() + "'" , e1]);
}
} else if (Clazz.exceptionOf(e$$,"org.json.simple.parser.ParseException")){
var e2 = e$$;
{
$I$(5,"error$S$Throwable",["Error when parsing pAE file '" + pae.getAbsolutePath$() + "'" , e2]);
}
} else {
throw e$$;
}
}
}}, 1);

Clazz.newMeth(C$, 'addPAEToStructure$jalview_structure_StructureSelectionManager$S$java_io_File$S',  function (ssm, structFilename, pae, label) {
var paeInput=null;
try {
paeInput=Clazz.new_($I$(9,1).c$$java_io_File,[pae]);
} catch (e) {
if (Clazz.exceptionOf(e,"java.io.FileNotFoundException")){
$I$(5,"error$S$Throwable",["Could not find pAE file '" + pae.getAbsolutePath$() + "'" , e]);
return;
} else {
throw e;
}
}
if (ssm == null ) {
ssm=$I$(10,"getStructureSelectionManager$jalview_api_StructureSelectionManagerProvider",[$I$(11).getInstance$()]);
}if (ssm != null ) {
var smArray=ssm.getMapping$S(structFilename);
try {
if (!C$.importPaeJSONAsContactMatrixToStructure$jalview_structure_StructureMappingA$java_io_InputStream$S(smArray, paeInput, label)) {
$I$(5,"warn$S",["Could not import contact matrix from '" + pae.getAbsolutePath$() + "' to structure." ]);
}} catch (e$$) {
if (Clazz.exceptionOf(e$$,"java.io.IOException")){
var e1 = e$$;
{
$I$(5,"error$S$Throwable",["Error when importing pAE file '" + pae.getAbsolutePath$() + "'" , e1]);
}
} else if (Clazz.exceptionOf(e$$,"org.json.simple.parser.ParseException")){
var e2 = e$$;
{
$I$(5,"error$S$Throwable",["Error when parsing pAE file '" + pae.getAbsolutePath$() + "'" , e2]);
}
} else {
throw e$$;
}
}
}}, 1);

Clazz.newMeth(C$, 'importPaeJSONAsContactMatrixToSequence$jalview_datamodel_AlignmentI$java_io_InputStream$I$S$S',  function (pdbAlignment, pae_input, index, seqId, label) {
var sequence=null;
if (seqId == null ) {
var seqToGet=index > 0 ? index : 0;
sequence=pdbAlignment.getSequenceAt$I(seqToGet);
}if (sequence == null ) {
var sequences=pdbAlignment.findSequenceMatch$S(seqId);
if (sequences == null  || sequences.length < 1 ) {
$I$(5).warn$S("Could not find sequence with id '" + seqId + "' to attach pAE matrix to. Ignoring matrix." );
return false;
} else {
sequence=sequences[0];
}}if (sequence == null ) {
return false;
}return C$.importPaeJSONAsContactMatrixToSequence$jalview_datamodel_AlignmentI$java_io_InputStream$jalview_datamodel_SequenceI$S(pdbAlignment, pae_input, sequence, label);
}, 1);

Clazz.newMeth(C$, 'importPaeJSONAsContactMatrixToSequence$jalview_datamodel_AlignmentI$java_io_InputStream$jalview_datamodel_SequenceI$S',  function (pdbAlignment, pae_input, sequence, label) {
var paeDict=C$.parseJSONtoPAEContactMatrix$java_io_InputStream(pae_input);
if (paeDict == null ) {
$I$(5).debug$S("JSON file did not parse properly.");
return false;
}var matrix=Clazz.new_($I$(12,1).c$$jalview_datamodel_SequenceI$java_util_Map,[sequence, paeDict]);
var cmannot=sequence.addContactList$jalview_datamodel_ContactMatrixI(matrix);
if (label != null ) cmannot.label=label;
pdbAlignment.addAnnotation$jalview_datamodel_AlignmentAnnotation(cmannot);
return true;
}, 1);

Clazz.newMeth(C$, 'parseJSONtoPAEContactMatrix$java_io_InputStream',  function (pae_input) {
var paeJson=$I$(4).parseJSON$java_io_InputStream(pae_input);
var paeDict=null;
if (Clazz.instanceOf(paeJson, "org.json.simple.JSONObject")) {
paeDict=paeJson;
} else if (Clazz.instanceOf(paeJson, "org.json.simple.JSONArray")) {
var jsonArray=paeJson;
if (jsonArray.size$() > 0) paeDict=jsonArray.get$I(0);
}return paeDict;
}, 1);

Clazz.newMeth(C$, 'importPaeJSONAsContactMatrixToStructure$jalview_structure_StructureMappingA$java_io_InputStream$S',  function (smArray, paeInput, label) {
var someDone=false;
for (var sm, $sm = 0, $$sm = smArray; $sm<$$sm.length&&((sm=($$sm[$sm])),1);$sm++) {
var thisDone=C$.importPaeJSONAsContactMatrixToStructure$jalview_structure_StructureMapping$java_io_InputStream$S(sm, paeInput, label);
someDone=!!(someDone|(thisDone));
}
return someDone;
}, 1);

Clazz.newMeth(C$, 'importPaeJSONAsContactMatrixToStructure$jalview_structure_StructureMapping$java_io_InputStream$S',  function (sm, paeInput, label) {
var pae_obj=C$.parseJSONtoPAEContactMatrix$java_io_InputStream(paeInput);
if (pae_obj == null ) {
$I$(5).debug$S("JSON file did not parse properly.");
return false;
}var seq=sm.getSequence$();
var matrix=Clazz.new_($I$(12,1).c$$jalview_datamodel_SequenceI$java_util_Map,[seq, pae_obj]);
var cmannot=sm.getSequence$().addContactList$jalview_datamodel_ContactMatrixI(matrix);
return true;
}, 1);

Clazz.newMeth(C$, 'importDownloadedStructureFromUrl$S$java_io_File$S$S$S$S',  function (alphaFoldCif, tmpFile, id, chain, dbSource, dbVersion) {
var file=tmpFile.getAbsolutePath$();
var fileFormat=$I$(13).MMCif;
var tempfacType=$I$(14).PLDDT;
var pdbAlignment=Clazz.new_($I$(15,1)).readFile$java_io_File$S$jalview_io_DataSourceType$jalview_io_FileFormatI$jalview_structure_StructureImportSettings_TFType(tmpFile, file, $I$(16).FILE, fileFormat, tempfacType);
if (pdbAlignment != null ) {
var toremove=Clazz.new_($I$(17,1));
for (var pdbcs, $pdbcs = pdbAlignment.getSequences$().iterator$(); $pdbcs.hasNext$()&&((pdbcs=($pdbcs.next$())),1);) {
var chid=null;
for (var pid, $pid = pdbcs.getAllPDBEntries$().iterator$(); $pid.hasNext$()&&((pid=($pid.next$())),1);) {
if (pid.getFile$() == file) {
chid=pid.getChainCode$();
}}
if (chain == null  || (chid != null  && (chid.equals$O(chain) || chid.trim$().equals$O(chain.trim$()) || (chain.trim$().length$() == 0 && chid.equals$O("_") )  ) ) ) {
pdbcs.setName$S(id + "|" + pdbcs.getName$() );
if (dbSource != null ) {
var dbentry=Clazz.new_([dbSource, dbVersion, (chid == null  ? id : id + chid)],$I$(18,1).c$$S$S$S);
pdbcs.addDBRef$jalview_datamodel_DBRefEntry(dbentry);
var allsf=pdbcs.getFeatures$().getAllFeatures$SA(Clazz.array(String, -1, []));
var newsf=Clazz.new_($I$(17,1));
if (allsf != null  && allsf.size$() > 0 ) {
for (var f, $f = allsf.iterator$(); $f.hasNext$()&&((f=($f.next$())),1);) {
if (file.equals$O(f.getFeatureGroup$())) {
f=Clazz.new_($I$(19,1).c$$jalview_datamodel_SequenceFeature$S$I$I$S$F,[f, f.type, f.begin, f.end, id, f.score]);
}newsf.add$O(f);
}
pdbcs.setSequenceFeatures$java_util_List(newsf);
}}} else {
toremove.add$O(pdbcs);
}}
for (var pdbcs, $pdbcs = toremove.iterator$(); $pdbcs.hasNext$()&&((pdbcs=($pdbcs.next$())),1);) {
pdbAlignment.deleteSequence$jalview_datamodel_SequenceI(pdbcs);
if (pdbcs.getAnnotation$() != null ) {
for (var aa, $aa = 0, $$aa = pdbcs.getAnnotation$(); $aa<$$aa.length&&((aa=($$aa[$aa])),1);$aa++) {
pdbAlignment.deleteAnnotation$jalview_datamodel_AlignmentAnnotation(aa);
}
}}
}return pdbAlignment;
}, 1);

Clazz.newMeth(C$, 'isValidReference$S',  function (accession) {
var r=this.getAccessionValidator$();
return r.search$S(accession.trim$());
});

Clazz.newMeth(C$, 'getTestQuery$',  function () {
return "AF-O15552-F1";
});

Clazz.newMeth(C$, 'getDbName$',  function () {
return "ALPHAFOLD";
});

Clazz.newMeth(C$, 'getTier$',  function () {
return 0;
});

Clazz.newMeth(C$, 'getFeatureColourScheme$',  function () {
return Clazz.new_($I$(20,1));
});

C$.$static$=function(){C$.$static$=0;
C$.AF_VERSION=null;
C$.paeDownloadCache=Clazz.new_($I$(1,1));
};
})();
;Clazz.setTVer('3.3.1-v1');//Created 2026-01-06 03:20:02 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
