(function(){var P$=Clazz.newPackage("jalview.io"),p$1={},I$=[[0,'jalview.datamodel.HiddenMarkovModel','java.util.Scanner','java.util.ArrayList','jalview.datamodel.HMMNode','StringBuilder','jalview.datamodel.SequenceI']],I$0=I$[0],$I$=function(i,n){return((i=(I$[i]||(I$[i]=Clazz.load(I$0[i])))),!n&&i.$load$&&Clazz.load(i,2),i)};
/*c*/var C$=Clazz.newClass(P$, "HMMFile", null, 'jalview.io.AlignFile', ['jalview.io.AlignmentFileReaderI', 'jalview.io.AlignmentFileWriterI']);

C$.$clinit$=2;

Clazz.newMeth(C$, '$init$', function () {
},1);

C$.$fields$=[['I',['numberOfSymbols'],'O',['hmm','jalview.datamodel.HiddenMarkovModel']]
,['S',['NL']]]

Clazz.newMeth(C$, 'c$$S$jalview_io_DataSourceType',  function (inFile, type) {
;C$.superclazz.c$$O$jalview_io_DataSourceType.apply(this,[inFile, type]);C$.$init$.apply(this);
}, 1);

Clazz.newMeth(C$, 'c$$jalview_io_FileParse',  function (source) {
;C$.superclazz.c$$jalview_io_FileParse.apply(this,[source]);C$.$init$.apply(this);
}, 1);

Clazz.newMeth(C$, 'c$',  function () {
Clazz.super_(C$, this);
}, 1);

Clazz.newMeth(C$, 'c$$jalview_datamodel_HiddenMarkovModel',  function (markov) {
Clazz.super_(C$, this);
this.hmm=markov;
}, 1);

Clazz.newMeth(C$, 'getHMM$',  function () {
return this.hmm;
});

Clazz.newMeth(C$, 'getName$',  function () {
return this.hmm.getName$();
});

Clazz.newMeth(C$, 'parse$',  function () {
try {
this.hmm=Clazz.new_($I$(1,1));
this.parseHeaderLines$java_io_BufferedReader(this.dataIn);
this.parseModel$java_io_BufferedReader(this.dataIn);
} catch (e) {
if (Clazz.exceptionOf(e,"Exception")){
e.printStackTrace$();
} else {
throw e;
}
}
});

Clazz.newMeth(C$, 'parseHeaderLines$java_io_BufferedReader',  function (input) {
var readingHeaders=true;
this.hmm.setFileHeader$S(input.readLine$());
var line=input.readLine$();
while (readingHeaders && line != null  ){
var parser=Clazz.new_($I$(2,1).c$$S,[line]);
var next=parser.next$();
if ("ALPH".equals$O(next)) {
var alphabetType=parser.next$();
this.hmm.setProperty$S$S("ALPH", alphabetType);
var alphabet="DNA".equalsIgnoreCase$S(alphabetType) ? "ACGT" : ("RNA".equalsIgnoreCase$S(alphabetType) ? "ACGU" : "ACDEFGHIKLMNPQRSTVWY");
this.numberOfSymbols=this.hmm.setAlphabet$S(alphabet);
} else if ("HMM".equals$O(next)) {
readingHeaders=false;
var symbols=line.substring$I(line.indexOf$S("HMM") + "HMM".length$());
this.numberOfSymbols=this.hmm.setAlphabet$S(symbols);
} else if ("STATS".equals$O(next)) {
parser.next$();
var key;
var value;
key=parser.next$();
value=parser.next$() + " " + " " + parser.next$() ;
this.hmm.setProperty$S$S(key, value);
} else {
var key=next;
var value=parser.next$();
while (parser.hasNext$()){
value=value + " " + parser.next$() ;
}
this.hmm.setProperty$S$S(key, value);
}parser.close$();
line=input.readLine$();
}
});

Clazz.newMeth(C$, 'parseModel$java_io_BufferedReader',  function (input) {
var nodeNo=0;
var line=input.readLine$();
var nodes=Clazz.new_($I$(3,1));
while (line != null  && !"//".equals$O(line) ){
var node=Clazz.new_($I$(4,1));
nodes.add$O(node);
var scanner=Clazz.new_($I$(2,1).c$$S,[line]);
var next=scanner.next$();
if ("COMPO".equals$O(next) || nodeNo > 0 ) {
var matches=C$.parseDoubles$java_util_Scanner$I(scanner, this.numberOfSymbols);
node.setMatchEmissions$DA(matches);
if (!"COMPO".equals$O(next)) {
var resNo=this.parseAnnotations$java_util_Scanner$jalview_datamodel_HMMNode(scanner, node);
if (resNo == 0) {
resNo=nodeNo;
}node.setResidueNumber$I(resNo);
}line=input.readLine$();
}scanner.close$();
scanner=Clazz.new_($I$(2,1).c$$S,[line]);
var inserts=C$.parseDoubles$java_util_Scanner$I(scanner, this.numberOfSymbols);
node.setInsertEmissions$DA(inserts);
scanner.close$();
line=input.readLine$();
scanner=Clazz.new_($I$(2,1).c$$S,[line]);
var transitions=C$.parseDoubles$java_util_Scanner$I(scanner, 7);
node.setStateTransitions$DA(transitions);
scanner.close$();
line=input.readLine$();
++nodeNo;
}
this.hmm.setNodes$java_util_List(nodes);
});

Clazz.newMeth(C$, 'parseAnnotations$java_util_Scanner$jalview_datamodel_HMMNode',  function (scanner, node) {
var mapTo=0;
if (scanner.hasNext$()) {
var value=scanner.next$();
if (!"-".equals$O(value)) {
try {
mapTo=Integer.parseInt$S(value);
node.setResidueNumber$I(mapTo);
} catch (e) {
if (Clazz.exceptionOf(e,"NumberFormatException")){
} else {
throw e;
}
}
}}if (scanner.hasNext$()) {
node.setConsensusResidue$C(scanner.next$().charAt$I(0));
}if (scanner.hasNext$()) {
node.setReferenceAnnotation$C(scanner.next$().charAt$I(0));
}if (scanner.hasNext$()) {
node.setMaskValue$C(scanner.next$().charAt$I(0));
}if (scanner.hasNext$()) {
node.setConsensusStructure$C(scanner.next$().charAt$I(0));
}return mapTo;
});

Clazz.newMeth(C$, 'parseDoubles$java_util_Scanner$I',  function (input, numberOfElements) {
var values=Clazz.array(Double.TYPE, [numberOfElements]);
for (var i=0; i < numberOfElements; i++) {
if (!input.hasNext$()) {
throw Clazz.new_(Clazz.load('java.io.IOException').c$$S,["Incomplete data"]);
}var next=input.next$();
if (next.contains$CharSequence("*")) {
values[i]=-Infinity;
} else {
var prob=(Double.valueOf$S(next)).valueOf();
prob=Math.pow(2.718281828459045, -prob);
values[i]=prob;
}}
return values;
}, 1);

Clazz.newMeth(C$, 'addData$I$I$java_util_List',  function (initialColumnSeparation, columnSeparation, data) {
var line="";
var first=true;
for (var value, $value = data.iterator$(); $value.hasNext$()&&((value=($value.next$())),1);) {
var sep=first ? initialColumnSeparation : columnSeparation;
line+=String.format$S$OA("%" + sep + "s" , Clazz.array(java.lang.Object, -1, [value]));
first=false;
}
return line;
});

Clazz.newMeth(C$, 'charListToStringList$java_util_List',  function (list) {
var strList=Clazz.new_($I$(3,1));
for (var value, $value = list.iterator$(); $value.hasNext$()&&((value=($value.next$()).objectValue$()),1);) {
var strValue=Character.toString$C(value);
strList.add$O(strValue);
}
return strList;
});

Clazz.newMeth(C$, 'doublesToStringList$DA',  function (doubles) {
var strList=Clazz.new_($I$(3,1));
for (var value, $value = 0, $$value = doubles; $value<$$value.length&&((value=($$value[$value])),1);$value++) {
var strValue;
if (value > 0 ) {
strValue=String.format$S$OA("%.5f", Clazz.array(java.lang.Object, -1, [Double.valueOf$D(value)]));
} else if (value == -0.0 ) {
strValue="0.00000";
} else {
strValue="*";
}strList.add$O(strValue);
}
return strList;
});

Clazz.newMeth(C$, 'appendModelAsString$StringBuilder',  function (output) {
output.append$S("HMM").append$S("  ");
var charSymbols=this.hmm.getSymbols$();
for (var c, $c = 0, $$c = charSymbols.toCharArray$(); $c<$$c.length&&((c=($$c[$c])),1);$c++) {
output.append$S(String.format$S$OA("%9s", Clazz.array(java.lang.Object, -1, [Character.valueOf$C(c)])));
}
output.append$S(C$.NL).append$S("            m->m     m->i     m->d     i->m     i->i     d->m     d->d");
var length=this.hmm.getLength$();
for (var nodeNo=0; nodeNo <= length; nodeNo++) {
var matchLine=String.format$S$OA("%7s", Clazz.array(java.lang.Object, -1, [nodeNo == 0 ? "COMPO" : Integer.toString$I(nodeNo)]));
var doubleMatches=this.convertToLogSpace$DA(this.hmm.getNode$I(nodeNo).getMatchEmissions$());
var strMatches=this.doublesToStringList$DA(doubleMatches);
matchLine+=this.addData$I$I$java_util_List(10, 9, strMatches);
if (nodeNo != 0) {
matchLine+=" " + (this.hmm.getNodeMapPosition$I(nodeNo));
matchLine+=" " + this.hmm.getConsensusResidue$I(nodeNo);
matchLine+=" " + this.hmm.getReferenceAnnotation$I(nodeNo);
if (this.hmm.getFileHeader$().contains$CharSequence("HMMER3/f")) {
matchLine+=" " + this.hmm.getMaskedValue$I(nodeNo);
matchLine+=" " + this.hmm.getConsensusStructure$I(nodeNo);
}}output.append$S(C$.NL).append$S(matchLine);
var insertLine="";
var doubleInserts=this.convertToLogSpace$DA(this.hmm.getNode$I(nodeNo).getInsertEmissions$());
var strInserts=this.doublesToStringList$DA(doubleInserts);
insertLine+=this.addData$I$I$java_util_List(17, 9, strInserts);
output.append$S(C$.NL).append$S(insertLine);
var transitionLine="";
var doubleTransitions=this.convertToLogSpace$DA(this.hmm.getNode$I(nodeNo).getStateTransitions$());
var strTransitions=this.doublesToStringList$DA(doubleTransitions);
transitionLine+=this.addData$I$I$java_util_List(17, 9, strTransitions);
output.append$S(C$.NL).append$S(transitionLine);
}
});

Clazz.newMeth(C$, 'appendProperties$StringBuilder',  function (output) {
output.append$S(this.hmm.getFileHeader$());
var format="%n%-5s %1s";
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "NAME"]);
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "ACC"]);
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "DESC"]);
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "LENG"]);
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "MAXL"]);
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "ALPH"]);
p$1.appendBooleanProperty$StringBuilder$S$S.apply(this, [output, format, "RF"]);
p$1.appendBooleanProperty$StringBuilder$S$S.apply(this, [output, format, "MM"]);
p$1.appendBooleanProperty$StringBuilder$S$S.apply(this, [output, format, "CONS"]);
p$1.appendBooleanProperty$StringBuilder$S$S.apply(this, [output, format, "CS"]);
p$1.appendBooleanProperty$StringBuilder$S$S.apply(this, [output, format, "MAP"]);
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "DATE"]);
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "NSEQ"]);
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "EFFN"]);
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "CKSUM"]);
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "GA"]);
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "TC"]);
p$1.appendProperty$StringBuilder$S$S.apply(this, [output, format, "NC"]);
if (this.hmm.getMSV$() != null ) {
format="%n%-19s %18s";
output.append$S(String.format$S$OA(format, Clazz.array(java.lang.Object, -1, ["STATS LOCAL MSV", this.hmm.getMSV$()])));
output.append$S(String.format$S$OA(format, Clazz.array(java.lang.Object, -1, ["STATS LOCAL VITERBI", this.hmm.getViterbi$()])));
output.append$S(String.format$S$OA(format, Clazz.array(java.lang.Object, -1, ["STATS LOCAL FORWARD", this.hmm.getForward$()])));
}});

Clazz.newMeth(C$, 'appendBooleanProperty$StringBuilder$S$S',  function (output, format, propertyName) {
var set=this.hmm.getBooleanProperty$S(propertyName);
output.append$S(String.format$S$OA(format, Clazz.array(java.lang.Object, -1, [propertyName, set ? "yes" : "no"])));
}, p$1);

Clazz.newMeth(C$, 'appendProperty$StringBuilder$S$S',  function (output, format, propertyName) {
var value=this.hmm.getProperty$S(propertyName);
if (value != null ) {
output.append$S(String.format$S$OA(format, Clazz.array(java.lang.Object, -1, [propertyName, value])));
}}, p$1);

Clazz.newMeth(C$, 'print$jalview_datamodel_SequenceIA$Z',  function (sequences, jvsuffix) {
if (sequences[0].getHMM$() != null ) {
this.hmm=sequences[0].getHMM$();
}return this.print$();
});

Clazz.newMeth(C$, 'print$',  function () {
var output=Clazz.new_($I$(5,1));
this.appendProperties$StringBuilder(output);
output.append$S(C$.NL);
this.appendModelAsString$StringBuilder(output);
output.append$S(C$.NL).append$S("//").append$S(C$.NL);
return output.toString();
});

Clazz.newMeth(C$, 'convertToLogSpace$DA',  function (ds) {
var converted=Clazz.array(Double.TYPE, [ds.length]);
for (var i=0; i < ds.length; i++) {
var prob=ds[i];
var logProb=-1 * Math.log(prob);
converted[i]=logProb;
}
return converted;
});

Clazz.newMeth(C$, 'getSeqsAsArray$',  function () {
var hmmSeq=this.hmm.getConsensusSequence$();
var seq=Clazz.array($I$(6), [1]);
seq[0]=hmmSeq;
return seq;
});

Clazz.newMeth(C$, 'setNewlineString$S',  function (newLine) {
C$.NL=newLine;
});

Clazz.newMeth(C$, 'setExportSettings$jalview_api_AlignExportSettingsI',  function (exportSettings) {
});

Clazz.newMeth(C$, 'configureForView$jalview_api_AlignmentViewPanel',  function (viewpanel) {
});

Clazz.newMeth(C$, 'hasWarningMessage$',  function () {
return false;
});

Clazz.newMeth(C$, 'getWarningMessage$',  function () {
return "warning message";
});

C$.$static$=function(){C$.$static$=0;
C$.NL=System.lineSeparator$();
};
})();
;Clazz.setTVer('3.3.1-v1');//Created 2026-01-06 03:19:57 Java2ScriptVisitor version 3.3.1-v1 net.sf.j2s.core.jar version 3.3.1-v1
