/*
 * Decompiled with CFR 0.152.
 */
package intervalstore.impl;

import intervalstore.api.IntervalI;
import intervalstore.impl.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class NCListBuilder<T extends IntervalI> {
    private Comparator<T> comparator = new NCListComparator<T>();

    Comparator<T> getComparator() {
        return this.comparator;
    }

    List<IntervalI> partitionNestedSublists(List<T> ranges) {
        ArrayList<IntervalI> sublists = new ArrayList<IntervalI>();
        Collections.sort(ranges, this.comparator);
        int listStartIndex = 0;
        IntervalI lastParent = (IntervalI)ranges.get(0);
        boolean first = true;
        int i = 0;
        while (i < ranges.size()) {
            IntervalI nextInterval = (IntervalI)ranges.get(i);
            if (!first && !lastParent.properlyContainsInterval(nextInterval)) {
                sublists.add(new Range(listStartIndex, i - 1));
                listStartIndex = i;
                lastParent = nextInterval;
            }
            first = false;
            ++i;
        }
        sublists.add(new Range(listStartIndex, ranges.size() - 1));
        return sublists;
    }

    class NCListComparator<V extends IntervalI>
    implements Comparator<V> {
        NCListComparator() {
        }

        @Override
        public int compare(V o1, V o2) {
            int order = Integer.compare(o1.getBegin(), o2.getBegin());
            if (order == 0) {
                order = Integer.compare(o2.getEnd(), o1.getEnd());
            }
            return order;
        }
    }
}

