/*
 * Decompiled with CFR 0.152.
 */
package intervalstore.impl;

import intervalstore.api.IntervalI;
import intervalstore.api.IntervalStoreI;
import intervalstore.impl.BinarySearcher;
import intervalstore.impl.NCList;
import intervalstore.impl.NCListBuilder;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IntervalStore<T extends IntervalI>
extends AbstractCollection<T>
implements IntervalStoreI<T> {
    private List<T> nonNested = new ArrayList<T>();
    private NCList<T> nested;

    public IntervalStore() {
    }

    public IntervalStore(List<T> intervals) {
        this();
        List<IntervalI> sublists = new NCListBuilder<T>().partitionNestedSublists(intervals);
        ArrayList<IntervalI> nested = new ArrayList<IntervalI>();
        for (IntervalI subrange : sublists) {
            int listIndex = subrange.getBegin();
            IntervalI root = (IntervalI)intervals.get(listIndex);
            while (listIndex <= subrange.getEnd()) {
                IntervalI t = (IntervalI)intervals.get(listIndex);
                if (root.equalsInterval(t)) {
                    this.nonNested.add(t);
                } else {
                    nested.add(t);
                }
                ++listIndex;
            }
        }
        if (!nested.isEmpty()) {
            this.nested = new NCList(nested);
        }
    }

    @Override
    public boolean add(T interval) {
        if (interval == null) {
            return false;
        }
        if (!this.addNonNestedInterval(interval)) {
            this.addNestedInterval(interval);
        }
        return true;
    }

    @Override
    public boolean contains(Object entry) {
        if (this.listContains(this.nonNested, entry)) {
            return true;
        }
        return this.nested == null ? false : this.nested.contains(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addNonNestedInterval(T entry) {
        List<T> list = this.nonNested;
        synchronized (list) {
            int insertPosition;
            block6: {
                IntervalI following;
                block5: {
                    insertPosition = BinarySearcher.findFirst(this.nonNested, val -> val.getBegin() >= entry.getBegin());
                    if (insertPosition <= 0 || !((IntervalI)this.nonNested.get(insertPosition - 1)).properlyContainsInterval((IntervalI)entry)) break block5;
                    return false;
                }
                if (insertPosition >= this.nonNested.size() || !entry.properlyContainsInterval(following = (IntervalI)this.nonNested.get(insertPosition)) && !following.properlyContainsInterval((IntervalI)entry)) break block6;
                return false;
            }
            this.nonNested.add(insertPosition, entry);
            return true;
        }
    }

    @Override
    public List<T> findOverlaps(long from, long to) {
        ArrayList<T> result = new ArrayList<T>();
        this.findNonNestedOverlaps(from, to, result);
        if (this.nested != null) {
            result.addAll(this.nested.findOverlaps(from, to));
        }
        return result;
    }

    @Override
    public String prettyPrint() {
        String pp = this.nonNested.toString();
        if (this.nested != null) {
            pp = String.valueOf(pp) + System.lineSeparator() + this.nested.prettyPrint();
        }
        return pp;
    }

    @Override
    public boolean isValid() {
        int i = 0;
        while (i < this.nonNested.size() - 1) {
            IntervalI i1 = (IntervalI)this.nonNested.get(i);
            IntervalI i2 = (IntervalI)this.nonNested.get(i + 1);
            if (i2.getBegin() < i1.getBegin()) {
                System.err.println("nonNested wrong start order : " + i1.toString() + ", " + i2.toString());
                return false;
            }
            if (i1.properlyContainsInterval(i2) || i2.properlyContainsInterval(i1)) {
                System.err.println("nonNested invalid containment!: " + i1.toString() + ", " + i2.toString());
                return false;
            }
            ++i;
        }
        return this.nested == null ? true : this.nested.isValid();
    }

    @Override
    public int size() {
        int i = this.nonNested.size();
        if (this.nested != null) {
            i += this.nested.size();
        }
        return i;
    }

    @Override
    public synchronized boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        try {
            IntervalI entry = (IntervalI)o;
            boolean removed = this.removeNonNested(entry);
            if (!removed && this.nested != null) {
                removed = this.nested.remove(entry);
            }
            return removed;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    protected boolean removeNonNested(T entry) {
        int startIndex = BinarySearcher.findFirst(this.nonNested, val -> val.getBegin() >= entry.getBegin());
        int from = entry.getBegin();
        int i = startIndex;
        int size = this.nonNested.size();
        while (i < size) {
            IntervalI sf = (IntervalI)this.nonNested.get(i);
            if (sf.getBegin() > from) break;
            if (sf.equals(entry)) {
                this.nonNested.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int getDepth() {
        if (this.size() == 0) {
            return 0;
        }
        return (this.nonNested.isEmpty() ? 0 : 1) + (this.nested == null ? 0 : this.nested.getDepth());
    }

    protected synchronized void addNestedInterval(T interval) {
        if (this.nested == null) {
            this.nested = new NCList();
        }
        this.nested.add(interval);
    }

    protected boolean listContains(List<T> intervals, Object entry) {
        if (intervals == null || entry == null || !(entry instanceof IntervalI)) {
            return false;
        }
        IntervalI interval = (IntervalI)entry;
        int pos = BinarySearcher.findFirst(intervals, val -> val.getBegin() >= interval.getBegin());
        int len = intervals.size();
        while (pos < len) {
            IntervalI sf = (IntervalI)intervals.get(pos);
            if (sf.getBegin() > interval.getBegin()) {
                return false;
            }
            if (sf.equals(interval)) {
                return true;
            }
            ++pos;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new IntervalIterator(this);
    }

    @Override
    public void clear() {
        this.nonNested.clear();
        this.nested = new NCList();
    }

    protected void findNonNestedOverlaps(long from, long to, List<T> result) {
        int startIndex;
        int startIndex1;
        int i = startIndex1 = (startIndex = BinarySearcher.findFirst(this.nonNested, val -> (long)val.getEnd() >= from));
        while (i < this.nonNested.size()) {
            IntervalI sf = (IntervalI)this.nonNested.get(i);
            if ((long)sf.getBegin() > to) break;
            if ((long)sf.getBegin() <= to && (long)sf.getEnd() >= from) {
                result.add(sf);
            }
            ++i;
        }
    }

    @Override
    public String toString() {
        String s = this.nonNested.toString();
        if (this.nested != null) {
            s = String.valueOf(s) + System.lineSeparator() + this.nested.toString();
        }
        return s;
    }

    private class IntervalIterator<V extends IntervalI>
    implements Iterator<V> {
        Iterator<? extends IntervalI> topLevelIterator;
        Iterator<? extends IntervalI> nestedIterator;

        public IntervalIterator(IntervalStore<? extends IntervalI> intervalStore2) {
            this.topLevelIterator = IntervalStore.this.nonNested.iterator();
            if (IntervalStore.this.nested != null) {
                this.nestedIterator = IntervalStore.this.nested.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.topLevelIterator.hasNext() ? true : this.nestedIterator != null && this.nestedIterator.hasNext();
        }

        @Override
        public V next() {
            if (this.topLevelIterator.hasNext()) {
                return (V)this.topLevelIterator.next();
            }
            if (this.nestedIterator != null) {
                return (V)this.nestedIterator.next();
            }
            throw new NoSuchElementException();
        }
    }
}

