/*
 * Decompiled with CFR 0.152.
 */
package intervalstore.api;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public interface IntervalI {
    public static final Comparator<? super IntervalI> FORWARD_STRAND = new Comparator<IntervalI>(){

        @Override
        public int compare(IntervalI o1, IntervalI o2) {
            return Integer.compare(o1.getBegin(), o2.getBegin());
        }
    };
    public static final Comparator<? super IntervalI> REVERSE_STRAND = new Comparator<IntervalI>(){

        @Override
        public int compare(IntervalI o1, IntervalI o2) {
            return Integer.compare(o2.getEnd(), o1.getEnd());
        }
    };

    public int getBegin();

    public int getEnd();

    default public boolean containsInterval(IntervalI i) {
        return i != null && i.getBegin() >= this.getBegin() && i.getEnd() <= this.getEnd();
    }

    default public boolean properlyContainsInterval(IntervalI i) {
        return this.containsInterval(i) && (i.getBegin() > this.getBegin() || i.getEnd() < this.getEnd());
    }

    default public boolean equalsInterval(IntervalI i) {
        return i != null && i.getBegin() == this.getBegin() && i.getEnd() == this.getEnd();
    }

    default public boolean overlapsInterval(IntervalI i) {
        if (i == null) {
            return false;
        }
        if (i.getBegin() < this.getBegin()) {
            return i.getEnd() >= this.getBegin();
        }
        if (i.getEnd() > this.getEnd()) {
            return i.getBegin() <= this.getEnd();
        }
        return true;
    }

    public static void sortIntervals(List<? extends IntervalI> intervals, boolean forwardStrand) {
        Collections.sort(intervals, forwardStrand ? FORWARD_STRAND : REVERSE_STRAND);
    }
}

