/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import gov.nih.nlm.ncbi.ngs.NGS;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.util.Log;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ngs.Alignment;
import ngs.AlignmentIterator;
import ngs.ErrorMsg;
import ngs.Read;
import ngs.ReadCollection;
import ngs.ReadIterator;

public class SRALazyRecord
extends SAMRecord {
    private static final Log log = Log.getInstance(SRALazyRecord.class);
    private SRAAccession accession;
    private boolean isAligned;
    private transient ReadCollection run;
    private transient Alignment alignmentIterator;
    private transient Read unalignmentIterator;
    private String sraReadId;
    private String sraAlignmentId;
    private int unalignedReadFragmentIndex = -1;
    private Set<LazyField> initializedFields = EnumSet.noneOf(LazyField.class);
    private Set<LazyFlag> initializedFlags = EnumSet.noneOf(LazyFlag.class);
    private Set<LazyAttribute> initializedAttributes = EnumSet.noneOf(LazyAttribute.class);
    private static Map<Short, LazyAttribute> lazyAttributeTags = new HashMap<Short, LazyAttribute>();

    public SRALazyRecord(SAMFileHeader header, SRAAccession accession, ReadCollection run, AlignmentIterator alignmentIterator, String readId, String alignmentId) {
        this(header, accession, readId, alignmentId);
        this.run = run;
        this.alignmentIterator = alignmentIterator;
    }

    public SRALazyRecord(SAMFileHeader header, SRAAccession accession, ReadCollection run, ReadIterator unalignmentIterator, String readId, int unalignedReadFragmentIndex) {
        this(header, accession, readId, unalignedReadFragmentIndex);
        this.run = run;
        this.unalignmentIterator = unalignmentIterator;
    }

    protected SRALazyRecord(SAMFileHeader header, SRAAccession accession, String readId, String alignmentId) {
        this(header, accession, readId, true);
        this.sraAlignmentId = alignmentId;
    }

    protected SRALazyRecord(SAMFileHeader header, SRAAccession accession, String readId, int unalignedReadFragmentIndex) {
        this(header, accession, readId, false);
        this.unalignedReadFragmentIndex = unalignedReadFragmentIndex;
    }

    private SRALazyRecord(SAMFileHeader header, SRAAccession accession, String readId, boolean isAligned) {
        super(header);
        this.accession = accession;
        this.isAligned = isAligned;
        this.sraReadId = readId;
        this.setReadName(readId);
        this.setReadUnmappedFlag(!isAligned);
    }

    public void detachFromIterator() {
        this.alignmentIterator = null;
        this.unalignmentIterator = null;
    }

    @Override
    public int getAlignmentStart() {
        if (!this.initializedFields.contains((Object)LazyField.ALIGNMENT_START)) {
            this.setAlignmentStart(this.getAlignmentStartImpl());
        }
        return super.getAlignmentStart();
    }

    @Override
    public void setAlignmentStart(int value) {
        if (!this.initializedFields.contains((Object)LazyField.ALIGNMENT_START)) {
            this.initializedFields.add(LazyField.ALIGNMENT_START);
        }
        super.setAlignmentStart(value);
    }

    @Override
    public int getMappingQuality() {
        if (!this.initializedFields.contains((Object)LazyField.MAPPING_QUALITY)) {
            this.setMappingQuality(this.getMappingQualityImpl());
        }
        return super.getMappingQuality();
    }

    @Override
    public void setMappingQuality(int value) {
        if (!this.initializedFields.contains((Object)LazyField.MAPPING_QUALITY)) {
            this.initializedFields.add(LazyField.MAPPING_QUALITY);
        }
        super.setMappingQuality(value);
    }

    @Override
    public String getReferenceName() {
        if (!this.initializedFields.contains((Object)LazyField.REFERENCE_NAME)) {
            this.setReferenceName(this.getReferenceNameImpl());
        }
        return super.getReferenceName();
    }

    @Override
    public void setReferenceName(String value) {
        if (!this.initializedFields.contains((Object)LazyField.REFERENCE_NAME)) {
            this.initializedFields.add(LazyField.REFERENCE_NAME);
        }
        super.setReferenceName(value);
    }

    @Override
    public Integer getReferenceIndex() {
        if (!this.initializedFields.contains((Object)LazyField.REFERENCE_NAME)) {
            this.setReferenceName(this.getReferenceNameImpl());
        }
        return super.getReferenceIndex();
    }

    @Override
    public void setReferenceIndex(int value) {
        if (!this.initializedFields.contains((Object)LazyField.REFERENCE_NAME)) {
            this.initializedFields.add(LazyField.REFERENCE_NAME);
        }
        super.setReferenceIndex(value);
    }

    @Override
    public String getCigarString() {
        if (!this.initializedFields.contains((Object)LazyField.CIGAR_STRING)) {
            this.setCigarString(this.getCigarStringImpl());
        }
        return super.getCigarString();
    }

    @Override
    public void setCigarString(String value) {
        if (!this.initializedFields.contains((Object)LazyField.CIGAR_STRING)) {
            this.initializedFields.add(LazyField.CIGAR_STRING);
        }
        super.setCigarString(value);
    }

    @Override
    public Cigar getCigar() {
        if (!this.initializedFields.contains((Object)LazyField.CIGAR_STRING)) {
            this.setCigarString(this.getCigarStringImpl());
        }
        return super.getCigar();
    }

    @Override
    public void setCigar(Cigar value) {
        if (!this.initializedFields.contains((Object)LazyField.CIGAR_STRING)) {
            this.initializedFields.add(LazyField.CIGAR_STRING);
        }
        super.setCigar(value);
    }

    @Override
    public byte[] getReadBases() {
        if (!this.initializedFields.contains((Object)LazyField.BASES)) {
            this.setReadBases(this.getReadBasesImpl());
        }
        return super.getReadBases();
    }

    @Override
    public void setReadBases(byte[] value) {
        if (!this.initializedFields.contains((Object)LazyField.BASES)) {
            this.initializedFields.add(LazyField.BASES);
        }
        super.setReadBases(value);
    }

    @Override
    public byte[] getBaseQualities() {
        if (!this.initializedFields.contains((Object)LazyField.QUALS)) {
            this.setBaseQualities(this.getBaseQualitiesImpl());
        }
        return super.getBaseQualities();
    }

    @Override
    public void setBaseQualities(byte[] value) {
        if (!this.initializedFields.contains((Object)LazyField.QUALS)) {
            this.initializedFields.add(LazyField.QUALS);
        }
        super.setBaseQualities(value);
    }

    @Override
    public int getMateAlignmentStart() {
        if (!this.initializedFields.contains((Object)LazyField.MATE_ALIGNMENT_START)) {
            this.setMateAlignmentStart(this.getMateAlignmentStartImpl());
        }
        return super.getMateAlignmentStart();
    }

    @Override
    public void setMateAlignmentStart(int value) {
        if (!this.initializedFields.contains((Object)LazyField.MATE_ALIGNMENT_START)) {
            this.initializedFields.add(LazyField.MATE_ALIGNMENT_START);
        }
        super.setMateAlignmentStart(value);
    }

    @Override
    public String getMateReferenceName() {
        if (!this.initializedFields.contains((Object)LazyField.MATE_REFERENCE_NAME)) {
            this.setMateReferenceName(this.getMateReferenceNameImpl());
        }
        return super.getMateReferenceName();
    }

    @Override
    public void setMateReferenceName(String value) {
        if (!this.initializedFields.contains((Object)LazyField.MATE_REFERENCE_NAME)) {
            this.initializedFields.add(LazyField.MATE_REFERENCE_NAME);
        }
        super.setMateReferenceName(value);
    }

    @Override
    public Integer getMateReferenceIndex() {
        if (!this.initializedFields.contains((Object)LazyField.MATE_REFERENCE_NAME)) {
            this.setMateReferenceName(this.getMateReferenceNameImpl());
        }
        return super.getMateReferenceIndex();
    }

    @Override
    public void setMateReferenceIndex(int value) {
        if (!this.initializedFields.contains((Object)LazyField.MATE_REFERENCE_NAME)) {
            this.initializedFields.add(LazyField.MATE_REFERENCE_NAME);
        }
        super.setMateReferenceIndex(value);
    }

    @Override
    public int getInferredInsertSize() {
        if (!this.initializedFields.contains((Object)LazyField.INFERRED_INSERT_SIZE)) {
            this.setInferredInsertSize(this.getInferredInsertSizeImpl());
        }
        return super.getInferredInsertSize();
    }

    @Override
    public void setInferredInsertSize(int value) {
        if (!this.initializedFields.contains((Object)LazyField.INFERRED_INSERT_SIZE)) {
            this.initializedFields.add(LazyField.INFERRED_INSERT_SIZE);
        }
        super.setInferredInsertSize(value);
    }

    @Override
    public int getFlags() {
        for (LazyFlag flag : LazyFlag.values()) {
            if (this.initializedFlags.contains((Object)flag) || !flag.canCallOnNotPaired() && !this.getReadPairedFlag()) continue;
            flag.getFlag(this);
        }
        return super.getFlags();
    }

    @Override
    public void setFlags(int value) {
        for (LazyFlag flag : LazyFlag.values()) {
            if (this.initializedFlags.contains((Object)flag)) continue;
            this.initializedFlags.add(flag);
        }
        super.setFlags(value);
    }

    @Override
    public boolean getReadNegativeStrandFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.READ_NEGATIVE_STRAND)) {
            this.setReadNegativeStrandFlag(this.getReadNegativeStrandFlagImpl());
        }
        return super.getReadNegativeStrandFlag();
    }

    @Override
    public void setReadNegativeStrandFlag(boolean flag) {
        if (!this.initializedFlags.contains((Object)LazyFlag.READ_NEGATIVE_STRAND)) {
            this.initializedFlags.add(LazyFlag.READ_NEGATIVE_STRAND);
        }
        super.setReadNegativeStrandFlag(flag);
    }

    @Override
    public boolean getReadPairedFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.READ_PAIRED)) {
            this.setReadPairedFlag(this.getReadPairedFlagImpl());
        }
        return super.getReadPairedFlag();
    }

    @Override
    public void setReadPairedFlag(boolean flag) {
        if (!this.initializedFlags.contains((Object)LazyFlag.READ_PAIRED)) {
            this.initializedFlags.add(LazyFlag.READ_PAIRED);
        }
        super.setReadPairedFlag(flag);
    }

    @Override
    public boolean getProperPairFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.PROPER_PAIR)) {
            this.setProperPairFlag(this.getProperPairFlagImpl());
        }
        return super.getProperPairFlag();
    }

    @Override
    public void setProperPairFlag(boolean flag) {
        if (!this.initializedFlags.contains((Object)LazyFlag.PROPER_PAIR)) {
            this.initializedFlags.add(LazyFlag.PROPER_PAIR);
        }
        super.setProperPairFlag(flag);
    }

    @Override
    public boolean getNotPrimaryAlignmentFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.NOT_PRIMARY_ALIGNMENT)) {
            this.setNotPrimaryAlignmentFlag(this.getNotPrimaryAlignmentFlagImpl());
        }
        return super.getNotPrimaryAlignmentFlag();
    }

    @Override
    public void setNotPrimaryAlignmentFlag(boolean flag) {
        if (!this.initializedFlags.contains((Object)LazyFlag.NOT_PRIMARY_ALIGNMENT)) {
            this.initializedFlags.add(LazyFlag.NOT_PRIMARY_ALIGNMENT);
        }
        super.setNotPrimaryAlignmentFlag(flag);
    }

    @Override
    public boolean getMateNegativeStrandFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.MATE_NEGATIVE_STRAND)) {
            this.setMateNegativeStrandFlag(this.getMateNegativeStrandFlagImpl());
        }
        return super.getMateNegativeStrandFlag();
    }

    @Override
    public void setMateNegativeStrandFlag(boolean flag) {
        if (!this.initializedFlags.contains((Object)LazyFlag.MATE_NEGATIVE_STRAND)) {
            this.initializedFlags.add(LazyFlag.MATE_NEGATIVE_STRAND);
        }
        super.setMateNegativeStrandFlag(flag);
    }

    @Override
    public boolean getMateUnmappedFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.MATE_UNMAPPED)) {
            this.setMateUnmappedFlag(this.getMateUnmappedFlagImpl());
        }
        return super.getMateUnmappedFlag();
    }

    @Override
    public void setMateUnmappedFlag(boolean flag) {
        if (!this.initializedFlags.contains((Object)LazyFlag.MATE_UNMAPPED)) {
            this.initializedFlags.add(LazyFlag.MATE_UNMAPPED);
        }
        super.setMateUnmappedFlag(flag);
    }

    @Override
    public boolean getFirstOfPairFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.FIRST_OF_PAIR)) {
            this.setFirstOfPairFlag(this.getFirstOfPairFlagImpl());
        }
        return super.getFirstOfPairFlag();
    }

    @Override
    public void setFirstOfPairFlag(boolean flag) {
        if (!this.initializedFlags.contains((Object)LazyFlag.FIRST_OF_PAIR)) {
            this.initializedFlags.add(LazyFlag.FIRST_OF_PAIR);
        }
        super.setFirstOfPairFlag(flag);
    }

    @Override
    public boolean getSecondOfPairFlag() {
        if (!this.initializedFlags.contains((Object)LazyFlag.SECOND_OF_PAIR)) {
            this.setSecondOfPairFlag(this.getSecondOfPairFlagImpl());
        }
        return super.getSecondOfPairFlag();
    }

    @Override
    public void setSecondOfPairFlag(boolean flag) {
        if (!this.initializedFlags.contains((Object)LazyFlag.SECOND_OF_PAIR)) {
            this.initializedFlags.add(LazyFlag.SECOND_OF_PAIR);
        }
        super.setSecondOfPairFlag(flag);
    }

    @Override
    public Object getAttribute(short tag) {
        LazyAttribute attr = lazyAttributeTags.get(tag);
        if (attr != null && !this.initializedAttributes.contains((Object)attr)) {
            this.setAttribute(tag, (Object)attr.getAttribute(this));
        }
        return super.getAttribute(tag);
    }

    @Override
    public void setAttribute(short tag, Object value) {
        LazyAttribute attr = lazyAttributeTags.get(tag);
        if (attr != null && !this.initializedAttributes.contains((Object)attr)) {
            this.initializedAttributes.add(attr);
        }
        super.setAttribute(tag, value);
    }

    @Override
    protected void setAttribute(short tag, Object value, boolean isUnsignedArray) {
        LazyAttribute attr = lazyAttributeTags.get(tag);
        if (attr != null && !this.initializedAttributes.contains((Object)attr)) {
            this.initializedAttributes.add(attr);
        }
        super.setAttribute(tag, value, isUnsignedArray);
    }

    @Override
    public void clearAttributes() {
        for (LazyAttribute lazyAttribute : LazyAttribute.values()) {
            if (this.initializedAttributes.contains((Object)lazyAttribute)) continue;
            this.initializedAttributes.add(lazyAttribute);
        }
        super.clearAttributes();
    }

    @Override
    protected void setAttributes(SAMBinaryTagAndValue attributes) {
        for (LazyAttribute lazyAttribute : LazyAttribute.values()) {
            if (this.initializedAttributes.contains((Object)lazyAttribute)) continue;
            this.initializedAttributes.add(lazyAttribute);
        }
        super.setAttributes(attributes);
    }

    @Override
    protected SAMBinaryTagAndValue getBinaryAttributes() {
        for (Map.Entry<Short, LazyAttribute> info : lazyAttributeTags.entrySet()) {
            if (this.initializedAttributes.contains((Object)info.getValue())) continue;
            this.getAttribute(info.getKey());
        }
        return super.getBinaryAttributes();
    }

    @Override
    public boolean isUnsignedArrayAttribute(String tag) {
        Short binaryTag = SAMTagUtil.getSingleton().makeBinaryTag(tag);
        LazyAttribute attr = lazyAttributeTags.get(binaryTag);
        if (attr != null && !this.initializedAttributes.contains((Object)attr)) {
            this.getAttribute(binaryTag);
        }
        return super.isUnsignedArrayAttribute(tag);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof SRALazyRecord) {
            SRALazyRecord otherRecord = (SRALazyRecord)o;
            otherRecord.getReferenceIndex();
            otherRecord.getAlignmentStart();
        }
        this.getReferenceIndex();
        this.getAlignmentStart();
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        this.getReferenceIndex();
        this.getAlignmentStart();
        return super.hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SRALazyRecord newObject = (SRALazyRecord)super.clone();
        newObject.initializedFields = EnumSet.copyOf(this.initializedFields);
        newObject.initializedFlags = EnumSet.copyOf(this.initializedFlags);
        newObject.initializedAttributes = EnumSet.copyOf(this.initializedAttributes);
        newObject.detachFromIterator();
        return newObject;
    }

    @Override
    public String format() {
        if (!this.initializedAttributes.contains((Object)LazyAttribute.RG)) {
            this.getAttribute("RG");
        }
        return super.format();
    }

    @Override
    public List<SAMValidationError> isValid(boolean firstOnly) {
        this.loadFields();
        this.getFlags();
        this.getBinaryAttributes();
        return super.isValid(firstOnly);
    }

    private ReadCollection getReadCollection() {
        if (this.run != null) {
            return this.run;
        }
        log.debug("Recovering SRA read collection. Accession: " + this.accession);
        try {
            this.run = NGS.openReadCollection((String)this.accession.toString());
            return this.run;
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
    }

    private Alignment getCurrentAlignment() throws ErrorMsg {
        if (!this.isAligned) {
            throw new RuntimeException("Should be called for aligned records only");
        }
        if (this.alignmentIterator == null) {
            log.debug("Recovering SAM record after detaching from iterator. Alignment id: " + this.sraAlignmentId);
            if (this.sraAlignmentId == null) {
                throw new RuntimeException("Cannot recover SAM object after detaching from iterator: no alignment id");
            }
            this.alignmentIterator = this.getReadCollection().getAlignment(this.sraAlignmentId);
        }
        return this.alignmentIterator;
    }

    private Read getCurrentUnalignedRead() throws ErrorMsg {
        if (this.isAligned) {
            throw new RuntimeException("Should be called for unaligned records only");
        }
        if (this.unalignmentIterator == null) {
            log.debug("Recovering SAM record after detaching from iterator. Read id: " + this.sraReadId + ", fragment index: " + this.unalignedReadFragmentIndex);
            if (this.sraReadId == null) {
                throw new RuntimeException("Cannot recover SAM object after detaching from iterator: no read id");
            }
            Read read = this.getReadCollection().getRead(this.sraReadId);
            for (int i = 0; i < this.unalignedReadFragmentIndex + 1; ++i) {
                read.nextFragment();
            }
            this.unalignmentIterator = read;
        }
        return this.unalignmentIterator;
    }

    private void loadFields() {
        for (LazyField field : LazyField.values()) {
            if (this.initializedFields.contains((Object)field)) continue;
            field.loadValue(this);
        }
    }

    private int getAlignmentStartImpl() {
        try {
            if (this.isAligned) {
                return (int)this.getCurrentAlignment().getAlignmentPosition() + 1;
            }
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private int getMappingQualityImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().getMappingQuality();
            }
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private String getReferenceNameImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().getReferenceSpec();
            }
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        return "*";
    }

    private String getCigarStringImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().getShortCigar(false);
            }
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        return "*";
    }

    private byte[] getReadBasesImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().getAlignedFragmentBases().getBytes();
            }
            return this.getCurrentUnalignedRead().getFragmentBases().getBytes();
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getBaseQualitiesImpl() {
        try {
            Object fragment = this.isAligned ? this.getCurrentAlignment() : this.getCurrentUnalignedRead();
            return SAMUtils.fastqToPhred(fragment.getFragmentQualities());
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
    }

    private int getMateAlignmentStartImpl() {
        try {
            if (this.isAligned && this.getReadPairedFlag() && !this.getMateUnmappedFlag()) {
                Alignment mate = this.getCurrentAlignment().getMateAlignment();
                return (int)mate.getAlignmentPosition() + 1;
            }
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private String getMateReferenceNameImpl() {
        try {
            if (this.isAligned && this.getReadPairedFlag() && !this.getMateUnmappedFlag()) {
                return this.getCurrentAlignment().getMateReferenceSpec();
            }
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        return "*";
    }

    private int getInferredInsertSizeImpl() {
        try {
            if (this.isAligned) {
                return (int)this.getCurrentAlignment().getTemplateLength();
            }
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private boolean getReadNegativeStrandFlagImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().getIsReversedOrientation();
            }
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private boolean getReadPairedFlagImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().isPaired();
            }
            return this.getCurrentUnalignedRead().getNumFragments() > 1;
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
    }

    private boolean getProperPairFlagImpl() {
        return this.isAligned && this.getReadPairedFlag() && !this.getMateUnmappedFlag();
    }

    private boolean getNotPrimaryAlignmentFlagImpl() {
        try {
            if (this.isAligned) {
                return this.getCurrentAlignment().getAlignmentCategory() == 2;
            }
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private boolean getMateNegativeStrandFlagImpl() {
        try {
            if (this.isAligned && this.getReadPairedFlag() && !this.getMateUnmappedFlag()) {
                Alignment mate = this.getCurrentAlignment().getMateAlignment();
                return mate.getIsReversedOrientation();
            }
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private boolean getMateUnmappedFlagImpl() {
        try {
            if (this.isAligned) {
                return !this.getCurrentAlignment().hasMate();
            }
            int nextFragmentIdx = this.unalignedReadFragmentIndex + 1;
            Read unalignedRead = this.getCurrentUnalignedRead();
            int numFragments = unalignedRead.getNumFragments();
            if (nextFragmentIdx == numFragments) {
                nextFragmentIdx = 0;
            }
            return unalignedRead.fragmentIsAligned(nextFragmentIdx);
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
    }

    private boolean getFirstOfPairFlagImpl() {
        if (!this.getReadPairedFlag()) {
            return false;
        }
        try {
            if (this.isAligned) {
                String fragmentId = this.getCurrentAlignment().getFragmentId();
                if (!fragmentId.contains(".FA")) {
                    throw new RuntimeException("Invalid fragment id: " + fragmentId);
                }
                return fragmentId.contains(".FA0.");
            }
            return this.unalignedReadFragmentIndex == 0;
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
    }

    private boolean getSecondOfPairFlagImpl() {
        if (!this.getReadPairedFlag()) {
            return false;
        }
        try {
            if (this.isAligned) {
                String fragmentId = this.getCurrentAlignment().getFragmentId();
                if (!fragmentId.contains(".FA")) {
                    throw new RuntimeException("Invalid fragment id: " + fragmentId);
                }
                return !fragmentId.contains(".FA0.");
            }
            return this.unalignedReadFragmentIndex != 0;
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
    }

    private String getAttributeGroupNameImpl() {
        try {
            String readGroupName = this.isAligned ? this.getCurrentAlignment().getReadGroup() : this.getCurrentUnalignedRead().getReadGroup();
            if (!readGroupName.isEmpty()) {
                return readGroupName;
            }
            return this.getReadCollection().getName();
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
    }

    static {
        lazyAttributeTags.put(SAMTagUtil.getSingleton().RG, LazyAttribute.RG);
    }

    private static enum LazyAttribute {
        RG{

            @Override
            public String getAttribute(SRALazyRecord self) {
                return self.getAttributeGroupNameImpl();
            }
        };


        public abstract String getAttribute(SRALazyRecord var1);
    }

    private static enum LazyFlag {
        READ_NEGATIVE_STRAND(true){

            @Override
            public boolean getFlag(SRALazyRecord self) {
                return self.getReadNegativeStrandFlag();
            }
        }
        ,
        READ_PAIRED(true){

            @Override
            public boolean getFlag(SRALazyRecord self) {
                return self.getReadPairedFlag();
            }
        }
        ,
        PROPER_PAIR(false){

            @Override
            public boolean getFlag(SRALazyRecord self) {
                return self.getProperPairFlag();
            }
        }
        ,
        NOT_PRIMARY_ALIGNMENT(true){

            @Override
            public boolean getFlag(SRALazyRecord self) {
                return self.getNotPrimaryAlignmentFlag();
            }
        }
        ,
        MATE_NEGATIVE_STRAND(false){

            @Override
            public boolean getFlag(SRALazyRecord self) {
                return self.getMateNegativeStrandFlag();
            }
        }
        ,
        MATE_UNMAPPED(false){

            @Override
            public boolean getFlag(SRALazyRecord self) {
                return self.getMateUnmappedFlag();
            }
        }
        ,
        FIRST_OF_PAIR(false){

            @Override
            public boolean getFlag(SRALazyRecord self) {
                return self.getFirstOfPairFlag();
            }
        }
        ,
        SECOND_OF_PAIR(false){

            @Override
            public boolean getFlag(SRALazyRecord self) {
                return self.getSecondOfPairFlag();
            }
        };

        private final boolean canCallOnNotPaired;

        private LazyFlag(boolean canCallOnNotPaired) {
            this.canCallOnNotPaired = canCallOnNotPaired;
        }

        public boolean canCallOnNotPaired() {
            return this.canCallOnNotPaired;
        }

        public abstract boolean getFlag(SRALazyRecord var1);
    }

    private static enum LazyField {
        ALIGNMENT_START{

            @Override
            public void loadValue(SRALazyRecord self) {
                self.getAlignmentStart();
            }
        }
        ,
        MAPPING_QUALITY{

            @Override
            public void loadValue(SRALazyRecord self) {
                self.getMappingQuality();
            }
        }
        ,
        REFERENCE_NAME{

            @Override
            public void loadValue(SRALazyRecord self) {
                self.getReferenceName();
            }
        }
        ,
        CIGAR_STRING{

            @Override
            public void loadValue(SRALazyRecord self) {
                self.getCigarString();
            }
        }
        ,
        BASES{

            @Override
            public void loadValue(SRALazyRecord self) {
                self.getReadBases();
            }
        }
        ,
        QUALS{

            @Override
            public void loadValue(SRALazyRecord self) {
                self.getBaseQualities();
            }
        }
        ,
        MATE_ALIGNMENT_START{

            @Override
            public void loadValue(SRALazyRecord self) {
                self.getMateAlignmentStart();
            }
        }
        ,
        MATE_REFERENCE_NAME{

            @Override
            public void loadValue(SRALazyRecord self) {
                self.getMateReferenceName();
            }
        }
        ,
        INFERRED_INSERT_SIZE{

            @Override
            public void loadValue(SRALazyRecord self) {
                self.getInferredInsertSize();
            }
        };


        public abstract void loadValue(SRALazyRecord var1);
    }
}

