/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

public class MemorySetting {
    public static final long leaveFreeMinMemory = 0x20000000L;
    public static final long applicationMinMemory = 0x20000000L;

    protected static long getPhysicalMemory() {
        java.lang.management.OperatingSystemMXBean o = ManagementFactory.getOperatingSystemMXBean();
        try {
            if (o instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean osb = (OperatingSystemMXBean)o;
                return osb.getTotalPhysicalMemorySize();
            }
        }
        catch (NoClassDefFoundError e) {
            System.err.println("No com.sun.management.OperatingSystemMXBean");
        }
        return -1L;
    }

    public static long memPercent(int percent) {
        long memPercent = -1L;
        long physicalMem = MemorySetting.getPhysicalMemory();
        if (physicalMem > 0x20000000L) {
            memPercent = Math.max(0x20000000L, physicalMem - Math.max(physicalMem * (long)(100 - percent) / 100L, 0x20000000L));
        }
        return memPercent;
    }
}

