/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.HostWhitelist;
import com.threerings.getdown.util.Rectangle;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Config {
    public static final Config EMPTY = new Config(new HashMap<String, Object>());
    private final Map<String, Object> _data;
    public static final List<String> allowedReplaceKeys = Arrays.asList("appbase", "apparg", "jvmarg", "jvmmempc");
    public static final List<String> allowedMergeKeys = Arrays.asList("apparg", "jvmarg");

    public static ParseOpts createOpts(boolean checkPlatform) {
        ParseOpts opts = new ParseOpts();
        if (checkPlatform) {
            opts.osname = StringUtil.deNull(System.getProperty("os.name")).toLowerCase(Locale.ROOT);
            opts.osarch = StringUtil.deNull(System.getProperty("os.arch")).toLowerCase(Locale.ROOT);
        }
        return opts;
    }

    /*
     * Exception decompiling
     */
    public static List<String[]> parsePairs(File source, ParseOpts opts) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String[]> parsePairs(Reader source, ParseOpts opts) throws IOException {
        ArrayList<String[]> pairs = new ArrayList<String[]>();
        for (String line : FileUtil.readLines(source)) {
            int eidx;
            int cidx = line.indexOf("#");
            if (opts.strictComments ? cidx == 0 : cidx != -1) {
                line = line.substring(0, cidx);
            }
            if (StringUtil.isBlank(line = line.trim())) continue;
            String[] pair = new String[2];
            int n = eidx = opts.biasToKey ? line.lastIndexOf("=") : line.indexOf("=");
            if (eidx != -1) {
                pair[0] = line.substring(0, eidx).trim();
                pair[1] = line.substring(eidx + 1).trim();
            } else {
                pair[0] = line;
                pair[1] = "";
            }
            if (pair[1].startsWith("[")) {
                int qidx = pair[1].indexOf("]");
                if (qidx == -1) {
                    Log.log.warning("Bogus platform specifier", "key", pair[0], "value", pair[1]);
                    continue;
                }
                String quals = pair[1].substring(1, qidx);
                if (opts.osname != null && !Config.checkQualifiers(quals, opts.osname, opts.osarch)) {
                    Log.log.debug("Skipping", "quals", quals, "osname", opts.osname, "osarch", opts.osarch, "key", pair[0], "value", pair[1]);
                    continue;
                }
                pair[1] = pair[1].substring(qidx + 1).trim();
            }
            pairs.add(pair);
        }
        return pairs;
    }

    public static Rectangle parseRect(String name, String value) {
        if (!StringUtil.isBlank(value)) {
            int[] v = StringUtil.parseIntArray(value);
            if (v != null && v.length == 4) {
                return new Rectangle(v[0], v[1], v[2], v[3]);
            }
            Log.log.warning("Ignoring invalid rect '" + name + "' config '" + value + "'.", new Object[0]);
        }
        return null;
    }

    public static Integer parseColor(String hexValue) {
        if (!StringUtil.isBlank(hexValue)) {
            try {
                int alpha = hexValue.length() > 6 ? 0 : -16777216;
                return Integer.parseInt(hexValue, 16) | alpha;
            }
            catch (NumberFormatException e) {
                Log.log.warning("Ignoring invalid color", "hexValue", hexValue, "exception", e);
            }
        }
        return null;
    }

    public static Config parseConfig(File source, ParseOpts opts) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (String[] pair : Config.parsePairs(source, opts)) {
            Object value = data.get(pair[0]);
            if (value == null) {
                data.put(pair[0], pair[1]);
                continue;
            }
            if (value instanceof String) {
                data.put(pair[0], new String[]{(String)value, pair[1]});
                continue;
            }
            if (!(value instanceof String[])) continue;
            String[] values = (String[])value;
            String[] nvalues = new String[values.length + 1];
            System.arraycopy(values, 0, nvalues, 0, values.length);
            nvalues[values.length] = pair[1];
            data.put(pair[0], nvalues);
        }
        if (!opts.strictComments && Boolean.parseBoolean((String)data.get("strict_comments"))) {
            opts.strictComments = true;
            return Config.parseConfig(source, opts);
        }
        return new Config(data);
    }

    public Config(Map<String, Object> data) {
        this._data = data;
    }

    public boolean hasValue(String name) {
        return this._data.containsKey(name);
    }

    public Object getRaw(String name) {
        return this._data.get(name);
    }

    public String getString(String name) {
        return (String)this._data.get(name);
    }

    public String getString(String name, String def) {
        String value = (String)this._data.get(name);
        return value == null ? def : value;
    }

    public boolean getBoolean(String name) {
        return Boolean.parseBoolean(this.getString(name));
    }

    public String[] getMultiValue(String name) {
        Object value = this._data.get(name);
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        return (String[])value;
    }

    public Rectangle getRect(String name, Rectangle def) {
        String value = this.getString(name);
        Rectangle rect = Config.parseRect(name, value);
        return rect == null ? def : rect;
    }

    public int getInt(String name, int def) {
        String value = this.getString(name);
        try {
            return value == null ? def : Integer.parseInt(value);
        }
        catch (Exception e) {
            Log.log.warning("Ignoring invalid int '" + name + "' config '" + value + "',", new Object[0]);
            return def;
        }
    }

    public long getLong(String name, long def) {
        String value = this.getString(name);
        try {
            return value == null ? def : Long.parseLong(value);
        }
        catch (Exception e) {
            Log.log.warning("Ignoring invalid long '" + name + "' config '" + value + "',", new Object[0]);
            return def;
        }
    }

    public int getColor(String name, int def) {
        String value = this.getString(name);
        Integer color = Config.parseColor(value);
        return color == null ? def : color;
    }

    public String[] getList(String name) {
        String value = this.getString(name);
        return value == null ? new String[]{} : StringUtil.parseStringArray(value);
    }

    public String getUrl(String name, String def) {
        String value = this.getString(name + "." + Locale.getDefault().getLanguage());
        if (StringUtil.isBlank(value)) {
            value = this.getString(name);
        }
        if (StringUtil.isBlank(value)) {
            value = def;
        }
        if (!StringUtil.isBlank(value)) {
            try {
                HostWhitelist.verify(new URL(value));
            }
            catch (MalformedURLException e) {
                Log.log.warning("Invalid URL.", "url", value, e);
                value = null;
            }
        }
        return value;
    }

    protected static boolean checkQualifiers(String quals, String osname, String osarch) {
        if (quals.startsWith("!")) {
            if (quals.indexOf(",") != -1) {
                Log.log.warning("Multiple qualifiers cannot be used when one of the qualifiers is negative", "quals", quals);
                return false;
            }
            return !Config.checkQualifier(quals.substring(1), osname, osarch);
        }
        for (String qual : quals.split(",")) {
            if (!Config.checkQualifier(qual, osname, osarch)) continue;
            return true;
        }
        return false;
    }

    protected static boolean checkQualifier(String qual, String osname, String osarch) {
        String[] bits = qual.trim().toLowerCase(Locale.ROOT).split("-");
        String os = bits[0];
        String arch = bits.length > 1 ? bits[1] : "";
        return osname.indexOf(os) != -1 && osarch.indexOf(arch) != -1;
    }

    public void mergeConfig(Config newValues, boolean merge) {
        for (Map.Entry<String, Object> entry : newValues.getData().entrySet()) {
            String mkey;
            String key = entry.getKey();
            Object nvalue = entry.getValue();
            String string = mkey = key.indexOf(46) > -1 ? key.substring(key.indexOf(46) + 1) : key;
            if (merge && allowedMergeKeys.contains(mkey)) {
                String[] values;
                String[] newvalues;
                Object value = this._data.get(key);
                if (value == null) {
                    this._data.put(key, nvalue);
                    continue;
                }
                if (value instanceof String) {
                    if (nvalue instanceof String) {
                        this._data.put(key, new String[]{(String)value, (String)nvalue});
                        continue;
                    }
                    if (!(nvalue instanceof String[])) continue;
                    String[] nvalues = (String[])nvalue;
                    newvalues = new String[nvalues.length + 1];
                    newvalues[0] = (String)value;
                    System.arraycopy(nvalues, 0, newvalues, 1, nvalues.length);
                    this._data.put(key, newvalues);
                    continue;
                }
                if (!(value instanceof String[])) continue;
                if (nvalue instanceof String) {
                    values = (String[])value;
                    newvalues = new String[values.length + 1];
                    System.arraycopy(values, 0, newvalues, 0, values.length);
                    newvalues[values.length] = (String)nvalue;
                    this._data.put(key, newvalues);
                    continue;
                }
                if (!(nvalue instanceof String[])) continue;
                values = (String[])value;
                String[] nvalues = (String[])nvalue;
                String[] newvalues2 = new String[values.length + nvalues.length];
                System.arraycopy(values, 0, newvalues2, 0, values.length);
                System.arraycopy(nvalues, 0, newvalues2, values.length, newvalues2.length);
                this._data.put(key, newvalues2);
                continue;
            }
            if (allowedReplaceKeys.contains(mkey)) {
                this._data.put(key, nvalue);
                continue;
            }
            Log.log.warning("Not merging key '" + key + "' into config", new Object[0]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.getData().entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            sb.append(key);
            sb.append("=");
            if (val instanceof String) {
                sb.append((String)val);
            } else if (val instanceof String[]) {
                sb.append(Arrays.toString((String[])val));
            } else {
                sb.append("Value not String or String[]");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Map<String, Object> getData() {
        return this._data;
    }

    public static class ParseOpts {
        public boolean biasToKey = false;
        public boolean strictComments = false;
        public String osname = null;
        public String osarch = null;
    }
}

