/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.ClassPath;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.PathBuilder;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.util.Base64;
import com.threerings.getdown.util.Color;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.ConnectionUtil;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.HostWhitelist;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.MessageUtil;
import com.threerings.getdown.util.ProgressAggregator;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.Rectangle;
import com.threerings.getdown.util.StreamUtil;
import com.threerings.getdown.util.StringUtil;
import com.threerings.getdown.util.VersionUtil;
import jalview.bin.MemorySetting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class Application {
    public static final String CONFIG_FILE = "getdown.txt";
    public static final String BACKUP_CONFIG_DIR = "install";
    public static final String VERSION_FILE = "version.txt";
    public static final String PROP_PASSTHROUGH_PREFIX = "app.";
    public static final String SIGNATURE_SUFFIX = ".sig";
    public static final String MANIFEST_CLASS = "manifest";
    public Proxy proxy = Proxy.NO_PROXY;
    protected final EnvConfig _envc;
    protected File _config;
    protected File _backupConfig;
    protected Digest _digest;
    protected long _version = -1L;
    protected long _targetVersion = -1L;
    protected String _appbase;
    protected URL _vappbase;
    protected URL _latest;
    protected String _class;
    protected String _dockName;
    protected String _dockIconPath;
    protected boolean _strictComments;
    protected boolean _windebug;
    protected boolean _allowOffline;
    protected int _maxConcDownloads;
    protected String _trackingURL;
    protected Set<Integer> _trackingPcts;
    protected String _trackingCookieName;
    protected String _trackingCookieProperty;
    protected String _trackingURLSuffix;
    protected String _trackingGAHash;
    protected long _trackingStart;
    protected int _trackingId;
    protected String _javaVersionProp = "java.version";
    protected String _javaVersionRegex = "(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)(_\\d+)?)?)?";
    protected long _javaMinVersion;
    protected long _javaMaxVersion;
    protected boolean _javaExactVersionRequired;
    protected String _javaLocation;
    protected List<Resource> _codes = new ArrayList<Resource>();
    protected List<Resource> _resources = new ArrayList<Resource>();
    protected boolean _useCodeCache;
    protected int _codeCacheRetentionDays;
    protected Map<String, AuxGroup> _auxgroups = new HashMap<String, AuxGroup>();
    protected Map<String, Boolean> _auxactive = new HashMap<String, Boolean>();
    protected List<String> _jvmargs = new ArrayList<String>();
    protected List<String> _appargs = new ArrayList<String>();
    protected String[] _optimumJvmArgs;
    protected List<String> _txtJvmArgs = new ArrayList<String>();
    protected boolean _warnedAboutSetLastModified;
    protected FileLock _lock;
    protected FileChannel _lockChannel;
    protected Random _rando = new Random();
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final String ENV_VAR_PREFIX = "%ENV.";
    protected static final Pattern ENV_VAR_PATTERN = Pattern.compile("%ENV\\.(.*?)%");
    protected static File _locatorFile;
    protected static List<File> _startupFiles;
    public static final String LOCATOR_FILE_EXTENSION = "jvl";

    public Application(EnvConfig envc) {
        this._envc = envc;
        this._config = this.getLocalPath(envc.appDir, CONFIG_FILE);
        this._backupConfig = this.getLocalPath(envc.appDir, BACKUP_CONFIG_DIR + File.separator + CONFIG_FILE);
    }

    public File getAppDir() {
        return this._envc.appDir;
    }

    public boolean useCodeCache() {
        return this._useCodeCache;
    }

    public int getCodeCacheRetentionDays() {
        return this._codeCacheRetentionDays;
    }

    public int maxConcurrentDownloads() {
        return this._maxConcDownloads;
    }

    public Resource getConfigResource() {
        try {
            return this.createResource(CONFIG_FILE, Resource.NORMAL);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid appbase '" + this._vappbase + "'.", e);
        }
    }

    public List<Resource> getCodeResources() {
        return this._codes;
    }

    public List<Resource> getResources() {
        return this._resources;
    }

    public String getDigest(Resource resource) {
        return this._digest.getDigest(resource);
    }

    public List<Resource> getAllActiveResources() {
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        allResources.addAll(this.getActiveCodeResources());
        allResources.addAll(this.getActiveResources());
        return allResources;
    }

    public AuxGroup getAuxGroup(String name) {
        return this._auxgroups.get(name);
    }

    public Iterable<AuxGroup> getAuxGroups() {
        return this._auxgroups.values();
    }

    public boolean isAuxGroupActive(String auxgroup) {
        Boolean active = this._auxactive.get(auxgroup);
        if (active == null) {
            active = this.getLocalPath(auxgroup + ".dat").exists();
            this._auxactive.put(auxgroup, active);
        }
        return active;
    }

    public List<Resource> getActiveCodeResources() {
        ArrayList<Resource> codes = new ArrayList<Resource>();
        codes.addAll(this.getCodeResources());
        for (AuxGroup aux : this.getAuxGroups()) {
            if (!this.isAuxGroupActive(aux.name)) continue;
            codes.addAll(aux.codes);
        }
        return codes;
    }

    public List<Resource> getNativeResources() {
        ArrayList<Resource> natives = new ArrayList<Resource>();
        for (Resource resource : this._resources) {
            if (!resource.isNative()) continue;
            natives.add(resource);
        }
        return natives;
    }

    public List<Resource> getActiveResources() {
        ArrayList<Resource> rsrcs = new ArrayList<Resource>();
        rsrcs.addAll(this.getResources());
        for (AuxGroup aux : this.getAuxGroups()) {
            if (!this.isAuxGroupActive(aux.name)) continue;
            rsrcs.addAll(aux.rsrcs);
        }
        return rsrcs;
    }

    public Resource getPatchResource(String auxgroup) {
        if (this._targetVersion <= this._version) {
            Log.log.warning("Requested patch resource for up-to-date or non-versioned application", "cvers", this._version, "tvers", this._targetVersion);
            return null;
        }
        String infix = auxgroup == null ? "" : "-" + auxgroup;
        String pfile = "patch" + infix + this._version + ".dat";
        try {
            URL remote = new URL(this.createVAppBase(this._targetVersion), Application.encodePath(pfile));
            return new Resource(pfile, remote, this.getLocalPath(pfile), Resource.NORMAL);
        }
        catch (Exception e) {
            Log.log.warning("Failed to create patch resource path", "pfile", pfile, "appbase", this._appbase, "tvers", this._targetVersion, "error", e);
            return null;
        }
    }

    public Resource getJavaVMResource() {
        if (StringUtil.isBlank(this._javaLocation)) {
            return null;
        }
        String extension = this._javaLocation.endsWith(".tgz") ? ".tgz" : ".jar";
        String vmfile = "jre" + extension;
        Log.log.info("vmfile is '" + vmfile + "'", new Object[0]);
        System.out.println("vmfile is '" + vmfile + "'");
        try {
            URL remote = new URL(this.createVAppBase(this._targetVersion), Application.encodePath(this._javaLocation));
            Log.log.info("Attempting to fetch jvm at " + remote.toString(), new Object[0]);
            System.out.println("Attempting to fetch jvm at " + remote.toString());
            return new Resource(vmfile, remote, this.getLocalPath(vmfile), EnumSet.of(Resource.Attr.UNPACK, Resource.Attr.CLEAN));
        }
        catch (Exception e) {
            Log.log.warning("Failed to create VM resource", "vmfile", vmfile, "appbase", this._appbase, "tvers", this._targetVersion, "javaloc", this._javaLocation, "error", e);
            System.out.println("Failed to create VM resource: vmfile=" + vmfile + ", appbase=" + this._appbase + ", tvers=" + this._targetVersion + ", javaloc=" + this._javaLocation + ", error=" + e);
            return null;
        }
    }

    public Resource getFullResource() {
        String file = "full";
        try {
            URL remote = new URL(this.createVAppBase(this._targetVersion), Application.encodePath(file));
            return new Resource(file, remote, this.getLocalPath(file), Resource.NORMAL);
        }
        catch (Exception e) {
            Log.log.warning("Failed to create full resource path", "file", file, "appbase", this._appbase, "tvers", this._targetVersion, "error", e);
            return null;
        }
    }

    public URL getTrackingURL(String event) {
        try {
            String suffix = this._trackingURLSuffix == null ? "" : this._trackingURLSuffix;
            String ga = this.getGATrackingCode();
            return this._trackingURL == null ? null : HostWhitelist.verify(new URL(this._trackingURL + Application.encodePath(event + suffix + ga)));
        }
        catch (MalformedURLException mue) {
            Log.log.warning("Invalid tracking URL", "path", this._trackingURL, "event", event, "error", mue);
            return null;
        }
    }

    public URL getTrackingProgressURL(int percent) {
        if (this._trackingPcts == null || !this._trackingPcts.contains(percent)) {
            return null;
        }
        return this.getTrackingURL("pct" + percent);
    }

    public String getTrackingCookieName() {
        return this._trackingCookieName;
    }

    public String getTrackingCookieProperty() {
        return this._trackingCookieProperty;
    }

    public Config init(boolean checkPlatform) throws IOException {
        Config locatorConfig;
        Config config = null;
        File cfgfile = this._config;
        Config.ParseOpts opts = Config.createOpts(checkPlatform);
        try {
            if (cfgfile.exists()) {
                config = Config.parseConfig(this._config, opts);
            } else {
                cfgfile = this.getLocalPath("getdown.txt_old");
                if (cfgfile.exists()) {
                    config = Config.parseConfig(cfgfile, opts);
                } else {
                    Log.log.info("Found no getdown.txt file", "appdir", this.getAppDir());
                }
            }
        }
        catch (Exception e) {
            Log.log.warning("Failure reading config file", "file", this._config, e);
        }
        if (config == null || config.getString("appbase") == null || config.getString("appbase").isEmpty()) {
            try {
                Config backupConfig;
                config = backupConfig = Config.parseConfig(this._backupConfig, opts);
                Log.log.warning("Using backup config file", "appdir", this.getAppDir(), "backupConfig", this._backupConfig.getAbsoluteFile());
            }
            catch (Exception e) {
                Log.log.warning("Failure reading backup config file", "file", this._backupConfig, e);
            }
        }
        if ((locatorConfig = this.createLocatorConfig(opts)) != null) {
            if (config == null || locatorConfig.getBoolean("jvl_replace")) {
                config = locatorConfig;
            } else {
                config.mergeConfig(locatorConfig, locatorConfig.getBoolean("jvl_merge"));
            }
        }
        if (config == null) {
            String appbase = this._envc.appBase;
            Log.log.info("Using 'appbase' from bootstrap config", "appbase", appbase);
            HashMap<String, Object> cdata = new HashMap<String, Object>();
            cdata.put("appbase", appbase);
            config = new Config(cdata);
        }
        this._appbase = config.getString("appbase");
        if (locatorConfig != null && !StringUtil.isBlank(locatorConfig.getString("appbase"))) {
            this._appbase = locatorConfig.getString("appbase");
        }
        if (this._appbase == null) {
            throw new RuntimeException("m.missing_appbase");
        }
        this._appbase = SysProps.overrideAppbase(this._appbase);
        if (!this._appbase.endsWith("/")) {
            this._appbase = this._appbase + "/";
        }
        this._version = config.getLong("version", -1L);
        try {
            this._vappbase = this.createVAppBase(this._version);
        }
        catch (MalformedURLException mue) {
            String err = MessageUtil.tcompose("m.invalid_appbase", this._appbase);
            throw (IOException)new IOException(err).initCause(mue);
        }
        String latest = config.getString("latest");
        if (latest != null) {
            latest = latest.startsWith(this._appbase) ? this._appbase + latest.substring(this._appbase.length()) : SysProps.replaceDomain(latest);
            try {
                this._latest = HostWhitelist.verify(new URL(latest));
            }
            catch (MalformedURLException mue) {
                Log.log.warning("Invalid URL for latest attribute.", mue);
            }
        }
        String appPrefix = this._envc.appId == null ? "" : this._envc.appId + ".";
        this._class = config.getString("class");
        if (appPrefix.length() > 0) {
            this._class = config.getString(appPrefix + "class", this._class);
        }
        if (this._class == null) {
            throw new IOException("m.missing_class");
        }
        this._strictComments = config.getBoolean("strict_comments");
        this._javaVersionProp = config.getString("java_version_prop", this._javaVersionProp);
        this._javaVersionRegex = config.getString("java_version_regex", this._javaVersionRegex);
        this._javaMinVersion = config.getLong("java_version", this._javaMinVersion);
        this._javaMinVersion = config.getLong("java_min_version", this._javaMinVersion);
        this._javaMaxVersion = config.getLong("java_max_version", this._javaMaxVersion);
        this._javaExactVersionRequired = config.getBoolean("java_exact_version_required");
        Object javaloc = config.getRaw("java_location");
        if (javaloc instanceof String) {
            this._javaLocation = (String)javaloc;
        }
        this._trackingURL = config.getString("tracking_url");
        String trackPcts = config.getString("tracking_percents");
        if (!StringUtil.isBlank(trackPcts)) {
            this._trackingPcts = new HashSet<Integer>();
            for (int pct : StringUtil.parseIntArray(trackPcts)) {
                this._trackingPcts.add(pct);
            }
        } else if (!StringUtil.isBlank(this._trackingURL)) {
            this._trackingPcts = new HashSet<Integer>();
            this._trackingPcts.add(50);
        }
        this._trackingCookieName = config.getString("tracking_cookie_name");
        this._trackingCookieProperty = config.getString("tracking_cookie_property");
        this._trackingURLSuffix = config.getString("tracking_url_suffix");
        this._trackingGAHash = config.getString("tracking_ga_hash");
        this._codes.clear();
        this._resources.clear();
        this._auxgroups.clear();
        this._jvmargs.clear();
        this._appargs.clear();
        this._txtJvmArgs.clear();
        if (config.getMultiValue("code") == null && config.getMultiValue("ucode") == null) {
            throw new IOException("m.missing_code");
        }
        this.parseResources(config, "code", Resource.NORMAL, this._codes);
        this.parseResources(config, "ucode", Resource.UNPACK, this._codes);
        this.parseResources(config, "resource", Resource.NORMAL, this._resources);
        this.parseResources(config, "uresource", Resource.UNPACK, this._resources);
        this.parseResources(config, "xresource", Resource.EXEC, this._resources);
        this.parseResources(config, "presource", Resource.PRELOAD, this._resources);
        this.parseResources(config, "nresource", Resource.NATIVE, this._resources);
        for (String auxgroup : config.getList("auxgroups")) {
            ArrayList<Resource> codes = new ArrayList<Resource>();
            this.parseResources(config, auxgroup + ".code", Resource.NORMAL, codes);
            this.parseResources(config, auxgroup + ".ucode", Resource.UNPACK, codes);
            ArrayList<Resource> rsrcs = new ArrayList<Resource>();
            this.parseResources(config, auxgroup + ".resource", Resource.NORMAL, rsrcs);
            this.parseResources(config, auxgroup + ".xresource", Resource.EXEC, rsrcs);
            this.parseResources(config, auxgroup + ".uresource", Resource.UNPACK, rsrcs);
            this.parseResources(config, auxgroup + ".presource", Resource.PRELOAD, rsrcs);
            this.parseResources(config, auxgroup + ".nresource", Resource.NATIVE, rsrcs);
            this._auxgroups.put(auxgroup, new AuxGroup(auxgroup, codes, rsrcs));
        }
        String[] stringArray = config.getMultiValue("jvmarg");
        Application.addAll(stringArray, this._jvmargs);
        if (appPrefix.length() > 0) {
            String[] stringArray2 = config.getMultiValue(appPrefix + "jvmarg");
            Application.addAll(stringArray2, this._jvmargs);
        }
        int jvmmempc = config.getInt("jvmmempc", -1);
        if (appPrefix.length() > 0) {
            jvmmempc = config.getInt(appPrefix + "jvmmempc", jvmmempc);
        }
        if (0 <= jvmmempc && jvmmempc <= 100) {
            long maxMemLong = -1L;
            try {
                maxMemLong = MemorySetting.memPercent(jvmmempc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (maxMemLong > 0L) {
                String[] maxMemHeapArg = new String[]{"-Xmx" + Long.toString(maxMemLong)};
                for (int i = 0; i < this._jvmargs.size(); ++i) {
                    if (!(this._jvmargs.get(i) instanceof String) || !this._jvmargs.get(i).startsWith("-Xmx")) continue;
                    this._jvmargs.remove(i);
                    break;
                }
                Application.addAll(maxMemHeapArg, this._jvmargs);
                Log.log.info("Max memory set", "maxMemHeapArg", maxMemHeapArg[0]);
            }
        } else if (jvmmempc != -1) {
            Log.log.warning("'jvmmempc' value must be in range 0 to 100 (read as '" + Integer.toString(jvmmempc) + "')", new Object[0]);
        }
        this._optimumJvmArgs = config.getMultiValue("optimum_jvmarg");
        String[] appargs = config.getMultiValue(appPrefix + "apparg");
        Application.addAll(appargs, this._appargs);
        this._appargs.addAll(this._envc.appArgs);
        this.fillAssignmentListFromPairs("extra.txt", this._txtJvmArgs);
        this._allowOffline = config.getBoolean("allow_offline");
        this._windebug = this.getLocalPath("debug.txt").exists();
        this._useCodeCache = config.getBoolean("use_code_cache");
        this._codeCacheRetentionDays = config.getInt("code_cache_retention_days", 7);
        this._maxConcDownloads = Math.max(1, config.getInt("max_concurrent_downloads", SysProps.threadPoolSize()));
        this._dockName = config.getString("ui.name");
        this._dockIconPath = config.getString("ui.mac_dock_icon", "../desktop.icns");
        return config;
    }

    protected void fillAssignmentListFromPairs(String pairLocation, List<String> collector) {
        File pairFile = this.getLocalPath(pairLocation);
        if (pairFile.exists()) {
            try {
                List<String[]> args = Config.parsePairs(pairFile, Config.createOpts(false));
                for (String[] pair : args) {
                    if (pair[1].length() == 0) {
                        collector.add(pair[0]);
                        continue;
                    }
                    collector.add(pair[0] + "=" + pair[1]);
                }
            }
            catch (Throwable t) {
                Log.log.warning("Failed to parse '" + pairFile + "': " + t, new Object[0]);
            }
        }
    }

    public URL getRemoteURL(String path) throws MalformedURLException {
        return new URL(this._vappbase, Application.encodePath(path));
    }

    public File getLocalPath(String path) {
        return this.getLocalPath(this.getAppDir(), path);
    }

    public boolean haveValidJavaVersion() {
        if (this._javaMinVersion == 0L && this._javaMaxVersion == 0L) {
            return true;
        }
        try {
            long version = SysProps.parseJavaVersion(this._javaVersionProp, this._javaVersionRegex);
            Log.log.info("Checking Java version", "current", version, "wantMin", this._javaMinVersion, "wantMax", this._javaMaxVersion);
            Resource vmjar = this.getJavaVMResource();
            if (vmjar != null && vmjar.isMarkedValid()) {
                File vmdir = new File(this.getAppDir(), "jre");
                File relfile = new File(vmdir, "release");
                if (!relfile.exists()) {
                    Log.log.warning("Unpacked JVM missing 'release' file. Assuming valid version.", new Object[0]);
                    return true;
                }
                long vmvers = VersionUtil.readReleaseVersion(relfile, this._javaVersionRegex);
                if (vmvers == 0L) {
                    Log.log.warning("Unable to read version from 'release' file. Assuming valid.", new Object[0]);
                    return true;
                }
                version = vmvers;
                Log.log.info("Checking version of unpacked JVM [vers=" + version + "].", new Object[0]);
            }
            if (this._javaExactVersionRequired) {
                if (version == this._javaMinVersion) {
                    return true;
                }
                Log.log.warning("An exact Java VM version is required.", "current", version, "required", this._javaMinVersion);
                return false;
            }
            boolean minVersionOK = this._javaMinVersion == 0L || version >= this._javaMinVersion;
            boolean maxVersionOK = this._javaMaxVersion == 0L || version <= this._javaMaxVersion;
            return minVersionOK && maxVersionOK;
        }
        catch (RuntimeException re) {
            Log.log.warning("Unable to parse VM version, hoping for the best", "error", re, "needed", this._javaMinVersion);
            return true;
        }
    }

    public boolean hasOptimumJvmArgs() {
        return this._optimumJvmArgs != null;
    }

    public boolean allowOffline() {
        return this._allowOffline;
    }

    public void attemptRecovery(StatusDisplay status) throws IOException {
        status.updateStatus("m.updating_metadata");
        this.downloadConfigFile();
    }

    public void updateMetadata() throws IOException {
        try {
            this._vappbase = this.createVAppBase(this._targetVersion);
        }
        catch (MalformedURLException mue) {
            String err = MessageUtil.tcompose("m.invalid_appbase", this._appbase);
            throw (IOException)new IOException(err).initCause(mue);
        }
        try {
            this.downloadDigestFiles();
            this.downloadConfigFile();
        }
        catch (IOException ex) {
            if (this._allowOffline) {
                Log.log.warning("Failed to update digest files.  Attempting offline operaton.", ex);
                if (!FileUtil.deleteHarder(this.getLocalPath(VERSION_FILE))) {
                    Log.log.warning("Deleting version.txt failed.  This probably isn't going to work.", new Object[0]);
                }
            }
            throw ex;
        }
    }

    public Process createProcess(boolean optimum) throws IOException {
        String proxyHost;
        ArrayList<String> args = new ArrayList<String>();
        args.add(LaunchUtil.getJVMPath(this.getAppDir(), this._windebug || optimum));
        boolean dashJarMode = MANIFEST_CLASS.equals(this._class);
        ClassPath classPath = PathBuilder.buildClassPath(this);
        if (!dashJarMode) {
            args.add("-classpath");
            args.add(classPath.asArgumentString());
        }
        if (LaunchUtil.isMacOS()) {
            args.add("-Xdock:icon=" + this.getLocalPath(this._dockIconPath).getAbsolutePath());
            args.add("-Xdock:name=" + this._dockName);
        }
        if ((proxyHost = System.getProperty("http.proxyHost")) != null) {
            args.add("-Dhttp.proxyHost=" + proxyHost);
            args.add("-Dhttp.proxyPort=" + System.getProperty("http.proxyPort"));
            args.add("-Dhttps.proxyHost=" + proxyHost);
            args.add("-Dhttps.proxyPort=" + System.getProperty("http.proxyPort"));
        }
        args.add("-Dcom.threerings.getdown=true");
        ClassPath javaLibPath = PathBuilder.buildLibsPath(this, true);
        if (javaLibPath != null) {
            args.add("-Djava.library.path=" + javaLibPath.asArgumentString());
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(PROP_PASSTHROUGH_PREFIX)) continue;
            key = key.substring(PROP_PASSTHROUGH_PREFIX.length());
            args.add("-D" + key + "=" + entry.getValue());
        }
        for (String string : this._jvmargs) {
            args.add(this.processArg(string));
        }
        if (optimum && this._optimumJvmArgs != null) {
            for (Iterator<Object> iterator : this._optimumJvmArgs) {
                args.add(this.processArg((String)((Object)iterator)));
            }
        }
        for (String string : this._txtJvmArgs) {
            args.add(this.processArg(string));
        }
        if (dashJarMode) {
            args.add("-jar");
            args.add(classPath.asArgumentString());
        } else {
            args.add(this._class);
        }
        Iterator<Object> iterator = _startupFiles.iterator();
        if (iterator.hasNext()) {
            File f = (File)iterator.next();
            this._appargs.add(f.getAbsolutePath());
        }
        if (this._appargs.size() == 1 && this._appargs.get(0) != null) {
            String filename = this._appargs.get(0);
            String ext = null;
            int j = filename.lastIndexOf(46);
            if (j > -1) {
                ext = filename.substring(j + 1);
            }
            if (ext == null || !LOCATOR_FILE_EXTENSION.equals(ext.toLowerCase())) {
                this._appargs.add(0, "-open");
            }
        }
        for (String string : this._appargs) {
            args.add(this.processArg(string));
        }
        String[] envp = this.createEnvironment();
        Object[] sargs = args.toArray(new String[args.size()]);
        Log.log.info("Running " + StringUtil.join(sargs, "\n  "), new Object[0]);
        return Runtime.getRuntime().exec((String[])sargs, envp, this.getAppDir());
    }

    protected String[] createEnvironment() {
        ArrayList<String> envvar = new ArrayList<String>();
        this.fillAssignmentListFromPairs("env.txt", envvar);
        if (envvar.isEmpty()) {
            Log.log.info("Didn't find any custom environment variables, not setting any.", new Object[0]);
            return null;
        }
        ArrayList<String> envAssignments = new ArrayList<String>();
        for (String string : envvar) {
            envAssignments.add(this.processArg(string));
        }
        for (Map.Entry entry : System.getenv().entrySet()) {
            envAssignments.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        Object[] envp = envAssignments.toArray(new String[envAssignments.size()]);
        Log.log.info("Environment " + StringUtil.join(envp, "\n "), new Object[0]);
        return envp;
    }

    /*
     * WARNING - void declaration
     */
    public void invokeDirect() throws IOException {
        void var6_14;
        void var6_9;
        ClassPath classPath = PathBuilder.buildClassPath(this);
        URL[] jarUrls = classPath.asUrls();
        URLClassLoader loader = new URLClassLoader(jarUrls, ClassLoader.getSystemClassLoader()){

            @Override
            protected PermissionCollection getPermissions(CodeSource code) {
                Permissions perms = new Permissions();
                perms.add(new AllPermission());
                return perms;
            }
        };
        Thread.currentThread().setContextClassLoader(loader);
        Log.log.info("Configured URL class loader:", new Object[0]);
        URL[] uRLArray = jarUrls;
        int n = uRLArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            URL url = uRLArray[var6_9];
            Log.log.info("  " + url, new Object[0]);
            ++var6_9;
        }
        for (String jvmarg : this._jvmargs) {
            if (!jvmarg.startsWith("-D")) continue;
            int n2 = (jvmarg = this.processArg(jvmarg.substring(2))).indexOf("=");
            if (n2 == -1) {
                Log.log.warning("Bogus system property: '" + jvmarg + "'?", new Object[0]);
                continue;
            }
            System.setProperty(jvmarg.substring(0, n2), jvmarg.substring(n2 + 1));
        }
        HashMap<String, String> passProps = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(PROP_PASSTHROUGH_PREFIX)) continue;
            key = key.substring(PROP_PASSTHROUGH_PREFIX.length());
            passProps.put(key, (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : passProps.entrySet()) {
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        Object[] args = new String[this._appargs.size()];
        boolean bl2 = false;
        while (var6_14 < args.length) {
            args[var6_14] = this.processArg(this._appargs.get((int)var6_14));
            ++var6_14;
        }
        try {
            Log.log.info("Loading " + this._class, new Object[0]);
            Class<?> clazz = loader.loadClass(this._class);
            Method main = clazz.getMethod("main", EMPTY_STRING_ARRAY.getClass());
            Log.log.info("Invoking main({" + StringUtil.join(args, ", ") + "})", new Object[0]);
            main.invoke(null, new Object[]{args});
        }
        catch (Exception exception) {
            Log.log.warning("Failure invoking app main", exception);
        }
    }

    protected String processArg(String arg) {
        arg = arg.replace("%APPDIR%", this.getAppDir().getAbsolutePath());
        if ((arg = arg.replace("%VERSION%", String.valueOf(this._version))).contains(ENV_VAR_PREFIX)) {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = ENV_VAR_PATTERN.matcher(arg);
            while (matcher.find()) {
                String varName = matcher.group(1);
                String varValue = System.getenv(varName);
                String repValue = varValue == null ? "MISSING:" + varName : varValue;
                matcher.appendReplacement(sb, Matcher.quoteReplacement(repValue));
            }
            matcher.appendTail(sb);
            arg = sb.toString();
        }
        return arg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyMetadata(StatusDisplay status) throws IOException {
        Resource crsrc;
        Log.log.info("Verifying application: " + this._vappbase, new Object[0]);
        Log.log.info("Version: " + this._version, new Object[0]);
        Log.log.info("Class: " + this._class, new Object[0]);
        try {
            this._digest = new Digest(this.getAppDir(), this._strictComments);
        }
        catch (IOException ioe) {
            Log.log.info("Failed to load digest: " + ioe.getMessage() + ". Attempting recovery...", new Object[0]);
        }
        if (this._version == -1L) {
            String olddig = this._digest == null ? "" : this._digest.getMetaDigest();
            try {
                status.updateStatus("m.checking");
                this.downloadDigestFiles();
                this._digest = new Digest(this.getAppDir(), this._strictComments);
                if (!olddig.equals(this._digest.getMetaDigest())) {
                    Log.log.info("Unversioned digest changed. Revalidating...", new Object[0]);
                    status.updateStatus("m.validating");
                    this.clearValidationMarkers();
                }
            }
            catch (IOException ioe) {
                Log.log.warning("Failed to refresh non-versioned digest: " + ioe.getMessage() + ". Proceeding...", new Object[0]);
            }
        }
        if (this._digest == null) {
            status.updateStatus("m.updating_metadata");
            this.downloadDigestFiles();
            this._digest = new Digest(this.getAppDir(), this._strictComments);
        }
        if (!this._digest.validateResource(crsrc = this.getConfigResource(), null)) {
            status.updateStatus("m.updating_metadata");
            this.downloadConfigFile();
            this.downloadDigestFiles();
            this._digest = new Digest(this.getAppDir(), this._strictComments);
            this.clearValidationMarkers();
            if (this._digest.validateResource(crsrc, null)) {
                this.init(true);
            } else {
                Log.log.warning("getdown.txt failed to validate even after redownloading. Blindly forging onward.", new Object[0]);
            }
        }
        this._targetVersion = this._version;
        if (this._version != -1L) {
            File vfile = this.getLocalPath(VERSION_FILE);
            long fileVersion = VersionUtil.readVersion(vfile);
            if (fileVersion != -1L) {
                this._targetVersion = fileVersion;
            }
            if (this._latest != null) {
                try (InputStream in = ConnectionUtil.open(this.proxy, this._latest, 0, 0).getInputStream();
                     InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
                     BufferedReader bin = new BufferedReader(reader);){
                    for (String[] pair : Config.parsePairs(bin, Config.createOpts(false))) {
                        if (!pair[0].equals("version")) continue;
                        this._targetVersion = Math.max(Long.parseLong(pair[1]), this._targetVersion);
                        if (fileVersion == -1L || this._targetVersion <= fileVersion) break;
                        try (FileOutputStream fos = new FileOutputStream(vfile);
                             PrintStream out = new PrintStream(fos);){
                            out.println(this._targetVersion);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    Log.log.warning("Unable to retrieve version from latest config file.", e);
                }
            }
        }
        if (this._version == this._targetVersion) return false;
        return true;
    }

    public void verifyResources(ProgressObserver obs, int[] alreadyValid, Set<Resource> unpacked, Set<Resource> toInstall, Set<Resource> toDownload) throws InterruptedException {
        ExecutorService exec = Executors.newFixedThreadPool(SysProps.threadPoolSize());
        final LinkedBlockingQueue actions = new LinkedBlockingQueue();
        final int[] completed = new int[1];
        long start = System.currentTimeMillis();
        List<Resource> rsrcs = this.getAllActiveResources();
        long[] sizes = new long[rsrcs.size()];
        long totalSize = 0L;
        for (int ii = 0; ii < sizes.length; ++ii) {
            sizes[ii] = rsrcs.get(ii).getLocal().length();
            totalSize += sizes[ii];
        }
        final ProgressObserver fobs = obs;
        final ProgressAggregator pagg = new ProgressAggregator(new ProgressObserver(){

            @Override
            public void progress(final int percent) {
                actions.add(new Runnable(){

                    @Override
                    public void run() {
                        fobs.progress(percent);
                    }
                });
            }
        }, sizes);
        final int[] fAlreadyValid = alreadyValid;
        final ConcurrentSkipListSet<Resource> toInstallAsync = new ConcurrentSkipListSet<Resource>(toInstall);
        final ConcurrentSkipListSet toDownloadAsync = new ConcurrentSkipListSet();
        final ConcurrentSkipListSet unpackedAsync = new ConcurrentSkipListSet();
        int ii = 0;
        while (ii < sizes.length) {
            final Resource rsrc = rsrcs.get(ii);
            final int index = ii++;
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    Application.this.verifyResource(rsrc, pagg.startElement(index), fAlreadyValid, unpackedAsync, toInstallAsync, toDownloadAsync);
                    actions.add(new Runnable(){

                        @Override
                        public void run() {
                            completed[0] = completed[0] + 1;
                        }
                    });
                }
            });
        }
        while (completed[0] < rsrcs.size()) {
            Runnable action = (Runnable)actions.poll(60L, TimeUnit.SECONDS);
            action.run();
        }
        exec.shutdown();
        toInstall.addAll(toInstallAsync);
        toDownload.addAll(toDownloadAsync);
        unpacked.addAll(unpackedAsync);
        long complete = System.currentTimeMillis();
        Log.log.info("Verified resources", "count", rsrcs.size(), "size", totalSize / 1024L + "k", "duration", complete - start + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyResource(Resource rsrc, ProgressObserver obs, int[] alreadyValid, Set<Resource> unpacked, Set<Resource> toInstall, Set<Resource> toDownload) {
        if (rsrc.isMarkedValid()) {
            if (alreadyValid != null) {
                alreadyValid[0] = alreadyValid[0] + 1;
            }
            obs.progress(100);
            return;
        }
        try {
            if (this._digest.validateResource(rsrc, obs)) {
                if (rsrc.getLocalNew().exists()) {
                    toInstall.add(rsrc);
                    return;
                }
                rsrc.applyAttrs();
                unpacked.add(rsrc);
                rsrc.markAsValid();
                return;
            }
        }
        catch (Exception e) {
            Log.log.info("Failure verifying resource. Requesting redownload...", "rsrc", rsrc, "error", e);
        }
        finally {
            obs.progress(100);
        }
        toDownload.add(rsrc);
    }

    public void unpackResources(ProgressObserver obs, Set<Resource> unpacked) throws InterruptedException {
        List<Resource> rsrcs = this.getActiveResources();
        Iterator<Resource> it = rsrcs.iterator();
        while (it.hasNext()) {
            Resource rsrc = it.next();
            if (rsrc.shouldUnpack() && !unpacked.contains(rsrc)) continue;
            it.remove();
        }
        long[] sizes = new long[rsrcs.size()];
        for (int ii = 0; ii < sizes.length; ++ii) {
            sizes[ii] = rsrcs.get(ii).getLocal().length();
        }
        ProgressAggregator pagg = new ProgressAggregator(obs, sizes);
        for (int ii = 0; ii < sizes.length; ++ii) {
            Resource rsrc = rsrcs.get(ii);
            ProgressObserver pobs = pagg.startElement(ii);
            try {
                rsrc.unpack();
            }
            catch (IOException ioe) {
                Log.log.warning("Failure unpacking resource", "rsrc", rsrc, ioe);
            }
            pobs.progress(100);
        }
    }

    public void clearValidationMarkers() {
        this.clearValidationMarkers(this.getAllActiveResources().iterator());
    }

    public long getVersion() {
        return this._version;
    }

    protected URL createVAppBase(long version) throws MalformedURLException {
        String url = version < 0L ? this._appbase : this._appbase.replace("%VERSION%", "" + version);
        return HostWhitelist.verify(new URL(url));
    }

    protected void clearValidationMarkers(Iterator<Resource> iter) {
        while (iter.hasNext()) {
            iter.next().clearMarker();
        }
    }

    protected void downloadConfigFile() throws IOException {
        this.downloadControlFile(CONFIG_FILE, 0);
    }

    public synchronized boolean lockForUpdates() {
        if (this._lock != null && this._lock.isValid()) {
            return true;
        }
        try {
            this._lockChannel = new RandomAccessFile(this.getLocalPath("gettingdown.lock"), "rw").getChannel();
        }
        catch (FileNotFoundException e) {
            Log.log.warning("Unable to create lock file", "message", e.getMessage(), e);
            return false;
        }
        try {
            this._lock = this._lockChannel.tryLock();
        }
        catch (IOException e) {
            Log.log.warning("Unable to create lock", "message", e.getMessage(), e);
            return false;
        }
        catch (OverlappingFileLockException e) {
            Log.log.warning("The lock is held elsewhere in this JVM", e);
            return false;
        }
        Log.log.info("Able to lock for updates: " + (this._lock != null), new Object[0]);
        return this._lock != null;
    }

    public synchronized void releaseLock() {
        if (this._lock != null) {
            Log.log.info("Releasing lock", new Object[0]);
            try {
                this._lock.release();
            }
            catch (IOException e) {
                Log.log.warning("Unable to release lock", "message", e.getMessage(), e);
            }
            try {
                this._lockChannel.close();
            }
            catch (IOException e) {
                Log.log.warning("Unable to close lock channel", "message", e.getMessage(), e);
            }
            this._lockChannel = null;
            this._lock = null;
        }
    }

    protected void downloadDigestFiles() throws IOException {
        for (int version = 1; version <= 2; ++version) {
            this.downloadControlFile(Digest.digestFile(version), version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadControlFile(String path, int sigVersion) throws IOException {
        File original;
        File target = this.downloadFile(path);
        if (sigVersion > 0) {
            if (this._envc.certs.isEmpty()) {
                Log.log.info("No signing certs, not verifying digest.txt", "path", path);
            } else {
                File signatureFile = this.downloadFile(path + SIGNATURE_SUFFIX);
                byte[] signature = null;
                try (FileInputStream signatureStream = new FileInputStream(signatureFile);){
                    signature = StreamUtil.toByteArray(signatureStream);
                }
                finally {
                    FileUtil.deleteHarder(signatureFile);
                }
                byte[] buffer = new byte[8192];
                int validated = 0;
                for (Certificate cert : this._envc.certs) {
                    try {
                        FileInputStream dataInput = new FileInputStream(target);
                        Throwable throwable = null;
                        try {
                            int length;
                            Signature sig = Signature.getInstance(Digest.sigAlgorithm(sigVersion));
                            sig.initVerify(cert);
                            while ((length = dataInput.read(buffer)) != -1) {
                                sig.update(buffer, 0, length);
                            }
                            if (!sig.verify(Base64.decode(signature, 0))) {
                                Log.log.info("Signature does not match", "cert", cert.getPublicKey());
                                continue;
                            }
                            Log.log.info("Signature matches", "cert", cert.getPublicKey());
                            ++validated;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (dataInput == null) continue;
                            if (throwable != null) {
                                try {
                                    dataInput.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            dataInput.close();
                        }
                    }
                    catch (IOException ioe) {
                        Log.log.warning("Failure validating signature of " + target + ": " + ioe, new Object[0]);
                    }
                    catch (GeneralSecurityException generalSecurityException) {}
                }
                if (validated == 0) {
                    FileUtil.deleteHarder(target);
                    throw new IOException("m.corrupt_digest_signature_error");
                }
            }
        }
        if (!FileUtil.renameTo(target, original = this.getLocalPath(path))) {
            throw new IOException("Failed to rename(" + target + ", " + original + ")");
        }
    }

    protected File downloadFile(String path) throws IOException {
        File target = this.getLocalPath(path + "_new");
        URL targetURL = null;
        try {
            targetURL = this.getRemoteURL(path);
        }
        catch (Exception e) {
            Log.log.warning("Requested to download invalid control file", "appbase", this._vappbase, "path", path, "error", e);
            throw (IOException)new IOException("Invalid path '" + path + "'.").initCause(e);
        }
        Log.log.info("Attempting to refetch '" + path + "' from '" + targetURL + "'.", new Object[0]);
        URLConnection uconn = ConnectionUtil.open(this.proxy, targetURL, 0, 0);
        uconn.setUseCaches(false);
        uconn.setRequestProperty("Accept-Encoding", "gzip");
        try (InputStream fin = uconn.getInputStream();){
            String encoding = uconn.getContentEncoding();
            boolean gzip = "gzip".equalsIgnoreCase(encoding);
            try (InputStream fin2 = gzip ? new GZIPInputStream(fin) : fin;
                 FileOutputStream fout = new FileOutputStream(target);){
                StreamUtil.copy(fin2, fout);
            }
        }
        return target;
    }

    protected Resource createResource(String path, EnumSet<Resource.Attr> attrs) throws MalformedURLException {
        return new Resource(path, this.getRemoteURL(path), this.getLocalPath(path), attrs);
    }

    protected static void addAll(String[] values, List<String> target) {
        if (values != null) {
            for (String value : values) {
                target.add(value);
            }
        }
    }

    public static List<Integer> intsToList(int[] values) {
        ArrayList<Integer> list = new ArrayList<Integer>(values.length);
        for (int val : values) {
            list.add(val);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<String> stringsToList(String[] values) {
        return values == null ? null : Collections.unmodifiableList(Arrays.asList(values));
    }

    protected void parseResources(Config config, String name, EnumSet<Resource.Attr> attrs, List<Resource> list) {
        String[] rsrcs = config.getMultiValue(name);
        if (rsrcs == null) {
            return;
        }
        for (String rsrc : rsrcs) {
            try {
                list.add(this.createResource(rsrc, attrs));
            }
            catch (Exception e) {
                Log.log.warning("Invalid resource '" + rsrc + "'. " + e, new Object[0]);
            }
        }
    }

    protected String getGATrackingCode() {
        if (this._trackingGAHash == null) {
            return "";
        }
        long time = System.currentTimeMillis() / 1000L;
        if (this._trackingStart == 0L) {
            this._trackingStart = time;
        }
        if (this._trackingId == 0) {
            int low = 100000000;
            int high = 1000000000;
            this._trackingId = low + this._rando.nextInt(high - low);
        }
        StringBuilder cookie = new StringBuilder("&utmcc=__utma%3D").append(this._trackingGAHash);
        cookie.append(".").append(this._trackingId);
        cookie.append(".").append(this._trackingStart).append(".").append(this._trackingStart);
        cookie.append(".").append(time).append(".1%3B%2B");
        cookie.append("__utmz%3D").append(this._trackingGAHash).append(".");
        cookie.append(this._trackingStart).append(".1.1.");
        cookie.append("utmcsr%3D(direct)%7Cutmccn%3D(direct)%7Cutmcmd%3D(none)%3B");
        int low = 1000000000;
        int high = 2000000000;
        cookie.append("&utmn=").append(this._rando.nextInt(high - low));
        return cookie.toString();
    }

    protected static String encodePath(String path) {
        try {
            return URLEncoder.encode(path, "UTF-8").replace("%2F", "/").replace("+", "%20");
        }
        catch (UnsupportedEncodingException ue) {
            Log.log.warning("Failed to URL encode " + path + ": " + ue, new Object[0]);
            return path;
        }
    }

    protected File getLocalPath(File appdir, String path) {
        return new File(appdir, path);
    }

    public static void setStartupFilesFromParameterString(String p) {
        String q = "\"";
        if (!StringUtil.isBlank(p)) {
            String locatorFilename;
            String[] filenames = p.startsWith(q) && p.endsWith(q) ? p.substring(q.length(), p.length() - q.length()).split(q + " " + q) : new String[]{p};
            String string = locatorFilename = filenames.length >= 1 ? filenames[0] : null;
            if (!StringUtil.isBlank(locatorFilename) && locatorFilename.toLowerCase().endsWith(".jvl")) {
                Application.setLocatorFile(locatorFilename);
                String[] otherFilenames = new String[filenames.length - 1];
                System.arraycopy(filenames, 1, otherFilenames, 0, otherFilenames.length);
                filenames = otherFilenames;
            }
            for (int i = 0; i < filenames.length; ++i) {
                String filename = filenames[i];
                if (filename.toLowerCase().endsWith(".jvl")) continue;
                Application.addStartupFile(filename);
            }
        }
    }

    public static void setLocatorFile(String filename) {
        _locatorFile = new File(filename);
    }

    public static void addStartupFile(String filename) {
        _startupFiles.add(new File(filename));
    }

    private Config createLocatorConfig(Config.ParseOpts opts) {
        if (_locatorFile == null) {
            return null;
        }
        Config locatorConfig = null;
        try {
            Config tmpConfig = null;
            HashMap<String, Object> tmpData = new HashMap<String, Object>();
            if (_locatorFile.exists()) {
                tmpConfig = Config.parseConfig(_locatorFile, opts);
                Map<String, Object> tmpConfigData = tmpConfig.getData();
                if (tmpConfig != null) {
                    for (Map.Entry<String, Object> entry : tmpConfigData.entrySet()) {
                        String mkey;
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        String string = mkey = key.indexOf(46) > -1 ? key.substring(key.indexOf(46) + 1) : key;
                        if (!Config.allowedReplaceKeys.contains(mkey) && !Config.allowedMergeKeys.contains(mkey)) continue;
                        tmpData.put(key, value);
                    }
                } else {
                    Log.log.warning("Error occurred reading config file", "file", _locatorFile);
                }
            } else {
                Log.log.warning("Given locator file does not exist", "file", _locatorFile);
            }
            locatorConfig = new Config(tmpData);
        }
        catch (Exception e) {
            Log.log.warning("Failure reading locator file", "file", _locatorFile, e);
        }
        return locatorConfig;
    }

    public String getAppbase() {
        return this._appbase;
    }

    static {
        _startupFiles = new ArrayList<File>();
    }

    public static class AuxGroup {
        public final String name;
        public final List<Resource> codes;
        public final List<Resource> rsrcs;

        public AuxGroup(String name, List<Resource> codes, List<Resource> rsrcs) {
            this.name = name;
            this.codes = Collections.unmodifiableList(codes);
            this.rsrcs = Collections.unmodifiableList(rsrcs);
        }
    }

    public static interface StatusDisplay {
        public void updateStatus(String var1);
    }

    public static final class UpdateInterface {
        public final String name;
        public final int background;
        public final List<String> rotatingBackgrounds;
        public final String errorBackground;
        public final List<String> iconImages;
        public final String instantBackgroundImage;
        public final String backgroundImage;
        public final String progressImage;
        public final Rectangle progress;
        public final int progressText;
        public final int progressBar;
        public final Rectangle status;
        public final int statusText;
        public final int textShadow;
        public final String installError;
        public final Rectangle patchNotes;
        public final String patchNotesUrl;
        public final boolean hideDecorations;
        public final boolean hideProgressText;
        public final boolean progressSync;
        public final boolean progressSyncAfterShown;
        public final boolean keepOnTop;
        public final boolean displayAppbase;
        public final boolean displayVersion;
        public final int minShowSeconds;
        public final Map<Step, List<Integer>> stepPercentages;

        public String toString() {
            return "[name=" + this.name + ", bg=" + this.background + ", bg=" + this.backgroundImage + ", instant_bg=" + this.instantBackgroundImage + ", pi=" + this.progressImage + ", prect=" + this.progress + ", pt=" + this.progressText + ", pb=" + this.progressBar + ", srect=" + this.status + ", st=" + this.statusText + ", shadow=" + this.textShadow + ", err=" + this.installError + ", nrect=" + this.patchNotes + ", notes=" + this.patchNotesUrl + ", stepPercentages=" + this.stepPercentages + ", hideProgressText=" + this.hideProgressText + ", keepOnTop=" + this.keepOnTop + ", progressSync=" + this.progressSync + ", progressSyncAfterShown=" + this.progressSyncAfterShown + ", minShow=" + this.minShowSeconds + ", displayAppbase=" + this.displayAppbase + ", displayVersion=" + this.displayVersion + "]";
        }

        public UpdateInterface(Config config) {
            this.name = config.getString("ui.name");
            this.progress = config.getRect("ui.progress", new Rectangle(5, 5, 300, 15));
            this.progressText = config.getColor("ui.progress_text", -16777216);
            this.hideProgressText = config.getBoolean("ui.hide_progress_text");
            this.progressSync = config.getBoolean("ui.progress_sync_before_shown");
            this.progressSyncAfterShown = config.getBoolean("ui.progress_sync_after_shown");
            this.keepOnTop = config.getBoolean("ui.keep_on_top");
            this.displayAppbase = config.getBoolean("ui.display_appbase");
            this.displayVersion = config.getBoolean("ui.display_version");
            this.minShowSeconds = config.getInt("ui.min_show_seconds", 5);
            this.progressBar = config.getColor("ui.progress_bar", 0x6699CC);
            this.status = config.getRect("ui.status", new Rectangle(5, 25, 500, 100));
            this.statusText = config.getColor("ui.status_text", -16777216);
            this.textShadow = config.getColor("ui.text_shadow", 0);
            this.hideDecorations = config.getBoolean("ui.hide_decorations");
            this.backgroundImage = config.getString("ui.background_image");
            this.instantBackgroundImage = config.getString("ui.instant_background_image");
            int defaultBackground = 0.5f < Color.brightness(this.progressText) ? -16777216 : -1;
            this.background = config.getColor("ui.background", defaultBackground);
            this.progressImage = config.getString("ui.progress_image");
            this.rotatingBackgrounds = Application.stringsToList(config.getMultiValue("ui.rotating_background"));
            this.iconImages = Application.stringsToList(config.getMultiValue("ui.icon"));
            this.errorBackground = config.getString("ui.error_background");
            String installError = config.getUrl("ui.install_error", null);
            this.installError = installError == null ? "m.default_install_error" : MessageUtil.taint(installError);
            this.patchNotes = config.getRect("ui.patch_notes", new Rectangle(5, 50, 112, 26));
            this.patchNotesUrl = config.getUrl("ui.patch_notes_url", null);
            EnumMap<Step, List<Integer>> stepPercentages = new EnumMap<Step, List<Integer>>(Step.class);
            for (Step step : Step.values()) {
                stepPercentages.put(step, step.defaultPercents);
            }
            for (Step step : Step.values()) {
                String spec = config.getString("ui.percents." + step.name());
                if (spec == null) continue;
                try {
                    stepPercentages.put(step, Application.intsToList(StringUtil.parseIntArray(spec)));
                }
                catch (Exception e) {
                    Log.log.warning("Failed to parse percentages for " + (Object)((Object)step) + ": " + spec, new Object[0]);
                }
            }
            this.stepPercentages = Collections.unmodifiableMap(stepPercentages);
        }

        public static enum Step {
            UPDATE_JAVA(20),
            VERIFY_METADATA(15, 45, 90),
            DOWNLOAD(60),
            PATCH(60),
            VERIFY_RESOURCES(40, 90),
            REDOWNLOAD_RESOURCES(80),
            UNPACK(95),
            LAUNCH(100);

            public final List<Integer> defaultPercents;

            private Step(int ... percents) {
                this.defaultPercents = Application.intsToList(percents);
            }
        }
    }
}

