/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2.jabaws2;

import compbio.data.msa.JABAService;
import compbio.ws.client.Services;
import jalview.ws.jws2.AAConClient;
import jalview.ws.jws2.RNAalifoldClient;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.util.HashMap;
import java.util.HashSet;

public class Jws2InstanceFactory {
    private static HashMap<String, AlignAnalysisUIText> aaConGUI;
    private static HashSet<String> ignoreGUI;

    private static String category_rewrite(String cat_name) {
        return cat_name != null && cat_name.equals("Prediction") ? "Secondary Structure Prediction" : cat_name;
    }

    private static void init() {
        if (aaConGUI == null) {
            aaConGUI = new HashMap();
            aaConGUI.put(Services.AAConWS.toString(), AAConClient.getAlignAnalysisUITest());
            aaConGUI.put(Services.RNAalifoldWS.toString(), RNAalifoldClient.getAlignAnalysisUITest());
            ignoreGUI = new HashSet();
        }
    }

    public static boolean ignoreService(String serviceType) {
        Jws2InstanceFactory.init();
        return ignoreGUI.contains(serviceType.toString());
    }

    public static Jws2Instance newJws2Instance(String jwsservers, String serviceType, String name, String description, JABAService service) {
        Jws2InstanceFactory.init();
        Jws2Instance svc = new Jws2Instance(jwsservers, serviceType, Jws2InstanceFactory.category_rewrite(name), description, service);
        svc.aaui = aaConGUI.get(serviceType.toString());
        return svc;
    }
}

