/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.util.MessageManager;
import jalview.ws.WSMenuEntryProviderI;
import jalview.ws.api.JalviewServiceEndpointProviderI;
import jalview.ws.api.MultipleSequenceAlignmentI;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.gui.MsaWSThread;
import jalview.ws.jws2.Jws2Client;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ToolTipManager;

public class MsaWSClient
extends Jws2Client
implements WSMenuEntryProviderI {
    MultipleSequenceAlignmentI server;

    public MsaWSClient(ServiceWithParameters sh, String altitle, AlignmentView msa, boolean submitGaps, boolean preserveOrder, AlignmentI seqdataset, AlignFrame _alignFrame) {
        this(sh, null, null, false, altitle, msa, submitGaps, preserveOrder, seqdataset, _alignFrame);
    }

    public MsaWSClient(ServiceWithParameters sh, WsParamSetI preset, String altitle, AlignmentView msa, boolean submitGaps, boolean preserveOrder, AlignmentI seqdataset, AlignFrame _alignFrame) {
        this(sh, preset, null, false, altitle, msa, submitGaps, preserveOrder, seqdataset, _alignFrame);
    }

    public MsaWSClient(ServiceWithParameters sh, WsParamSetI preset, List<ArgumentI> arguments, boolean editParams, String altitle, AlignmentView msa, boolean submitGaps, boolean preserveOrder, AlignmentI seqdataset, AlignFrame _alignFrame) {
        super(_alignFrame, preset, arguments);
        if (!this.processParams(sh, editParams)) {
            return;
        }
        if (!(sh instanceof JalviewServiceEndpointProviderI) || !(((JalviewServiceEndpointProviderI)((Object)sh)).getEndpoint() instanceof MultipleSequenceAlignmentI)) {
            JvOptionPane.showMessageDialog(Desktop.desktop, MessageManager.formatMessage("label.service_called_is_not_msa_service", new String[]{sh.getName()}), MessageManager.getString("label.internal_jalview_error"), 2);
            return;
        }
        this.serviceHandle = sh;
        this.server = (MultipleSequenceAlignmentI)((JalviewServiceEndpointProviderI)((Object)sh)).getEndpoint();
        this.wsInfo = this.setWebService(sh, false);
        if (this.wsInfo == null) {
            JvOptionPane.showMessageDialog(Desktop.desktop, MessageManager.formatMessage("label.msa_service_is_unknown", new String[]{sh.getName()}), MessageManager.getString("label.internal_jalview_error"), 2);
            return;
        }
        this.startMsaWSClient(altitle, msa, submitGaps, preserveOrder, seqdataset);
    }

    public MsaWSClient() {
    }

    private void startMsaWSClient(String altitle, AlignmentView msa, boolean submitGaps, boolean preserveOrder, AlignmentI seqdataset) {
        this.wsInfo.setProgressText((submitGaps ? "Re-alignment" : "Alignment") + " of " + altitle + "\nJob details\n");
        Object jobtitle = this.WebServiceName.toLowerCase();
        if (((String)jobtitle).endsWith("alignment")) {
            if (submitGaps && (!((String)jobtitle).endsWith("realignment") || ((String)jobtitle).indexOf("profile") == -1)) {
                int pos = ((String)jobtitle).indexOf("alignment");
                jobtitle = this.WebServiceName.substring(0, pos) + "re-alignment of " + altitle;
            } else {
                jobtitle = this.WebServiceName + " of " + altitle;
            }
        } else {
            jobtitle = this.WebServiceName + (submitGaps ? " re" : " ") + "alignment of " + altitle;
        }
        MsaWSThread msathread = new MsaWSThread(this.server, this.preset, this.paramset, this.WsURL, this.wsInfo, this.alignFrame, this.WebServiceName, (String)jobtitle, msa, submitGaps, preserveOrder, seqdataset);
        if (msathread.hasValidInput()) {
            this.wsInfo.setthisService(msathread);
            this.wsInfo.setVisible(true);
            msathread.start();
        } else {
            JvOptionPane.showMessageDialog(this.alignFrame, MessageManager.getString("info.invalid_msa_input_mininfo"), MessageManager.getString("info.invalid_msa_notenough"), 1);
            this.wsInfo.setVisible(false);
        }
    }

    public static void main(String[] args) {
        System.out.println("A".matches("(-*[a-zA-Z]-*){1}[a-zA-Z-]*"));
    }

    protected String getServiceActionKey() {
        return "MsaWS";
    }

    protected String getServiceActionDescription() {
        return "Multiple Sequence Alignment";
    }

    private boolean canSubmitGaps() {
        return this.WebServiceName.indexOf("lustal") > -1;
    }

    @Override
    public void attachWSMenuEntry(JMenu rmsawsmenu, ServiceWithParameters service, AlignFrame alignFrame) {
        if (MsaWSClient.registerAAConWSInstance(rmsawsmenu, service, alignFrame)) {
            return;
        }
        this.serviceHandle = service;
        this.setWebService(service, true);
        this.attachWSMenuEntry(rmsawsmenu, alignFrame);
    }

    @Override
    public void attachWSMenuEntry(JMenu wsmenu, final AlignFrame alignFrame) {
        boolean finished = true;
        boolean submitGaps = false;
        JMenu msawsmenu = wsmenu;
        JMenu rmsawsmenu = wsmenu;
        String svcname = this.WebServiceName;
        if (svcname.endsWith("WS")) {
            svcname = svcname.substring(0, svcname.length() - 2);
        }
        Object calcName = svcname + " ";
        if (this.canSubmitGaps()) {
            msawsmenu = new JMenu(svcname);
            rmsawsmenu.add(msawsmenu);
            calcName = "";
        }
        boolean hasparams = this.serviceHandle.hasParameters();
        final ServiceWithParameters service = (ServiceWithParameters)this.serviceHandle;
        do {
            String action = "Align ";
            if (submitGaps) {
                action = "Realign ";
                msawsmenu = new JMenu(MessageManager.formatMessage("label.realign_with_params", new String[]{svcname}));
                msawsmenu.setToolTipText(MessageManager.getString("label.align_sequences_to_existing_alignment"));
                rmsawsmenu.add(msawsmenu);
            }
            final boolean withGaps = submitGaps;
            JMenuItem method = new JMenuItem(MessageManager.formatMessage("label.calcname_with_default_settings", new String[]{calcName}));
            method.setToolTipText(MessageManager.formatMessage("label.action_with_default_settings", new String[]{action}));
            method.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlignmentView msa = alignFrame.gatherSequencesForAlignment();
                    if (msa != null) {
                        new MsaWSClient(service, alignFrame.getTitle(), msa, withGaps, true, alignFrame.getViewport().getAlignment().getDataset(), alignFrame);
                    }
                }
            });
            msawsmenu.add(method);
            if (hasparams) {
                method = new JMenuItem(MessageManager.getString("label.edit_settings_and_run"));
                method.setToolTipText(MessageManager.getString("label.view_and_change_parameters_before_alignment"));
                method.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AlignmentView msa = alignFrame.gatherSequencesForAlignment();
                        if (msa != null) {
                            new MsaWSClient(service, null, null, true, alignFrame.getTitle(), msa, withGaps, true, alignFrame.getViewport().getAlignment().getDataset(), alignFrame);
                        }
                    }
                });
                msawsmenu.add(method);
                List<WsParamSetI> presets = service.getParamStore().getPresets();
                if (presets != null && presets.size() > 0) {
                    JMenu presetlist = new JMenu(MessageManager.formatMessage("label.run_with_preset_params", new String[]{calcName}));
                    final int showToolTipFor = ToolTipManager.sharedInstance().getDismissDelay();
                    for (final WsParamSetI preset : presets) {
                        JMenuItem methodR = new JMenuItem(preset.getName());
                        int QUICK_TOOLTIP = 1500;
                        methodR.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseEntered(MouseEvent e) {
                                ToolTipManager.sharedInstance().setDismissDelay(1500);
                            }

                            @Override
                            public void mouseExited(MouseEvent e) {
                                ToolTipManager.sharedInstance().setDismissDelay(showToolTipFor);
                            }
                        });
                        String tooltip = JvSwingUtils.wrapTooltip(true, "<strong>" + (preset.isModifiable() ? MessageManager.getString("label.user_preset") : MessageManager.getString("label.service_preset")) + "</strong><br/>" + preset.getDescription());
                        methodR.setToolTipText(tooltip);
                        methodR.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                AlignmentView msa = alignFrame.gatherSequencesForAlignment();
                                if (msa != null) {
                                    MsaWSClient msaWSClient = new MsaWSClient(service, preset, alignFrame.getTitle(), msa, false, true, alignFrame.getViewport().getAlignment().getDataset(), alignFrame);
                                }
                            }
                        });
                        presetlist.add(methodR);
                    }
                    msawsmenu.add(presetlist);
                }
            }
            if (!submitGaps && this.canSubmitGaps()) {
                submitGaps = true;
                finished = false;
                continue;
            }
            finished = true;
        } while (!finished);
    }
}

