/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.ws.client.Services;
import compbio.ws.client.WSTester;
import jalview.bin.Cache;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.util.MessageManager;
import jalview.util.QuickSort;
import jalview.ws.WSMenuEntryProviderI;
import jalview.ws.api.UIinfo;
import jalview.ws.jws2.JabaWsServerQuery;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.ParamDatastoreI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class Jws2Discoverer
implements Runnable,
WSMenuEntryProviderI {
    public static final String COMPBIO_JABAWS = "http://www.compbio.dundee.ac.uk/jabaws";
    private static final String JWS2HOSTURLS = "JWS2HOSTURLS";
    private static Jws2Discoverer discoverer;
    private static List<String> testUrls;
    private String preferredUrl;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private Vector<String> invalidServiceUrls = null;
    private Vector<String> urlsWithoutServices = null;
    private Vector<String> validServiceUrls = null;
    private volatile boolean running = false;
    private volatile boolean aborted = false;
    private Thread oldthread = null;
    protected Vector<Jws2Instance> services;
    Map<String, Map<String, String>> preferredServiceMap = new HashMap<String, Map<String, String>>();

    private Jws2Discoverer() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    @Override
    public void run() {
        if (this.running && this.oldthread != null && this.oldthread.isAlive()) {
            if (!this.aborted) {
                return;
            }
            while (this.running) {
                try {
                    Cache.log.debug((Object)"Waiting around for old discovery thread to finish.");
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            this.aborted = false;
            Cache.log.debug((Object)"Old discovery thread has finished.");
        }
        this.running = true;
        HashSet<String> ignoredServices = new HashSet<String>();
        for (String string : Cache.getDefault("IGNORED_JABAWS_SERVICETYPES", "").split("\\|")) {
            ignoredServices.add(string);
        }
        this.changeSupport.firePropertyChange("services", this.services, new Vector());
        this.oldthread = Thread.currentThread();
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("compbio.ws.client.Jws2Client");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Not enabling JABA Webservices : client jar is not available.\nPlease check that your webstart JNLP file is up to date!");
            this.running = false;
            return;
        }
        if (this.services != null) {
            this.services.removeAllElements();
        }
        if (this.urlsWithoutServices != null) {
            this.urlsWithoutServices.removeAllElements();
        }
        if (this.invalidServiceUrls != null) {
            this.invalidServiceUrls.removeAllElements();
        }
        if (this.validServiceUrls != null) {
            this.validServiceUrls.removeAllElements();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<JabaWsServerQuery> qrys = new ArrayList<JabaWsServerQuery>();
        for (String string : this.getServiceUrls()) {
            JabaWsServerQuery squery = new JabaWsServerQuery(this, string);
            if (arrayList.size() == 0) {
                for (Services sv : squery.JABAWS2SERVERS) {
                    if (ignoredServices.contains(sv.toString())) continue;
                    arrayList.add(sv.toString());
                }
            }
            qrys.add(squery);
            new Thread(squery).start();
        }
        boolean finished = true;
        do {
            finished = true;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (JabaWsServerQuery squery : qrys) {
                if (!squery.isRunning()) continue;
                finished = false;
            }
            if (!this.aborted) continue;
            Cache.log.debug((Object)("Aborting " + qrys.size() + " JABAWS discovery threads."));
            for (JabaWsServerQuery squery : qrys) {
                squery.setQuit(true);
            }
        } while (!this.aborted && !finished);
        if (!this.aborted && this.services != null && this.services.size() > 0) {
            Object[] objectArray = new Jws2Instance[this.services.size()];
            int[] spos = new int[this.services.size()];
            int ipos = 0;
            List<String> svcUrls = this.getServiceUrls();
            for (Jws2Instance svc : this.services) {
                objectArray[ipos] = svc;
                spos[ipos++] = 1000 * svcUrls.indexOf(svc.getHostURL()) + 1 + arrayList.indexOf(svc.getName());
            }
            QuickSort.sort(spos, objectArray);
            this.services = new Vector();
            for (Object svc : objectArray) {
                if (ignoredServices.contains(((UIinfo)svc).getName())) continue;
                this.services.add((Jws2Instance)svc);
            }
        }
        this.oldthread = null;
        this.running = false;
        this.changeSupport.firePropertyChange("services", new Vector(), this.services);
    }

    synchronized void addService(String jwsservers, Jws2Instance service) {
        if (this.services == null) {
            this.services = new Vector();
        }
        System.out.println("Discovered service: " + jwsservers + " " + service.toString());
        this.services.add(service);
        ParamDatastoreI pds = service.getParamStore();
        if (pds != null) {
            pds.getPresets();
        }
        service.hasParameters();
        if (this.validServiceUrls == null) {
            this.validServiceUrls = new Vector();
        }
        this.validServiceUrls.add(jwsservers);
    }

    @Override
    public void attachWSMenuEntry(JMenu wsmenu, AlignFrame alignFrame) {
        this.populateWSMenuEntry(wsmenu, alignFrame, null);
    }

    private boolean isRecalculable(String action) {
        return action != null && action.equalsIgnoreCase("conservation");
    }

    private void populateWSMenuEntry(JMenu jws2al, final AlignFrame alignFrame, String typeFilter) {
        if (this.running || this.services == null || this.services.size() == 0) {
            return;
        }
        ArrayList<Jws2Instance> enumerableServices = new ArrayList<Jws2Instance>();
        HashMap<String, Jws2Instance> preferredHosts = new HashMap<String, Jws2Instance>();
        HashMap<String, ArrayList<Jws2Instance>> alternates = new HashMap<String, ArrayList<Jws2Instance>>();
        for (Jws2Instance service : this.services.toArray(new Jws2Instance[0])) {
            if (!this.isRecalculable(service.getName())) {
                enumerableServices.add(service);
                continue;
            }
            if (!preferredHosts.containsKey(service.getName())) {
                Jws2Instance preferredInstance = this.getPreferredServiceFor(alignFrame, service.getName());
                if (preferredInstance != null) {
                    preferredHosts.put(service.getName(), preferredInstance);
                } else {
                    preferredHosts.put(service.getName(), service);
                }
            }
            ArrayList<Jws2Instance> ph = (ArrayList<Jws2Instance>)alternates.get(service.getName());
            if (preferredHosts.get(service.getName()) == service) continue;
            if (ph == null) {
                ph = new ArrayList<Jws2Instance>();
            }
            ph.add(service);
            alternates.put(service.getName(), ph);
        }
        this.addEnumeratedServices(jws2al, alignFrame, enumerableServices);
        for (final Jws2Instance service : preferredHosts.values()) {
            JMenu atpoint = JvSwingUtils.findOrCreateMenu(jws2al, service.getServiceType());
            if (atpoint.getItemCount() > 1) {
                atpoint.addSeparator();
            }
            JMenuItem hitm = new JMenuItem(service.getHostURL());
            atpoint.add(hitm);
            hitm.setForeground(Color.blue);
            hitm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Desktop.showUrl(service.getHostURL());
                }
            });
            hitm.setToolTipText(JvSwingUtils.wrapTooltip(false, MessageManager.getString("label.open_jabaws_web_page")));
            service.attachWSMenuEntry(atpoint, alignFrame);
            if (!alternates.containsKey(service.getName())) continue;
            hitm = new JMenu(MessageManager.getString("label.switch_server"));
            atpoint.add(hitm);
            hitm.setToolTipText(JvSwingUtils.wrapTooltip(false, MessageManager.getString("label.choose_jabaws_server")));
            for (final Jws2Instance sv : (List)alternates.get(service.getName())) {
                JMenuItem itm = new JMenuItem(sv.getHostURL());
                hitm.add(itm);
                itm.setForeground(Color.blue);
                itm.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                Jws2Discoverer.this.setPreferredServiceFor(alignFrame, sv.getName(), sv.getServiceType(), sv);
                                Jws2Discoverer.this.changeSupport.firePropertyChange("services", new Vector(), Jws2Discoverer.this.services);
                            }
                        }).start();
                    }
                });
            }
        }
    }

    private void addEnumeratedServices(JMenu jws2al, AlignFrame alignFrame, List<Jws2Instance> enumerableServices) {
        boolean byhost = Cache.getDefault("WSMENU_BYHOST", false);
        boolean bytype = Cache.getDefault("WSMENU_BYTYPE", false);
        ArrayList<Object> hostLabels = new ArrayList<Object>();
        Hashtable<String, String> lasthostFor = new Hashtable<String, String>();
        Hashtable<String, ArrayList<Jws2Instance>> hosts = new Hashtable<String, ArrayList<Jws2Instance>>();
        ArrayList<String> hostlist = new ArrayList<String>();
        for (Jws2Instance service : enumerableServices) {
            ArrayList<Jws2Instance> hostservices = (ArrayList<Jws2Instance>)hosts.get(service.getHostURL());
            if (hostservices == null) {
                hostservices = new ArrayList<Jws2Instance>();
                hosts.put(service.getHostURL(), hostservices);
                hostlist.add(service.getHostURL());
            }
            hostservices.add(service);
        }
        for (String host : hostlist) {
            Object[] orderedsvcs = ((ArrayList)hosts.get(host)).toArray(new Jws2Instance[1]);
            String[] sortbytype = new String[orderedsvcs.length];
            for (int i = 0; i < sortbytype.length; ++i) {
                sortbytype[i] = ((UIinfo)orderedsvcs[i]).getName();
            }
            QuickSort.sort(sortbytype, orderedsvcs);
            for (Object service : orderedsvcs) {
                JMenu atpoint = JvSwingUtils.findOrCreateMenu(jws2al, ((UIinfo)service).getAction());
                String type = ((UIinfo)service).getName();
                if (byhost && (atpoint = JvSwingUtils.findOrCreateMenu(atpoint, host)).getToolTipText() == null) {
                    atpoint.setToolTipText(MessageManager.formatMessage("label.services_at", new String[]{host}));
                }
                if (bytype && (atpoint = JvSwingUtils.findOrCreateMenu(atpoint, type)).getToolTipText() == null) {
                    atpoint.setToolTipText(((UIinfo)service).getActionText());
                }
                if (!byhost && !hostLabels.contains(host + ((UIinfo)service).getName() + ((UIinfo)service).getActionText())) {
                    if (hostLabels.contains(host)) {
                        atpoint.addSeparator();
                    } else {
                        hostLabels.add(host);
                    }
                    if (lasthostFor.get(((UIinfo)service).getAction()) == null || !((String)lasthostFor.get(((UIinfo)service).getAction())).equals(host)) {
                        JMenuItem hitm = new JMenuItem(host);
                        atpoint.add(hitm);
                        hitm.setForeground(Color.blue);
                        hitm.addActionListener(new ActionListener((Jws2Instance)service){
                            final /* synthetic */ Jws2Instance val$service;
                            {
                                this.val$service = jws2Instance;
                            }

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Desktop.showUrl(this.val$service.getHostURL());
                            }
                        });
                        hitm.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.open_jabaws_web_page")));
                        lasthostFor.put(((UIinfo)service).getAction(), host);
                    }
                    hostLabels.add(host + ((UIinfo)service).getName() + ((UIinfo)service).getActionText());
                }
                ((Jws2Instance)service).attachWSMenuEntry(atpoint, alignFrame);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            testUrls = new ArrayList<String>();
            for (String url : args) {
                testUrls.add(url);
            }
        }
        Thread runner = Jws2Discoverer.getDiscoverer().startDiscoverer(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (Jws2Discoverer.getDiscoverer().services != null) {
                    System.out.println("Changesupport: There are now " + Jws2Discoverer.getDiscoverer().services.size() + " services");
                    int i = 1;
                    for (Jws2Instance instance : Jws2Discoverer.getDiscoverer().services) {
                        System.out.println("Service " + i++ + " " + instance.getClass() + "@" + instance.getHostURL() + ": " + instance.getActionText());
                    }
                }
            }
        });
        while (runner.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Jws2Discoverer getDiscoverer() {
        if (discoverer == null) {
            discoverer = new Jws2Discoverer();
        }
        return discoverer;
    }

    public boolean hasServices() {
        return !this.running && this.services != null && this.services.size() > 0;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setServiceUrls(List<String> wsUrls) {
        if (wsUrls != null && !wsUrls.isEmpty()) {
            StringBuilder urls = new StringBuilder(128);
            String sep = "";
            for (String url : wsUrls) {
                urls.append(sep);
                urls.append(url);
                sep = ",";
            }
            Cache.setProperty(JWS2HOSTURLS, urls.toString());
        } else {
            Cache.removeProperty(JWS2HOSTURLS);
        }
    }

    public List<String> getServiceUrls() {
        if (testUrls != null) {
            return testUrls;
        }
        ArrayList<String> urls = new ArrayList<String>();
        if (this.preferredUrl != null) {
            urls.add(this.preferredUrl);
        }
        String surls = Cache.getDefault(JWS2HOSTURLS, COMPBIO_JABAWS);
        try {
            StringTokenizer st = new StringTokenizer(surls, ",");
            while (st.hasMoreElements()) {
                String url = null;
                try {
                    url = st.nextToken();
                    new URL(url);
                    if (!urls.contains(url)) {
                        urls.add(url);
                        continue;
                    }
                    Cache.log.warn((Object)("Ignoring duplicate url " + url + " in JWS2HOSTURLS list"));
                }
                catch (MalformedURLException ex) {
                    Cache.log.warn((Object)("Problem whilst trying to make a URL from '" + (url != null ? url : "<null>") + "'"));
                    Cache.log.warn((Object)"This was probably due to a malformed comma separated list in the JWS2HOSTURLS entry of $(HOME)/.jalview_properties)");
                    Cache.log.debug((Object)"Exception was ", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            Cache.log.warn((Object)"Error parsing comma separated list of urls in JWS2HOSTURLS preference.", (Throwable)ex);
        }
        return urls;
    }

    public Vector<Jws2Instance> getServices() {
        return this.services == null ? new Vector<Jws2Instance>() : new Vector<Jws2Instance>(this.services);
    }

    public static boolean testServiceUrl(URL foo) {
        try {
            WSTester.main((String[])new String[]{"-h=" + foo.toString()});
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return false;
        }
        catch (Error e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restart() {
        Jws2Discoverer jws2Discoverer = this;
        synchronized (jws2Discoverer) {
            if (this.running) {
                this.aborted = true;
            } else {
                this.running = true;
            }
            return this.aborted;
        }
    }

    public Thread startDiscoverer(PropertyChangeListener changeSupport2) {
        if (this.isRunning()) {
            this.setAborted(true);
        }
        this.addPropertyChangeListener(changeSupport2);
        Thread thr = new Thread(this);
        thr.start();
        return thr;
    }

    public Vector<String> getInvalidServiceUrls() {
        return this.invalidServiceUrls;
    }

    public Vector<String> getUrlsWithoutServices() {
        return this.urlsWithoutServices;
    }

    public synchronized void addUrlwithnoservices(String jwsservers) {
        if (this.urlsWithoutServices == null) {
            this.urlsWithoutServices = new Vector();
        }
        if (!(this.invalidServiceUrls != null && this.invalidServiceUrls.contains(jwsservers) || this.urlsWithoutServices.contains(jwsservers))) {
            this.urlsWithoutServices.add(jwsservers);
        }
    }

    public synchronized void addInvalidServiceUrl(String jwsservers) {
        if (this.invalidServiceUrls == null) {
            this.invalidServiceUrls = new Vector();
        }
        if (!this.invalidServiceUrls.contains(jwsservers)) {
            this.invalidServiceUrls.add(jwsservers);
        }
    }

    public String getErrorMessages() {
        if (!this.isRunning() && !this.isAborted()) {
            StringBuffer ermsg = new StringBuffer();
            boolean list = false;
            if (this.getInvalidServiceUrls() != null && this.getInvalidServiceUrls().size() > 0) {
                ermsg.append(MessageManager.getString("warn.urls_not_contacted") + ": \n");
                for (String svcurl : this.getInvalidServiceUrls()) {
                    if (list) {
                        ermsg.append(", ");
                    }
                    list = true;
                    ermsg.append(svcurl);
                }
                ermsg.append("\n\n");
            }
            list = false;
            if (this.getUrlsWithoutServices() != null && this.getUrlsWithoutServices().size() > 0) {
                ermsg.append(MessageManager.getString("warn.urls_no_jaba") + ": \n");
                for (String svcurl : this.getUrlsWithoutServices()) {
                    if (list) {
                        ermsg.append(", ");
                    }
                    list = true;
                    ermsg.append(svcurl);
                }
                ermsg.append("\n");
            }
            if (ermsg.length() > 1) {
                return ermsg.toString();
            }
        }
        return null;
    }

    public int getServerStatusFor(String url) {
        if (this.validServiceUrls != null && this.validServiceUrls.contains(url)) {
            return 1;
        }
        if (this.urlsWithoutServices != null && this.urlsWithoutServices.contains(url)) {
            return 0;
        }
        if (this.invalidServiceUrls != null && this.invalidServiceUrls.contains(url)) {
            return -1;
        }
        return -2;
    }

    public Jws2Instance getPreferredServiceFor(String[] serviceURLs) {
        HashSet<String> urls = new HashSet<String>();
        urls.addAll(Arrays.asList(serviceURLs));
        Jws2Instance match = null;
        if (this.services != null) {
            for (Jws2Instance svc : this.services) {
                if (!urls.contains(svc.getNameURI())) continue;
                if (match == null) {
                    match = svc;
                }
                if (!urls.contains(svc.getUri())) continue;
                return svc;
            }
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Jws2Instance getPreferredServiceFor(AlignFrame af, String serviceName) {
        String serviceurl = null;
        Map<String, Map<String, String>> map = this.preferredServiceMap;
        synchronized (map) {
            String afid = af == null ? "" : af.getViewport().getSequenceSetId();
            Map<String, String> prefmap = this.preferredServiceMap.get(afid);
            if (afid.length() > 0 && prefmap == null) {
                prefmap = this.preferredServiceMap.get("");
            }
            if (prefmap != null) {
                serviceurl = prefmap.get(serviceName);
            }
        }
        Jws2Instance response = null;
        for (Jws2Instance svc : this.services) {
            if (!svc.getName().equals(serviceName) || serviceurl != null && !serviceurl.equals(svc.getHostURL())) continue;
            response = svc;
            break;
        }
        return response;
    }

    public void setPreferredServiceFor(AlignFrame af, String serviceName, String serviceAction, Jws2Instance selectedServer) {
        Map<String, String> prefmap;
        String afid;
        String string = afid = af == null ? "" : af.getViewport().getSequenceSetId();
        if (this.preferredServiceMap == null) {
            this.preferredServiceMap = new HashMap<String, Map<String, String>>();
        }
        if ((prefmap = this.preferredServiceMap.get(afid)) == null) {
            prefmap = new HashMap<String, String>();
            this.preferredServiceMap.put(afid, prefmap);
        }
        prefmap.put(serviceName, selectedServer.getHostURL());
        prefmap.put(serviceAction, selectedServer.getHostURL());
    }

    public void setPreferredServiceFor(String serviceType, String serviceAction, Jws2Instance selectedServer) {
        this.setPreferredServiceFor(null, serviceType, serviceAction, selectedServer);
    }

    public void setPreferredUrl(String value) throws MalformedURLException {
        if (value != null && value.trim().length() > 0) {
            new URL(value);
            this.preferredUrl = value;
        }
    }

    static {
        testUrls = null;
    }
}

