/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.data.msa.MsaWS;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Score;
import compbio.metadata.ChunkHolder;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.WrongParameterException;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.util.MessageManager;
import jalview.ws.jws2.AbstractJabaCalcWorker;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import java.util.Iterator;
import java.util.List;

public abstract class JabawsMsaInterfaceAlignCalcWorker
extends AbstractJabaCalcWorker {
    protected MsaWS msaservice;
    protected Alignment msascoreset;

    public JabawsMsaInterfaceAlignCalcWorker(AlignViewportI alignViewport, AlignmentViewPanel alignPanel) {
        super(alignViewport, alignPanel);
    }

    public JabawsMsaInterfaceAlignCalcWorker(Jws2Instance service, AlignFrame alignFrame, WsParamSetI preset, List<ArgumentI> paramset) {
        this(alignFrame.getCurrentView(), alignFrame.alignPanel);
        this.guiProgress = alignFrame;
        this.preset = preset;
        this.arguments = paramset;
        this.service = service;
        this.msaservice = (MsaWS)service.service;
    }

    @Override
    ChunkHolder pullExecStatistics(String rslt, long rpos) {
        return this.msaservice.pullExecStatistics(rslt, rpos);
    }

    @Override
    boolean collectAnnotationResultsFor(String rslt) throws ResultNotAvailableException {
        this.msascoreset = this.msaservice.getResult(rslt);
        return this.msascoreset != null;
    }

    @Override
    boolean cancelJob(String rslt) throws Exception {
        return this.msaservice.cancelJob(rslt);
    }

    @Override
    protected JobStatus getJobStatus(String rslt) throws Exception {
        return this.msaservice.getJobStatus(rslt);
    }

    @Override
    boolean hasService() {
        return this.msaservice != null;
    }

    @Override
    protected boolean isInteractiveUpdate() {
        return false;
    }

    @Override
    protected String submitToService(List<FastaSequence> seqs) throws JobSubmissionException {
        String rslt;
        if (this.preset == null && this.arguments == null) {
            rslt = this.msaservice.align(seqs);
        } else {
            try {
                rslt = this.msaservice.customAlign(seqs, this.getJabaArguments());
            }
            catch (WrongParameterException x) {
                throw new JobSubmissionException(MessageManager.getString("exception.jobsubmission_invalid_params_set"), (Throwable)x);
            }
        }
        return rslt;
    }

    protected void createAnnotationRowsForScores(List<AlignmentAnnotation> ourAnnot, String calcId, int alWidth, Score scr) {
        AlignmentAnnotation annotation = this.alignViewport.getAlignment().findOrCreateAnnotation(scr.getMethod(), calcId, true, null, null);
        if (alWidth == this.gapMap.length) {
            this.constructAnnotationFromScore(annotation, 0, alWidth, scr);
            ourAnnot.add(annotation);
        }
    }

    protected AlignmentAnnotation createAnnotationRowsForScores(List<AlignmentAnnotation> ourAnnot, String typeName, String calcId, SequenceI dseq, int base, Score scr) {
        System.out.println("Creating annotation on dseq:" + dseq.getStart() + " base is " + base + " and length=" + dseq.getLength() + " == " + scr.getScores().size());
        AlignmentAnnotation annotation = this.alignViewport.getAlignment().findOrCreateAnnotation(typeName, calcId, false, dseq, null);
        this.constructAnnotationFromScore(annotation, 0, dseq.getLength(), scr);
        annotation.createSequenceMapping(dseq, base, false);
        annotation.adjustForAlignment();
        dseq.addAlignmentAnnotation(annotation);
        ourAnnot.add(annotation);
        return annotation;
    }

    private void constructAnnotationFromScore(AlignmentAnnotation annotation, int base, int alWidth, Score scr) {
        Annotation[] elm = new Annotation[alWidth];
        Iterator vals = scr.getScores().iterator();
        float m = 0.0f;
        float x = 0.0f;
        int i = 0;
        while (vals.hasNext()) {
            float val = ((Float)vals.next()).floatValue();
            if (i == 0) {
                m = val;
                x = val;
            } else {
                if (m > val) {
                    m = val;
                }
                if (x < val) {
                    x = val;
                }
            }
            if (this.gapMap != null && this.gapMap.length > 0) {
                while (!this.gapMap[i]) {
                    elm[i++] = new Annotation("", "", ' ', Float.NaN);
                }
            }
            elm[i] = new Annotation("", "" + val, ' ', val);
            ++i;
        }
        annotation.annotations = elm;
        annotation.belowAlignment = true;
        if (x < 0.0f) {
            x = 0.0f;
        }
        annotation.graphMax = x = (float)((double)x + (double)(x - m) * 0.1);
        annotation.graphMin = m;
        annotation.validateRangeAndDisplay();
    }
}

