/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.metadata.Option;
import compbio.metadata.Parameter;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import jalview.gui.WsJobParameters;
import jalview.util.MessageManager;
import jalview.ws.jws2.JabaPreset;
import jalview.ws.jws2.Jws2Discoverer;
import jalview.ws.jws2.ParameterUtils;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JabaWsParamTest {
    public static void main(String[] args) {
        Jws2Discoverer disc = Jws2Discoverer.getDiscoverer();
        int p = 0;
        if (args.length > 0) {
            Vector<String> services = new Vector<String>();
            services.addElement(args[p++]);
            Jws2Discoverer.getDiscoverer().setServiceUrls(services);
        }
        try {
            disc.run();
        }
        catch (Exception e) {
            System.err.println("Aborting. Problem discovering services.");
            e.printStackTrace();
            return;
        }
        Jws2Instance lastserv = null;
        Iterator<Jws2Instance> iterator = disc.getServices().iterator();
        while (iterator.hasNext()) {
            Iterator en;
            PresetManager prman;
            Jws2Instance service;
            lastserv = service = iterator.next();
            if (p < args.length && !service.getName().equalsIgnoreCase(args[p]) || lastserv == null) continue;
            List prl = null;
            Preset pr = null;
            if (++p < args.length) {
                prman = lastserv.getPresets();
                if (prman != null && (pr = prman.getPresetByName(args[p])) == null) {
                    prl = prman.getPresets();
                }
            } else {
                prman = lastserv.getPresets();
                if (prman != null) {
                    prl = prman.getPresets();
                }
            }
            Iterator iterator2 = en = prl == null ? null : prl.iterator();
            while (en != null && en.hasNext()) {
                if (en != null) {
                    if (!en.hasNext()) {
                        en = prl.iterator();
                    }
                    pr = (Preset)en.next();
                }
                System.out.println("Testing opts dupes for " + lastserv.getUri() + " : " + lastserv.getActionText() + ":" + pr.getName());
                List rg = lastserv.getRunnerConfig().getOptions();
                for (Option o : rg) {
                    try {
                        Option option = ParameterUtils.copyOption(o);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to copy " + o.getName());
                        e.printStackTrace();
                    }
                    catch (Error e) {
                        System.err.println("Failed to copy " + o.getName());
                        e.printStackTrace();
                    }
                }
                System.out.println("Testing param dupes:");
                rg = lastserv.getRunnerConfig().getParameters();
                for (Option o : rg) {
                    try {
                        Parameter e = ParameterUtils.copyParameter((Parameter)o);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to copy " + o.getName());
                        e.printStackTrace();
                    }
                    catch (Error e) {
                        System.err.println("Failed to copy " + o.getName());
                        e.printStackTrace();
                    }
                }
                System.out.println("Testing param write:");
                List<String> writeparam = null;
                List<String> readparam = null;
                try {
                    writeparam = ParameterUtils.writeParameterSet(pr.getArguments(lastserv.getRunnerConfig()), " ");
                    System.out.println("Testing param read :");
                    List<Option> pset = ParameterUtils.processParameters(writeparam, lastserv.getRunnerConfig(), " ");
                    readparam = ParameterUtils.writeParameterSet(pset, " ");
                    Iterator o = pr.getOptions().iterator();
                    Iterator<String> s = writeparam.iterator();
                    Iterator<String> t = readparam.iterator();
                    boolean failed = false;
                    while (s.hasNext() && t.hasNext()) {
                        String st;
                        String on = (String)o.next();
                        String sn = s.next();
                        if (sn.equals(st = t.next())) continue;
                        System.out.println("Original was " + on + " Phase 1 wrote " + sn + "\tPhase 2 wrote " + st);
                        failed = true;
                    }
                    if (failed) {
                        System.out.println("Original parameters:\n" + pr.getOptions());
                        System.out.println("Wrote parameters in first set:\n" + writeparam);
                        System.out.println("Wrote parameters in second set:\n" + readparam);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                WsJobParameters pgui = new WsJobParameters(null, lastserv, new JabaPreset(lastserv, pr), null);
                JFrame jf = new JFrame(MessageManager.formatMessage("label.ws_parameters_for", new String[]{lastserv.getActionText()}));
                JPanel cont = new JPanel(new BorderLayout());
                pgui.validate();
                cont.setPreferredSize(pgui.getPreferredSize());
                cont.add((Component)pgui, "Center");
                jf.setLayout(new BorderLayout());
                jf.add((Component)cont, "Center");
                jf.validate();
                final Thread thr = Thread.currentThread();
                jf.addWindowListener(new WindowListener(){

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        thr.interrupt();
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }
                });
                jf.setVisible(true);
                boolean inter = false;
                while (!inter) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                        inter = true;
                    }
                }
                jf.dispose();
            }
        }
    }
}

