/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.data.sequence.FastaSequence;
import compbio.metadata.ChunkHolder;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Option;
import compbio.metadata.ResultNotAvailableException;
import jalview.analysis.AlignSeq;
import jalview.analysis.SeqsetUtils;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import jalview.workers.AlignCalcWorker;
import jalview.ws.jws2.JabaParamStore;
import jalview.ws.jws2.dm.AAConSettings;
import jalview.ws.jws2.dm.JabaWsParamSet;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractJabaCalcWorker
extends AlignCalcWorker {
    protected Jws2Instance service;
    protected WsParamSetI preset;
    protected List<ArgumentI> arguments;
    protected IProgressIndicator guiProgress;
    protected boolean submitGaps = true;
    protected boolean filterNonStandardResidues = true;
    protected boolean alignedSeqs = true;
    protected boolean nucleotidesAllowed = false;
    protected boolean proteinAllowed = false;
    protected boolean bySequence = false;
    protected Map<String, SequenceI> seqNames;
    protected boolean[] gapMap;
    int realw;
    protected int start;
    int end;
    volatile String rslt = "JOB NOT DEFINED";

    protected void initViewportParams() {
        if (this.getCalcId() != null) {
            ((AlignViewport)this.alignViewport).setCalcIdSettingsFor(this.getCalcId(), new AAConSettings(true, this.service, this.preset, this.arguments), true);
        }
    }

    public abstract String getCalcId();

    public WsParamSetI getPreset() {
        return this.preset;
    }

    public List<ArgumentI> getArguments() {
        return this.arguments;
    }

    public void updateParameters(WsParamSetI newpreset, List<ArgumentI> newarguments) {
        this.preset = newpreset;
        this.arguments = newarguments;
        this.calcMan.startWorker(this);
        this.initViewportParams();
    }

    public List<Option> getJabaArguments() {
        ArrayList<Option> newargs = new ArrayList<Option>();
        if (this.preset != null && this.preset instanceof JabaWsParamSet) {
            newargs.addAll(((JabaWsParamSet)this.preset).getjabaArguments());
        }
        if (this.arguments != null && this.arguments.size() > 0) {
            for (Object rg : JabaParamStore.getJabafromJwsArgs(this.arguments)) {
                if (!Option.class.isAssignableFrom(rg.getClass())) continue;
                newargs.add((Option)rg);
            }
        }
        return newargs;
    }

    public AbstractJabaCalcWorker(AlignViewportI alignViewport, AlignmentViewPanel alignPanel) {
        super(alignViewport, alignPanel);
    }

    public AbstractJabaCalcWorker(Jws2Instance service, AlignFrame alignFrame, WsParamSetI preset, List<ArgumentI> paramset) {
        this(alignFrame.getCurrentView(), alignFrame.alignPanel);
        this.guiProgress = alignFrame;
        this.preset = preset;
        this.arguments = paramset;
        this.service = service;
    }

    abstract boolean hasService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block42: {
            if (!this.hasService()) {
                return;
            }
            long progressId = -1L;
            int serverErrorsLeft = 3;
            StringBuffer msg = new StringBuffer();
            try {
                if (this.checkDone()) {
                    return;
                }
                List<FastaSequence> seqs = this.getInputSequences(this.alignViewport.getAlignment(), this.bySequence ? this.alignViewport.getSelectionGroup() : null);
                if (seqs == null || !this.checkValidInputSeqs(true, seqs)) {
                    this.calcMan.workerComplete(this);
                    return;
                }
                AlignmentAnnotation[] aa = this.alignViewport.getAlignment().getAlignmentAnnotation();
                if (this.guiProgress != null) {
                    progressId = System.currentTimeMillis();
                    this.guiProgress.setProgressBar("JABA " + this.getServiceActionText(), progressId);
                }
                this.rslt = this.submitToService(seqs);
                if (this.guiProgress != null) {
                    this.guiProgress.registerHandler(progressId, new IProgressIndicatorHandler(){

                        @Override
                        public boolean cancelActivity(long id) {
                            AbstractJabaCalcWorker.this.cancelCurrentJob();
                            return true;
                        }

                        @Override
                        public boolean canCancel() {
                            return true;
                        }
                    });
                }
                boolean finished = false;
                long rpos = 0L;
                do {
                    long cpos;
                    JobStatus status;
                    if ((status = this.getJobStatus(this.rslt)).equals((Object)JobStatus.FINISHED)) {
                        finished = true;
                    }
                    if (this.calcMan.isPending(this) && this.isInteractiveUpdate()) {
                        finished = true;
                        try {
                            if (this.cancelJob(this.rslt)) {
                                System.err.println("Cancelled AACon job: " + this.rslt);
                            } else {
                                System.err.println("FAILED TO CANCEL AACon job: " + this.rslt);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.rslt = "CANCELLED JOB";
                        return;
                    }
                    ChunkHolder stats = null;
                    do {
                        cpos = rpos;
                        boolean retry = false;
                        do {
                            try {
                                stats = this.pullExecStatistics(this.rslt, rpos);
                            }
                            catch (Exception x) {
                                if (x.getMessage().contains("Position in a file could not be negative!")) {
                                    stats = null;
                                    continue;
                                }
                                if (--serverErrorsLeft > 0) {
                                    retry = true;
                                    try {
                                        Thread.sleep(200L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    continue;
                                }
                                throw x;
                            }
                        } while (retry);
                        if (stats == null) continue;
                        System.out.print(stats.getChunk());
                        msg.append(stats);
                        rpos = stats.getNextPosition();
                    } while (stats != null && rpos > cpos);
                    if (finished || !status.equals((Object)JobStatus.FAILED)) continue;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!finished);
                if (serverErrorsLeft <= 0) break block42;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.collectAnnotationResultsFor(this.rslt)) {
                    Cache.log.debug((Object)("Updating result annotation from Job " + this.rslt + " at " + this.service.getUri()));
                    this.updateResultAnnotation(true);
                    this.ap.adjustAnnotationHeight();
                }
            }
            catch (JobSubmissionException x) {
                System.err.println("submission error with " + this.getServiceActionText() + " :");
                x.printStackTrace();
                this.calcMan.disableWorker(this);
            }
            catch (ResultNotAvailableException x) {
                System.err.println("collection error:\nJob ID: " + this.rslt);
                x.printStackTrace();
                this.calcMan.disableWorker(this);
            }
            catch (OutOfMemoryError error) {
                this.calcMan.disableWorker(this);
                this.ap.raiseOOMWarning(this.getServiceActionText(), error);
            }
            catch (Exception x) {
                this.calcMan.disableWorker(this);
                System.err.println("Blacklisting worker due to unexpected exception:");
                x.printStackTrace();
            }
            finally {
                this.calcMan.workerComplete(this);
                if (this.ap != null) {
                    this.calcMan.workerComplete(this);
                    if (this.guiProgress != null && progressId != -1L) {
                        this.guiProgress.setProgressBar("", progressId);
                    }
                    this.ap.paintAlignment(false, false);
                }
                if (msg.length() > 0) {
                    // empty if block
                }
            }
        }
    }

    abstract boolean checkValidInputSeqs(boolean var1, List<FastaSequence> var2);

    abstract String submitToService(List<FastaSequence> var1) throws JobSubmissionException;

    abstract boolean cancelJob(String var1) throws Exception;

    abstract JobStatus getJobStatus(String var1) throws Exception;

    abstract ChunkHolder pullExecStatistics(String var1, long var2);

    abstract boolean collectAnnotationResultsFor(String var1) throws ResultNotAvailableException;

    public void cancelCurrentJob() {
        try {
            String id = this.rslt;
            if (this.cancelJob(this.rslt)) {
                System.err.println("Cancelled job " + id);
            } else {
                System.err.println("Job " + id + " couldn't be cancelled.");
            }
        }
        catch (Exception q) {
            q.printStackTrace();
        }
    }

    abstract boolean isInteractiveUpdate();

    public List<FastaSequence> getInputSequences(AlignmentI alignment, AnnotatedCollectionI inputSeqs) {
        if (alignment == null || alignment.getWidth() <= 0 || alignment.getSequences() == null || alignment.isNucleotide() ? !this.nucleotidesAllowed : !this.proteinAllowed) {
            return null;
        }
        if (inputSeqs == null || inputSeqs.getWidth() <= 0 || inputSeqs.getSequences() == null || inputSeqs.getSequences().size() < 1) {
            inputSeqs = alignment;
        }
        ArrayList<FastaSequence> seqs = new ArrayList<FastaSequence>();
        int minlen = 10;
        int ln = -1;
        if (this.bySequence) {
            this.seqNames = new HashMap<String, SequenceI>();
        }
        this.gapMap = new boolean[0];
        this.start = inputSeqs.getStartRes();
        this.end = inputSeqs.getEndRes();
        for (SequenceI sq : inputSeqs.getSequences()) {
            FastaSequence seq;
            if (!(this.bySequence ? sq.findPosition(this.end + 1) - sq.findPosition(this.start + 1) > minlen - 1 : sq.getEnd() - sq.getStart() > minlen - 1)) continue;
            String newname = SeqsetUtils.unique_name(seqs.size() + 1);
            if (this.seqNames != null) {
                this.seqNames.put(newname, sq);
            }
            if (this.submitGaps) {
                int p;
                seq = new FastaSequence(newname, sq.getSequenceAsString());
                seqs.add(seq);
                if (this.gapMap == null || this.gapMap.length < seq.getSequence().length()) {
                    boolean[] blArray = this.gapMap;
                    this.gapMap = new boolean[seq.getLength()];
                    System.arraycopy(blArray, 0, this.gapMap, 0, blArray.length);
                    for (p = blArray.length; p < this.gapMap.length; ++p) {
                        this.gapMap[p] = false;
                    }
                }
                int[] nArray = sq.gapMap();
                p = nArray.length;
                for (int i = 0; i < p; ++i) {
                    int n = nArray[i];
                    char sqc = sq.getCharAt(n);
                    if (this.filterNonStandardResidues && !(sq.isProtein() ? ResidueProperties.aaIndex[sqc] < 20 : ResidueProperties.nucleotideIndex[sqc] < 5)) continue;
                    this.gapMap[n] = true;
                }
            } else {
                seq = new FastaSequence(newname, AlignSeq.extractGaps(Comparison.GapChars, sq.getSequenceAsString(this.start, this.end + 1)));
                seqs.add(seq);
            }
            if (seq.getSequence().length() <= ln) continue;
            ln = seq.getSequence().length();
        }
        if (this.alignedSeqs && this.submitGaps) {
            this.realw = 0;
            for (int i = 0; i < this.gapMap.length; ++i) {
                if (!this.gapMap[i]) continue;
                ++this.realw;
            }
            for (int p = 0; p < seqs.size(); ++p) {
                SequenceI sq;
                sq = (FastaSequence)seqs.get(p);
                int l = sq.getSequence().length();
                char[] padded = new char[this.realw];
                char[] cArray = sq.getSequence().toCharArray();
                int i = 0;
                int pp = 0;
                while (i < this.realw) {
                    if (this.gapMap[pp]) {
                        padded[i++] = cArray.length > pp ? cArray[pp] : 45;
                    }
                    ++pp;
                }
                seqs.set(p, new FastaSequence(sq.getId(), new String(padded)));
            }
        }
        return seqs;
    }

    @Override
    public void updateAnnotation() {
        this.updateResultAnnotation(false);
    }

    public abstract void updateResultAnnotation(boolean var1);

    public abstract String getServiceActionText();

    protected boolean checkDone() {
        this.calcMan.notifyStart(this);
        this.ap.paintAlignment(false, false);
        while (!this.calcMan.notifyWorking(this)) {
            if (this.calcMan.isWorking(this)) {
                return true;
            }
            try {
                if (this.ap != null) {
                    this.ap.paintAlignment(false, false);
                }
                Thread.sleep(200L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.alignViewport.isClosed()) {
            this.abortAndDestroy();
            return true;
        }
        return false;
    }

    protected void updateOurAnnots(List<AlignmentAnnotation> ourAnnot) {
        List our = this.ourAnnots;
        this.ourAnnots = ourAnnot;
        AlignmentI alignment = this.alignViewport.getAlignment();
        if (our != null) {
            if (our.size() > 0) {
                for (AlignmentAnnotation an : our) {
                    if (this.ourAnnots.contains(an)) continue;
                    alignment.deleteAnnotation(an);
                }
            }
            our.clear();
            this.ap.adjustAnnotationHeight();
        }
    }
}

