/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.gui;

import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.SplitFrame;
import jalview.gui.WebserviceInfo;
import jalview.util.MessageManager;
import jalview.ws.AWSThread;
import jalview.ws.AWsJob;
import jalview.ws.JobStateSummary;
import jalview.ws.WSClientI;
import jalview.ws.api.CancellableI;
import jalview.ws.api.JobId;
import jalview.ws.api.MultipleSequenceAlignmentI;
import jalview.ws.gui.MsaWSJob;
import jalview.ws.gui.WsJob;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

public class MsaWSThread
extends AWSThread
implements WSClientI {
    boolean submitGaps = false;
    boolean preserveOrder = true;
    String alTitle;
    AlignmentI dataset;
    MultipleSequenceAlignmentI server = null;
    boolean validInput = false;

    private MsaWSThread(MultipleSequenceAlignmentI server, String wsUrl, WebserviceInfo wsinfo, AlignFrame alFrame, AlignmentView alview, String wsname, boolean subgaps, boolean presorder) {
        super(alFrame, wsinfo, alview, wsname, wsUrl);
        this.server = server;
        this.submitGaps = subgaps;
        this.preserveOrder = presorder;
    }

    public MsaWSThread(MultipleSequenceAlignmentI server2, WsParamSetI preset, List<ArgumentI> paramset, String wsUrl, WebserviceInfo wsinfo, AlignFrame alFrame, String wsname, String title, AlignmentView _msa, boolean subgaps, boolean presorder, AlignmentI seqset) {
        this(server2, wsUrl, wsinfo, alFrame, _msa, wsname, subgaps, presorder);
        this.OutputHeader = this.wsInfo.getProgressText();
        this.alTitle = title;
        this.dataset = seqset;
        SequenceI[][] conmsa = _msa.getVisibleContigs('-');
        if (conmsa != null) {
            int nvalid = 0;
            int njobs = conmsa.length;
            this.jobs = new AWsJob[njobs];
            for (int j = 0; j < njobs; ++j) {
                this.jobs[j] = j != 0 ? new MsaWSJob(this, wsinfo.addJobPane(), conmsa[j]) : new MsaWSJob(this, 0, conmsa[j]);
                if (this.jobs[j].hasValidInput()) {
                    ++nvalid;
                }
                this.jobs[j].setPreset(preset);
                this.jobs[j].setArguments(paramset);
                ((MsaWSJob)this.jobs[j]).alignmentProgram = wsname;
                if (njobs > 0) {
                    wsinfo.setProgressName("region " + this.jobs[j].getJobnum(), this.jobs[j].getJobnum());
                }
                wsinfo.setProgressText(this.jobs[j].getJobnum(), this.OutputHeader);
            }
            this.validInput = nvalid > 0;
        }
    }

    public boolean hasValidInput() {
        return this.validInput;
    }

    @Override
    public boolean isCancellable() {
        return this.server instanceof CancellableI;
    }

    @Override
    public void cancelJob() {
        if (!this.jobComplete && this.jobs != null) {
            boolean cancelled = true;
            for (int job = 0; job < this.jobs.length; ++job) {
                if (this.jobs[job].isSubmitted() && !this.jobs[job].isSubjobComplete()) {
                    Object cancelledMessage = "";
                    try {
                        CancellableI service = (CancellableI)((Object)this.server);
                        boolean cancelledJob = service.cancel((WsJob)this.jobs[job]);
                        if (cancelledJob) {
                            cancelledMessage = "Job cancelled.";
                            ((MsaWSJob)this.jobs[job]).cancel();
                            this.wsInfo.setStatus(this.jobs[job].getJobnum(), 3);
                        } else {
                            cancelledMessage = (String)cancelledMessage + "Server cannot cancel this job. just close the window.\n";
                            cancelled = false;
                        }
                    }
                    catch (Exception exc) {
                        cancelledMessage = (String)cancelledMessage + "\nProblems cancelling the job : Exception received...\n" + exc + "\n";
                        Cache.log.warn((Object)("Exception whilst cancelling " + this.jobs[job].getJobId()), (Throwable)exc);
                    }
                    this.wsInfo.setProgressText(this.jobs[job].getJobnum(), this.OutputHeader + (String)cancelledMessage + "\n");
                    continue;
                }
                this.jobs[job].setSubjobComplete(true);
                this.wsInfo.setStatus(this.jobs[job].getJobnum(), 3);
            }
            if (cancelled) {
                this.wsInfo.setStatus(3);
                this.jobComplete = true;
            }
            this.interrupt();
        } else if (!this.jobComplete) {
            this.wsInfo.setProgressText(this.OutputHeader + "Server cannot cancel this job because it has not been submitted properly. just close the window.\n");
        }
    }

    @Override
    public void pollJob(AWsJob job) throws Exception {
        MsaWSJob j = (MsaWSJob)job;
        this.server.updateStatus(j);
        this.server.updateJobProgress(j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void StartJob(AWsJob job) {
        Object lex = null;
        if (!(job instanceof MsaWSJob)) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_msawbjob_called", new String[]{job.getClass().toString()}));
        }
        MsaWSJob j = (MsaWSJob)job;
        if (j.isSubmitted()) {
            if (Cache.log.isDebugEnabled()) {
                Cache.log.debug((Object)("Tried to submit an already submitted job " + j.getJobId()));
            }
            return;
        }
        if (j.seqs == null || j.seqs.size() == 0) {
            j.setState(WsJob.JobState.FINISHED);
            j.setStatus(MessageManager.getString("label.empty_alignment_job"));
        }
        try {
            block18: {
                j.addInitialStatus();
                try {
                    JobId jobHandle = this.server.align(j.seqs, j.getPreset(), j.getArguments());
                    if (jobHandle != null) {
                        j.setJobHandle(jobHandle);
                    }
                }
                catch (Throwable throwable) {
                    if (this.server.handleSubmitError(throwable, j, this.wsInfo)) break block18;
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    if (!(throwable instanceof Error)) break block18;
                    throw (Error)throwable;
                }
            }
            if (j.getJobId() != null) {
                j.setSubmitted(true);
                j.setSubjobComplete(false);
                return;
            }
            try {
                throw new Exception(MessageManager.formatMessage("exception.web_service_returned_null_try_later", new String[]{this.WsUrl}));
            }
            catch (Error e) {
                System.err.println(this.WebServiceName + "Client: Failed to submit the sequences for alignment (probably a server side problem)\nWhen contacting Server:" + this.WsUrl + "\n");
                e.printStackTrace(System.err);
                this.wsInfo.setStatus(5);
                this.wsInfo.setStatus(j.getJobnum(), 5);
            }
            catch (Exception e) {
                System.err.println(this.WebServiceName + "Client: Failed to submit the sequences for alignment (probably a server side problem)\nWhen contacting Server:" + this.WsUrl + "\n");
                e.printStackTrace(System.err);
                this.wsInfo.setStatus(5);
                this.wsInfo.setStatus(j.getJobnum(), 5);
            }
        }
        finally {
            if (!j.isSubmitted()) {
                j.setAllowedServerExceptions(0);
                this.wsInfo.appendProgressText(j.getJobnum(), MessageManager.getString("info.failed_to_submit_sequences_for_alignment"));
            }
        }
    }

    @Override
    public void parseResult() {
        long progbar = System.currentTimeMillis();
        this.wsInfo.setProgressBar(MessageManager.getString("status.collecting_job_results"), progbar);
        int results = 0;
        JobStateSummary finalState = new JobStateSummary();
        try {
            for (int j = 0; j < this.jobs.length; ++j) {
                block15: {
                    MsaWSJob msjob = (MsaWSJob)this.jobs[j];
                    if (this.jobs[j].isFinished() && msjob.alignment == null) {
                        int nunchanged = 3;
                        int nexcept = 3;
                        boolean jpchanged = false;
                        boolean jpex = false;
                        do {
                            try {
                                jpchanged = this.server.updateJobProgress(msjob);
                                jpex = false;
                                if (jpchanged) {
                                    nexcept = 3;
                                }
                            }
                            catch (Exception e) {
                                Cache.log.warn((Object)("Exception when retrieving remaining Job progress data for job " + msjob.getJobId() + " on server " + this.WsUrl));
                                e.printStackTrace();
                                --nexcept;
                                nunchanged = 3;
                                jpex = true;
                                jpchanged = false;
                            }
                            if (jpchanged) continue;
                            try {
                                Thread.sleep(jpex ? 2400L : 1200L);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            --nunchanged;
                        } while (nunchanged > 0 && nexcept > 0);
                        if (Cache.log.isDebugEnabled()) {
                            System.out.println("Job Execution file for job: " + msjob.getJobId() + " on server " + this.WsUrl);
                            System.out.println(msjob.getStatus());
                            System.out.println("*** End of status");
                        }
                        try {
                            msjob.alignment = this.server.getAlignmentFor(msjob.getJobHandle());
                        }
                        catch (Exception e) {
                            if (this.server.handleCollectionException(e, msjob, this.wsInfo)) break block15;
                            Cache.log.error((Object)"Couldn't get Alignment for job.", (Throwable)e);
                            msjob.setState(WsJob.JobState.SERVERERROR);
                        }
                    }
                }
                finalState.updateJobPanelState(this.wsInfo, this.OutputHeader, this.jobs[j]);
                if (!this.jobs[j].isSubmitted() || !this.jobs[j].isSubjobComplete() || !this.jobs[j].hasResults()) continue;
                ++results;
            }
        }
        catch (Exception ex) {
            Cache.log.error((Object)("Unexpected exception when processing results for " + this.alTitle), (Throwable)ex);
            this.wsInfo.setStatus(4);
        }
        if (results > 0) {
            this.wsInfo.showResultsNewFrame.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MsaWSThread.this.displayResults(true);
                }
            });
            this.wsInfo.mergeResults.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MsaWSThread.this.displayResults(false);
                }
            });
            this.wsInfo.setResultsReady();
        } else {
            this.wsInfo.setFinishedNoResults();
        }
        this.updateGlobalStatus(finalState);
        this.wsInfo.setProgressBar(null, progbar);
    }

    void displayResults(boolean newFrame) {
        ArrayList<AlignmentOrder> alorders = new ArrayList<AlignmentOrder>();
        SequenceI[][] results = new SequenceI[this.jobs.length][];
        AlignmentOrder[] orders = new AlignmentOrder[this.jobs.length];
        String lastProgram = null;
        for (int j = 0; j < this.jobs.length; ++j) {
            if (this.jobs[j].hasResults()) {
                MsaWSJob msjob = (MsaWSJob)this.jobs[j];
                Object[] res = msjob.getAlignment();
                lastProgram = msjob.getAlignmentProgram();
                alorders.add((AlignmentOrder)res[1]);
                results[j] = (SequenceI[])res[0];
                orders[j] = (AlignmentOrder)res[1];
                continue;
            }
            results[j] = null;
        }
        Object[] newview = this.input.getUpdatedView(results, orders, this.getGapChar());
        for (int j = 0; j < this.jobs.length; ++j) {
            results[j] = null;
            orders[j] = null;
        }
        SequenceI[] alignment = (SequenceI[])newview[0];
        HiddenColumns hidden = (HiddenColumns)newview[1];
        Alignment al = new Alignment(alignment);
        if (lastProgram != null) {
            al.setProperty("Alignment Program", lastProgram);
        }
        if (this.dataset != null) {
            al.setDataset(this.dataset);
        }
        this.propagateDatasetMappings(al);
        if (newFrame) {
            this.displayInNewFrame(al, alorders, hidden);
        } else {
            System.out.println("MERGE WITH OLD FRAME");
        }
    }

    protected void displayInNewFrame(AlignmentI al, List<AlignmentOrder> alorders, HiddenColumns hidden) {
        AlignFrame requestedBy;
        AlignFrame af = new AlignFrame(al, hidden, 700, 500);
        af.getFeatureRenderer().transferSettings(this.featureSettings);
        if (alorders.size() > 0) {
            this.addSortByMenuItems(af, alorders);
        }
        if ((requestedBy = this.getRequestingAlignFrame()) != null && requestedBy.getSplitViewContainer() != null && requestedBy.getSplitViewContainer().getComplement(requestedBy) != null) {
            AlignmentI complement = requestedBy.getSplitViewContainer().getComplement(requestedBy);
            String complementTitle = requestedBy.getSplitViewContainer().getComplementTitle(requestedBy);
            Alignment copyComplement = new Alignment(complement);
            copyComplement.setGapCharacter(complement.getGapCharacter());
            copyComplement.setDataset(complement.getDataset());
            copyComplement.alignAs(al);
            if (copyComplement.getHeight() > 0) {
                af.setTitle(this.alTitle);
                AlignFrame af2 = new AlignFrame(copyComplement, 700, 500);
                af2.setTitle(complementTitle);
                String linkedTitle = MessageManager.getString("label.linked_view_title");
                SplitFrame splitFrame = new SplitFrame(al.isNucleotide() ? af : af2, al.isNucleotide() ? af2 : af);
                Desktop.addInternalFrame(splitFrame, linkedTitle, -1, -1);
                return;
            }
        }
        Desktop.addInternalFrame(af, this.alTitle, 700, 500);
    }

    protected void addSortByMenuItems(AlignFrame af, List<AlignmentOrder> alorders) {
        if (alorders.size() == 1) {
            af.addSortByOrderMenuItem(this.WebServiceName + " Ordering", alorders.get(0));
        } else {
            int i;
            ArrayList<Object> names = new ArrayList<Object>();
            int l = alorders.size();
            for (i = 0; i < l; ++i) {
                String orderName = " Region " + i;
                int j = i + 1;
                while (j < l) {
                    if (alorders.get(i).equals(alorders.get(j))) {
                        alorders.remove(j);
                        --l;
                        orderName = orderName + "," + j;
                        continue;
                    }
                    ++j;
                }
                if (i == 0 && j == 1) {
                    names.add("");
                    continue;
                }
                names.add(orderName);
            }
            l = alorders.size();
            for (i = 0; i < l; ++i) {
                af.addSortByOrderMenuItem(this.WebServiceName + (String)names.get(i) + " Ordering", alorders.get(i));
            }
        }
    }

    @Override
    public boolean canMergeResults() {
        return false;
    }
}

