/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.ebi;

import jalview.util.MessageManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class EBIFetchClient {
    public String[] getSupportedDBs() {
        throw new Error(MessageManager.getString("error.not_yet_implemented"));
    }

    public String[] getSupportedFormats() {
        throw new Error(MessageManager.getString("error.not_yet_implemented"));
    }

    public String[] getSupportedStyles() {
        throw new Error(MessageManager.getString("error.not_yet_implemented"));
    }

    public File fetchDataAsFile(String ids, String format, String ext) throws OutOfMemoryError {
        File outFile = null;
        try {
            outFile = File.createTempFile("jalview", "." + ext);
            outFile.deleteOnExit();
            this.fetchData(ids, format, outFile);
            if (outFile.length() == 0L) {
                outFile.delete();
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outFile;
    }

    String[] fetchData(String ids, String format, File outFile) throws OutOfMemoryError {
        StringBuilder querystring = new StringBuilder(ids.length());
        String database = EBIFetchClient.parseIds(ids, querystring);
        if (database == null) {
            System.err.println("Invalid Query string : '" + ids + "'");
            System.err.println("Should be of form 'dbname:q1;q2;q3;q4'");
            return null;
        }
        String[] rslt = this.fetchBatch(querystring.toString(), database, format, outFile);
        return rslt != null && rslt.length > 0 ? rslt : null;
    }

    static String parseIds(String ids, StringBuilder queryString) {
        boolean appending;
        String database = null;
        StringTokenizer queries = new StringTokenizer(ids, ";");
        boolean bl = appending = queryString.length() > 0;
        while (queries.hasMoreTokens()) {
            String query = queries.nextToken();
            int p = query.indexOf(58);
            if (p > -1) {
                String db = query.substring(0, p);
                if (database != null && !db.equalsIgnoreCase(database)) {
                    return null;
                }
                database = db;
                query = query.substring(p + 1);
            }
            queryString.append(appending ? "," : "");
            queryString.append(query);
            appending = true;
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String[] fetchBatch(String ids, String database, String format, File outFile) throws OutOfMemoryError {
        String url = EBIFetchClient.buildUrl(ids, database, format);
        try {
            URL rcall = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)rcall.openConnection();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                System.err.println("Warning: response code " + responseCode + " for " + url);
            }
            BufferedInputStream is = new BufferedInputStream(conn.getInputStream());
            if (outFile != null) {
                FileOutputStream fio = new FileOutputStream(outFile);
                byte[] bb = new byte[32768];
                while (true) {
                    int l;
                    if ((l = ((InputStream)is).read(bb)) <= 0) {
                        fio.close();
                        ((InputStream)is).close();
                        return null;
                    }
                    fio.write(bb, 0, l);
                }
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            ArrayList<String> arl = new ArrayList<String>();
            while (true) {
                String rtn;
                if ((rtn = br.readLine()) == null) {
                    return arl.toArray(new String[arl.size()]);
                }
                arl.add(rtn);
            }
        }
        catch (OutOfMemoryError er) {
            System.out.println("OUT OF MEMORY DOWNLOADING QUERY FROM " + database + ":\n" + ids);
            throw er;
        }
        catch (Exception ex) {
            if (ex.getMessage().startsWith("uk.ac.ebi.jdbfetch.exceptions.DbfNoEntryFoundException")) {
                return null;
            }
            System.err.println("Unexpected exception when retrieving from " + database + "\nQuery was : '" + ids + "'");
            ex.printStackTrace(System.err);
            return null;
        }
    }

    static String buildUrl(String ids, String database, String format) {
        String url = database.equalsIgnoreCase("EMBL") || database.equalsIgnoreCase("EMBLCDS") ? "https://www.ebi.ac.uk/ena/data/view/" + ids.toLowerCase() + (String)(format != null ? "&" + format : "") : "https://www.ebi.ac.uk/Tools/dbfetch/dbfetch/" + database.toLowerCase() + "/" + ids.toLowerCase() + (String)(format != null ? "/" + format : "");
        return url;
    }
}

