/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import com.stevesoft.pat.Regex;
import jalview.api.FeatureSettingsModelI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FormatAdapter;
import jalview.io.PDBFeatureSettings;
import jalview.structure.StructureImportSettings;
import jalview.util.MessageManager;
import jalview.ws.dbsources.EbiFileRetrievedProxy;
import jalview.ws.ebi.EBIFetchClient;
import java.io.File;
import java.util.ArrayList;

public class Pdb
extends EbiFileRetrievedProxy {
    private static final String SEPARATOR = "|";
    private static final String COLON = ":";
    private static final int PDB_ID_LENGTH = 4;

    @Override
    public String getAccessionSeparator() {
        return null;
    }

    @Override
    public Regex getAccessionValidator() {
        return new Regex("([1-9][0-9A-Za-z]{3}):?([ _A-Za-z0-9]?)");
    }

    @Override
    public String getDbSource() {
        return "PDB";
    }

    @Override
    public String getDbVersion() {
        return "0";
    }

    @Override
    public AlignmentI getSequenceRecords(String queries) throws Exception {
        AlignmentI pdbAlignment = null;
        String chain = null;
        String id = null;
        if (queries.indexOf(COLON) > -1) {
            chain = queries.substring(queries.indexOf(COLON) + 1);
            id = queries.substring(0, queries.indexOf(COLON));
        } else {
            id = queries;
        }
        if (queries.length() > 4 && chain == null) {
            chain = queries.substring(4, 5);
            id = queries.substring(0, 4);
        }
        if (!this.isValidReference(id)) {
            System.err.println("Ignoring invalid pdb query: '" + id + "'");
            this.stopQuery();
            return null;
        }
        PDBEntry.Type pdbFileFormat = StructureImportSettings.getDefaultStructureFileFormat();
        String ext = pdbFileFormat.getExtension();
        String fetchFormat = pdbFileFormat.getFormat();
        EBIFetchClient ebi = new EBIFetchClient();
        File tmpFile = ebi.fetchDataAsFile("pdb:" + id, fetchFormat, ext);
        this.file = tmpFile.getAbsolutePath();
        this.stopQuery();
        if (this.file == null) {
            return null;
        }
        try {
            FileFormat fileFormat = pdbFileFormat == PDBEntry.Type.PDB ? FileFormat.PDB : FileFormat.MMCif;
            pdbAlignment = new FormatAdapter().readFile(this.file, DataSourceType.FILE, fileFormat);
            if (pdbAlignment != null) {
                ArrayList<SequenceI> toremove = new ArrayList<SequenceI>();
                for (SequenceI pdbcs : pdbAlignment.getSequences()) {
                    String chid = null;
                    for (PDBEntry pid : pdbcs.getAllPDBEntries()) {
                        if (pid.getFile() != this.file) continue;
                        chid = pid.getChainCode();
                    }
                    if (chain == null || chid != null && (chid.equals(chain) || chid.trim().equals(chain.trim()) || chain.trim().length() == 0 && chid.equals("_"))) {
                        pdbcs.setName("PDB|" + id + SEPARATOR + pdbcs.getName());
                        DBRefEntry dbentry = new DBRefEntry(this.getDbSource(), this.getDbVersion(), (String)(chid == null ? id : id + chid));
                        pdbcs.addDBRef(dbentry);
                        continue;
                    }
                    toremove.add(pdbcs);
                }
                for (SequenceI pdbcs : toremove) {
                    pdbAlignment.deleteSequence(pdbcs);
                    if (pdbcs.getAnnotation() == null) continue;
                    for (AlignmentAnnotation aa : pdbcs.getAnnotation()) {
                        pdbAlignment.deleteAnnotation(aa);
                    }
                }
            }
            if (pdbAlignment == null || pdbAlignment.getHeight() < 1) {
                throw new Exception(MessageManager.formatMessage("exception.no_pdb_records_for_chain", new String[]{id, chain == null ? "' '" : chain}));
            }
        }
        catch (Exception ex) {
            this.stopQuery();
            throw ex;
        }
        return pdbAlignment;
    }

    @Override
    public boolean isValidReference(String accession) {
        Regex r = this.getAccessionValidator();
        return r.search(accession.trim());
    }

    @Override
    public String getTestQuery() {
        return "1QIP";
    }

    @Override
    public String getDbName() {
        return "PDB";
    }

    @Override
    public int getTier() {
        return 0;
    }

    @Override
    public FeatureSettingsModelI getFeatureColourScheme() {
        return new PDBFeatureSettings();
    }
}

