/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.WebserviceInfo;
import jalview.gui.WsJobParameters;
import jalview.util.MessageManager;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.api.UIinfo;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import java.util.Hashtable;
import java.util.List;

public abstract class WSClient {
    protected String WebServiceName;
    protected String WebServiceJobTitle;
    protected String WebServiceReference;
    protected String WsURL;
    protected WebserviceInfo wsInfo;
    protected UIinfo serviceHandle;
    int jobsRunning = 0;
    protected Hashtable ServiceActions = new Hashtable();
    protected AlignFrame alignFrame;
    protected WsParamSetI preset;
    protected List<ArgumentI> paramset;

    public WSClient() {
        this.ServiceActions.put("MsaWS", "Multiple Sequence Alignment");
        this.ServiceActions.put("SecStrPred", "Secondary Structure Prediction");
    }

    public WSClient(AlignFrame _alignFrame, WsParamSetI preset, List<ArgumentI> arguments) {
        this.ServiceActions.put("MsaWS", "Multiple Sequence Alignment");
        this.ServiceActions.put("SecStrPred", "Secondary Structure Prediction");
        this.alignFrame = _alignFrame;
        this.preset = preset;
        this.paramset = arguments;
    }

    protected WebserviceInfo setWebService(UIinfo serv, boolean b) {
        this.WebServiceName = serv.getName();
        this.WebServiceJobTitle = serv.getActionText();
        this.WsURL = serv.getHostURL();
        if (!b) {
            return new WebserviceInfo(this.WebServiceJobTitle, this.WebServiceJobTitle + " using service hosted at " + this.WsURL + "\n" + (serv.getDescription() != null ? serv.getDescription() : ""), false);
        }
        return null;
    }

    protected boolean processParams(ServiceWithParameters sh, boolean editParams) {
        return this.processParams(sh, editParams, false);
    }

    protected boolean processParams(ServiceWithParameters sh, boolean editParams, boolean adjustingExisting) {
        if (editParams) {
            WsJobParameters jobParams;
            sh.initParamStore(Desktop.getUserParameterStore());
            WsJobParameters wsJobParameters = jobParams = this.preset == null && this.paramset != null && this.paramset.size() > 0 ? new WsJobParameters(null, sh, null, this.paramset) : new WsJobParameters(null, sh, this.preset, null);
            if (adjustingExisting) {
                jobParams.setName(MessageManager.getString("label.adjusting_parameters_for_calculation"));
            }
            if (!jobParams.showRunDialog()) {
                return false;
            }
            WsParamSetI prset = jobParams.getPreset();
            if (prset == null) {
                this.paramset = jobParams.isServiceDefaults() ? null : jobParams.getJobParams();
                this.preset = null;
            } else {
                this.preset = prset;
                this.paramset = null;
            }
        }
        return true;
    }
}

