/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.analysis.AAFrequency;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.workers.ConsensusThread;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;

public class ComplementConsensusThread
extends ConsensusThread {
    public ComplementConsensusThread(AlignViewportI alignViewport, AlignmentViewPanel alignPanel) {
        super(alignViewport, alignPanel);
    }

    @Override
    protected AlignmentAnnotation getConsensusAnnotation() {
        return this.alignViewport.getComplementConsensusAnnotation();
    }

    protected Hashtable[] getViewportConsensus() {
        return this.alignViewport.getComplementConsensusHash();
    }

    @Override
    protected void computeConsensus(AlignmentI alignment) {
        Hashtable[] hconsensus = new Hashtable[alignment.getWidth()];
        SequenceI[] aseqs = this.getSequences();
        for (int i = 0; i < 3; ++i) {
            try {
                AAFrequency.calculateCdna(alignment, hconsensus);
                break;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        this.alignViewport.setComplementConsensusHash(hconsensus);
    }

    protected void deriveConsensus(AlignmentAnnotation consensusAnnotation, Hashtable[] consensusData) {
        AAFrequency.completeCdnaConsensus(consensusAnnotation, consensusData, this.alignViewport.isShowSequenceLogo(), this.getSequences().length);
    }

    @Override
    public void updateResultAnnotation(boolean immediate) {
        AlignmentAnnotation consensus = this.getConsensusAnnotation();
        Hashtable[] hconsensus = this.getViewportConsensus();
        if (immediate || !this.calcMan.isWorking(this) && consensus != null && hconsensus != null) {
            this.deriveConsensus(consensus, hconsensus);
        }
    }
}

