/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import com.stevesoft.pat.Regex;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.SequenceI;
import jalview.util.DBRefUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class UrlLink {
    private static final String SEQUENCEID_PLACEHOLDER = "$SEQUENCE_ID$";
    private static final String ACCESSION_PLACEHOLDER = "$DB_ACCESSION$";
    public static final Comparator<String> LINK_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String link1, String link2) {
            if (link1 == null || link2 == null) {
                return 0;
            }
            if (link1.contains(UrlLink.SEQUENCEID_PLACEHOLDER) && link2.contains(UrlLink.ACCESSION_PLACEHOLDER)) {
                return -1;
            }
            if (link2.contains(UrlLink.SEQUENCEID_PLACEHOLDER) && link1.contains(UrlLink.ACCESSION_PLACEHOLDER)) {
                return 1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(link1, link2);
        }
    };
    private static final String EQUALS = "=";
    private static final String SPACE = " ";
    private String urlSuffix;
    private String urlPrefix;
    private String target;
    private String label;
    private String dbname;
    private String regexReplace;
    private boolean dynamic = false;
    private boolean usesDBaccession = false;
    private String invalidMessage = null;

    public UrlLink(String link) {
        int sep = link.indexOf("|");
        int psqid = link.indexOf("$DB_ACCESSION");
        int nsqid = link.indexOf("$SEQUENCE_ID");
        if (psqid > -1) {
            this.dynamic = true;
            this.usesDBaccession = true;
            sep = this.parseLabel(sep, psqid, link);
            int endOfRegex = this.parseUrl(link, "DB_ACCESSION", psqid, sep);
            this.parseTarget(link, sep, endOfRegex);
        } else if (nsqid > -1) {
            this.dynamic = true;
            sep = this.parseLabel(sep, nsqid, link);
            int endOfRegex = this.parseUrl(link, "SEQUENCE_ID", nsqid, sep);
            this.parseTarget(link, sep, endOfRegex);
        } else {
            this.label = link.substring(0, sep).trim();
            int lastsep = link.lastIndexOf("|");
            if (lastsep != sep) {
                this.urlPrefix = link.substring(sep + 1, lastsep).trim();
                this.target = link.substring(lastsep + 1).trim();
            } else {
                this.urlPrefix = link.substring(sep + 1).trim();
                this.target = this.label;
            }
            this.regexReplace = null;
            this.urlSuffix = null;
        }
        this.label = this.label.trim();
        this.target = this.target.trim();
    }

    public UrlLink(String name, String url, String desc) {
        this(name + "|" + url + "|" + desc);
    }

    public String getUrlSuffix() {
        return this.urlSuffix;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public String getTarget() {
        return this.target;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUrlWithToken() {
        String var;
        String string = var = this.usesDBaccession ? "DB_ACCESSION" : "SEQUENCE_ID";
        return this.urlPrefix + (String)(this.dynamic ? "$" + var + (String)(this.regexReplace != null ? EQUALS + this.regexReplace + "=$" : "$") : "") + (this.urlSuffix == null ? "" : this.urlSuffix);
    }

    public String getRegexReplace() {
        return this.regexReplace;
    }

    public String getInvalidMessage() {
        return this.invalidMessage;
    }

    public boolean isValid() {
        return this.invalidMessage == null;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean usesDBAccession() {
        return this.usesDBaccession;
    }

    public void setLabel(String newlabel) {
        this.label = newlabel;
    }

    public void setTarget(String desc) {
        this.target = desc;
    }

    public String[] makeUrls(String idstring, boolean onlyIfMatches) {
        if (this.dynamic) {
            if (this.regexReplace != null) {
                Regex rg = Regex.perlCode("/" + this.regexReplace + "/");
                if (rg.search(idstring)) {
                    int ns = rg.numSubs();
                    if (ns == 0) {
                        return new String[]{rg.stringMatched(), this.urlPrefix + rg.stringMatched() + this.urlSuffix};
                    }
                    for (int s = 0; s <= rg.numSubs(); ++s) {
                        System.err.println("Sub " + s + " : " + rg.matchedFrom(s) + " : " + rg.matchedTo(s) + " : '" + rg.stringMatched(s) + "'");
                    }
                    Vector<Object> subs = new Vector<Object>();
                    int s = 0;
                    while (s <= ns) {
                        if (s + 1 <= ns && rg.matchedTo(s) > -1 && rg.matchedTo(s + 1) > -1 && rg.matchedTo(s + 1) < rg.matchedTo(s)) {
                            int r;
                            Object mtch = "";
                            for (r = s + 1; r <= ns && rg.matchedTo(r) <= rg.matchedTo(s); ++r) {
                                if (rg.matchedFrom(r) <= -1) continue;
                                mtch = (String)mtch + rg.stringMatched(r);
                            }
                            if (((String)mtch).length() > 0) {
                                subs.addElement(mtch);
                                subs.addElement(this.urlPrefix + (String)mtch + this.urlSuffix);
                            }
                            s = r;
                            continue;
                        }
                        if (rg.matchedFrom(s) > -1) {
                            subs.addElement(rg.stringMatched(s));
                            subs.addElement(this.urlPrefix + rg.stringMatched(s) + this.urlSuffix);
                        }
                        ++s;
                    }
                    String[] res = new String[subs.size()];
                    int rs = subs.size();
                    for (int r = 0; r < rs; ++r) {
                        res[r] = (String)subs.elementAt(r);
                    }
                    subs.removeAllElements();
                    return res;
                }
                if (onlyIfMatches) {
                    return null;
                }
            }
            if (idstring.indexOf("|") > -1) {
                idstring = idstring.substring(idstring.lastIndexOf("|") + 1);
            }
            return new String[]{idstring, this.urlPrefix + idstring + this.urlSuffix};
        }
        return new String[]{"", this.urlPrefix};
    }

    public String toString() {
        return this.label + "|" + this.getUrlWithToken();
    }

    public String toStringWithTarget() {
        return this.label + "|" + this.getUrlWithToken() + "|" + this.target;
    }

    protected int parseLabel(int firstSep, int psqid, String link) {
        int p = firstSep;
        int sep = firstSep;
        while ((p = link.indexOf("|", (sep = p) + 1)) > sep && p < psqid) {
        }
        this.label = link.substring(0, sep);
        return sep;
    }

    protected void parseTarget(String link, int sep, int endOfRegex) {
        int lastsep = link.lastIndexOf("|");
        this.target = lastsep != sep && lastsep > endOfRegex ? link.substring(lastsep + 1).trim() : this.label;
        if (this.target.indexOf("|") > -1) {
            this.target = this.target.substring(0, this.target.indexOf("|"));
        } else if (this.target.indexOf(SPACE) > 2) {
            this.target = this.target.substring(0, this.target.indexOf(SPACE));
        }
    }

    protected int parseUrl(String link, String varName, int sqidPos, int sep) {
        this.urlPrefix = link.substring(sep + 1, sqidPos).trim();
        String startDelimiter = "$" + varName + "=/";
        String endDelimiter = "/=$";
        int startLength = startDelimiter.length();
        int p = link.indexOf(endDelimiter, sqidPos + startLength);
        if (link.indexOf(startDelimiter) == sqidPos && p > sqidPos + startLength) {
            this.urlSuffix = link.substring(p + endDelimiter.length());
            this.regexReplace = link.substring(sqidPos + startLength, p);
            try {
                Regex rg = Regex.perlCode("/" + this.regexReplace + "/");
                if (rg == null) {
                    this.invalidMessage = "Invalid Regular Expression : '" + this.regexReplace + "'\n";
                }
            }
            catch (Exception e) {
                this.invalidMessage = "Invalid Regular Expression : '" + this.regexReplace + "'\n";
            }
        } else {
            this.regexReplace = null;
            if (link.indexOf("$" + varName + "$") == sqidPos) {
                int lastsep = link.lastIndexOf("|");
                if (lastsep < sqidPos + startLength - 1) {
                    lastsep = link.length();
                }
                this.urlSuffix = link.substring(sqidPos + startLength - 1, lastsep).trim();
                this.regexReplace = null;
            } else {
                this.invalidMessage = "Warning: invalid regex structure for URL link : " + link;
            }
        }
        return p;
    }

    public void createLinksFromSeq(SequenceI seq, Map<String, List<String>> linkset) {
        if (seq != null && this.dynamic) {
            this.createDynamicLinks(seq, linkset);
        } else {
            this.createStaticLink(linkset);
        }
    }

    protected void createStaticLink(Map<String, List<String>> linkset) {
        if (!linkset.containsKey(this.label + "|" + this.getUrlPrefix())) {
            linkset.put(this.label + "|" + this.getUrlPrefix(), Arrays.asList(this.target, this.label, null, this.getUrlPrefix()));
        }
    }

    protected void createDynamicLinks(SequenceI seq, Map<String, List<String>> linkset) {
        String id = seq.getName();
        String descr = seq.getDescription();
        if (descr != null && descr.length() < 1) {
            descr = null;
        }
        if (this.usesDBAccession()) {
            DBRefEntry[] dbr = DBRefUtils.selectRefs(seq.getDBRefs(), new String[]{this.target});
            if (dbr != null) {
                for (int r = 0; r < dbr.length; ++r) {
                    this.createBareURLLink(dbr[r].getAccessionId(), true, linkset);
                }
            }
        } else if (!this.usesDBAccession() && id != null) {
            this.createBareURLLink(id, false, linkset);
        }
        if (descr != null && this.getRegexReplace() != null) {
            this.createBareURLLink(descr, false, linkset);
        }
    }

    protected void createBareURLLink(String id, Boolean combineLabel, Map<String, List<String>> linkset) {
        String[] urls = this.makeUrls(id, true);
        if (urls != null) {
            for (int u = 0; u < urls.length; u += 2) {
                if (linkset.containsKey(urls[u] + "|" + urls[u + 1])) continue;
                Object thisLabel = this.label;
                if (combineLabel.booleanValue()) {
                    thisLabel = this.label + "|" + urls[u];
                }
                linkset.put(urls[u] + "|" + urls[u + 1], Arrays.asList(this.target, thisLabel, urls[u], urls[u + 1]));
            }
        }
    }

    public static void sort(List<String> nlinks) {
        Collections.sort(nlinks, LINK_COMPARATOR);
    }
}

