/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.util.MappingUtils;
import jalview.util.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MapList {
    private List<int[]> fromShifts = new ArrayList<int[]>();
    private List<int[]> toShifts = new ArrayList<int[]>();
    private int fromRatio;
    private int toRatio;
    private int fromLowest;
    private int fromHighest;
    private int toLowest;
    private int toHighest;

    public MapList() {
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof MapList)) {
            return false;
        }
        MapList obj = (MapList)o;
        if (obj == this) {
            return true;
        }
        if (obj.fromRatio != this.fromRatio || obj.toRatio != this.toRatio || obj.fromShifts == null || obj.toShifts == null) {
            return false;
        }
        return Arrays.deepEquals(this.fromShifts.toArray(), obj.fromShifts.toArray()) && Arrays.deepEquals(this.toShifts.toArray(), obj.toShifts.toArray());
    }

    public int hashCode() {
        int hashCode = 31 * this.fromRatio;
        hashCode = 31 * hashCode + this.toRatio;
        for (int[] shift : this.fromShifts) {
            hashCode = 31 * hashCode + shift[0];
            hashCode = 31 * hashCode + shift[1];
        }
        for (int[] shift : this.toShifts) {
            hashCode = 31 * hashCode + shift[0];
            hashCode = 31 * hashCode + shift[1];
        }
        return hashCode;
    }

    public List<int[]> getFromRanges() {
        return this.fromShifts;
    }

    public List<int[]> getToRanges() {
        return this.toShifts;
    }

    protected static int[] getRanges(List<int[]> shifts) {
        int[] rnges = new int[2 * shifts.size()];
        int i = 0;
        for (int[] r : shifts) {
            rnges[i++] = r[0];
            rnges[i++] = r[1];
        }
        return rnges;
    }

    public int getFromRatio() {
        return this.fromRatio;
    }

    public int getToRatio() {
        return this.toRatio;
    }

    public int getFromLowest() {
        return this.fromLowest;
    }

    public int getFromHighest() {
        return this.fromHighest;
    }

    public int getToLowest() {
        return this.toLowest;
    }

    public int getToHighest() {
        return this.toHighest;
    }

    public MapList(int[] from, int[] to, int fromRatio, int toRatio) {
        this();
        int i;
        this.fromRatio = fromRatio;
        this.toRatio = toRatio;
        this.fromLowest = Integer.MAX_VALUE;
        this.fromHighest = Integer.MIN_VALUE;
        int added = 0;
        for (i = 0; i < from.length; i += 2) {
            this.fromLowest = Math.min(this.fromLowest, Math.min(from[i], from[i + 1]));
            this.fromHighest = Math.max(this.fromHighest, Math.max(from[i], from[i + 1]));
            if (added > 0 && from[i] == this.fromShifts.get(added - 1)[1]) {
                this.fromShifts.get((int)(added - 1))[1] = from[i + 1];
                continue;
            }
            this.fromShifts.add(new int[]{from[i], from[i + 1]});
            ++added;
        }
        this.toLowest = Integer.MAX_VALUE;
        this.toHighest = Integer.MIN_VALUE;
        added = 0;
        for (i = 0; i < to.length; i += 2) {
            this.toLowest = Math.min(this.toLowest, Math.min(to[i], to[i + 1]));
            this.toHighest = Math.max(this.toHighest, Math.max(to[i], to[i + 1]));
            if (added > 0 && to[i] == this.toShifts.get(added - 1)[1]) {
                this.toShifts.get((int)(added - 1))[1] = to[i + 1];
                continue;
            }
            this.toShifts.add(new int[]{to[i], to[i + 1]});
            ++added;
        }
    }

    public MapList(MapList map) {
        this();
        this.fromLowest = map.fromLowest;
        this.fromHighest = map.fromHighest;
        this.toLowest = map.toLowest;
        this.toHighest = map.toHighest;
        this.fromRatio = map.fromRatio;
        this.toRatio = map.toRatio;
        if (map.fromShifts != null) {
            for (int[] r : map.fromShifts) {
                this.fromShifts.add(new int[]{r[0], r[1]});
            }
        }
        if (map.toShifts != null) {
            for (int[] r : map.toShifts) {
                this.toShifts.add(new int[]{r[0], r[1]});
            }
        }
    }

    public MapList(List<int[]> fromRange, List<int[]> toRange, int fromRatio, int toRatio) {
        this();
        fromRange = MapList.coalesceRanges(fromRange);
        toRange = MapList.coalesceRanges(toRange);
        this.fromShifts = fromRange;
        this.toShifts = toRange;
        this.fromRatio = fromRatio;
        this.toRatio = toRatio;
        this.fromLowest = Integer.MAX_VALUE;
        this.fromHighest = Integer.MIN_VALUE;
        for (int[] range : fromRange) {
            if (range.length != 2) {
                System.err.println("Invalid format for fromRange " + Arrays.toString(range) + " may cause errors");
            }
            this.fromLowest = Math.min(this.fromLowest, Math.min(range[0], range[1]));
            this.fromHighest = Math.max(this.fromHighest, Math.max(range[0], range[1]));
        }
        this.toLowest = Integer.MAX_VALUE;
        this.toHighest = Integer.MIN_VALUE;
        for (int[] range : toRange) {
            if (range.length != 2) {
                System.err.println("Invalid format for toRange " + Arrays.toString(range) + " may cause errors");
            }
            this.toLowest = Math.min(this.toLowest, Math.min(range[0], range[1]));
            this.toHighest = Math.max(this.toHighest, Math.max(range[0], range[1]));
        }
    }

    public static List<int[]> coalesceRanges(List<int[]> ranges) {
        if (ranges == null || ranges.size() < 2) {
            return ranges;
        }
        boolean changed = false;
        ArrayList<int[]> merged = new ArrayList<int[]>();
        int[] lastRange = ranges.get(0);
        int lastDirection = lastRange[1] >= lastRange[0] ? 1 : -1;
        lastRange = new int[]{lastRange[0], lastRange[1]};
        merged.add(lastRange);
        boolean first = true;
        for (int[] range : ranges) {
            boolean overlapping;
            if (first) {
                first = false;
                continue;
            }
            if (range[0] == lastRange[0] && range[1] == lastRange[1]) {
                changed = true;
                continue;
            }
            if (lastDirection == 1 && range[0] >= lastRange[0] && range[0] <= lastRange[1] && range[1] >= lastRange[0] && range[1] <= lastRange[1] || lastDirection == -1 && range[0] <= lastRange[0] && range[0] >= lastRange[1] && range[1] <= lastRange[0] && range[1] >= lastRange[1]) {
                changed = true;
                continue;
            }
            int direction = range[1] >= range[0] ? 1 : -1;
            boolean sameDirection = range[1] == range[0] || direction == lastDirection;
            boolean extending = range[0] == lastRange[1] + lastDirection;
            boolean bl = overlapping = lastDirection == 1 && range[0] >= lastRange[0] && range[0] <= lastRange[1] || lastDirection == -1 && range[0] <= lastRange[0] && range[0] >= lastRange[1];
            if (sameDirection && (overlapping || extending)) {
                lastRange[1] = range[1];
                changed = true;
                continue;
            }
            lastRange = new int[]{range[0], range[1]};
            merged.add(lastRange);
            lastDirection = range[1] == range[0] ? lastDirection : direction;
        }
        return changed ? merged : ranges;
    }

    protected int[][] makeFromMap() {
        return this.posMap(this.fromShifts, this.fromRatio, this.toShifts, this.toRatio);
    }

    protected int[][] makeToMap() {
        return this.posMap(this.toShifts, this.toRatio, this.fromShifts, this.fromRatio);
    }

    private int[][] posMap(List<int[]> shiftTo, int ratio, List<int[]> shiftFrom, int toRatio) {
        int to;
        int[] intv;
        int from;
        int iv = 0;
        int ivSize = shiftTo.size();
        if (iv >= ivSize) {
            return null;
        }
        if ((from = (intv = shiftTo.get(iv++))[0]) > (to = intv[1])) {
            from = intv[1];
            to = intv[0];
        }
        while (iv < ivSize) {
            if ((intv = shiftTo.get(iv++))[0] < from) {
                from = intv[0];
            }
            if (intv[1] < from) {
                from = intv[1];
            }
            if (intv[0] > to) {
                to = intv[0];
            }
            if (intv[1] <= to) continue;
            to = intv[1];
        }
        int tF = 0;
        int tT = 0;
        int[][] mp = new int[to - from + 2][];
        for (int i = 0; i < mp.length; ++i) {
            int[] m = MapList.shift(i + from, shiftTo, ratio, shiftFrom, toRatio);
            if (m != null) {
                if (i == 0) {
                    tF = tT = m[0];
                } else {
                    if (m[0] < tF) {
                        tF = m[0];
                    }
                    if (m[0] > tT) {
                        tT = m[0];
                    }
                }
            }
            mp[i] = m;
        }
        int[][] map = new int[][]{{from, to, tF, tT}, new int[to - from + 2]};
        map[0][2] = tF;
        map[0][3] = tT;
        for (int i = 0; i < mp.length; ++i) {
            map[1][i] = mp[i] != null ? mp[i][0] - tF : -1;
        }
        return map;
    }

    public int[] shiftFrom(int pos) {
        return MapList.shift(pos, this.fromShifts, this.fromRatio, this.toShifts, this.toRatio);
    }

    public int[] shiftTo(int pos) {
        return MapList.shift(pos, this.toShifts, this.toRatio, this.fromShifts, this.fromRatio);
    }

    protected static int[] shift(int pos, List<int[]> shiftTo, int fromRatio, List<int[]> shiftFrom, int toRatio) {
        int[] fromCount = MapList.countPos(shiftTo, pos);
        if (fromCount == null) {
            return null;
        }
        int fromRemainder = (fromCount[0] - 1) % fromRatio;
        int toCount = 1 + (fromCount[0] - 1) / fromRatio * toRatio;
        int[] toPos = MapList.countToPos(shiftFrom, toCount);
        if (toPos == null) {
            return null;
        }
        return new int[]{toPos[0], fromRemainder, toPos[1]};
    }

    protected static int[] countPos(List<int[]> shiftTo, int pos) {
        int count = 0;
        int iv = 0;
        int ivSize = shiftTo.size();
        while (iv < ivSize) {
            int[] intv;
            if ((intv = shiftTo.get(iv++))[0] <= intv[1]) {
                if (pos >= intv[0] && pos <= intv[1]) {
                    return new int[]{count + pos - intv[0] + 1, 1};
                }
                count += intv[1] - intv[0] + 1;
                continue;
            }
            if (pos >= intv[1] && pos <= intv[0]) {
                return new int[]{count + intv[0] - pos + 1, -1};
            }
            count += intv[0] - intv[1] + 1;
        }
        return null;
    }

    protected static int[] countToPos(List<int[]> shiftFrom, int pos) {
        int count = 0;
        int diff = 0;
        int iv = 0;
        int ivSize = shiftFrom.size();
        int[] intv = new int[]{0, 0};
        while (iv < ivSize) {
            if ((diff = (intv = shiftFrom.get(iv++))[1] - intv[0]) >= 0) {
                if (pos <= count + 1 + diff) {
                    return new int[]{pos - count - 1 + intv[0], 1};
                }
                count += 1 + diff;
                continue;
            }
            if (pos <= count + 1 - diff) {
                return new int[]{intv[0] - (pos - count - 1), -1};
            }
            count += 1 - diff;
        }
        return null;
    }

    public int[] locateInFrom(int start, int end) {
        int[] fromStart = this.shiftTo(start);
        int[] fromEnd = this.shiftTo(end);
        return MapList.getIntervals(this.fromShifts, fromStart, fromEnd, this.fromRatio);
    }

    public int[] locateInTo(int start, int end) {
        int[] toStart = this.shiftFrom(start);
        int[] toEnd = this.shiftFrom(end);
        return MapList.getIntervals(this.toShifts, toStart, toEnd, this.toRatio);
    }

    protected static int[] getIntervals(List<int[]> shiftFrom, int[] fromStart, int[] fromEnd, int fromRatio2) {
        int[] iv;
        if (fromStart == null || fromEnd == null) {
            return null;
        }
        int startpos = fromStart[0];
        int endpos = fromEnd[0];
        int endindx = fromRatio2 - 1;
        int intv = 0;
        int intvSize = shiftFrom.size();
        int i = 0;
        int fs = -1;
        int fe_s = -1;
        int fe = -1;
        while (intv < intvSize && (fs == -1 || fe == -1)) {
            iv = shiftFrom.get(intv++);
            if (fe_s > -1) {
                endpos = iv[0];
                --endindx;
            }
            if (iv[0] <= iv[1]) {
                if (fs == -1 && startpos >= iv[0] && startpos <= iv[1]) {
                    fs = i;
                }
                if (endpos >= iv[0] && endpos <= iv[1]) {
                    if (fe_s == -1) {
                        fe_s = i;
                    }
                    if (fe_s != -1) {
                        if (endpos + endindx <= iv[1]) {
                            fe = i;
                            endpos += endindx;
                        } else {
                            endindx -= iv[1] - endpos;
                        }
                    }
                }
            } else {
                if (fs == -1 && startpos <= iv[0] && startpos >= iv[1]) {
                    fs = i;
                }
                if (endpos <= iv[0] && endpos >= iv[1]) {
                    if (fe_s == -1) {
                        fe_s = i;
                    }
                    if (fe_s != -1) {
                        if (endpos - endindx >= iv[1]) {
                            fe = i;
                            endpos -= endindx;
                        } else {
                            endindx -= endpos - iv[1];
                        }
                    }
                }
            }
            ++i;
        }
        if (fs == fe && fe == -1) {
            return null;
        }
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        if (fs <= fe) {
            intv = fs;
            i = fs;
            iv = shiftFrom.get(intv++);
            iv = new int[]{iv[0], iv[1]};
            if (i == fs) {
                iv[0] = startpos;
            }
            while (i != fe) {
                ranges.add(iv);
                iv = shiftFrom.get(intv++);
                iv = new int[]{iv[0], iv[1]};
                ++i;
            }
            if (i == fe) {
                iv[1] = endpos;
            }
            ranges.add(iv);
        } else {
            for (i = shiftFrom.size() - 1; i > fs; --i) {
            }
            iv = shiftFrom.get(i);
            iv = new int[]{iv[1], iv[0]};
            if (i == fs) {
                iv[0] = startpos;
            }
            while (--i != fe) {
                ranges.add(iv);
                iv = shiftFrom.get(i);
                iv = new int[]{iv[1], iv[0]};
            }
            if (i == fe) {
                iv[1] = endpos;
            }
            ranges.add(iv);
        }
        int[] range = null;
        if (ranges != null && ranges.size() > 0) {
            range = new int[ranges.size() * 2];
            intv = 0;
            intvSize = ranges.size();
            i = 0;
            while (intv < intvSize) {
                iv = (int[])ranges.get(intv);
                range[i++] = iv[0];
                range[i++] = iv[1];
                ranges.set(intv++, null);
            }
        }
        return range;
    }

    public int getToPosition(int mpos) {
        int[] mp = this.shiftTo(mpos);
        if (mp != null) {
            return mp[0];
        }
        return mpos;
    }

    public int[] getToWord(int mpos) {
        int[] mp = this.shiftTo(mpos);
        if (mp != null) {
            return new int[]{mp[0], mp[0] + mp[2] * (this.getFromRatio() - 1)};
        }
        return null;
    }

    public int getMappedPosition(int pos) {
        int[] mp = this.shiftFrom(pos);
        if (mp != null) {
            return mp[0];
        }
        return pos;
    }

    public int[] getMappedWord(int pos) {
        int[] mp = this.shiftFrom(pos);
        if (mp != null) {
            return new int[]{mp[0], mp[0] + mp[2] * (this.getToRatio() - 1)};
        }
        return null;
    }

    public MapList getInverse() {
        return new MapList(this.getToRanges(), this.getFromRanges(), this.getToRatio(), this.getFromRatio());
    }

    public boolean containsEither(boolean local, MapList map) {
        if (local) {
            return this.getFromLowest() >= map.getFromLowest() && this.getFromHighest() <= map.getFromHighest() || this.getFromLowest() <= map.getFromLowest() && this.getFromHighest() >= map.getFromHighest();
        }
        return this.getToLowest() >= map.getToLowest() && this.getToHighest() <= map.getToHighest() || this.getToLowest() <= map.getToLowest() && this.getToHighest() >= map.getToHighest();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[");
        for (int[] shift : this.fromShifts) {
            sb.append(" ").append(Arrays.toString(shift));
        }
        sb.append(" ] ");
        sb.append(this.fromRatio).append(":").append(this.toRatio);
        sb.append(" to [");
        for (int[] shift : this.toShifts) {
            sb.append(" ").append(Arrays.toString(shift));
        }
        sb.append(" ]");
        return sb.toString();
    }

    public void addMapList(MapList map) {
        if (this.equals(map)) {
            return;
        }
        this.fromLowest = Math.min(this.fromLowest, map.fromLowest);
        this.toLowest = Math.min(this.toLowest, map.toLowest);
        this.fromHighest = Math.max(this.fromHighest, map.fromHighest);
        this.toHighest = Math.max(this.toHighest, map.toHighest);
        for (int[] range : map.getFromRanges()) {
            MappingUtils.addRange(range, this.fromShifts);
        }
        for (int[] range : map.getToRanges()) {
            MappingUtils.addRange(range, this.toShifts);
        }
    }

    public boolean isFromForwardStrand() {
        return this.isForwardStrand(this.getFromRanges());
    }

    public boolean isToForwardStrand() {
        return this.isForwardStrand(this.getToRanges());
    }

    private boolean isForwardStrand(List<int[]> ranges) {
        boolean forwardStrand = true;
        for (int[] range : ranges) {
            if (range[1] > range[0]) break;
            if (range[1] >= range[0]) continue;
            forwardStrand = false;
            break;
        }
        return forwardStrand;
    }

    public boolean isTripletMap() {
        return this.toRatio == 3 && this.fromRatio == 1 || this.fromRatio == 3 && this.toRatio == 1;
    }

    public MapList traverse(MapList map) {
        if (map == null) {
            return null;
        }
        int outFromRatio = this.getFromRatio() * map.getFromRatio();
        int outToRatio = this.getToRatio() * map.getToRatio();
        int gcd = MathUtils.gcd(outFromRatio, outToRatio);
        outFromRatio /= gcd;
        outToRatio /= gcd;
        ArrayList<int[]> toRanges = new ArrayList<int[]>();
        for (int[] range : this.getToRanges()) {
            int[] transferred = map.locateInTo(range[0], range[1]);
            if (transferred == null || transferred.length % 2 != 0) {
                return null;
            }
            for (int i = 0; i < transferred.length; i += 2) {
                toRanges.add(new int[]{transferred[i], transferred[i + 1]});
            }
        }
        return new MapList(this.getFromRanges(), toRanges, outFromRatio, outToRatio);
    }

    public boolean isContiguous() {
        return this.fromShifts.size() == 1 && this.toShifts.size() == 1;
    }
}

