/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Cache;
import jalview.bin.Jalview;
import jalview.gui.EPSOptions;
import jalview.gui.IProgressIndicator;
import jalview.gui.SVGOptions;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.util.MessageManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jfree.graphics2d.svg.SVGHints;
import org.jibble.epsgraphics.EpsGraphics2D;

public class ImageMaker {
    public static final String SVG_DESCRIPTION = "Scalable Vector Graphics";
    public static final String SVG_EXTENSION = "svg";
    public static final String EPS_DESCRIPTION = "Encapsulated Postscript";
    public static final String EPS_EXTENSION = "eps";
    public static final String PNG_EXTENSION = "png";
    public static final String PNG_DESCRIPTION = "Portable  network graphics";
    public static final String HTML_EXTENSION = "html";
    public static final String HTML_DESCRIPTION = "Hypertext Markup Language";
    EpsGraphics2D pg;
    SVGGraphics2D g2;
    Graphics graphics;
    FileOutputStream out;
    BufferedImage bi;
    TYPE type;
    private IProgressIndicator pIndicator;
    private long pSessionId;
    private boolean headless;

    public ImageMaker(Component parent, TYPE type, String title, int width, int height, File file, String fileTitle, IProgressIndicator pIndicator, long pSessionId, boolean headless) {
        this.pIndicator = pIndicator;
        this.type = type;
        this.pSessionId = pSessionId;
        this.headless = headless;
        if (file == null) {
            this.setProgressMessage(MessageManager.formatMessage("status.waiting_for_user_to_select_output_file", type.name));
            JalviewFileChooser chooser = type.getFileChooser();
            chooser.setFileView(new JalviewFileView());
            chooser.setDialogTitle(title);
            chooser.setToolTipText(MessageManager.getString("action.save"));
            int value = chooser.showSaveDialog(parent);
            if (value == 0) {
                Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
                file = chooser.getSelectedFile();
            } else {
                this.setProgressMessage(MessageManager.formatMessage("status.cancelled_image_export_operation", type.name));
            }
        }
        if (file != null) {
            try {
                this.out = new FileOutputStream(file);
                this.setProgressMessage(null);
                this.setProgressMessage(MessageManager.formatMessage("status.exporting_alignment_as_x_file", type.getName()));
                if (type == TYPE.SVG) {
                    this.setupSVG(width, height, fileTitle);
                } else if (type == TYPE.EPS) {
                    this.setupEPS(width, height, fileTitle);
                } else if (type == TYPE.PNG) {
                    this.setupPNG(width, height);
                }
            }
            catch (Exception ex) {
                System.out.println("Error creating " + type.getName() + " file.");
                this.setProgressMessage(MessageManager.formatMessage("info.error_creating_file", type.getName()));
            }
        }
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public void writeImage() {
        try {
            switch (this.type) {
                case EPS: {
                    this.pg.flush();
                    this.pg.close();
                    break;
                }
                case SVG: {
                    String svgData = ((SVGGraphics2D)this.getGraphics()).getSVGDocument();
                    this.out.write(svgData.getBytes());
                    this.out.flush();
                    this.out.close();
                    break;
                }
                case PNG: {
                    ImageIO.write((RenderedImage)this.bi, PNG_EXTENSION, this.out);
                    this.out.flush();
                    this.out.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void setupEPS(int width, int height, String title) {
        EPSOptions eps;
        boolean accurateText = true;
        String renderStyle = Cache.getDefault("EPS_RENDERING", "Prompt each time");
        if (!(!renderStyle.equalsIgnoreCase("Prompt each time") || System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true") || (renderStyle = (eps = new EPSOptions()).getValue()) != null && !eps.cancelled)) {
            this.setProgressMessage(MessageManager.formatMessage("status.cancelled_image_export_operation", "EPS"));
            return;
        }
        if (renderStyle.equalsIgnoreCase("text")) {
            accurateText = false;
        }
        try {
            EpsGraphics2D ig2 = this.pg = new EpsGraphics2D(title, this.out, 0, 0, width, height);
            ((Graphics2D)ig2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.pg.setAccurateTextMode(accurateText);
            this.graphics = this.pg;
            this.setProgressMessage(MessageManager.formatMessage("status.export_complete", this.type.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setupPNG(int width, int height) {
        this.bi = new BufferedImage(width, height, 1);
        this.graphics = this.bi.getGraphics();
        Graphics2D ig2 = (Graphics2D)this.graphics;
        ig2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setProgressMessage(MessageManager.formatMessage("status.export_complete", this.type.getName()));
    }

    void setupSVG(int width, int height, String title) {
        SVGOptions svgOption;
        SVGGraphics2D ig2 = this.g2 = new SVGGraphics2D(width, height);
        String renderStyle = Cache.getDefault("SVG_RENDERING", "Prompt each time");
        if (!(!renderStyle.equalsIgnoreCase("Prompt each time") || System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true") || (renderStyle = (svgOption = new SVGOptions()).getValue()) != null && !svgOption.cancelled)) {
            this.setProgressMessage(MessageManager.formatMessage("status.cancelled_image_export_operation", "SVG"));
            return;
        }
        if (renderStyle.equalsIgnoreCase("Lineart")) {
            ig2.setRenderingHint((RenderingHints.Key)SVGHints.KEY_DRAW_STRING_TYPE, SVGHints.VALUE_DRAW_STRING_TYPE_VECTOR);
        }
        this.setProgressMessage(MessageManager.formatMessage("status.export_complete", this.type.getName()));
        this.graphics = this.g2;
    }

    static JalviewFileChooser getPNGChooser() {
        if (Jalview.isHeadlessMode()) {
            return null;
        }
        return new JalviewFileChooser(PNG_EXTENSION, PNG_DESCRIPTION);
    }

    static JalviewFileChooser getEPSChooser() {
        if (Jalview.isHeadlessMode()) {
            return null;
        }
        return new JalviewFileChooser(EPS_EXTENSION, EPS_DESCRIPTION);
    }

    private void setProgressMessage(String message) {
        if (this.pIndicator != null && !this.headless) {
            this.pIndicator.setProgressBar(message, this.pSessionId);
        }
    }

    static JalviewFileChooser getSVGChooser() {
        if (Jalview.isHeadlessMode()) {
            return null;
        }
        return new JalviewFileChooser(SVG_EXTENSION, SVG_DESCRIPTION);
    }

    public static enum TYPE {
        EPS("EPS", MessageManager.getString("label.eps_file"), "eps", "Encapsulated Postscript"),
        PNG("PNG", MessageManager.getString("label.png_image"), "png", "Portable  network graphics"),
        SVG("SVG", "SVG", "svg", "Scalable Vector Graphics");

        private String name;
        private String label;
        private String extension;
        private String description;

        private TYPE(String name, String label, String ext, String desc) {
            this.name = name;
            this.label = label;
            this.extension = ext;
            this.description = desc;
        }

        public String getName() {
            return this.name;
        }

        public JalviewFileChooser getFileChooser() {
            return new JalviewFileChooser(this.extension, this.description);
        }

        public String getLabel() {
            return this.label;
        }
    }
}

