/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class FileUtils {
    public static File getExecutable(String cmd, String binaryPath) {
        File file = new File(binaryPath, cmd);
        if (!file.canExecute() && !(file = new File(binaryPath, cmd + ".exe")).canExecute()) {
            file = null;
        }
        return file;
    }

    public static String getPathTo(String cmd) {
        String paths = System.getenv("PATH");
        for (String path : paths.split("\\" + File.pathSeparator)) {
            if (FileUtils.getExecutable(cmd, path) == null) continue;
            return path;
        }
        return null;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File f = File.createTempFile(prefix, suffix);
        f.deleteOnExit();
        return f;
    }

    public static List<String> findMatchingPaths(Path from, String pattern) {
        ArrayList<String> matches = new ArrayList<String>();
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("regex:" + pattern);
        try {
            Files.walk(from, new FileVisitOption[0]).filter(pathMatcher::matches).forEach(m -> matches.add(m.toString()));
        }
        catch (IOException e) {
            System.err.println("Error searching for " + pattern + " : " + e.toString());
        }
        return matches;
    }

    public static List<String> findMatches(String root, String pattern) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            Path from = Paths.get(root, new String[0]);
            FileUtils.findMatches(results, from, Arrays.asList(pattern.split("/")));
        }
        catch (Throwable e) {
            System.err.println(String.format("Error searching %s for %s: %s", root, pattern, e.toString()));
        }
        return results;
    }

    protected static void findMatches(List<String> results, Path from, List<String> patterns) {
        if (patterns.isEmpty()) {
            results.add(from.toString());
            return;
        }
        String pattern = patterns.get(0);
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(from, pattern);){
            dirStream.forEach(p -> {
                List<String> subList = patterns.subList(1, patterns.size());
                if (subList.isEmpty() || p.toFile().isDirectory()) {
                    FileUtils.findMatches(results, p, subList);
                }
            });
        }
        catch (IOException e) {
            System.err.println(String.format("Error searching %s: %s", pattern, e.toString()));
        }
    }
}

