/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import com.stevesoft.pat.Regex;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DBRefUtils {
    private static Map<String, String> canonicalSourceNameLookup = new HashMap<String, String>();
    public static DbRefComp matchNonNullonA;
    public static DbRefComp matchEitherNonNull;
    public static DbRefComp matchDbAndIdAndEitherMap;
    public static DbRefComp matchDbAndIdAndComplementaryMapList;
    public static DbRefComp matchDbAndIdAndEquivalentMapList;
    public static DbRefComp matchDbAndIdAndEitherMapOrEquivalentMapList;
    public static DbRefComp matchId;

    public static DBRefEntry[] selectRefs(DBRefEntry[] dbrefs, String[] sources) {
        if (dbrefs == null || sources == null) {
            return dbrefs;
        }
        HashSet<String> srcs = new HashSet<String>();
        for (String src : sources) {
            srcs.add(src.toUpperCase());
        }
        ArrayList<DBRefEntry> res = new ArrayList<DBRefEntry>();
        for (DBRefEntry dbr : dbrefs) {
            String source = DBRefUtils.getCanonicalName(dbr.getSource());
            if (!srcs.contains(source.toUpperCase())) continue;
            res.add(dbr);
        }
        if (res.size() > 0) {
            DBRefEntry[] reply = new DBRefEntry[res.size()];
            return res.toArray(reply);
        }
        return null;
    }

    public static String getCanonicalName(String source) {
        if (source == null) {
            return null;
        }
        String canonical = canonicalSourceNameLookup.get(source.toLowerCase());
        return canonical == null ? source : canonical;
    }

    public static List<DBRefEntry> searchRefs(DBRefEntry[] ref, DBRefEntry entry) {
        return DBRefUtils.searchRefs(ref, entry, matchDbAndIdAndEitherMapOrEquivalentMapList);
    }

    public static List<DBRefEntry> searchRefs(DBRefEntry[] refs, String accId) {
        return DBRefUtils.searchRefs(refs, new DBRefEntry("", "", accId), matchId);
    }

    static List<DBRefEntry> searchRefs(DBRefEntry[] refs, DBRefEntry entry, DbRefComp comparator) {
        ArrayList<DBRefEntry> rfs = new ArrayList<DBRefEntry>();
        if (refs == null || entry == null) {
            return rfs;
        }
        for (int i = 0; i < refs.length; ++i) {
            if (!comparator.matches(entry, refs[i])) continue;
            rfs.add(refs[i]);
        }
        return rfs;
    }

    public static DBRefEntry parseToDbRef(SequenceI seq, String dbname, String version, String acn) {
        DBRefEntry ref = null;
        if (dbname != null) {
            String locsrc = DBRefUtils.getCanonicalName(dbname);
            if (locsrc.equals("PDB")) {
                Regex r = new Regex("([0-9][0-9A-Za-z]{3})\\s*(.?)\\s*;\\s*([0-9]+)-([0-9]+)");
                if (r.search(acn.trim())) {
                    String pdbid = r.stringMatched(1);
                    String chaincode = r.stringMatched(2);
                    if (chaincode == null) {
                        chaincode = " ";
                    }
                    if (chaincode.equals(" ")) {
                        chaincode = "_";
                    }
                    ref = new DBRefEntry(locsrc, version, pdbid + chaincode);
                    PDBEntry pdbr = new PDBEntry();
                    pdbr.setId(pdbid);
                    pdbr.setType(PDBEntry.Type.PDB);
                    pdbr.setChainCode(chaincode);
                    seq.addPDBId(pdbr);
                } else {
                    System.err.println("Malformed PDB DR line:" + acn);
                }
            } else {
                ref = new DBRefEntry(locsrc, version, acn);
            }
        }
        if (ref != null) {
            seq.addDBRef(ref);
        }
        return ref;
    }

    public static boolean nullOrEqual(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return true;
        }
        return o1.equals(o2);
    }

    public static boolean nullOrEqualSource(String o1, String o2) {
        if (o1 == null || o2 == null) {
            return true;
        }
        return DBRefUtils.getCanonicalName(o1).equals(DBRefUtils.getCanonicalName(o2));
    }

    public static DBRefEntry[] selectDbRefs(boolean selectDna, DBRefEntry[] refs) {
        return DBRefUtils.selectRefs(refs, selectDna ? DBRefSource.DNACODINGDBS : DBRefSource.PROTEINDBS);
    }

    public static List<DBRefEntry> searchRefsForSource(DBRefEntry[] dbRefs, String source) {
        ArrayList<DBRefEntry> matches = new ArrayList<DBRefEntry>();
        if (dbRefs != null && source != null) {
            for (DBRefEntry dbref : dbRefs) {
                if (!source.equalsIgnoreCase(dbref.getSource())) continue;
                matches.add(dbref);
            }
        }
        return matches;
    }

    public static void ensurePrimaries(SequenceI sequence) {
        List<DBRefEntry> pr = sequence.getPrimaryDBRefs();
        if (pr.size() == 0) {
            return;
        }
        ArrayList<DBRefEntry> selfs = new ArrayList<DBRefEntry>();
        DBRefEntry[] selfArray = DBRefUtils.selectDbRefs(!sequence.isProtein(), sequence.getDBRefs());
        if (selfArray == null || selfArray.length == 0) {
            return;
        }
        selfs.addAll(Arrays.asList(selfArray));
        for (DBRefEntry p : pr) {
            while (selfs.contains(p)) {
                selfs.remove(p);
            }
        }
        ArrayList<DBRefEntry> toPromote = new ArrayList<DBRefEntry>();
        for (DBRefEntry p : pr) {
            DBRefEntry[] candidates;
            ArrayList<String> promType = new ArrayList<String>();
            if (sequence.isProtein()) {
                switch (DBRefUtils.getCanonicalName(p.getSource())) {
                    case "UNIPROT": {
                        promType.add("ENSEMBL");
                        break;
                    }
                    case "ENSEMBL": {
                        promType.add("UNIPROT");
                    }
                }
            }
            if ((candidates = DBRefUtils.selectRefs(selfs.toArray(new DBRefEntry[0]), promType.toArray(new String[0]))) == null) continue;
            for (DBRefEntry cand : candidates) {
                if (cand.hasMap() && (cand.getMap().getTo() != null && cand.getMap().getTo() != sequence || cand.getMap().getMap().getFromLowest() != sequence.getStart() && cand.getMap().getMap().getFromHighest() != sequence.getEnd())) continue;
                cand.setVersion(p.getVersion() + " (promoted)");
                selfs.remove(cand);
                toPromote.add(cand);
                if (cand.isPrimaryCandidate()) continue;
                System.out.println("Warning: Couldn't promote dbref " + cand.toString() + " for sequence " + sequence.toString());
            }
        }
    }

    static {
        canonicalSourceNameLookup.put("uniprotkb/swiss-prot", "UNIPROT");
        canonicalSourceNameLookup.put("uniprotkb/trembl", "UNIPROT");
        canonicalSourceNameLookup.put("uniprot/sptrembl", "UNIPROT");
        canonicalSourceNameLookup.put("uniprot/swissprot", "UNIPROT");
        canonicalSourceNameLookup.put("pdb", "PDB");
        canonicalSourceNameLookup.put("ensembl", "ENSEMBL");
        canonicalSourceNameLookup.put("ensembl-tr", "ENSEMBL");
        canonicalSourceNameLookup.put("ensembl-gn", "ENSEMBL");
        Set<String> keys = canonicalSourceNameLookup.keySet();
        for (String k : keys) {
            canonicalSourceNameLookup.put(k.toLowerCase(), canonicalSourceNameLookup.get(k));
        }
        matchNonNullonA = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb) {
                return !(refa.getSource() != null && !DBRefUtils.getCanonicalName(refb.getSource()).equals(DBRefUtils.getCanonicalName(refa.getSource())) || refa.getVersion() != null && !refb.getVersion().equals(refa.getVersion()) || refa.getAccessionId() != null && !refb.getAccessionId().equals(refa.getAccessionId()) || refa.getMap() != null && (refb.getMap() == null || !refb.getMap().equals(refa.getMap())));
            }
        };
        matchEitherNonNull = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb) {
                return DBRefUtils.nullOrEqualSource(refa.getSource(), refb.getSource()) && DBRefUtils.nullOrEqual(refa.getVersion(), refb.getVersion()) && DBRefUtils.nullOrEqual(refa.getAccessionId(), refb.getAccessionId()) && DBRefUtils.nullOrEqual(refa.getMap(), refb.getMap());
            }
        };
        matchDbAndIdAndEitherMap = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb) {
                return refa.getSource() != null && refb.getSource() != null && DBRefUtils.getCanonicalName(refb.getSource()).equals(DBRefUtils.getCanonicalName(refa.getSource())) && (refa.getAccessionId() != null && refb.getAccessionId() != null || refb.getAccessionId().equals(refa.getAccessionId())) && (refa.getMap() == null || refb.getMap() == null || refa.getMap() != null && refb.getMap() != null && refb.getMap().equals(refa.getMap()));
            }
        };
        matchDbAndIdAndComplementaryMapList = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb) {
                return refa.getSource() != null && refb.getSource() != null && DBRefUtils.getCanonicalName(refb.getSource()).equals(DBRefUtils.getCanonicalName(refa.getSource())) && (refa.getAccessionId() != null && refb.getAccessionId() != null || refb.getAccessionId().equals(refa.getAccessionId())) && (refa.getMap() == null && refb.getMap() == null || refa.getMap() != null && refb.getMap() != null) && (refb.getMap().getMap() == null && refa.getMap().getMap() == null || refb.getMap().getMap() != null && refa.getMap().getMap() != null && refb.getMap().getMap().getInverse().equals(refa.getMap().getMap()));
            }
        };
        matchDbAndIdAndEquivalentMapList = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb) {
                if (refa.getSource() != null && refb.getSource() != null && DBRefUtils.getCanonicalName(refb.getSource()).equals(DBRefUtils.getCanonicalName(refa.getSource())) && (refa.getAccessionId() != null && refb.getAccessionId() != null || refb.getAccessionId().equals(refa.getAccessionId()))) {
                    if (refa.getMap() == null && refb.getMap() == null) {
                        return true;
                    }
                    if (refa.getMap() != null && refb.getMap() != null && (refb.getMap().getMap() == null && refa.getMap().getMap() == null || refb.getMap().getMap() != null && refa.getMap().getMap() != null && refb.getMap().getMap().equals(refa.getMap().getMap()))) {
                        return true;
                    }
                }
                return false;
            }
        };
        matchDbAndIdAndEitherMapOrEquivalentMapList = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb) {
                if (refa.getSource() != null && refb.getSource() != null && DBRefUtils.getCanonicalName(refb.getSource()).equals(DBRefUtils.getCanonicalName(refa.getSource())) && (refa.getAccessionId() == null || refa.getAccessionId().equals(refb.getAccessionId()))) {
                    if (refa.getMap() == null || refb.getMap() == null) {
                        return true;
                    }
                    if (refa.getMap() != null && refb.getMap() != null && refb.getMap().getMap() == null && refa.getMap().getMap() == null || refb.getMap().getMap() != null && refa.getMap().getMap() != null && refb.getMap().getMap().equals(refa.getMap().getMap())) {
                        return true;
                    }
                }
                return false;
            }
        };
        matchId = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb) {
                return refa.getAccessionId() != null && refb.getAccessionId() != null && refb.getAccessionId().equals(refa.getAccessionId());
            }
        };
    }

    static interface DbRefComp {
        public boolean matches(DBRefEntry var1, DBRefEntry var2);
    }
}

