/*
 * Decompiled with CFR 0.152.
 */
package jalview.urls;

import jalview.urls.CustomUrlProvider;
import jalview.urls.UrlLinkDisplay;
import jalview.urls.api.UrlProviderI;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class UrlProvider
implements UrlProviderI {
    private List<UrlProviderI> providers;
    private UrlProviderI customProvider;

    public UrlProvider(String defaultUrlString, List<UrlProviderI> allProviders) {
        this.providers = allProviders;
        this.customProvider = this.findCustomProvider();
        if (!this.contains(defaultUrlString)) {
            this.choosePrimaryUrl();
        } else {
            this.setPrimaryUrl(defaultUrlString);
        }
    }

    private UrlProviderI findCustomProvider() {
        for (UrlProviderI p : this.providers) {
            if (!(p instanceof CustomUrlProvider)) continue;
            return p;
        }
        System.out.println("Error initialising UrlProvider - no custom url provider");
        return null;
    }

    @Override
    public boolean setPrimaryUrl(String id) {
        boolean outcome = false;
        for (UrlProviderI p : this.providers) {
            if (!p.setPrimaryUrl(id)) continue;
            outcome = true;
        }
        if (!outcome) {
            throw new IllegalArgumentException();
        }
        return outcome;
    }

    @Override
    public boolean contains(String id) {
        boolean outcome = false;
        for (UrlProviderI p : this.providers) {
            if (!p.contains(id)) continue;
            outcome = true;
        }
        return outcome;
    }

    @Override
    public String writeUrlsAsString(boolean selected) {
        Object result = "";
        for (UrlProviderI p : this.providers) {
            String next = p.writeUrlsAsString(selected);
            if (next.isEmpty()) continue;
            result = (String)result + next;
            result = (String)result + "|";
        }
        if (!((String)result).isEmpty()) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        return result;
    }

    public Vector<String> getLinksForMenu() {
        Vector<String> fullLinks = new Vector<String>();
        for (UrlProviderI p : this.providers) {
            List<String> links = p.getLinksForMenu();
            if (links == null) continue;
            fullLinks.addAll(links);
        }
        return fullLinks;
    }

    @Override
    public List<UrlLinkDisplay> getLinksForTable() {
        ArrayList<UrlLinkDisplay> displayLinks = new ArrayList<UrlLinkDisplay>();
        for (UrlProviderI p : this.providers) {
            displayLinks.addAll(p.getLinksForTable());
        }
        return displayLinks;
    }

    @Override
    public void setUrlData(List<UrlLinkDisplay> links) {
        for (UrlProviderI p : this.providers) {
            p.setUrlData(links);
        }
    }

    @Override
    public String getPrimaryUrl(String seqid) {
        String link = null;
        for (UrlProviderI p : this.providers) {
            if (p.getPrimaryUrl(seqid) == null) continue;
            link = p.getPrimaryUrl(seqid);
            break;
        }
        return link;
    }

    @Override
    public String getPrimaryUrlId() {
        String id = null;
        for (UrlProviderI p : this.providers) {
            if (p.getPrimaryUrlId() == null) continue;
            id = p.getPrimaryUrlId();
            break;
        }
        return id;
    }

    @Override
    public String getPrimaryTarget(String seqid) {
        String target = null;
        for (UrlProviderI p : this.providers) {
            if (p.getPrimaryTarget(seqid) == null) continue;
            target = p.getPrimaryTarget(seqid);
            break;
        }
        return target;
    }

    @Override
    public String choosePrimaryUrl() {
        return this.customProvider.choosePrimaryUrl();
    }

    @Override
    public boolean isUserEntry(String id) {
        return this.customProvider.isUserEntry(id);
    }
}

