/*
 * Decompiled with CFR 0.152.
 */
package jalview.urls;

import jalview.urls.IdOrgSettings;
import jalview.urls.UrlLinkDisplay;
import jalview.urls.UrlProviderImpl;
import jalview.util.UrlLink;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class IdentifiersUrlProvider
extends UrlProviderImpl {
    private static final String LOCAL_KEY = "Local";
    private static final String ID_ORG_KEY = "identifiers.org";
    private HashMap<String, UrlLink> urls = this.readIdentifiers(IdOrgSettings.getDownloadLocation());
    private ArrayList<String> selectedUrls = new ArrayList();

    public IdentifiersUrlProvider(String cachedUrlList) {
        this.checkSelectionMatchesUrls(cachedUrlList);
    }

    private HashMap<String, UrlLink> readIdentifiers(String idFileName) {
        JSONParser parser = new JSONParser();
        HashMap<String, UrlLink> idData = new HashMap<String, UrlLink>();
        try {
            FileReader reader = new FileReader(idFileName);
            String key = "";
            JSONObject obj = (JSONObject)parser.parse((Reader)reader);
            if (obj.containsKey((Object)ID_ORG_KEY)) {
                key = ID_ORG_KEY;
            } else if (obj.containsKey((Object)LOCAL_KEY)) {
                key = LOCAL_KEY;
            } else {
                System.out.println("Unexpected key returned from identifiers jalview service");
                return idData;
            }
            JSONArray jsonarray = (JSONArray)obj.get((Object)key);
            for (int i = 0; i < jsonarray.size(); ++i) {
                JSONObject item = (JSONObject)jsonarray.get(i);
                String url = (String)item.get((Object)"url") + "/$DB_ACCESSION$";
                UrlLink link = new UrlLink((String)item.get((Object)"name"), url, (String)item.get((Object)"prefix"));
                idData.put((String)item.get((Object)"id"), link);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            idData.clear();
        }
        catch (IOException e) {
            e.printStackTrace();
            idData.clear();
        }
        catch (ParseException e) {
            e.printStackTrace();
            idData.clear();
        }
        return idData;
    }

    private void checkSelectionMatchesUrls(String cachedUrlList) {
        StringTokenizer st = new StringTokenizer(cachedUrlList, "|");
        while (st.hasMoreElements()) {
            String id = st.nextToken();
            if (!this.isMiriamId(id) || !this.urls.containsKey(id)) continue;
            this.selectedUrls.add(id);
        }
        this.setPrimaryUrl(this.primaryUrl);
    }

    @Override
    public boolean setPrimaryUrl(String id) {
        this.primaryUrl = this.urls.containsKey(id) ? id : null;
        return this.urls.containsKey(id);
    }

    @Override
    public String writeUrlsAsString(boolean selected) {
        if (!selected) {
            return "";
        }
        StringBuffer links = new StringBuffer();
        if (!this.selectedUrls.isEmpty()) {
            for (String k : this.selectedUrls) {
                links.append(k);
                links.append("|");
            }
            links.setLength(links.length() - 1);
        }
        return links.toString();
    }

    @Override
    public List<String> getLinksForMenu() {
        ArrayList<String> links = new ArrayList<String>();
        for (String key : this.selectedUrls) {
            links.add(this.urls.get(key).toStringWithTarget());
        }
        return links;
    }

    @Override
    public List<UrlLinkDisplay> getLinksForTable() {
        return super.getLinksForTable(this.urls, this.selectedUrls, false);
    }

    @Override
    public void setUrlData(List<UrlLinkDisplay> links) {
        this.selectedUrls = new ArrayList();
        for (UrlLinkDisplay link : links) {
            if (!this.isMiriamId(link.getId()) || !this.urls.containsKey(link.getId())) continue;
            if (link.getIsSelected()) {
                this.selectedUrls.add(link.getId());
            }
            if (!link.getIsPrimary()) continue;
            this.setPrimaryUrl(link.getId());
        }
    }

    @Override
    public String getPrimaryUrl(String seqid) {
        return super.getPrimaryUrl(seqid, this.urls);
    }

    @Override
    public String getPrimaryUrlId() {
        return this.primaryUrl;
    }

    @Override
    public String getPrimaryTarget(String seqid) {
        return null;
    }

    @Override
    public String choosePrimaryUrl() {
        return null;
    }

    @Override
    public boolean contains(String id) {
        return this.urls.containsKey(id);
    }
}

