/*
 * Decompiled with CFR 0.152.
 */
package jalview.structures.models;

import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.api.SequenceRenderer;
import jalview.api.StructureSelectionManagerProvider;
import jalview.api.structures.JalviewStructureDisplayI;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.io.DataSourceType;
import jalview.schemes.ColourSchemeI;
import jalview.structure.AtomSpec;
import jalview.structure.StructureListener;
import jalview.structure.StructureMapping;
import jalview.structure.StructureMappingcommandSet;
import jalview.structure.StructureSelectionManager;
import jalview.structures.models.SequenceStructureBindingModel;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public abstract class AAStructureBindingModel
extends SequenceStructureBindingModel
implements StructureListener,
StructureSelectionManagerProvider {
    private StructureSelectionManager ssm;
    private PDBEntry[] pdbEntry;
    private SequenceI[][] sequence;
    private String[][] chains;
    DataSourceType protocol = null;
    protected boolean colourBySequence = true;
    private boolean nucleotide;
    private boolean finishedInit = false;
    protected String[] modelFileNames = null;
    public String fileLoadingError;

    public AAStructureBindingModel(StructureSelectionManager ssm, SequenceI[][] seqs) {
        this.ssm = ssm;
        this.sequence = seqs;
    }

    public AAStructureBindingModel(StructureSelectionManager ssm, PDBEntry[] pdbentry, SequenceI[][] sequenceIs, DataSourceType protocol) {
        this.ssm = ssm;
        this.sequence = sequenceIs;
        this.nucleotide = Comparison.isNucleotide(sequenceIs);
        this.pdbEntry = pdbentry;
        this.protocol = protocol;
        this.resolveChains();
    }

    private boolean resolveChains() {
        int chainmaps = 0;
        String[][] newchains = new String[this.pdbEntry.length][];
        int pe = 0;
        for (PDBEntry pdb : this.pdbEntry) {
            SequenceI[] seqsForPdb = this.sequence[pe];
            if (seqsForPdb == null) continue;
            newchains[pe] = new String[seqsForPdb.length];
            int se = 0;
            for (SequenceI asq : seqsForPdb) {
                SequenceI sq;
                String chain = this.chains != null && this.chains[pe] != null ? this.chains[pe][se] : null;
                SequenceI sequenceI = sq = asq.getDatasetSequence() == null ? asq : asq.getDatasetSequence();
                if (sq.getAllPDBEntries() != null) {
                    for (PDBEntry pdbentry : sq.getAllPDBEntries()) {
                        String chaincode;
                        if (pdb.getFile() == null || pdbentry.getFile() == null || !pdb.getFile().equals(pdbentry.getFile()) || (chaincode = pdbentry.getChainCode()) == null || chaincode.length() <= 0) continue;
                        chain = chaincode;
                        ++chainmaps;
                        break;
                    }
                }
                newchains[pe][se] = chain;
                ++se;
            }
            ++pe;
        }
        this.chains = newchains;
        return chainmaps > 0;
    }

    public StructureSelectionManager getSsm() {
        return this.ssm;
    }

    public PDBEntry getPdbEntry(int i) {
        return this.pdbEntry != null && this.pdbEntry.length > i ? this.pdbEntry[i] : null;
    }

    public boolean hasPdbId(String pdbId) {
        if (this.pdbEntry != null) {
            for (PDBEntry pdb : this.pdbEntry) {
                if (!pdb.getId().equals(pdbId)) continue;
                return true;
            }
        }
        return false;
    }

    public int getPdbCount() {
        return this.pdbEntry == null ? 0 : this.pdbEntry.length;
    }

    public SequenceI[][] getSequence() {
        return this.sequence;
    }

    public String[][] getChains() {
        return this.chains;
    }

    public DataSourceType getProtocol() {
        return this.protocol;
    }

    protected void setPdbentry(PDBEntry[] pdbentry) {
        this.pdbEntry = pdbentry;
    }

    protected void setSequence(SequenceI[][] sequence) {
        this.sequence = sequence;
    }

    protected void setChains(String[][] chains) {
        this.chains = chains;
    }

    public String getViewerTitle(String viewerName, boolean verbose) {
        if (this.getSequence() == null || this.getSequence().length < 1 || this.getPdbCount() < 1 || this.getSequence()[0].length < 1) {
            return "Jalview " + viewerName + " Window";
        }
        StringBuilder title = new StringBuilder(64);
        PDBEntry pdbe = this.getPdbEntry(0);
        title.append(viewerName + " view for " + this.getSequence()[0][0].getName() + ":" + pdbe.getId());
        if (verbose) {
            String chain;
            String method = (String)pdbe.getProperty("method");
            if (method != null) {
                title.append(" Method: ").append(method);
            }
            if ((chain = (String)pdbe.getProperty("chains")) != null) {
                title.append(" Chain:").append(chain);
            }
        }
        return title.toString();
    }

    protected void releaseUIResources() {
    }

    public boolean isColourBySequence() {
        return this.colourBySequence;
    }

    public void setColourBySequence(boolean colourBySequence) {
        this.colourBySequence = colourBySequence;
    }

    protected void addSequenceAndChain(int pe, SequenceI[] seq, String[] tchain) {
        int i;
        if (pe < 0 || pe >= this.getPdbCount()) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_no_pdbentry_from_index", Integer.valueOf(pe).toString()));
        }
        String nullChain = "TheNullChain";
        ArrayList<SequenceI> s = new ArrayList<SequenceI>();
        ArrayList<String> c = new ArrayList<String>();
        if (this.getChains() == null) {
            this.setChains(new String[this.getPdbCount()][]);
        }
        if (this.getSequence()[pe] != null) {
            for (i = 0; i < this.getSequence()[pe].length; ++i) {
                s.add(this.getSequence()[pe][i]);
                if (this.getChains()[pe] != null) {
                    if (i < this.getChains()[pe].length) {
                        c.add(this.getChains()[pe][i]);
                        continue;
                    }
                    c.add("TheNullChain");
                    continue;
                }
                if (tchain == null || tchain.length <= 0) continue;
                c.add("TheNullChain");
            }
        }
        for (i = 0; i < seq.length; ++i) {
            if (s.contains(seq[i])) continue;
            s.add(seq[i]);
            if (tchain == null || i >= tchain.length) continue;
            c.add(tchain[i] == null ? "TheNullChain" : tchain[i]);
        }
        SequenceI[] tmp = s.toArray(new SequenceI[s.size()]);
        this.getSequence()[pe] = tmp;
        if (c.size() > 0) {
            String[] tch = c.toArray(new String[c.size()]);
            for (int i2 = 0; i2 < tch.length; ++i2) {
                if (tch[i2] != "TheNullChain") continue;
                tch[i2] = null;
            }
            this.getChains()[pe] = tch;
        } else {
            this.getChains()[pe] = null;
        }
    }

    public synchronized PDBEntry[] addSequenceAndChain(PDBEntry[] pdbe, SequenceI[][] seq, String[][] chns) {
        int i;
        ArrayList<PDBEntry> v = new ArrayList<PDBEntry>();
        ArrayList<int[]> rtn = new ArrayList<int[]>();
        for (i = 0; i < this.getPdbCount(); ++i) {
            v.add(this.getPdbEntry(i));
        }
        for (i = 0; i < pdbe.length; ++i) {
            int r = v.indexOf(pdbe[i]);
            if (r == -1 || r >= this.getPdbCount()) {
                rtn.add(new int[]{v.size(), i});
                v.add(pdbe[i]);
                continue;
            }
            this.addSequenceAndChain(r, seq[i], chns[i]);
        }
        pdbe = v.toArray(new PDBEntry[v.size()]);
        this.setPdbentry(pdbe);
        if (rtn.size() > 0) {
            SequenceI[][] sqs = new SequenceI[this.getPdbCount()][];
            String[][] sch = new String[this.getPdbCount()][];
            System.arraycopy(this.getSequence(), 0, sqs, 0, this.getSequence().length);
            System.arraycopy(this.getChains(), 0, sch, 0, this.getChains().length);
            this.setSequence(sqs);
            this.setChains(sch);
            pdbe = new PDBEntry[rtn.size()];
            for (int r = 0; r < pdbe.length; ++r) {
                int[] stri = (int[])rtn.get(r);
                pdbe[r] = this.getPdbEntry(stri[0]);
                this.addSequenceAndChain(stri[0], seq[stri[1]], chns[stri[1]]);
            }
        } else {
            pdbe = null;
        }
        return pdbe;
    }

    public void addSequence(int pe, SequenceI[] seq) {
        this.addSequenceAndChain(pe, seq, null);
    }

    public void addSequenceForStructFile(String pdbFile, SequenceI[] seq) {
        for (int pe = 0; pe < this.getPdbCount(); ++pe) {
            if (!this.getPdbEntry(pe).getFile().equals(pdbFile)) continue;
            this.addSequence(pe, seq);
        }
    }

    @Override
    public abstract void highlightAtoms(List<AtomSpec> var1);

    protected boolean isNucleotide() {
        return this.nucleotide;
    }

    public String printMappings() {
        if (this.pdbEntry == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(128);
        for (int pdbe = 0; pdbe < this.getPdbCount(); ++pdbe) {
            String pdbfile = this.getPdbEntry(pdbe).getFile();
            List<SequenceI> seqs = Arrays.asList(this.getSequence()[pdbe]);
            sb.append(this.getSsm().printMappings(pdbfile, seqs));
        }
        return sb.toString();
    }

    protected int getMappedPosition(SequenceI seq, int alignedPos, StructureMapping mapping) {
        if (alignedPos >= seq.getLength()) {
            return -1;
        }
        if (Comparison.isGap(seq.getCharAt(alignedPos))) {
            return -1;
        }
        int seqPos = seq.findPosition(alignedPos);
        int pos = mapping.getPDBResNum(seqPos);
        return pos;
    }

    protected int findSuperposableResidues(AlignmentI alignment, BitSet matched, SuperposeData[] structures) {
        int refStructure = -1;
        String[] files = this.getStructureFiles();
        if (files == null) {
            return -1;
        }
        for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
            StructureMapping[] mappings = this.getSsm().getMapping(files[pdbfnum]);
            int lastPos = -1;
            int seqCountForPdbFile = this.getSequence()[pdbfnum].length;
            block1: for (int s = 0; s < seqCountForPdbFile; ++s) {
                for (StructureMapping mapping : mappings) {
                    SequenceI theSequence = this.getSequence()[pdbfnum][s];
                    if (mapping.getSequence() != theSequence || alignment.findIndex(theSequence) <= -1) continue;
                    if (refStructure < 0) {
                        refStructure = pdbfnum;
                    }
                    for (int r = 0; r < alignment.getWidth(); ++r) {
                        if (!matched.get(r)) continue;
                        int pos = this.getMappedPosition(theSequence, r, mapping);
                        if (pos < 1 || pos == lastPos) {
                            matched.clear(r);
                            continue;
                        }
                        lastPos = pos;
                        structures[pdbfnum].pdbResNo[r] = pos;
                    }
                    String chain = mapping.getChain();
                    if (chain != null && chain.trim().length() > 0) {
                        structures[pdbfnum].chain = chain;
                    }
                    structures[pdbfnum].pdbId = mapping.getPdbId();
                    structures[pdbfnum].isRna = theSequence.getRNA() != null;
                    s = seqCountForPdbFile;
                    continue block1;
                }
            }
        }
        return refStructure;
    }

    protected boolean waitForFileLoad(String[] files) {
        long starttime = System.currentTimeMillis();
        long endTime = (long)(10000 + 1000 * files.length) + starttime;
        String notLoaded = null;
        boolean waiting = true;
        while (waiting && System.currentTimeMillis() < endTime) {
            waiting = false;
            String[] stringArray = files;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String file;
                notLoaded = file = stringArray[i];
                if (file == null) continue;
                try {
                    StructureMapping[] sm = this.getSsm().getMapping(file);
                    if (sm != null && sm.length != 0) continue;
                    waiting = true;
                    continue;
                }
                catch (Throwable x) {
                    waiting = true;
                }
            }
        }
        if (waiting) {
            System.err.println("Timed out waiting for structure viewer to load file " + notLoaded);
            return false;
        }
        return true;
    }

    @Override
    public boolean isListeningFor(SequenceI seq) {
        if (this.sequence != null) {
            for (SequenceI[] seqs : this.sequence) {
                if (seqs == null) continue;
                for (SequenceI s : seqs) {
                    if (s != seq && (s.getDatasetSequence() == null || s.getDatasetSequence() != seq.getDatasetSequence())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFinishedInit() {
        return this.finishedInit;
    }

    public void setFinishedInit(boolean fi) {
        this.finishedInit = fi;
    }

    public abstract List<String> getChainNames();

    public JalviewStructureDisplayI getViewer() {
        return null;
    }

    public abstract void setJalviewColourScheme(ColourSchemeI var1);

    public abstract String superposeStructures(AlignmentI[] var1, int[] var2, HiddenColumns[] var3);

    public abstract void setBackgroundColour(Color var1);

    protected abstract StructureMappingcommandSet[] getColourBySequenceCommands(String[] var1, SequenceRenderer var2, AlignmentViewPanel var3);

    public abstract SequenceRenderer getSequenceRenderer(AlignmentViewPanel var1);

    protected abstract void colourBySequence(StructureMappingcommandSet[] var1);

    public abstract void colourByChain();

    public abstract void colourByCharge();

    public void colourBySequence(AlignmentViewPanel alignmentv) {
        if (!this.colourBySequence || !this.isLoadingFinished()) {
            return;
        }
        if (this.getSsm() == null) {
            return;
        }
        String[] files = this.getStructureFiles();
        SequenceRenderer sr = this.getSequenceRenderer(alignmentv);
        StructureMappingcommandSet[] colourBySequenceCommands = this.getColourBySequenceCommands(files, sr, alignmentv);
        this.colourBySequence(colourBySequenceCommands);
    }

    public boolean hasFileLoadingError() {
        return this.fileLoadingError != null && this.fileLoadingError.length() > 0;
    }

    public abstract FeatureRenderer getFeatureRenderer(AlignmentViewPanel var1);

    protected class SuperposeData {
        public String filename;
        public String pdbId;
        public String chain = "";
        public boolean isRna;
        public int[] pdbResNo;

        public SuperposeData(int width) {
            this.pdbResNo = new int[width];
        }
    }
}

