/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.JalviewColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.schemes.ScoreColourScheme;
import java.awt.Color;

public class HydrophobicColourScheme
extends ScoreColourScheme {
    public HydrophobicColourScheme() {
        super(ResidueProperties.aaIndex, ResidueProperties.hyd, -3.9, 4.5);
    }

    @Override
    public Color makeColour(float c) {
        return new Color(c, 0.0f, 1.0f - c);
    }

    @Override
    public boolean isPeptideSpecific() {
        return true;
    }

    @Override
    public String getSchemeName() {
        return JalviewColourScheme.Hydrophobic.toString();
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI coll) {
        return new HydrophobicColourScheme();
    }
}

