/*
 * Decompiled with CFR 0.152.
 */
package jalview.project;

import jalview.analysis.AlignSeq;
import jalview.analysis.Conservation;
import jalview.analysis.PCA;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.analysis.scoremodels.SimilarityParams;
import jalview.api.FeatureColourI;
import jalview.api.ViewStyleI;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.Cache;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.GeneLocus;
import jalview.datamodel.GraphLine;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.Mapping;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Point;
import jalview.datamodel.RnaViewerModel;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequencePoint;
import jalview.datamodel.StructureViewerModel;
import jalview.datamodel.features.FeatureMatcherI;
import jalview.datamodel.features.FeatureMatcherSet;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.ext.varna.RnaModel;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppVarna;
import jalview.gui.ChimeraViewFrame;
import jalview.gui.Desktop;
import jalview.gui.FeatureRenderer;
import jalview.gui.JvOptionPane;
import jalview.gui.OOMWarning;
import jalview.gui.PCAPanel;
import jalview.gui.PaintRefresher;
import jalview.gui.SplitFrame;
import jalview.gui.StructureViewer;
import jalview.gui.StructureViewerBase;
import jalview.gui.TreePanel;
import jalview.io.BackupFiles;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.HMMFile;
import jalview.io.NewickFile;
import jalview.math.Matrix;
import jalview.math.MatrixI;
import jalview.math.RotatableMatrix;
import jalview.renderer.ResidueShaderI;
import jalview.schemes.AnnotationColourGradient;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.FeatureColour;
import jalview.schemes.ResidueProperties;
import jalview.schemes.UserColourScheme;
import jalview.structure.StructureSelectionManager;
import jalview.structures.models.AAStructureBindingModel;
import jalview.util.Comparison;
import jalview.util.Format;
import jalview.util.MapList;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.QuickSort;
import jalview.util.StringUtils;
import jalview.util.jarInputStreamProvider;
import jalview.util.matcher.Condition;
import jalview.viewmodel.AlignmentViewport;
import jalview.viewmodel.PCAModel;
import jalview.viewmodel.ViewportRanges;
import jalview.viewmodel.seqfeatures.FeatureRendererSettings;
import jalview.viewmodel.seqfeatures.FeaturesDisplayed;
import jalview.ws.jws2.Jws2Discoverer;
import jalview.ws.jws2.dm.AAConSettings;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.AutoCalcSetting;
import jalview.ws.params.WsParamSetI;
import jalview.xml.binding.jalview.AlcodonFrame;
import jalview.xml.binding.jalview.Annotation;
import jalview.xml.binding.jalview.AnnotationColourScheme;
import jalview.xml.binding.jalview.AnnotationElement;
import jalview.xml.binding.jalview.DoubleMatrix;
import jalview.xml.binding.jalview.DoubleVector;
import jalview.xml.binding.jalview.Feature;
import jalview.xml.binding.jalview.FeatureMatcher;
import jalview.xml.binding.jalview.FeatureMatcherSet;
import jalview.xml.binding.jalview.FilterBy;
import jalview.xml.binding.jalview.JalviewModel;
import jalview.xml.binding.jalview.JalviewUserColours;
import jalview.xml.binding.jalview.MapListType;
import jalview.xml.binding.jalview.NoValueColour;
import jalview.xml.binding.jalview.ObjectFactory;
import jalview.xml.binding.jalview.PcaDataType;
import jalview.xml.binding.jalview.Pdbentry;
import jalview.xml.binding.jalview.Sequence;
import jalview.xml.binding.jalview.SequenceSet;
import jalview.xml.binding.jalview.ThresholdType;
import jalview.xml.binding.jalview.VAMSAS;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class Jalview2XML {
    private static final String VIEWER_PREFIX = "viewer_";
    private static final String RNA_PREFIX = "rna_";
    private static final String HMMER_PREFIX = "hmmer_";
    private static final String UTF_8 = "UTF-8";
    private static final String UNIQSEQSETID = "uniqueSeqSetId.";
    private int counter = 0;
    IdentityHashMap<SequenceI, String> seqsToIds = null;
    Map<String, SequenceI> seqRefIds = null;
    Map<String, SequenceI> incompleteSeqs = null;
    List<SeqFref> frefedSequence = null;
    boolean raiseGUI = true;
    private Map<JalviewModel.Viewport, AlignFrame> splitFrameCandidates = new HashMap<JalviewModel.Viewport, AlignFrame>();
    private Map<RnaModel, String> rnaSessions = new HashMap<RnaModel, String>();
    Map<String, AlignViewport> viewportsAdded = new HashMap<String, AlignViewport>();
    Map<String, AlignmentAnnotation> annotationIds = new HashMap<String, AlignmentAnnotation>();
    String uniqueSetSuffix = "";
    List<String> pdbfiles = null;
    IdentityHashMap jv2vobj = null;
    private Hashtable vobj2jv;
    String errorMessage = null;
    public boolean attemptversion1parse = false;
    Map<String, String> alreadyLoadedPDB = new HashMap<String, String>();
    private final boolean updateLocalViews = false;
    Vector<JalviewStructureDisplayI> newStructureViewers = null;
    Hashtable skipList = null;
    HashMap<String, AlignmentI> seqToDataset = new HashMap();
    Hashtable<String, AlignmentI> datasetIds = null;
    IdentityHashMap<AlignmentI, String> dataset2Ids = null;
    private Hashtable jvids2vobj;

    public static boolean safeBoolean(Boolean b) {
        return b == null ? false : b;
    }

    public static int safeInt(Integer i) {
        return i == null ? 0 : i;
    }

    public static float safeFloat(Float f) {
        return f == null ? 0.0f : f.floatValue();
    }

    String seqHash(SequenceI sq) {
        if (this.seqsToIds == null) {
            this.initSeqRefs();
        }
        if (this.seqsToIds.containsKey(sq)) {
            return this.seqsToIds.get(sq);
        }
        Object key = "sq" + (this.seqsToIds.size() + 1);
        key = this.makeHashCode(sq, (String)key);
        this.seqsToIds.put(sq, (String)key);
        return key;
    }

    void initSeqRefs() {
        if (this.seqsToIds == null) {
            this.seqsToIds = new IdentityHashMap();
        }
        if (this.seqRefIds == null) {
            this.seqRefIds = new HashMap<String, SequenceI>();
        }
        if (this.incompleteSeqs == null) {
            this.incompleteSeqs = new HashMap<String, SequenceI>();
        }
        if (this.frefedSequence == null) {
            this.frefedSequence = new ArrayList<SeqFref>();
        }
    }

    public Jalview2XML() {
    }

    public Jalview2XML(boolean raiseGUI) {
        this.raiseGUI = raiseGUI;
    }

    public SeqFref newMappingRef(String sref, final Mapping _jmap) {
        SeqFref fref = new SeqFref(sref, "Mapping"){
            public Mapping jmap;
            {
                super(_sref, type);
                this.jmap = _jmap;
            }

            @Override
            boolean resolve() {
                SequenceI seq = this.getSrefDatasetSeq();
                if (seq == null) {
                    return false;
                }
                this.jmap.setTo(seq);
                return true;
            }
        };
        return fref;
    }

    public SeqFref newAlcodMapRef(String sref, final AlignedCodonFrame _cf, final Mapping _jmap) {
        SeqFref fref = new SeqFref(sref, "Codon Frame"){
            AlignedCodonFrame cf;
            public Mapping mp;
            {
                super(_sref, type);
                this.cf = _cf;
                this.mp = _jmap;
            }

            @Override
            public boolean isResolvable() {
                return super.isResolvable() && this.mp.getTo() != null;
            }

            @Override
            boolean resolve() {
                SequenceI seq = this.getSrefDatasetSeq();
                if (seq == null) {
                    return false;
                }
                this.cf.addMap(seq, this.mp.getTo(), this.mp.getMap());
                return true;
            }
        };
        return fref;
    }

    public void resolveFrefedSequences() {
        Iterator<SeqFref> nextFref = this.frefedSequence.iterator();
        int toresolve = this.frefedSequence.size();
        int unresolved = 0;
        int failedtoresolve = 0;
        while (nextFref.hasNext()) {
            SeqFref ref = nextFref.next();
            if (ref.isResolvable()) {
                try {
                    if (ref.resolve()) {
                        nextFref.remove();
                        continue;
                    }
                    ++failedtoresolve;
                }
                catch (Exception x) {
                    System.err.println("IMPLEMENTATION ERROR: Failed to resolve forward reference for sequence " + ref.getSref());
                    x.printStackTrace();
                    ++failedtoresolve;
                }
                continue;
            }
            ++unresolved;
        }
        if (unresolved > 0) {
            System.err.println("Jalview Project Import: There were " + unresolved + " forward references left unresolved on the stack.");
        }
        if (failedtoresolve > 0) {
            System.err.println("SERIOUS! " + failedtoresolve + " resolvable forward references failed to resolve.");
        }
        if (this.incompleteSeqs != null && this.incompleteSeqs.size() > 0) {
            System.err.println("Jalview Project Import: There are " + this.incompleteSeqs.size() + " sequences which may have incomplete metadata.");
            if (this.incompleteSeqs.size() < 10) {
                for (SequenceI s : this.incompleteSeqs.values()) {
                    System.err.println(s.toString());
                }
            } else {
                System.err.println("Too many to report. Skipping output of incomplete sequences.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(File statefile) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(statefile);
            JarOutputStream jout = new JarOutputStream(fos);
            this.saveState(jout);
            fos.close();
        }
        catch (Exception e) {
            Cache.log.error((Object)("Couln't write Jalview state to " + statefile), (Throwable)e);
            this.errorMessage = this.errorMessage == null ? "Did't write Jalview Archive to output file '" + statefile + "' - See console error log for details" : this.errorMessage + "(Didn't write Jalview Archive to output file '" + statefile + ")";
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.reportErrors();
    }

    public void saveState(JarOutputStream jout) {
        AlignFrame[] frames = Desktop.getAlignFrames();
        if (frames == null) {
            return;
        }
        this.saveAllFrames(Arrays.asList(frames), jout);
    }

    private void saveAllFrames(List<AlignFrame> frames, JarOutputStream jout) {
        Hashtable<String, AlignFrame> dsses = new Hashtable<String, AlignFrame>();
        this.rnaSessions.clear();
        this.splitFrameCandidates.clear();
        try {
            ArrayList<String> shortNames = new ArrayList<String>();
            ArrayList<String> viewIds = new ArrayList<String>();
            for (int i = frames.size() - 1; i > -1; --i) {
                AlignFrame af = frames.get(i);
                if (this.skipList != null && this.skipList.containsKey(af.getViewport().getSequenceSetId())) continue;
                String shortName = this.makeFilename(af, shortNames);
                int apSize = af.getAlignPanels().size();
                for (int ap = 0; ap < apSize; ++ap) {
                    Object fileName;
                    AlignmentPanel apanel = (AlignmentPanel)af.getAlignPanels().get(ap);
                    Object object = fileName = apSize == 1 ? shortName : ap + shortName;
                    if (!((String)fileName).endsWith(".xml")) {
                        fileName = (String)fileName + ".xml";
                    }
                    this.saveState(apanel, (String)fileName, jout, viewIds);
                    String dssid = this.getDatasetIdRef(af.getViewport().getAlignment().getDataset());
                    if (dsses.containsKey(dssid)) continue;
                    dsses.put(dssid, af);
                }
            }
            this.writeDatasetFor(dsses, jout.hashCode() + " " + this.uniqueSetSuffix, jout);
            try {
                jout.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            jout.close();
        }
        catch (Exception ex) {
            if (this.errorMessage == null) {
                this.errorMessage = "Couldn't write Jalview Archive - see error output for details";
            }
            ex.printStackTrace();
        }
    }

    protected String makeFilename(AlignFrame af, List<String> namesUsed) {
        Object shortName = af.getTitle();
        if (((String)shortName).indexOf(File.separatorChar) > -1) {
            shortName = ((String)shortName).substring(((String)shortName).lastIndexOf(File.separatorChar) + 1);
        }
        int count = 1;
        while (namesUsed.contains(shortName)) {
            if (((String)shortName).endsWith("_" + (count - 1))) {
                shortName = ((String)shortName).substring(0, ((String)shortName).lastIndexOf("_"));
            }
            shortName = ((String)shortName).concat("_" + count);
            ++count;
        }
        namesUsed.add((String)shortName);
        if (!((String)shortName).endsWith(".xml")) {
            shortName = (String)shortName + ".xml";
        }
        return shortName;
    }

    public boolean saveAlignment(AlignFrame af, String jarFile, String fileName) {
        try {
            BackupFiles backupfiles = new BackupFiles(jarFile);
            FileOutputStream fos = new FileOutputStream(backupfiles.getTempFilePath());
            JarOutputStream jout = new JarOutputStream(fos);
            ArrayList<AlignFrame> frames = new ArrayList<AlignFrame>();
            if (af.getViewport().getCodingComplement() != null) {
                frames = ((SplitFrame)af.getSplitViewContainer()).getAlignFrames();
            } else {
                frames.add(af);
            }
            this.saveAllFrames(frames, jout);
            try {
                jout.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            jout.close();
            boolean success = true;
            backupfiles.setWriteSuccess(success);
            success = backupfiles.rollBackupsAndRenameTempFile();
            return success;
        }
        catch (Exception ex) {
            this.errorMessage = "Couldn't Write alignment view to Jalview Archive - see error output for details";
            ex.printStackTrace();
            return false;
        }
    }

    private void writeDatasetFor(Hashtable<String, AlignFrame> dsses, String fileName, JarOutputStream jout) {
        for (String dssids : dsses.keySet()) {
            AlignFrame _af = dsses.get(dssids);
            String jfileName = fileName + " Dataset for " + _af.getTitle();
            if (!jfileName.endsWith(".xml")) {
                jfileName = jfileName + ".xml";
            }
            this.saveState(_af.alignPanel, jfileName, true, jout, null);
        }
    }

    public JalviewModel saveState(AlignmentPanel ap, String fileName, JarOutputStream jout, List<String> viewIds) {
        return this.saveState(ap, fileName, false, jout, viewIds);
    }

    /*
     * WARNING - void declaration
     */
    public JalviewModel saveState(AlignmentPanel ap, String fileName, boolean storeDS, JarOutputStream jout, List<String> viewIds) {
        AlignmentI rjal;
        if (viewIds == null) {
            viewIds = new ArrayList<String>();
        }
        this.initSeqRefs();
        ArrayList<UserColourScheme> userColours = new ArrayList<UserColourScheme>();
        AlignViewport av = ap.av;
        ViewportRanges vpRanges = av.getRanges();
        ObjectFactory objectFactory = new ObjectFactory();
        JalviewModel object = objectFactory.createJalviewModel();
        object.setVamsasModel(new VAMSAS());
        try {
            GregorianCalendar c = new GregorianCalendar();
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar now = datatypeFactory.newXMLGregorianCalendar(c);
            object.setCreationDate(now);
        }
        catch (DatatypeConfigurationException e) {
            System.err.println("error writing date: " + e.toString());
        }
        object.setVersion(Cache.getDefault("VERSION", "Development Build"));
        AlignmentI jal = rjal = av.getAlignment();
        if (av.hasHiddenRows()) {
            rjal = jal.getHiddenSequences().getFullAlignment();
        }
        SequenceSet vamsasSet = new SequenceSet();
        vamsasSet.setGapChar("" + jal.getGapCharacter());
        if (jal.getDataset() != null) {
            vamsasSet.setDatasetId(this.getDatasetIdRef(jal.getDataset()));
            if (storeDS) {
                rjal = jal = jal.getDataset();
            }
        }
        if (jal.getProperties() != null) {
            Enumeration en = jal.getProperties().keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement().toString();
                SequenceSet.SequenceSetProperties ssp = new SequenceSet.SequenceSetProperties();
                ssp.setKey(key);
                ssp.setValue(jal.getProperties().get(key).toString());
                vamsasSet.getSequenceSetProperties().add(ssp);
            }
        }
        HashSet<String> calcIdSet = new HashSet<String>();
        HashMap<String, Sequence> vamsasSetIds = new HashMap<String, Sequence>();
        for (SequenceI sequenceI : rjal.getSequences()) {
            SequenceI jdatasq = sequenceI.getDatasetSequence() == null ? sequenceI : sequenceI.getDatasetSequence();
            String id = this.seqHash(sequenceI);
            if (vamsasSetIds.get(id) == null && (this.seqRefIds.get(id) == null || storeDS)) {
                Sequence vamsasSeq = this.createVamsasSequence(id, sequenceI);
                vamsasSet.getSequence().add(vamsasSeq);
                vamsasSetIds.put(id, vamsasSeq);
                this.seqRefIds.put(id, sequenceI);
            }
            JalviewModel.JSeq jseq = new JalviewModel.JSeq();
            jseq.setStart(sequenceI.getStart());
            jseq.setEnd(sequenceI.getEnd());
            jseq.setColour(av.getSequenceColour(sequenceI).getRGB());
            jseq.setId(id);
            if (!storeDS) {
                if (av.hasHiddenRows()) {
                    jseq.setHidden(av.getAlignment().getHiddenSequences().isHidden(sequenceI));
                    if (av.isHiddenRepSequence(sequenceI)) {
                        SequenceI[] reps = av.getRepresentedSequences(sequenceI).getSequencesInOrder(rjal);
                        for (int h = 0; h < reps.length; ++h) {
                            if (reps[h] == sequenceI) continue;
                            jseq.getHiddenSequences().add(rjal.findIndex(reps[h]));
                        }
                    }
                }
                if (jal.hasSeqrep()) {
                    jseq.setViewreference(sequenceI == jal.getSeqrep());
                }
            }
            List<SequenceFeature> sfs = sequenceI.getSequenceFeatures();
            for (SequenceFeature sf : sfs) {
                Feature features = new Feature();
                features.setBegin(sf.getBegin());
                features.setEnd(sf.getEnd());
                features.setDescription(sf.getDescription());
                features.setType(sf.getType());
                features.setFeatureGroup(sf.getFeatureGroup());
                features.setScore(Float.valueOf(sf.getScore()));
                if (sf.links != null) {
                    for (int l = 0; l < sf.links.size(); ++l) {
                        Feature.OtherData keyValue = new Feature.OtherData();
                        keyValue.setKey("LINK_" + l);
                        keyValue.setValue(sf.links.elementAt(l).toString());
                        features.getOtherData().add(keyValue);
                    }
                }
                if (sf.otherDetails != null) {
                    for (Map.Entry<String, Object> entry : sf.otherDetails.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        if (value instanceof Map) {
                            for (Map.Entry subAttribute : ((Map)value).entrySet()) {
                                Feature.OtherData otherData = new Feature.OtherData();
                                otherData.setKey(key);
                                otherData.setKey2((String)subAttribute.getKey());
                                otherData.setValue(subAttribute.getValue().toString());
                                features.getOtherData().add(otherData);
                            }
                            continue;
                        }
                        Feature.OtherData otherData = new Feature.OtherData();
                        otherData.setKey(key);
                        otherData.setValue(value.toString());
                        features.getOtherData().add(otherData);
                    }
                }
                jseq.getFeatures().add(features);
            }
            if (jdatasq.getAllPDBEntries() != null) {
                Enumeration<PDBEntry> en = jdatasq.getAllPDBEntries().elements();
                while (en.hasMoreElements()) {
                    String[] props;
                    JalviewModel.JSeq.Pdbids pdb = new JalviewModel.JSeq.Pdbids();
                    PDBEntry entry = en.nextElement();
                    String pdbId = entry.getId();
                    pdb.setId(pdbId);
                    pdb.setType(entry.getType());
                    JInternalFrame[] frames = Desktop.desktop.getAllFrames();
                    String matchedFile = null;
                    for (int f = frames.length - 1; f > -1; --f) {
                        if (!(frames[f] instanceof StructureViewerBase)) continue;
                        StructureViewerBase viewFrame = (StructureViewerBase)frames[f];
                        matchedFile = this.saveStructureState(ap, sequenceI, pdb, entry, viewIds, matchedFile, viewFrame);
                        String viewId = viewFrame.getViewId();
                        if (storeDS || viewIds.contains(viewId)) continue;
                        viewIds.add(viewId);
                        try {
                            String viewerState = viewFrame.getStateInfo();
                            this.writeJarEntry(jout, this.getViewerJarEntryName(viewId), viewerState.getBytes());
                            continue;
                        }
                        catch (IOException e) {
                            System.err.println("Error saving viewer state: " + e.getMessage());
                        }
                    }
                    if (matchedFile != null || entry.getFile() != null) {
                        if (entry.getFile() != null) {
                            matchedFile = entry.getFile();
                        }
                        pdb.setFile(matchedFile);
                        if (this.pdbfiles == null) {
                            this.pdbfiles = new ArrayList<String>();
                        }
                        if (!this.pdbfiles.contains(pdbId)) {
                            this.pdbfiles.add(pdbId);
                            this.copyFileToJar(jout, matchedFile, pdbId);
                        }
                    }
                    if ((props = entry.getProperties()).hasMoreElements()) {
                        while (props.hasMoreElements()) {
                            Pdbentry.Property prop = new Pdbentry.Property();
                            String key = props.nextElement();
                            prop.setName(key);
                            prop.setValue(entry.getProperty(key).toString());
                            pdb.getProperty().add(prop);
                        }
                    }
                    jseq.getPdbids().add(pdb);
                }
            }
            this.saveRnaViewers(jout, jseq, sequenceI, viewIds, ap, storeDS);
            if (sequenceI.hasHMMProfile()) {
                this.saveHmmerProfile(jout, jseq, sequenceI);
            }
            object.getJSeq().add(jseq);
        }
        if (!storeDS && av.hasHiddenRows()) {
            jal = av.getAlignment();
        }
        if (storeDS && jal.getCodonFrames() != null) {
            List<AlignedCodonFrame> jac = jal.getCodonFrames();
            for (AlignedCodonFrame acf : jac) {
                AlcodonFrame alc = new AlcodonFrame();
                if (acf.getProtMappings() == null || acf.getProtMappings().length <= 0) continue;
                boolean hasMap = false;
                SequenceI[] dnas = acf.getdnaSeqs();
                Mapping[] pmaps = acf.getProtMappings();
                for (int m = 0; m < pmaps.length; ++m) {
                    AlcodonFrame.AlcodMap alcmap = new AlcodonFrame.AlcodMap();
                    alcmap.setDnasq(this.seqHash(dnas[m]));
                    alcmap.setMapping(this.createVamsasMapping(pmaps[m], dnas[m], null, false));
                    alc.getAlcodMap().add(alcmap);
                    hasMap = true;
                }
                if (!hasMap) continue;
                vamsasSet.getAlcodonFrame().add(alc);
            }
        }
        if (!storeDS && av.getCurrentTree() != null && Desktop.desktop != null) {
            void var19_24;
            JInternalFrame[] frames = Desktop.desktop.getAllFrames();
            boolean bl = false;
            while (var19_24 < frames.length) {
                TreePanel tp;
                if (frames[var19_24] instanceof TreePanel && (tp = (TreePanel)frames[var19_24]).getTreeCanvas().getViewport().getAlignment() == jal) {
                    JalviewModel.Tree tree = new JalviewModel.Tree();
                    tree.setTitle(tp.getTitle());
                    tree.setCurrentTree(av.getCurrentTree() == tp.getTree());
                    tree.setNewick(tp.getTree().print());
                    tree.setThreshold(Float.valueOf(tp.getTreeCanvas().getThreshold()));
                    tree.setFitToWindow(tp.fitToWindow.getState());
                    tree.setFontName(tp.getTreeFont().getName());
                    tree.setFontSize(tp.getTreeFont().getSize());
                    tree.setFontStyle(tp.getTreeFont().getStyle());
                    tree.setMarkUnlinked(tp.placeholdersMenu.getState());
                    tree.setShowBootstrap(tp.bootstrapMenu.getState());
                    tree.setShowDistances(tp.distanceMenu.getState());
                    tree.setHeight(tp.getHeight());
                    tree.setWidth(tp.getWidth());
                    tree.setXpos(tp.getX());
                    tree.setYpos(tp.getY());
                    tree.setId(this.makeHashCode(tp, null));
                    tree.setLinkToAllViews(tp.getTreeCanvas().isApplyToAllViews());
                    object.getTree().add(tree);
                }
                ++var19_24;
            }
        }
        if (!storeDS && Desktop.desktop != null) {
            for (JInternalFrame frame : Desktop.desktop.getAllFrames()) {
                PCAPanel panel;
                if (!(frame instanceof PCAPanel) || (panel = (PCAPanel)frame).getAlignViewport().getAlignment() != jal) continue;
                this.savePCA(panel, object);
            }
        }
        IdentityHashMap<SequenceGroup, String> groupRefs = new IdentityHashMap<SequenceGroup, String>();
        if (storeDS) {
            for (SequenceI sq : jal.getSequences()) {
                AlignmentAnnotation[] aa = sq.getAnnotation();
                if (aa == null || aa.length <= 0) continue;
                this.storeAlignmentAnnotation(aa, groupRefs, av, calcIdSet, storeDS, vamsasSet);
            }
        } else if (jal.getAlignmentAnnotation() != null) {
            AlignmentAnnotation[] alignmentAnnotationArray = jal.getAlignmentAnnotation();
            this.storeAlignmentAnnotation(alignmentAnnotationArray, groupRefs, av, calcIdSet, storeDS, vamsasSet);
        }
        if (jal.getGroups() != null) {
            JalviewModel.JGroup[] jGroupArray = new JalviewModel.JGroup[jal.getGroups().size()];
            int i = -1;
            for (SequenceGroup sg : jal.getGroups()) {
                ColourSchemeI colourScheme;
                JalviewModel.JGroup jGroup = new JalviewModel.JGroup();
                jGroupArray[++i] = jGroup;
                jGroup.setStart(sg.getStartRes());
                jGroup.setEnd(sg.getEndRes());
                jGroup.setName(sg.getName());
                if (groupRefs.containsKey(sg)) {
                    jGroup.setId(groupRefs.get(sg));
                }
                if ((colourScheme = sg.getColourScheme()) != null) {
                    ResidueShaderI groupColourScheme = sg.getGroupColourScheme();
                    if (groupColourScheme.conservationApplied()) {
                        jGroup.setConsThreshold(groupColourScheme.getConservationInc());
                        if (colourScheme instanceof UserColourScheme) {
                            jGroup.setColour(this.setUserColourScheme(colourScheme, userColours, object));
                        } else {
                            jGroup.setColour(colourScheme.getSchemeName());
                        }
                    } else if (colourScheme instanceof AnnotationColourGradient) {
                        jGroup.setColour("AnnotationColourGradient");
                        jGroup.setAnnotationColours(this.constructAnnotationColours((AnnotationColourGradient)colourScheme, userColours, object));
                    } else if (colourScheme instanceof UserColourScheme) {
                        jGroup.setColour(this.setUserColourScheme(colourScheme, userColours, object));
                    } else {
                        jGroup.setColour(colourScheme.getSchemeName());
                    }
                    jGroup.setPidThreshold(groupColourScheme.getThreshold());
                }
                jGroup.setOutlineColour(sg.getOutlineColour().getRGB());
                jGroup.setDisplayBoxes(sg.getDisplayBoxes());
                jGroup.setDisplayText(sg.getDisplayText());
                jGroup.setColourText(sg.getColourText());
                jGroup.setTextCol1(sg.textColour.getRGB());
                jGroup.setTextCol2(sg.textColour2.getRGB());
                jGroup.setTextColThreshold(sg.thresholdTextColour);
                jGroup.setShowUnconserved(sg.getShowNonconserved());
                jGroup.setIgnoreGapsinConsensus(sg.getIgnoreGapsConsensus());
                jGroup.setShowConsensusHistogram(sg.isShowConsensusHistogram());
                jGroup.setShowSequenceLogo(sg.isShowSequenceLogo());
                jGroup.setNormaliseSequenceLogo(sg.isNormaliseSequenceLogo());
                for (SequenceI seq : sg.getSequences()) {
                    jGroup.getSeq().add(this.seqHash(seq));
                }
            }
            for (JalviewModel.JGroup grp : jGroupArray) {
                object.getJGroup().add(grp);
            }
        }
        if (!storeDS) {
            Rectangle size;
            JalviewModel.Viewport viewport = new JalviewModel.Viewport();
            viewport.setTitle(ap.alignFrame.getTitle());
            viewport.setSequenceSetId(this.makeHashCode(av.getSequenceSetId(), av.getSequenceSetId()));
            viewport.setId(av.getViewId());
            if (av.getCodingComplement() != null) {
                viewport.setComplementId(av.getCodingComplement().getViewId());
            }
            viewport.setViewName(av.getViewName());
            viewport.setGatheredViews(av.isGatherViewsHere());
            Rectangle position = size = ap.av.getExplodedGeometry();
            if (size == null) {
                size = ap.alignFrame.getBounds();
                position = av.getCodingComplement() != null ? ((SplitFrame)ap.alignFrame.getSplitViewContainer()).getBounds() : size;
            }
            viewport.setXpos(position.x);
            viewport.setYpos(position.y);
            viewport.setWidth(size.width);
            viewport.setHeight(size.height);
            viewport.setStartRes(vpRanges.getStartRes());
            viewport.setStartSeq(vpRanges.getStartSeq());
            if (av.getGlobalColourScheme() instanceof UserColourScheme) {
                viewport.setBgColour(this.setUserColourScheme(av.getGlobalColourScheme(), userColours, object));
            } else if (av.getGlobalColourScheme() instanceof AnnotationColourGradient) {
                AnnotationColourScheme ac = this.constructAnnotationColours((AnnotationColourGradient)av.getGlobalColourScheme(), userColours, object);
                viewport.setAnnotationColours(ac);
                viewport.setBgColour("AnnotationColourGradient");
            } else {
                viewport.setBgColour(ColourSchemeProperty.getColourName(av.getGlobalColourScheme()));
            }
            ResidueShaderI vcs = av.getResidueShading();
            ColourSchemeI cs = av.getGlobalColourScheme();
            if (cs != null) {
                if (vcs.conservationApplied()) {
                    viewport.setConsThreshold(vcs.getConservationInc());
                    if (cs instanceof UserColourScheme) {
                        viewport.setBgColour(this.setUserColourScheme(cs, userColours, object));
                    }
                }
                viewport.setPidThreshold(vcs.getThreshold());
            }
            viewport.setConservationSelected(av.getConservationSelected());
            viewport.setPidSelected(av.getAbovePIDThreshold());
            Font font = av.getFont();
            viewport.setFontName(font.getName());
            viewport.setFontSize(font.getSize());
            viewport.setFontStyle(font.getStyle());
            viewport.setScaleProteinAsCdna(av.getViewStyle().isScaleProteinAsCdna());
            viewport.setRenderGaps(av.isRenderGaps());
            viewport.setShowAnnotation(av.isShowAnnotation());
            viewport.setShowBoxes(av.getShowBoxes());
            viewport.setShowColourText(av.getColourText());
            viewport.setShowFullId(av.getShowJVSuffix());
            viewport.setRightAlignIds(av.isRightAlignIds());
            viewport.setShowSequenceFeatures(av.isShowSequenceFeatures());
            viewport.setShowText(av.getShowText());
            viewport.setShowUnconserved(av.getShowUnconserved());
            viewport.setWrapAlignment(av.getWrapAlignment());
            viewport.setTextCol1(av.getTextColour().getRGB());
            viewport.setTextCol2(av.getTextColour2().getRGB());
            viewport.setTextColThreshold(av.getThresholdTextColour());
            viewport.setShowConsensusHistogram(av.isShowConsensusHistogram());
            viewport.setShowSequenceLogo(av.isShowSequenceLogo());
            viewport.setNormaliseSequenceLogo(av.isNormaliseSequenceLogo());
            viewport.setShowGroupConsensus(av.isShowGroupConsensus());
            viewport.setShowGroupConservation(av.isShowGroupConservation());
            viewport.setShowNPfeatureTooltip(av.isShowNPFeats());
            viewport.setShowDbRefTooltip(av.isShowDBRefs());
            viewport.setFollowHighlight(av.isFollowHighlight());
            viewport.setFollowSelection(av.followSelection);
            viewport.setIgnoreGapsinConsensus(av.isIgnoreGapsConsensus());
            viewport.setShowComplementFeatures(av.isShowComplementFeatures());
            viewport.setShowComplementFeaturesOnTop(av.isShowComplementFeaturesOnTop());
            if (av.getFeaturesDisplayed() != null) {
                JalviewModel.FeatureSettings fs = new JalviewModel.FeatureSettings();
                FeatureRenderer fr = ap.getSeqPanel().seqCanvas.getFeatureRenderer();
                String[] renderOrder = fr.getRenderOrder().toArray(new String[0]);
                Vector<String> settingsAdded = new Vector<String>();
                if (renderOrder != null) {
                    for (String featureType : renderOrder) {
                        FeatureColourI fcol;
                        JalviewModel.FeatureSettings.Setting setting = new JalviewModel.FeatureSettings.Setting();
                        setting.setType(featureType);
                        FeatureMatcherSetI filter = fr.getFeatureFilter(featureType);
                        if (filter != null) {
                            Iterator<FeatureMatcherI> filters = filter.getMatchers().iterator();
                            FeatureMatcherI firstFilter = filters.next();
                            setting.setMatcherSet(Jalview2XML.marshalFilter(firstFilter, filters, filter.isAnded()));
                        }
                        if (!(fcol = fr.getFeatureStyle(featureType)).isSimpleColour()) {
                            setting.setColour(fcol.getMaxColour().getRGB());
                            setting.setMincolour(fcol.getMinColour().getRGB());
                            setting.setMin(Float.valueOf(fcol.getMin()));
                            setting.setMax(Float.valueOf(fcol.getMax()));
                            setting.setColourByLabel(fcol.isColourByLabel());
                            if (fcol.isColourByAttribute()) {
                                String[] attName = fcol.getAttributeName();
                                setting.getAttributeName().add(attName[0]);
                                if (attName.length > 1) {
                                    setting.getAttributeName().add(attName[1]);
                                }
                            }
                            setting.setAutoScale(fcol.isAutoScaled());
                            setting.setThreshold(Float.valueOf(fcol.getThreshold()));
                            Color noColour = fcol.getNoColour();
                            if (noColour == null) {
                                setting.setNoValueColour(NoValueColour.NONE);
                            } else if (noColour.equals(fcol.getMaxColour())) {
                                setting.setNoValueColour(NoValueColour.MAX);
                            } else {
                                setting.setNoValueColour(NoValueColour.MIN);
                            }
                            setting.setThreshstate(fcol.isAboveThreshold() ? 1 : (fcol.isBelowThreshold() ? 0 : -1));
                        } else {
                            setting.setColour(fcol.getColour().getRGB());
                        }
                        setting.setDisplay(av.getFeaturesDisplayed().isVisible(featureType));
                        float rorder = fr.getOrder(featureType);
                        if (rorder > -1.0f) {
                            setting.setOrder(Float.valueOf(rorder));
                        }
                        fs.getSetting().add(setting);
                        settingsAdded.addElement(featureType);
                    }
                }
                Iterator<String> en = fr.getFeatureGroups().iterator();
                Vector<String> groupsAdded = new Vector<String>();
                while (en.hasNext()) {
                    String grp = en.next();
                    if (groupsAdded.contains(grp)) continue;
                    JalviewModel.FeatureSettings.Group g = new JalviewModel.FeatureSettings.Group();
                    g.setName(grp);
                    g.setDisplay(fr.checkGroupVisibility(grp, false));
                    fs.getGroup().add(g);
                    groupsAdded.addElement(grp);
                }
                object.setFeatureSettings(fs);
            }
            if (av.hasHiddenColumns()) {
                HiddenColumns hidden = av.getAlignment().getHiddenColumns();
                if (hidden == null) {
                    this.warn("REPORT BUG: avoided null columnselection bug (DMAM reported). Please contact Jim about this.");
                } else {
                    Iterator<int[]> hiddenRegions = hidden.iterator();
                    while (hiddenRegions.hasNext()) {
                        int[] region = hiddenRegions.next();
                        JalviewModel.Viewport.HiddenColumns hc = new JalviewModel.Viewport.HiddenColumns();
                        hc.setStart(region[0]);
                        hc.setEnd(region[1]);
                        viewport.getHiddenColumns().add(hc);
                    }
                }
            }
            if (calcIdSet.size() > 0) {
                for (String calcId : calcIdSet) {
                    JalviewModel.Viewport.CalcIdParam cidp;
                    if (calcId.trim().length() <= 0 || (cidp = this.createCalcIdParam(calcId, av)) == null) continue;
                    viewport.getCalcIdParam().add(cidp);
                }
            }
            object.getViewport().add(viewport);
        }
        object.getVamsasModel().getSequenceSet().add(vamsasSet);
        if (jout != null && fileName != null) {
            try {
                System.out.println("Writing jar entry " + fileName);
                JarEntry jarEntry = new JarEntry(fileName);
                jout.putNextEntry(jarEntry);
                PrintWriter pout = new PrintWriter(new OutputStreamWriter((OutputStream)jout, UTF_8));
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{JalviewModel.class});
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.marshal(new ObjectFactory().createJalviewModel(object), (Writer)pout);
                pout.flush();
                jout.closeEntry();
            }
            catch (Exception exception) {
                System.err.println("Error writing Jalview project");
                exception.printStackTrace();
            }
        }
        return object;
    }

    protected void saveHmmerProfile(JarOutputStream jout, JalviewModel.JSeq xmlSeq, SequenceI seq) {
        HiddenMarkovModel profile = seq.getHMM();
        if (profile == null) {
            this.warn("Want to save HMM profile for " + seq.getName() + " but none found");
            return;
        }
        HMMFile hmmFile = new HMMFile(profile);
        String hmmAsString = hmmFile.print();
        String jarEntryName = HMMER_PREFIX + this.nextCounter();
        try {
            this.writeJarEntry(jout, jarEntryName, hmmAsString.getBytes());
            xmlSeq.setHmmerProfile(jarEntryName);
        }
        catch (IOException e) {
            this.warn("Error saving HMM profile: " + e.getMessage());
        }
    }

    protected void savePCA(PCAPanel panel, JalviewModel object) {
        try {
            JalviewModel.PcaViewer viewer = new JalviewModel.PcaViewer();
            viewer.setHeight(panel.getHeight());
            viewer.setWidth(panel.getWidth());
            viewer.setXpos(panel.getX());
            viewer.setYpos(panel.getY());
            viewer.setTitle(panel.getTitle());
            PCAModel pcaModel = panel.getPcaModel();
            viewer.setScoreModelName(pcaModel.getScoreModelName());
            viewer.setXDim(panel.getSelectedDimensionIndex(RotatableMatrix.Axis.X));
            viewer.setYDim(panel.getSelectedDimensionIndex(RotatableMatrix.Axis.Y));
            viewer.setZDim(panel.getSelectedDimensionIndex(RotatableMatrix.Axis.Z));
            viewer.setBgColour(panel.getRotatableCanvas().getBackgroundColour().getRGB());
            viewer.setScaleFactor(Float.valueOf(panel.getRotatableCanvas().getScaleFactor()));
            float[] spMin = panel.getRotatableCanvas().getSeqMin();
            JalviewModel.PcaViewer.SeqPointMin spmin = new JalviewModel.PcaViewer.SeqPointMin();
            spmin.setXPos(Float.valueOf(spMin[0]));
            spmin.setYPos(Float.valueOf(spMin[1]));
            spmin.setZPos(Float.valueOf(spMin[2]));
            viewer.setSeqPointMin(spmin);
            float[] spMax = panel.getRotatableCanvas().getSeqMax();
            JalviewModel.PcaViewer.SeqPointMax spmax = new JalviewModel.PcaViewer.SeqPointMax();
            spmax.setXPos(Float.valueOf(spMax[0]));
            spmax.setYPos(Float.valueOf(spMax[1]));
            spmax.setZPos(Float.valueOf(spMax[2]));
            viewer.setSeqPointMax(spmax);
            viewer.setShowLabels(panel.getRotatableCanvas().isShowLabels());
            viewer.setLinkToAllViews(panel.getRotatableCanvas().isApplyToAllViews());
            SimilarityParamsI sp = pcaModel.getSimilarityParameters();
            viewer.setIncludeGaps(sp.includeGaps());
            viewer.setMatchGaps(sp.matchGaps());
            viewer.setIncludeGappedColumns(sp.includeGappedColumns());
            viewer.setDenominateByShortestLength(sp.denominateByShortestLength());
            for (SequencePoint spt : pcaModel.getSequencePoints()) {
                JalviewModel.PcaViewer.SequencePoint point = new JalviewModel.PcaViewer.SequencePoint();
                point.setSequenceRef(this.seqHash(spt.getSequence()));
                point.setXPos(Float.valueOf(spt.coord.x));
                point.setYPos(Float.valueOf(spt.coord.y));
                point.setZPos(Float.valueOf(spt.coord.z));
                viewer.getSequencePoint().add(point);
            }
            for (Point p : panel.getRotatableCanvas().getAxisEndPoints()) {
                JalviewModel.PcaViewer.Axis axis = new JalviewModel.PcaViewer.Axis();
                axis.setXPos(Float.valueOf(p.x));
                axis.setYPos(Float.valueOf(p.y));
                axis.setZPos(Float.valueOf(p.z));
                viewer.getAxis().add(axis);
            }
            PcaDataType data = new PcaDataType();
            viewer.setPcaData(data);
            PCA pca = pcaModel.getPcaData();
            DoubleMatrix pm = new DoubleMatrix();
            this.saveDoubleMatrix(pca.getPairwiseScores(), pm);
            data.setPairwiseMatrix(pm);
            DoubleMatrix tm = new DoubleMatrix();
            this.saveDoubleMatrix(pca.getTridiagonal(), tm);
            data.setTridiagonalMatrix(tm);
            DoubleMatrix eigenMatrix = new DoubleMatrix();
            data.setEigenMatrix(eigenMatrix);
            this.saveDoubleMatrix(pca.getEigenmatrix(), eigenMatrix);
            object.getPcaViewer().add(viewer);
        }
        catch (Throwable t) {
            Cache.log.error((Object)("Error saving PCA: " + t.getMessage()));
        }
    }

    protected void saveDoubleMatrix(MatrixI m, DoubleMatrix xmlMatrix) {
        xmlMatrix.setRows(m.height());
        xmlMatrix.setColumns(m.width());
        for (int i = 0; i < m.height(); ++i) {
            DoubleVector row = new DoubleVector();
            for (int j = 0; j < m.width(); ++j) {
                row.getV().add(m.getValue(i, j));
            }
            xmlMatrix.getRow().add(row);
        }
        if (m.getD() != null) {
            DoubleVector dVector = new DoubleVector();
            for (double d : m.getD()) {
                dVector.getV().add(d);
            }
            xmlMatrix.setD(dVector);
        }
        if (m.getE() != null) {
            DoubleVector eVector = new DoubleVector();
            for (double e : m.getE()) {
                eVector.getV().add(e);
            }
            xmlMatrix.setE(eVector);
        }
    }

    protected MatrixI loadDoubleMatrix(DoubleMatrix mData) {
        List<Double> dVector;
        int rows = mData.getRows();
        double[][] vals = new double[rows][];
        for (int i = 0; i < rows; ++i) {
            dVector = mData.getRow().get(i).getV();
            vals[i] = new double[dVector.size()];
            int dvi = 0;
            for (Double d : dVector) {
                vals[i][dvi++] = d;
            }
        }
        Matrix m = new Matrix(vals);
        if (mData.getD() != null) {
            dVector = mData.getD().getV();
            double[] vec = new double[dVector.size()];
            int dvi = 0;
            for (Double d : dVector) {
                vec[dvi++] = d;
            }
            m.setD(vec);
        }
        if (mData.getE() != null) {
            dVector = mData.getE().getV();
            double[] vec = new double[dVector.size()];
            int dvi = 0;
            for (Double d : dVector) {
                vec[dvi++] = d;
            }
            m.setE(vec);
        }
        return m;
    }

    protected void saveRnaViewers(JarOutputStream jout, JalviewModel.JSeq jseq, SequenceI jds, List<String> viewIds, AlignmentPanel ap, boolean storeDataset) {
        if (Desktop.desktop == null) {
            return;
        }
        JInternalFrame[] frames = Desktop.desktop.getAllFrames();
        for (int f = frames.length - 1; f > -1; --f) {
            AppVarna varna;
            if (!(frames[f] instanceof AppVarna) || !(varna = (AppVarna)frames[f]).isListeningFor(jds) || ap != varna.getAlignmentPanel()) continue;
            String viewId = varna.getViewId();
            JalviewModel.JSeq.RnaViewer rna = new JalviewModel.JSeq.RnaViewer();
            rna.setViewId(viewId);
            rna.setTitle(varna.getTitle());
            rna.setXpos(varna.getX());
            rna.setYpos(varna.getY());
            rna.setWidth(varna.getWidth());
            rna.setHeight(varna.getHeight());
            rna.setDividerLocation(varna.getDividerLocation());
            rna.setSelectedRna(varna.getSelectedIndex());
            jseq.getRnaViewer().add(rna);
            for (RnaModel model : varna.getModels()) {
                if (model.seq != jds) continue;
                Object jarEntryName = this.rnaSessions.get(model);
                if (jarEntryName == null) {
                    String varnaStateFile = varna.getStateInfo(model.rna);
                    jarEntryName = RNA_PREFIX + viewId + "_" + this.nextCounter();
                    this.copyFileToJar(jout, varnaStateFile, (String)jarEntryName);
                    this.rnaSessions.put(model, (String)jarEntryName);
                }
                JalviewModel.JSeq.RnaViewer.SecondaryStructure ss = new JalviewModel.JSeq.RnaViewer.SecondaryStructure();
                String annotationId = varna.getAnnotation((SequenceI)jds).annotationId;
                ss.setAnnotationId(annotationId);
                ss.setViewerState((String)jarEntryName);
                ss.setGapped(model.gapped);
                ss.setTitle(model.title);
                rna.getSecondaryStructure().add(ss);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFileToJar(JarOutputStream jout, String infilePath, String jarEntryName) {
        FilterInputStream dis = null;
        try {
            File file = new File(infilePath);
            if (file.exists() && jout != null) {
                dis = new DataInputStream(new FileInputStream(file));
                byte[] data = new byte[(int)file.length()];
                ((DataInputStream)dis).readFully(data);
                this.writeJarEntry(jout, jarEntryName, data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void writeJarEntry(JarOutputStream jout, String jarEntryName, byte[] data) throws IOException {
        if (jout != null) {
            System.out.println("Writing jar entry " + jarEntryName);
            jout.putNextEntry(new JarEntry(jarEntryName));
            DataOutputStream dout = new DataOutputStream(jout);
            dout.write(data, 0, data.length);
            dout.flush();
            jout.closeEntry();
        }
    }

    protected String saveStructureState(AlignmentPanel ap, SequenceI jds, JalviewModel.JSeq.Pdbids pdb, PDBEntry entry, List<String> viewIds, String matchedFile, StructureViewerBase viewFrame) {
        AAStructureBindingModel bindingModel = viewFrame.getBinding();
        for (int peid = 0; peid < bindingModel.getPdbCount(); ++peid) {
            PDBEntry pdbentry = bindingModel.getPdbEntry(peid);
            String pdbId = pdbentry.getId();
            if (!pdbId.equals(entry.getId()) && (entry.getId().length() <= 4 || !entry.getId().toLowerCase().startsWith(pdbId.toLowerCase()))) continue;
            if (matchedFile == null) {
                matchedFile = pdbentry.getFile();
            } else if (!matchedFile.equals(pdbentry.getFile())) {
                Cache.log.warn((Object)("Probably lost some PDB-Sequence mappings for this structure file (which apparently has same PDB Entry code): " + pdbentry.getFile()));
            }
            for (int smap = 0; smap < viewFrame.getBinding().getSequence()[peid].length; ++smap) {
                if (jds != viewFrame.getBinding().getSequence()[peid][smap]) continue;
                JalviewModel.JSeq.Pdbids.StructureState state = new JalviewModel.JSeq.Pdbids.StructureState();
                state.setVisible(true);
                state.setXpos(viewFrame.getX());
                state.setYpos(viewFrame.getY());
                state.setWidth(viewFrame.getWidth());
                state.setHeight(viewFrame.getHeight());
                String viewId = viewFrame.getViewId();
                state.setViewId(viewId);
                state.setAlignwithAlignPanel(viewFrame.isUsedforaligment(ap));
                state.setColourwithAlignPanel(viewFrame.isUsedforcolourby(ap));
                state.setColourByJmol(viewFrame.isColouredByViewer());
                state.setType(viewFrame.getViewerType().toString());
                pdb.getStructureState().add(state);
            }
        }
        return matchedFile;
    }

    private AnnotationColourScheme constructAnnotationColours(AnnotationColourGradient acg, List<UserColourScheme> userColours, JalviewModel jm) {
        AnnotationColourScheme ac = new AnnotationColourScheme();
        ac.setAboveThreshold(acg.getAboveThreshold());
        ac.setThreshold(Float.valueOf(acg.getAnnotationThreshold()));
        ac.setAnnotation(acg.getAnnotation().annotationId);
        if (acg.getBaseColour() instanceof UserColourScheme) {
            ac.setColourScheme(this.setUserColourScheme(acg.getBaseColour(), userColours, jm));
        } else {
            ac.setColourScheme(ColourSchemeProperty.getColourName(acg.getBaseColour()));
        }
        ac.setMaxColour(acg.getMaxColour().getRGB());
        ac.setMinColour(acg.getMinColour().getRGB());
        ac.setPerSequence(acg.isSeqAssociated());
        ac.setPredefinedColours(acg.isPredefinedColours());
        return ac;
    }

    private void storeAlignmentAnnotation(AlignmentAnnotation[] aa, IdentityHashMap<SequenceGroup, String> groupRefs, AlignmentViewport av, Set<String> calcIdSet, boolean storeDS, SequenceSet vamsasSet) {
        for (int i = 0; i < aa.length; ++i) {
            Annotation an = new Annotation();
            AlignmentAnnotation annotation = aa[i];
            if (annotation.annotationId != null) {
                this.annotationIds.put(annotation.annotationId, annotation);
            }
            an.setId(annotation.annotationId);
            an.setVisible(annotation.visible);
            an.setDescription(annotation.description);
            if (annotation.sequenceRef != null) {
                an.setSequenceRef(this.seqsToIds.get(annotation.sequenceRef));
            }
            if (annotation.groupRef != null) {
                Object groupIdr = groupRefs.get(annotation.groupRef);
                if (groupIdr == null) {
                    groupIdr = System.currentTimeMillis() + annotation.groupRef.getName() + groupRefs.size();
                    groupRefs.put(annotation.groupRef, (String)groupIdr);
                }
                an.setGroupRef(((String)groupIdr).toString());
            }
            an.setGraphHeight(annotation.graphHeight);
            an.setCentreColLabels(annotation.centreColLabels);
            an.setScaleColLabels(annotation.scaleColLabel);
            an.setShowAllColLabels(annotation.showAllColLabels);
            an.setBelowAlignment(annotation.belowAlignment);
            if (annotation.graph > 0) {
                an.setGraph(true);
                an.setGraphType(annotation.graph);
                an.setGraphGroup(annotation.graphGroup);
                if (annotation.getThreshold() != null) {
                    Annotation.ThresholdLine line = new Annotation.ThresholdLine();
                    line.setLabel(annotation.getThreshold().label);
                    line.setValue(Float.valueOf(annotation.getThreshold().value));
                    line.setColour(annotation.getThreshold().colour.getRGB());
                    an.setThresholdLine(line);
                }
            } else {
                an.setGraph(false);
            }
            an.setLabel(annotation.label);
            if (annotation == av.getAlignmentQualityAnnot() || annotation == av.getAlignmentConservationAnnotation() || annotation == av.getAlignmentConsensusAnnotation() || annotation.autoCalculated) {
                an.setAutoCalculated(annotation.autoCalculated);
            }
            if (annotation.hasScore()) {
                an.setScore(annotation.getScore());
            }
            if (annotation.getCalcId() != null) {
                calcIdSet.add(annotation.getCalcId());
                an.setCalcId(annotation.getCalcId());
            }
            if (annotation.hasProperties()) {
                for (String pr : annotation.getProperties()) {
                    Annotation.Property prop = new Annotation.Property();
                    prop.setName(pr);
                    prop.setValue(annotation.getProperty(pr));
                    an.getProperty().add(prop);
                }
            }
            if (annotation.annotations != null) {
                an.setScoreOnly(false);
                for (int a = 0; a < annotation.annotations.length; ++a) {
                    if (annotation == null || annotation.annotations[a] == null) continue;
                    AnnotationElement ae = new AnnotationElement();
                    if (annotation.annotations[a].description != null) {
                        ae.setDescription(annotation.annotations[a].description);
                    }
                    if (annotation.annotations[a].displayCharacter != null) {
                        ae.setDisplayCharacter(annotation.annotations[a].displayCharacter);
                    }
                    if (!Float.isNaN(annotation.annotations[a].value)) {
                        ae.setValue(Float.valueOf(annotation.annotations[a].value));
                    }
                    ae.setPosition(a);
                    if (annotation.annotations[a].secondaryStructure > ' ') {
                        ae.setSecondaryStructure("" + annotation.annotations[a].secondaryStructure);
                    }
                    if (annotation.annotations[a].colour != null && annotation.annotations[a].colour != Color.black) {
                        ae.setColour(annotation.annotations[a].colour.getRGB());
                    }
                    an.getAnnotationElement().add(ae);
                    if (!annotation.autoCalculated) continue;
                }
            } else {
                an.setScoreOnly(true);
            }
            if (storeDS && (!storeDS || annotation.autoCalculated)) continue;
            vamsasSet.getAnnotation().add(an);
        }
    }

    private JalviewModel.Viewport.CalcIdParam createCalcIdParam(String calcId, AlignViewport av) {
        AutoCalcSetting settings = av.getCalcIdSettingsFor(calcId);
        if (settings != null) {
            JalviewModel.Viewport.CalcIdParam vCalcIdParam = new JalviewModel.Viewport.CalcIdParam();
            vCalcIdParam.setCalcId(calcId);
            vCalcIdParam.getServiceURL().add(settings.getServiceURI());
            for (String url : settings.getServiceURLs()) {
                vCalcIdParam.getServiceURL().add(url);
            }
            vCalcIdParam.setVersion("1.0");
            if (settings.getPreset() != null) {
                WsParamSetI setting = settings.getPreset();
                vCalcIdParam.setName(setting.getName());
                vCalcIdParam.setDescription(setting.getDescription());
            } else {
                vCalcIdParam.setName("");
                vCalcIdParam.setDescription("Last used parameters");
            }
            vCalcIdParam.setParameters(settings.getWsParamFile().replace("\n", "|\\n|"));
            vCalcIdParam.setAutoUpdate(settings.isAutoUpdate());
            return vCalcIdParam;
        }
        return null;
    }

    private boolean recoverCalcIdParam(JalviewModel.Viewport.CalcIdParam calcIdParam, AlignViewport av) {
        if (calcIdParam.getVersion().equals("1.0")) {
            String[] calcIds = calcIdParam.getServiceURL().toArray(new String[0]);
            Jws2Instance service = Jws2Discoverer.getDiscoverer().getPreferredServiceFor(calcIds);
            if (service != null) {
                WsParamSetI parmSet = null;
                try {
                    parmSet = service.getParamStore().parseServiceParameterFile(calcIdParam.getName(), calcIdParam.getDescription(), calcIds, calcIdParam.getParameters().replace("|\\n|", "\n"));
                }
                catch (IOException x) {
                    this.warn("Couldn't parse parameter data for " + calcIdParam.getCalcId(), x);
                    return false;
                }
                List<ArgumentI> argList = null;
                if (calcIdParam.getName().length() > 0) {
                    parmSet = service.getParamStore().getPreset(calcIdParam.getName());
                    if (parmSet != null) {
                        // empty if block
                    }
                } else {
                    argList = parmSet.getArguments();
                    parmSet = null;
                }
                AAConSettings settings = new AAConSettings(calcIdParam.isAutoUpdate(), service, parmSet, argList);
                av.setCalcIdSettingsFor(calcIdParam.getCalcId(), settings, calcIdParam.isNeedsUpdate());
                return true;
            }
            this.warn("Cannot resolve a service for the parameters used in this project. Try configuring a JABAWS server.");
            return false;
        }
        throw new Error(MessageManager.formatMessage("error.unsupported_version_calcIdparam", calcIdParam.toString()));
    }

    private String makeHashCode(Object jvobj, String altCode) {
        if (this.jv2vobj != null) {
            Object id = this.jv2vobj.get(jvobj);
            if (id != null) {
                return id.toString();
            }
            if (this.jvids2vobj != null && jvobj instanceof String) {
                id = this.jvids2vobj.get(jvobj);
            }
            if (id != null) {
                return id.toString();
            }
            this.warn("Cannot find ID for object in external mapping : " + jvobj);
        }
        return altCode;
    }

    private Object retrieveExistingObj(String idcode) {
        if (idcode != null && this.vobj2jv != null) {
            return this.vobj2jv.get(idcode);
        }
        return null;
    }

    private Sequence createVamsasSequence(String id, SequenceI jds) {
        return this.createVamsasSequence(true, id, jds, null);
    }

    private Sequence createVamsasSequence(boolean recurse, String id, SequenceI jds, SequenceI parentseq) {
        Sequence vamsasSeq = new Sequence();
        vamsasSeq.setId(id);
        vamsasSeq.setName(jds.getName());
        vamsasSeq.setSequence(jds.getSequenceAsString());
        vamsasSeq.setDescription(jds.getDescription());
        DBRefEntry[] dbrefs = null;
        if (jds.getDatasetSequence() != null) {
            vamsasSeq.setDsseqid(this.seqHash(jds.getDatasetSequence()));
        } else {
            vamsasSeq.setDsseqid(id);
            dbrefs = jds.getDBRefs();
            if (parentseq == null) {
                parentseq = jds;
            }
        }
        if (dbrefs != null) {
            for (int d = 0; d < dbrefs.length; ++d) {
                Sequence.DBRef dbref = new Sequence.DBRef();
                DBRefEntry dbRefEntry = dbrefs[d];
                dbref.setSource(dbRefEntry.getSource());
                dbref.setVersion(dbRefEntry.getVersion());
                dbref.setAccessionId(dbRefEntry.getAccessionId());
                if (dbRefEntry instanceof GeneLocus) {
                    dbref.setLocus(true);
                }
                if (dbRefEntry.hasMap()) {
                    jalview.xml.binding.jalview.Mapping mp = this.createVamsasMapping(dbRefEntry.getMap(), parentseq, jds, recurse);
                    dbref.setMapping(mp);
                }
                vamsasSeq.getDBRef().add(dbref);
            }
        }
        return vamsasSeq;
    }

    private jalview.xml.binding.jalview.Mapping createVamsasMapping(Mapping jmp, SequenceI parentseq, SequenceI jds, boolean recurse) {
        jalview.xml.binding.jalview.Mapping mp = null;
        if (jmp.getMap() != null) {
            mp = new jalview.xml.binding.jalview.Mapping();
            MapList mlst = jmp.getMap();
            List<int[]> r = mlst.getFromRanges();
            for (int[] range : r) {
                MapListType.MapListFrom mfrom = new MapListType.MapListFrom();
                mfrom.setStart(range[0]);
                mfrom.setEnd(range[1]);
                mp.getMapListFrom().add(mfrom);
            }
            r = mlst.getToRanges();
            for (int[] range : r) {
                MapListType.MapListTo mto = new MapListType.MapListTo();
                mto.setStart(range[0]);
                mto.setEnd(range[1]);
                mp.getMapListTo().add(mto);
            }
            mp.setMapFromUnit(BigInteger.valueOf(mlst.getFromRatio()));
            mp.setMapToUnit(BigInteger.valueOf(mlst.getToRatio()));
            if (jmp.getTo() != null) {
                String jmpid = "";
                SequenceI ps = null;
                if (parentseq != jmp.getTo() && parentseq.getDatasetSequence() != jmp.getTo()) {
                    ps = jmp.getTo();
                    jmpid = this.seqHash(ps);
                } else {
                    ps = parentseq;
                    jmpid = this.seqHash(ps);
                }
                mp.setDseqFor(jmpid);
                if (!this.seqRefIds.containsKey(jmpid)) {
                    Cache.log.debug((Object)"creatign new DseqFor ID");
                    this.seqRefIds.put(jmpid, ps);
                } else {
                    Cache.log.debug((Object)"reusing DseqFor ID");
                }
            }
        }
        return mp;
    }

    String setUserColourScheme(ColourSchemeI cs, List<UserColourScheme> userColours, JalviewModel jm) {
        String id = null;
        UserColourScheme ucs = (UserColourScheme)cs;
        boolean newucs = false;
        if (!userColours.contains(ucs)) {
            userColours.add(ucs);
            newucs = true;
        }
        id = "ucs" + userColours.indexOf(ucs);
        if (newucs) {
            JalviewUserColours.Colour col;
            int i;
            Color[] colours = ucs.getColours();
            JalviewModel.UserColours uc = new JalviewModel.UserColours();
            JalviewUserColours jbucs = new JalviewUserColours();
            for (i = 0; i < colours.length; ++i) {
                col = new JalviewUserColours.Colour();
                col.setName(ResidueProperties.aa[i]);
                col.setRGB(Format.getHexString(colours[i]));
                jbucs.getColour().add(col);
            }
            if (ucs.getLowerCaseColours() != null) {
                colours = ucs.getLowerCaseColours();
                for (i = 0; i < colours.length; ++i) {
                    col = new JalviewUserColours.Colour();
                    col.setName(ResidueProperties.aa[i].toLowerCase());
                    col.setRGB(Format.getHexString(colours[i]));
                    jbucs.getColour().add(col);
                }
            }
            uc.setId(id);
            uc.setUserColourScheme(jbucs);
            jm.getUserColours().add(uc);
        }
        return id;
    }

    UserColourScheme getUserColourScheme(JalviewModel jm, String id) {
        List<JalviewModel.UserColours> uc = jm.getUserColours();
        JalviewModel.UserColours colours = null;
        for (JalviewModel.UserColours c : uc) {
            if (!c.getId().equals(id)) continue;
            colours = c;
            break;
        }
        Color[] newColours = new Color[24];
        for (int i = 0; i < 24; ++i) {
            newColours[i] = new Color(Integer.parseInt(colours.getUserColourScheme().getColour().get(i).getRGB(), 16));
        }
        UserColourScheme ucs = new UserColourScheme(newColours);
        if (colours.getUserColourScheme().getColour().size() > 24) {
            newColours = new Color[23];
            for (int i = 0; i < 23; ++i) {
                newColours[i] = new Color(Integer.parseInt(colours.getUserColourScheme().getColour().get(i + 24).getRGB(), 16));
            }
            ucs.setLowerCaseColours(newColours);
        }
        return ucs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public AlignFrame loadJalviewAlign(String file) {
        AlignFrame af;
        block11: {
            block10: {
                af = null;
                this.newStructureViewers = new Vector();
                jarInputStreamProvider jprovider = this.createjarInputStreamProvider(file);
                af = this.loadJalviewAlign(jprovider);
                if (af == null) break block10;
                af.setMenusForViewport();
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Jalview2XML.this.setLoadingFinishedForNewStructureViewers();
                    }
                });
            }
            catch (Exception x) {
                System.err.println("Error loading alignment: " + x.getMessage());
            }
            break block11;
            catch (MalformedURLException e) {
                try {
                    this.errorMessage = "Invalid URL format for '" + file + "'";
                    this.reportErrors();
                }
                catch (Throwable throwable) {
                    try {
                        SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception x) {
                        System.err.println("Error loading alignment: " + x.getMessage());
                    }
                    throw throwable;
                }
                try {
                    SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception x) {
                    System.err.println("Error loading alignment: " + x.getMessage());
                }
            }
        }
        return af;
    }

    private jarInputStreamProvider createjarInputStreamProvider(final String file) throws MalformedURLException {
        URL url = null;
        this.errorMessage = null;
        this.uniqueSetSuffix = null;
        this.seqRefIds = null;
        this.viewportsAdded.clear();
        this.frefedSequence = null;
        if (file.startsWith("http://")) {
            url = new URL(file);
        }
        final URL _url = url;
        return new jarInputStreamProvider(){

            @Override
            public JarInputStream getJarInputStream() throws IOException {
                if (_url != null) {
                    return new JarInputStream(_url.openStream());
                }
                return new JarInputStream(new FileInputStream(file));
            }

            @Override
            public String getFilename() {
                return file;
            }
        };
    }

    public AlignFrame loadJalviewAlign(jarInputStreamProvider jprovider) {
        this.errorMessage = null;
        if (this.uniqueSetSuffix == null) {
            this.uniqueSetSuffix = "" + System.currentTimeMillis() % 100000L;
        }
        if (this.seqRefIds == null) {
            this.initSeqRefs();
        }
        AlignFrame af = null;
        AlignFrame _af = null;
        IdentityHashMap<AlignmentI, AlignmentI> importedDatasets = new IdentityHashMap<AlignmentI, AlignmentI>();
        HashMap<String, AlignFrame> gatherToThisFrame = new HashMap<String, AlignFrame>();
        String file = jprovider.getFilename();
        try {
            JarInputStream jin = null;
            JarEntry jarentry = null;
            int entryCount = 1;
            do {
                jin = jprovider.getJarInputStream();
                for (int i = 0; i < entryCount; ++i) {
                    jarentry = jin.getNextJarEntry();
                }
                if (jarentry != null && jarentry.getName().endsWith(".xml")) {
                    InputStreamReader in = new InputStreamReader((InputStream)jin, UTF_8);
                    JAXBContext jc = JAXBContext.newInstance((String)"jalview.xml.binding.jalview");
                    XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(jin);
                    Unmarshaller um = jc.createUnmarshaller();
                    JAXBElement jbe = um.unmarshal(streamReader, JalviewModel.class);
                    JalviewModel object = (JalviewModel)jbe.getValue();
                    _af = this.loadFromObject(object, file, true, jprovider);
                    if (_af != null && object.getViewport().size() > 0) {
                        if (af == null) {
                            af = _af;
                        }
                        if (_af.getViewport().isGatherViewsHere()) {
                            af = _af;
                            gatherToThisFrame.put(_af.getViewport().getSequenceSetId(), _af);
                        }
                        importedDatasets.put(af.getViewport().getAlignment().getDataset(), af.getViewport().getAlignment().getDataset());
                    }
                    ++entryCount;
                    continue;
                }
                if (jarentry == null) continue;
                ++entryCount;
            } while (jarentry != null);
            this.resolveFrefedSequences();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.errorMessage = "Couldn't locate Jalview XML file : " + file;
            System.err.println("Exception whilst loading jalview XML file : " + ex + "\n");
        }
        catch (Exception ex) {
            System.err.println("Parsing as Jalview Version 2 file failed.");
            ex.printStackTrace(System.err);
            if (this.attemptversion1parse) {
                // empty if block
            }
            if (Desktop.instance != null) {
                Desktop.instance.stopLoading();
            }
            if (af != null) {
                System.out.println("Successfully loaded archive file");
                return af;
            }
            ex.printStackTrace();
            System.err.println("Exception whilst loading jalview XML file : " + ex + "\n");
        }
        catch (OutOfMemoryError e) {
            this.errorMessage = "Out of memory loading jalview XML file";
            System.err.println("Out of memory whilst loading jalview XML file");
            e.printStackTrace();
        }
        for (AlignFrame fr : gatherToThisFrame.values()) {
            Desktop.instance.gatherViews(fr);
        }
        this.restoreSplitFrames();
        for (AlignmentI ds : importedDatasets.keySet()) {
            if (ds.getCodonFrames() == null) continue;
            StructureSelectionManager.getStructureSelectionManager(Desktop.instance).registerMappings(ds.getCodonFrames());
        }
        if (this.errorMessage != null) {
            this.reportErrors();
        }
        if (Desktop.instance != null) {
            Desktop.instance.stopLoading();
        }
        return af;
    }

    protected void restoreSplitFrames() {
        AlignFrame af;
        ArrayList<SplitFrame> gatherTo = new ArrayList<SplitFrame>();
        ArrayList<AlignFrame> addedToSplitFrames = new ArrayList<AlignFrame>();
        HashMap<String, AlignFrame> dna = new HashMap<String, AlignFrame>();
        for (Map.Entry<JalviewModel.Viewport, AlignFrame> candidate : this.splitFrameCandidates.entrySet()) {
            af = candidate.getValue();
            if (!af.getViewport().getAlignment().isNucleotide()) continue;
            dna.put(candidate.getKey().getId(), af);
        }
        for (Map.Entry<JalviewModel.Viewport, AlignFrame> candidate : this.splitFrameCandidates.entrySet()) {
            String complementId;
            af = candidate.getValue();
            if (af.getViewport().getAlignment().isNucleotide() || (complementId = candidate.getKey().getComplementId()) == null || !dna.containsKey(complementId)) continue;
            AlignFrame dnaFrame = (AlignFrame)dna.get(complementId);
            SplitFrame sf = this.createSplitFrame(dnaFrame, af);
            addedToSplitFrames.add(dnaFrame);
            addedToSplitFrames.add(af);
            dnaFrame.setMenusForViewport();
            af.setMenusForViewport();
            if (!af.getViewport().isGatherViewsHere()) continue;
            gatherTo.add(sf);
        }
        for (Map.Entry<JalviewModel.Viewport, AlignFrame> candidate : this.splitFrameCandidates.entrySet()) {
            af = candidate.getValue();
            if (addedToSplitFrames.contains(af)) continue;
            JalviewModel.Viewport view = candidate.getKey();
            Desktop.addInternalFrame(af, view.getTitle(), Jalview2XML.safeInt(view.getWidth()), Jalview2XML.safeInt(view.getHeight()));
            af.setMenusForViewport();
            System.err.println("Failed to restore view " + view.getTitle() + " to split frame");
        }
        for (SplitFrame sf : gatherTo) {
            Desktop.instance.gatherViews(sf);
        }
        this.splitFrameCandidates.clear();
    }

    protected SplitFrame createSplitFrame(AlignFrame dnaFrame, AlignFrame proteinFrame) {
        SplitFrame splitFrame = new SplitFrame(dnaFrame, proteinFrame);
        String title = MessageManager.getString("label.linked_view_title");
        int width = (int)dnaFrame.getBounds().getWidth();
        int height = (int)(dnaFrame.getBounds().getHeight() + proteinFrame.getBounds().getHeight() + 50.0);
        splitFrame.setLocation(dnaFrame.getX(), dnaFrame.getY());
        Desktop.addInternalFrame(splitFrame, title, width, height);
        proteinFrame.getViewport().alignmentChanged(proteinFrame.alignPanel);
        return splitFrame;
    }

    protected void reportErrors() {
        this.reportErrors(false);
    }

    protected void reportErrors(final boolean saving) {
        if (this.errorMessage != null) {
            final String finalErrorMessage = this.errorMessage;
            if (this.raiseGUI) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JvOptionPane.showInternalMessageDialog(Desktop.desktop, finalErrorMessage, "Error " + (saving ? "saving" : "loading") + " Jalview file", 2);
                    }
                });
            } else {
                System.err.println("Problem loading Jalview file: " + this.errorMessage);
            }
        }
        this.errorMessage = null;
    }

    String loadPDBFile(jarInputStreamProvider jprovider, String pdbId, String origFile) {
        if (this.alreadyLoadedPDB.containsKey(pdbId)) {
            return this.alreadyLoadedPDB.get(pdbId).toString();
        }
        String tempFile = this.copyJarEntry(jprovider, pdbId, "jalview_pdb", origFile);
        if (tempFile != null) {
            this.alreadyLoadedPDB.put(pdbId, tempFile);
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String copyJarEntry(jarInputStreamProvider jprovider, String jarEntryName, String prefix, String suffixModel) {
        int sfpos;
        BufferedReader in = null;
        PrintWriter out = null;
        Object suffix = ".tmp";
        if (suffixModel == null) {
            suffixModel = jarEntryName;
        }
        if ((sfpos = suffixModel.lastIndexOf(".")) > -1 && sfpos < suffixModel.length() - 1) {
            suffix = "." + suffixModel.substring(sfpos + 1);
        }
        try {
            JarInputStream jin = jprovider.getJarInputStream();
            JarEntry entry = null;
            while ((entry = jin.getNextJarEntry()) != null && !entry.getName().equals(jarEntryName)) {
            }
            if (entry != null) {
                String t;
                String data;
                in = new BufferedReader(new InputStreamReader((InputStream)jin, UTF_8));
                File outFile = File.createTempFile(prefix, (String)suffix);
                outFile.deleteOnExit();
                out = new PrintWriter(new FileOutputStream(outFile));
                while ((data = in.readLine()) != null) {
                    out.println(data);
                }
                out.flush();
                String string = t = outFile.getAbsolutePath();
                return string;
            }
            this.warn("Couldn't find entry in Jalview Jar for " + jarEntryName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                out.close();
            }
        }
        return null;
    }

    AlignFrame loadFromObject(JalviewModel jalviewModel, String file, boolean loadTreesAndStructures, jarInputStreamProvider jprovider) {
        AlignmentPanel[] views;
        SequenceSet vamsasSet = jalviewModel.getVamsasModel().getSequenceSet().get(0);
        List<Sequence> vamsasSeqs = vamsasSet.getSequence();
        JalviewModel.Viewport view = jalviewModel.getViewport().size() > 0 ? jalviewModel.getViewport().get(0) : null;
        Object uniqueSeqSetId = null;
        String viewId = null;
        if (view != null) {
            uniqueSeqSetId = view.getSequenceSetId() + this.uniqueSetSuffix;
            viewId = view.getId() == null ? null : view.getId() + this.uniqueSetSuffix;
        }
        ArrayList<SequenceI> hiddenSeqs = null;
        ArrayList<SequenceI> tmpseqs = new ArrayList<SequenceI>();
        boolean multipleView = false;
        SequenceI referenceseqForView = null;
        List<JalviewModel.JSeq> jseqs = jalviewModel.getJSeq();
        int vi = 0;
        for (int i = 0; i < jseqs.size(); ++i) {
            JalviewModel.JSeq jseq = jseqs.get(i);
            String seqId = jseq.getId();
            SequenceI tmpSeq = this.seqRefIds.get(seqId);
            if (tmpSeq != null) {
                if (!this.incompleteSeqs.containsKey(seqId)) {
                    if (tmpSeq.getStart() != jseq.getStart() || tmpSeq.getEnd() != jseq.getEnd()) {
                        System.err.println("Warning JAL-2154 regression: updating start/end for sequence " + tmpSeq.toString() + " to " + jseq);
                    }
                } else {
                    this.incompleteSeqs.remove(seqId);
                }
                if (vamsasSeqs.size() > vi && vamsasSeqs.get(vi).getId().equals(seqId)) {
                    tmpSeq.setName(vamsasSeqs.get(vi).getName());
                    tmpSeq.setDescription(vamsasSeqs.get(vi).getDescription());
                    tmpSeq.setSequence(vamsasSeqs.get(vi).getSequence());
                    ++vi;
                } else {
                    multipleView = true;
                }
                tmpSeq.setStart(jseq.getStart());
                tmpSeq.setEnd(jseq.getEnd());
                tmpseqs.add(tmpSeq);
            } else {
                Sequence vamsasSeq = vamsasSeqs.get(vi);
                tmpSeq = new jalview.datamodel.Sequence(vamsasSeq.getName(), vamsasSeq.getSequence());
                tmpSeq.setDescription(vamsasSeq.getDescription());
                tmpSeq.setStart(jseq.getStart());
                tmpSeq.setEnd(jseq.getEnd());
                tmpSeq.setVamsasId(this.uniqueSetSuffix + seqId);
                this.seqRefIds.put(vamsasSeq.getId(), tmpSeq);
                tmpseqs.add(tmpSeq);
                ++vi;
            }
            if (Jalview2XML.safeBoolean(jseq.isViewreference())) {
                referenceseqForView = (SequenceI)tmpseqs.get(tmpseqs.size() - 1);
            }
            if (jseq.isHidden() == null || !jseq.isHidden().booleanValue()) continue;
            if (hiddenSeqs == null) {
                hiddenSeqs = new ArrayList<SequenceI>();
            }
            hiddenSeqs.add(tmpSeq);
        }
        SequenceI[] orderedSeqs = tmpseqs.toArray(new SequenceI[tmpseqs.size()]);
        AlignmentI al = null;
        if (vamsasSet.getDatasetId() == null || vamsasSet.getDatasetId() == "") {
            al = new Alignment(orderedSeqs);
            al.setDataset(null);
        } else {
            boolean isdsal = jalviewModel.getViewport().isEmpty();
            if (isdsal) {
                al = this.getDatasetFor(vamsasSet.getDatasetId());
            }
            if (al == null) {
                al = new Alignment(orderedSeqs);
            }
            if (isdsal) {
                this.addDatasetRef(vamsasSet.getDatasetId(), al);
            }
            this.recoverDatasetFor(vamsasSet, al, isdsal, (String)uniqueSeqSetId);
        }
        if (referenceseqForView != null) {
            al.setSeqrep(referenceseqForView);
        }
        for (int i = 0; i < vamsasSet.getSequenceSetProperties().size(); ++i) {
            SequenceSet.SequenceSetProperties ssp = vamsasSet.getSequenceSetProperties().get(i);
            al.setProperty(ssp.getKey(), ssp.getValue());
        }
        Hashtable pdbloaded = new Hashtable();
        if (!multipleView) {
            for (int i = 0; i < vamsasSeqs.size(); ++i) {
                String hmmJarFile;
                JalviewModel.JSeq jseq = jseqs.get(i);
                if (jseq.getFeatures().size() > 0) {
                    List<Feature> features = jseq.getFeatures();
                    for (int f = 0; f < features.size(); ++f) {
                        Feature feat = features.get(f);
                        SequenceFeature sf = new SequenceFeature(feat.getType(), feat.getDescription(), feat.getBegin(), feat.getEnd(), Jalview2XML.safeFloat(feat.getScore()), feat.getFeatureGroup());
                        sf.setStatus(feat.getStatus());
                        HashMap mapAttributes = new HashMap();
                        for (int od = 0; od < feat.getOtherData().size(); ++od) {
                            Feature.OtherData keyValue = feat.getOtherData().get(od);
                            String attributeName = keyValue.getKey();
                            String attributeValue = keyValue.getValue();
                            if (attributeName.startsWith("LINK")) {
                                sf.addLink(attributeValue);
                                continue;
                            }
                            String subAttribute = keyValue.getKey2();
                            if (subAttribute == null) {
                                sf.setValue(attributeName, attributeValue);
                                continue;
                            }
                            if (!mapAttributes.containsKey(attributeName)) {
                                mapAttributes.put(attributeName, new HashMap());
                            }
                            ((Map)mapAttributes.get(attributeName)).put(subAttribute, attributeValue);
                        }
                        for (Map.Entry mapAttribute : mapAttributes.entrySet()) {
                            sf.setValue((String)mapAttribute.getKey(), mapAttribute.getValue());
                        }
                        al.getSequenceAt(i).addSequenceFeature(sf);
                    }
                }
                if (vamsasSeqs.get(i).getDBRef().size() > 0) {
                    this.addDBRefs(al.getSequenceAt(i).getDatasetSequence() == null ? al.getSequenceAt(i) : al.getSequenceAt(i).getDatasetSequence(), vamsasSeqs.get(i));
                }
                if (jseq.getPdbids().size() > 0) {
                    List<JalviewModel.JSeq.Pdbids> ids = jseq.getPdbids();
                    for (int p = 0; p < ids.size(); ++p) {
                        JalviewModel.JSeq.Pdbids pdbid = ids.get(p);
                        PDBEntry entry = new PDBEntry();
                        entry.setId(pdbid.getId());
                        if (pdbid.getType() != null) {
                            if (PDBEntry.Type.getType(pdbid.getType()) != null) {
                                entry.setType(PDBEntry.Type.getType(pdbid.getType()));
                            } else {
                                entry.setType(PDBEntry.Type.FILE);
                            }
                        }
                        if (pdbid.getFile() != null && jprovider != null) {
                            if (!pdbloaded.containsKey(pdbid.getFile())) {
                                entry.setFile(this.loadPDBFile(jprovider, pdbid.getId(), pdbid.getFile()));
                            } else {
                                entry.setFile(pdbloaded.get(pdbid.getId()).toString());
                            }
                        }
                        for (Pdbentry.Property prop : pdbid.getProperty()) {
                            entry.setProperty(prop.getName(), prop.getValue());
                        }
                        StructureSelectionManager.getStructureSelectionManager(Desktop.instance).registerPDBEntry(entry);
                        if (al.getSequenceAt(i).getDatasetSequence() != null) {
                            al.getSequenceAt(i).getDatasetSequence().addPDBId(entry);
                            continue;
                        }
                        al.getSequenceAt(i).addPDBId(entry);
                    }
                }
                if ((hmmJarFile = jseqs.get(i).getHmmerProfile()) == null || jprovider == null) continue;
                this.loadHmmerProfile(jprovider, hmmJarFile, al.getSequenceAt(i));
            }
        }
        if (vamsasSet.getAlcodonFrame().size() > 0) {
            List<AlcodonFrame> alc = vamsasSet.getAlcodonFrame();
            for (int i = 0; i < alc.size(); ++i) {
                AlignedCodonFrame cf = new AlignedCodonFrame();
                if (alc.get(i).getAlcodMap().size() <= 0) continue;
                List<AlcodonFrame.AlcodMap> maps = alc.get(i).getAlcodMap();
                for (int m = 0; m < maps.size(); ++m) {
                    AlcodonFrame.AlcodMap map = maps.get(m);
                    SequenceI dnaseq = this.seqRefIds.get(map.getDnasq());
                    Mapping mapping = null;
                    if (map.getMapping() == null) continue;
                    mapping = this.addMapping(map.getMapping());
                    if (dnaseq != null && mapping.getTo() != null) {
                        cf.addMap(dnaseq, mapping.getTo(), mapping.getMap());
                        continue;
                    }
                    this.frefedSequence.add(this.newAlcodMapRef(map.getDnasq(), cf, mapping));
                }
                al.addCodonFrame(cf);
            }
        }
        ArrayList<JvAnnotRow> autoAlan = new ArrayList<JvAnnotRow>();
        Hashtable<String, ArrayList<AlignmentAnnotation>> groupAnnotRefs = new Hashtable<String, ArrayList<AlignmentAnnotation>>();
        if (vamsasSet.getAnnotation().size() > 0) {
            List<Annotation> an = vamsasSet.getAnnotation();
            for (int i = 0; i < an.size(); ++i) {
                String sequenceRef;
                String annotationId;
                Annotation annotation = an.get(i);
                boolean autoForView = false;
                if (annotation.getLabel().equals("Quality") || annotation.getLabel().equals("Conservation") || annotation.getLabel().equals("Consensus")) {
                    autoForView = true;
                }
                if (autoForView || annotation.isAutoCalculated()) {
                    annotation.setId(null);
                }
                if ((annotationId = annotation.getId()) != null && this.annotationIds.containsKey(annotationId)) {
                    AlignmentAnnotation jda = this.annotationIds.get(annotationId);
                    if (annotation.isVisible() != null) {
                        jda.visible = annotation.isVisible();
                    }
                    al.addAnnotation(jda);
                    continue;
                }
                List<AnnotationElement> ae = annotation.getAnnotationElement();
                jalview.datamodel.Annotation[] anot = null;
                Color firstColour = null;
                if (!annotation.isScoreOnly()) {
                    anot = new jalview.datamodel.Annotation[al.getWidth()];
                    for (int aa = 0; aa < ae.size() && aa < anot.length; ++aa) {
                        AnnotationElement annElement = ae.get(aa);
                        int anpos = annElement.getPosition();
                        if (anpos >= anot.length) continue;
                        float value = Jalview2XML.safeFloat(annElement.getValue());
                        anot[anpos] = new jalview.datamodel.Annotation(annElement.getDisplayCharacter(), annElement.getDescription(), annElement.getSecondaryStructure() == null || annElement.getSecondaryStructure().length() == 0 ? (char)' ' : annElement.getSecondaryStructure().charAt(0), value);
                        anot[anpos].colour = new Color(Jalview2XML.safeInt(annElement.getColour()));
                        if (firstColour != null) continue;
                        firstColour = anot[anpos].colour;
                    }
                }
                AlignmentAnnotation jaa = null;
                if (annotation.isGraph()) {
                    float llim = 0.0f;
                    float hlim = 0.0f;
                    jaa = new AlignmentAnnotation(annotation.getLabel(), annotation.getDescription(), anot, llim, hlim, Jalview2XML.safeInt(annotation.getGraphType()));
                    jaa.graphGroup = Jalview2XML.safeInt(annotation.getGraphGroup());
                    jaa._linecolour = firstColour;
                    if (annotation.getThresholdLine() != null) {
                        jaa.setThreshold(new GraphLine(Jalview2XML.safeFloat(annotation.getThresholdLine().getValue()), annotation.getThresholdLine().getLabel(), new Color(Jalview2XML.safeInt(annotation.getThresholdLine().getColour()))));
                    }
                    if (autoForView || annotation.isAutoCalculated()) {
                        jaa.hasText = true;
                    }
                } else {
                    jaa = new AlignmentAnnotation(annotation.getLabel(), annotation.getDescription(), anot);
                    jaa._linecolour = firstColour;
                }
                if (annotation.getId() != null) {
                    this.annotationIds.put(annotation.getId(), jaa);
                    jaa.annotationId = annotation.getId();
                }
                if ((sequenceRef = annotation.getSequenceRef()) != null) {
                    SequenceI sequence = this.seqRefIds.get(sequenceRef);
                    if (sequence == null) {
                        sequence = al.findName(sequenceRef);
                    }
                    if (sequence != null) {
                        jaa.createSequenceMapping(sequence, 1, true);
                        sequence.addAlignmentAnnotation(jaa);
                    }
                }
                if (annotation.getGroupRef() != null && annotation.getGroupRef().length() > 0) {
                    ArrayList<AlignmentAnnotation> aal = (ArrayList<AlignmentAnnotation>)groupAnnotRefs.get(annotation.getGroupRef());
                    if (aal == null) {
                        aal = new ArrayList<AlignmentAnnotation>();
                        groupAnnotRefs.put(annotation.getGroupRef(), aal);
                    }
                    aal.add(jaa);
                }
                if (annotation.getScore() != null) {
                    jaa.setScore(annotation.getScore());
                }
                if (annotation.isVisible() != null) {
                    jaa.visible = annotation.isVisible();
                }
                if (annotation.isCentreColLabels() != null) {
                    jaa.centreColLabels = annotation.isCentreColLabels();
                }
                if (annotation.isScaleColLabels() != null) {
                    jaa.scaleColLabel = annotation.isScaleColLabels();
                }
                if (annotation.isAutoCalculated()) {
                    jaa.autoCalculated = true;
                }
                if (annotation.getGraphHeight() != null) {
                    jaa.graphHeight = annotation.getGraphHeight();
                }
                jaa.belowAlignment = annotation.isBelowAlignment();
                jaa.setCalcId(annotation.getCalcId());
                if (annotation.getProperty().size() > 0) {
                    for (Annotation.Property prop : annotation.getProperty()) {
                        jaa.setProperty(prop.getName(), prop.getValue());
                    }
                }
                if (jaa.autoCalculated) {
                    autoAlan.add(new JvAnnotRow(i, jaa));
                    continue;
                }
                al.addAnnotation(jaa);
            }
        }
        if (jalviewModel.getJGroup().size() > 0) {
            List<JalviewModel.JGroup> groups = jalviewModel.getJGroup();
            boolean addAnnotSchemeGroup = false;
            for (int i = 0; i < groups.size(); ++i) {
                List jaal;
                JalviewModel.JGroup jGroup = groups.get(i);
                ColourSchemeI cs = null;
                if (jGroup.getColour() != null) {
                    if (jGroup.getColour().startsWith("ucs")) {
                        cs = this.getUserColourScheme(jalviewModel, jGroup.getColour());
                    } else if (jGroup.getColour().equals("AnnotationColourGradient") && jGroup.getAnnotationColours() != null) {
                        addAnnotSchemeGroup = true;
                    } else {
                        cs = ColourSchemeProperty.getColourScheme(null, al, jGroup.getColour());
                    }
                }
                int pidThreshold = Jalview2XML.safeInt(jGroup.getPidThreshold());
                Vector<SequenceI> seqs = new Vector<SequenceI>();
                for (int s = 0; s < jGroup.getSeq().size(); ++s) {
                    String seqId = jGroup.getSeq().get(s);
                    SequenceI ts = this.seqRefIds.get(seqId);
                    if (ts == null) continue;
                    seqs.addElement(ts);
                }
                if (seqs.size() < 1) continue;
                SequenceGroup sg = new SequenceGroup(seqs, jGroup.getName(), cs, Jalview2XML.safeBoolean(jGroup.isDisplayBoxes()), Jalview2XML.safeBoolean(jGroup.isDisplayText()), Jalview2XML.safeBoolean(jGroup.isColourText()), Jalview2XML.safeInt(jGroup.getStart()), Jalview2XML.safeInt(jGroup.getEnd()));
                sg.getGroupColourScheme().setThreshold(pidThreshold, true);
                sg.getGroupColourScheme().setConservationInc(Jalview2XML.safeInt(jGroup.getConsThreshold()));
                sg.setOutlineColour(new Color(Jalview2XML.safeInt(jGroup.getOutlineColour())));
                sg.textColour = new Color(Jalview2XML.safeInt(jGroup.getTextCol1()));
                sg.textColour2 = new Color(Jalview2XML.safeInt(jGroup.getTextCol2()));
                sg.setShowNonconserved(Jalview2XML.safeBoolean(jGroup.isShowUnconserved()));
                sg.thresholdTextColour = Jalview2XML.safeInt(jGroup.getTextColThreshold());
                sg.setShowConsensusHistogram(jGroup.isShowConsensusHistogram());
                sg.setshowSequenceLogo(jGroup.isShowSequenceLogo());
                sg.setNormaliseSequenceLogo(jGroup.isNormaliseSequenceLogo());
                sg.setIgnoreGapsConsensus(jGroup.isIgnoreGapsinConsensus());
                if (jGroup.getConsThreshold() != null && jGroup.getConsThreshold() != 0) {
                    Conservation c = new Conservation("All", sg.getSequences(null), 0, sg.getWidth() - 1);
                    c.calculate();
                    c.verdict(false, 25.0f);
                    sg.cs.setConservation(c);
                }
                if (jGroup.getId() != null && groupAnnotRefs.size() > 0 && (jaal = (List)groupAnnotRefs.get(jGroup.getId())) != null) {
                    for (AlignmentAnnotation jaa : jaal) {
                        jaa.groupRef = sg;
                        if (!jaa.autoCalculated) continue;
                        if (jaa.label.startsWith("Consensus for ")) {
                            sg.setConsensus(jaa);
                        }
                        if (!jaa.label.startsWith("Conservation for ")) continue;
                        sg.setConservationRow(jaa);
                    }
                }
                al.addGroup(sg);
                if (!addAnnotSchemeGroup) continue;
                sg.setColourScheme(this.constructAnnotationColour(jGroup.getAnnotationColours(), null, al, jalviewModel, false));
            }
        }
        if (view == null) {
            return null;
        }
        AlignFrame af = null;
        AlignViewport av = null;
        if (multipleView && this.viewportsAdded.size() == 0) {
            System.err.println("About to recover a viewport for existing alignment: Sequence set ID is " + (String)uniqueSeqSetId);
            Object seqsetobj = this.retrieveExistingObj((String)uniqueSeqSetId);
            if (seqsetobj != null) {
                if (seqsetobj instanceof String) {
                    uniqueSeqSetId = (String)seqsetobj;
                    System.err.println("Recovered extant sequence set ID mapping for ID : New Sequence set ID is " + (String)uniqueSeqSetId);
                } else {
                    System.err.println("Warning : Collision between sequence set ID string and existing jalview object mapping.");
                }
            }
        }
        boolean doGroupAnnColour = Jalview2XML.isVersionStringLaterThan("2.8.1", jalviewModel.getVersion());
        AlignmentPanel ap = null;
        boolean isnewview = true;
        if (viewId != null && (views = Desktop.getAlignmentPanels((String)uniqueSeqSetId)) != null && views.length > 0) {
            for (int v = 0; v < views.length; ++v) {
                if (!views[v].av.getViewId().equalsIgnoreCase(viewId)) continue;
                af = views[v].alignFrame;
                av = views[v].av;
                ap = views[v];
                isnewview = false;
            }
        }
        if (isnewview) {
            af = this.loadViewport(file, jseqs, hiddenSeqs, al, jalviewModel, view, (String)uniqueSeqSetId, viewId, autoAlan);
            av = af.getViewport();
            ap = af.alignPanel;
        }
        if (loadTreesAndStructures) {
            this.loadTrees(jalviewModel, view, af, av, ap);
            this.loadPCAViewers(jalviewModel, ap);
            this.loadPDBStructures(jprovider, jseqs, af, ap);
            this.loadRnaViewers(jprovider, jseqs, ap);
        }
        return af;
    }

    protected void loadHmmerProfile(jarInputStreamProvider jprovider, String hmmJarFile, SequenceI seq) {
        try {
            String hmmFile = this.copyJarEntry(jprovider, hmmJarFile, "hmm", null);
            HMMFile parser = new HMMFile(hmmFile, DataSourceType.FILE);
            HiddenMarkovModel hmmModel = parser.getHMM();
            hmmModel = new HiddenMarkovModel(hmmModel, seq);
            seq.setHMM(hmmModel);
        }
        catch (IOException e) {
            this.warn("Error loading HMM profile for " + seq.getName() + ": " + e.getMessage());
        }
    }

    private void loadRnaViewers(jarInputStreamProvider jprovider, List<JalviewModel.JSeq> jseqs, AlignmentPanel ap) {
        for (JalviewModel.JSeq jseq : jseqs) {
            for (int i = 0; i < jseq.getRnaViewer().size(); ++i) {
                JalviewModel.JSeq.RnaViewer viewer = jseq.getRnaViewer().get(i);
                AppVarna appVarna = this.findOrCreateVarnaViewer(viewer, this.uniqueSetSuffix, ap);
                for (int j = 0; j < viewer.getSecondaryStructure().size(); ++j) {
                    JalviewModel.JSeq.RnaViewer.SecondaryStructure ss = viewer.getSecondaryStructure().get(j);
                    SequenceI seq = this.seqRefIds.get(jseq.getId());
                    AlignmentAnnotation ann = this.annotationIds.get(ss.getAnnotationId());
                    boolean gapped = Jalview2XML.safeBoolean(ss.isGapped());
                    String rnaTitle = ss.getTitle();
                    String sessionState = ss.getViewerState();
                    String tempStateFile = this.copyJarEntry(jprovider, sessionState, "varna", null);
                    RnaModel rna = new RnaModel(rnaTitle, ann, seq, null, gapped);
                    appVarna.addModelSession(rna, rnaTitle, tempStateFile);
                }
                appVarna.setInitialSelection(Jalview2XML.safeInt(viewer.getSelectedRna()));
            }
        }
    }

    protected AppVarna findOrCreateVarnaViewer(JalviewModel.JSeq.RnaViewer viewer, String viewIdSuffix, AlignmentPanel ap) {
        String postLoadId = viewer.getViewId() + viewIdSuffix;
        for (JInternalFrame frame : this.getAllFrames()) {
            AppVarna varna;
            if (!(frame instanceof AppVarna) || !postLoadId.equals((varna = (AppVarna)frame).getViewId())) continue;
            return varna;
        }
        RnaViewerModel model = new RnaViewerModel(postLoadId, viewer.getTitle(), Jalview2XML.safeInt(viewer.getXpos()), Jalview2XML.safeInt(viewer.getYpos()), Jalview2XML.safeInt(viewer.getWidth()), Jalview2XML.safeInt(viewer.getHeight()), Jalview2XML.safeInt(viewer.getDividerLocation()));
        AppVarna varna = new AppVarna(model, ap);
        return varna;
    }

    protected void loadTrees(JalviewModel jm, JalviewModel.Viewport view, AlignFrame af, AlignViewport av, AlignmentPanel ap) {
        try {
            for (int t = 0; t < jm.getTree().size(); ++t) {
                JalviewModel.Tree tree = jm.getTree().get(t);
                TreePanel tp = (TreePanel)this.retrieveExistingObj(tree.getId());
                if (tp == null) {
                    tp = af.showNewickTree(new NewickFile(tree.getNewick()), tree.getTitle(), Jalview2XML.safeInt(tree.getWidth()), Jalview2XML.safeInt(tree.getHeight()), Jalview2XML.safeInt(tree.getXpos()), Jalview2XML.safeInt(tree.getYpos()));
                    if (tree.getId() != null) {
                        // empty if block
                    }
                } else {
                    tp.setTitle(tree.getTitle());
                    tp.setBounds(new Rectangle(Jalview2XML.safeInt(tree.getXpos()), Jalview2XML.safeInt(tree.getYpos()), Jalview2XML.safeInt(tree.getWidth()), Jalview2XML.safeInt(tree.getHeight())));
                    tp.setViewport(av);
                    tp.getTreeCanvas().setViewport(av);
                    tp.getTreeCanvas().setAssociatedPanel(ap);
                }
                tp.getTreeCanvas().setApplyToAllViews(tree.isLinkToAllViews());
                if (tp == null) {
                    this.warn("There was a problem recovering stored Newick tree: \n" + tree.getNewick());
                    continue;
                }
                tp.fitToWindow.setState(Jalview2XML.safeBoolean(tree.isFitToWindow()));
                tp.fitToWindow_actionPerformed(null);
                if (tree.getFontName() != null) {
                    tp.setTreeFont(new Font(tree.getFontName(), Jalview2XML.safeInt(tree.getFontStyle()), Jalview2XML.safeInt(tree.getFontSize())));
                } else {
                    tp.setTreeFont(new Font(view.getFontName(), Jalview2XML.safeInt(view.getFontStyle()), Jalview2XML.safeInt(view.getFontSize())));
                }
                tp.showPlaceholders(Jalview2XML.safeBoolean(tree.isMarkUnlinked()));
                tp.showBootstrap(Jalview2XML.safeBoolean(tree.isShowBootstrap()));
                tp.showDistances(Jalview2XML.safeBoolean(tree.isShowDistances()));
                tp.getTreeCanvas().setThreshold(Jalview2XML.safeFloat(tree.getThreshold()));
                if (!Jalview2XML.safeBoolean(tree.isCurrentTree())) continue;
                af.getViewport().setCurrentTree(tp.getTree());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void loadPDBStructures(jarInputStreamProvider jprovider, List<JalviewModel.JSeq> jseqs, AlignFrame af, AlignmentPanel ap) {
        LinkedHashMap<CallSite, StructureViewerModel> structureViewers = new LinkedHashMap<CallSite, StructureViewerModel>();
        for (int i = 0; i < jseqs.size(); ++i) {
            JalviewModel.JSeq jSeq = jseqs.get(i);
            if (jSeq.getPdbids().size() <= 0) continue;
            List<JalviewModel.JSeq.Pdbids> ids = jSeq.getPdbids();
            for (int p = 0; p < ids.size(); ++p) {
                JalviewModel.JSeq.Pdbids pdbid = ids.get(p);
                int structureStateCount = pdbid.getStructureState().size();
                for (int s = 0; s < structureStateCount; ++s) {
                    StructureViewerModel jmoldat;
                    JalviewModel.JSeq.Pdbids.StructureState structureState = pdbid.getStructureState().get(s);
                    String sviewid = structureState.getViewId() == null ? null : structureState.getViewId() + this.uniqueSetSuffix;
                    PDBEntry jpdb = new PDBEntry();
                    jpdb.setFile(this.loadPDBFile(jprovider, pdbid.getId(), pdbid.getFile()));
                    jpdb.setId(pdbid.getId());
                    int x = Jalview2XML.safeInt(structureState.getXpos());
                    int y = Jalview2XML.safeInt(structureState.getYpos());
                    int width = Jalview2XML.safeInt(structureState.getWidth());
                    int height = Jalview2XML.safeInt(structureState.getHeight());
                    String pdbFile = this.loadPDBFile(jprovider, pdbid.getId(), pdbid.getFile());
                    SequenceI seq = this.seqRefIds.get(jSeq.getId());
                    if (sviewid == null) {
                        sviewid = "_jalview_pre2_4_" + x + "," + y + "," + width + "," + height;
                    }
                    if (!structureViewers.containsKey(sviewid)) {
                        structureViewers.put((CallSite)((Object)sviewid), new StructureViewerModel(x, y, width, height, false, false, true, structureState.getViewId(), structureState.getType()));
                    }
                    jmoldat.setAlignWithPanel((jmoldat = (StructureViewerModel)structureViewers.get(sviewid)).isAlignWithPanel() || structureState.isAlignwithAlignPanel());
                    boolean colourWithAlignPanel = jmoldat.isColourWithAlignPanel();
                    jmoldat.setColourWithAlignPanel(colourWithAlignPanel |= structureState.isColourwithAlignPanel());
                    boolean colourByViewer = jmoldat.isColourByViewer();
                    jmoldat.setColourByViewer(colourByViewer &= structureState.isColourByJmol());
                    if (jmoldat.getStateData().length() < structureState.getValue().length()) {
                        jmoldat.setStateData(structureState.getValue());
                    }
                    if (pdbid.getFile() != null) {
                        File mapkey = new File(pdbid.getFile());
                        StructureViewerModel.StructureData seqstrmaps = jmoldat.getFileData().get(mapkey);
                        if (seqstrmaps == null) {
                            Map<File, StructureViewerModel.StructureData> map = jmoldat.getFileData();
                            StructureViewerModel structureViewerModel = jmoldat;
                            Objects.requireNonNull(structureViewerModel);
                            seqstrmaps = structureViewerModel.new StructureViewerModel.StructureData(pdbFile, pdbid.getId());
                            map.put(mapkey, seqstrmaps);
                        }
                        if (seqstrmaps.getSeqList().contains(seq)) continue;
                        seqstrmaps.getSeqList().add(seq);
                        continue;
                    }
                    this.errorMessage = "The Jmol views in this project were imported\nfrom an older version of Jalview.\nPlease review the sequence colour associations\nin the Colour by section of the Jmol View menu.\n\nIn the case of problems, see note at\nhttp://issues.jalview.org/browse/JAL-747";
                    this.warn(this.errorMessage);
                }
            }
        }
        for (Map.Entry<String, StructureViewerModel> entry : structureViewers.entrySet()) {
            try {
                this.createOrLinkStructureViewer(entry, af, ap, jprovider);
            }
            catch (Exception e) {
                System.err.println("Error loading structure viewer: " + e.getMessage());
            }
        }
    }

    protected void createOrLinkStructureViewer(Map.Entry<String, StructureViewerModel> viewerData, AlignFrame af, AlignmentPanel ap, jarInputStreamProvider jprovider) {
        StructureViewerModel stateData = viewerData.getValue();
        StructureViewerBase comp = this.findMatchingViewer(viewerData);
        if (comp != null) {
            this.linkStructureViewer(ap, comp, stateData);
            return;
        }
        if (StructureViewer.ViewerType.CHIMERA.toString().equals(stateData.getType())) {
            this.createChimeraViewer(viewerData, af, jprovider);
        } else {
            this.createJmolViewer(viewerData, af, jprovider);
        }
    }

    protected void createChimeraViewer(Map.Entry<String, StructureViewerModel> viewerData, AlignFrame af, jarInputStreamProvider jprovider) {
        StructureViewerModel data = viewerData.getValue();
        String chimeraSessionFile = data.getStateData();
        String viewerJarEntryName = this.getViewerJarEntryName(data.getViewId());
        chimeraSessionFile = this.copyJarEntry(jprovider, viewerJarEntryName, "chimera", ".py");
        Set<Map.Entry<File, StructureViewerModel.StructureData>> fileData = data.getFileData().entrySet();
        ArrayList<PDBEntry> pdbs = new ArrayList<PDBEntry>();
        ArrayList<SequenceI[]> allseqs = new ArrayList<SequenceI[]>();
        for (Map.Entry<File, StructureViewerModel.StructureData> pdb : fileData) {
            String filePath = pdb.getValue().getFilePath();
            String pdbId = pdb.getValue().getPdbId();
            pdbs.add(new PDBEntry(pdbId, null, PDBEntry.Type.PDB, filePath));
            List<SequenceI> seqList = pdb.getValue().getSeqList();
            SequenceI[] seqs = seqList.toArray(new SequenceI[seqList.size()]);
            allseqs.add(seqs);
        }
        boolean colourByChimera = data.isColourByViewer();
        boolean colourBySequence = data.isColourWithAlignPanel();
        PDBEntry[] pdbArray = pdbs.toArray(new PDBEntry[pdbs.size()]);
        SequenceI[][] seqsArray = (SequenceI[][])allseqs.toArray((T[])new SequenceI[allseqs.size()][]);
        String newViewId = viewerData.getKey();
        ChimeraViewFrame cvf = new ChimeraViewFrame(chimeraSessionFile, af.alignPanel, pdbArray, seqsArray, colourByChimera, colourBySequence, newViewId);
        cvf.setSize(data.getWidth(), data.getHeight());
        cvf.setLocation(data.getX(), data.getY());
    }

    protected void createJmolViewer(Map.Entry<String, StructureViewerModel> viewerData, AlignFrame af, jarInputStreamProvider jprovider) {
        int ncp;
        final StructureViewerModel svattrib = viewerData.getValue();
        String state = svattrib.getStateData();
        if (StructureViewer.ViewerType.JMOL.toString().equals(svattrib.getType())) {
            state = this.readJarEntry(jprovider, this.getViewerJarEntryName(svattrib.getViewId()));
        }
        ArrayList<String> pdbfilenames = new ArrayList<String>();
        ArrayList<SequenceI[]> seqmaps = new ArrayList<SequenceI[]>();
        ArrayList<String> pdbids = new ArrayList<String>();
        StringBuilder newFileLoc = new StringBuilder(64);
        int cp = 0;
        Map<File, StructureViewerModel.StructureData> oldFiles = svattrib.getFileData();
        while ((ncp = state.indexOf("load ", cp)) > -1) {
            int ecp;
            do {
                ncp = state.indexOf("\"", ncp + 1) + 1;
                newFileLoc.append(state.substring(cp, ncp));
                ecp = state.indexOf("\"", ncp);
                String oldfilenam = state.substring(ncp, ecp);
                StructureViewerModel.StructureData filedat = oldFiles.get(new File(oldfilenam));
                if (filedat == null) {
                    String reformatedOldFilename = oldfilenam.replaceAll("/", "\\\\");
                    filedat = oldFiles.get(new File(reformatedOldFilename));
                }
                newFileLoc.append(Platform.escapeBackslashes(filedat.getFilePath()));
                pdbfilenames.add(filedat.getFilePath());
                pdbids.add(filedat.getPdbId());
                seqmaps.add(filedat.getSeqList().toArray(new SequenceI[0]));
                newFileLoc.append("\"");
            } while ((ncp = state.indexOf("/*file*/", cp = ecp + 1)) > -1);
        }
        if (cp > 0) {
            newFileLoc.append(state.substring(cp));
        } else {
            System.err.print("Ignoring incomplete Jmol state for PDB ids: ");
            newFileLoc = new StringBuilder(state);
            newFileLoc.append("; load append ");
            for (File id : oldFiles.keySet()) {
                StructureViewerModel.StructureData filedat = oldFiles.get(id);
                newFileLoc.append(filedat.getFilePath());
                pdbfilenames.add(filedat.getFilePath());
                pdbids.add(filedat.getPdbId());
                seqmaps.add(filedat.getSeqList().toArray(new SequenceI[0]));
                newFileLoc.append(" \"");
                newFileLoc.append(filedat.getFilePath());
                newFileLoc.append("\"");
            }
            newFileLoc.append(";");
        }
        if (newFileLoc.length() == 0) {
            return;
        }
        int histbug = newFileLoc.indexOf("history = ");
        if (histbug > -1) {
            String val;
            int diff = (histbug += 10) == -1 ? -1 : newFileLoc.indexOf(";", histbug);
            String string = val = diff == -1 ? null : newFileLoc.substring(histbug, diff);
            if (val != null && val.length() >= 4 && val.contains("e")) {
                val = val.trim().equals("true") ? "1" : "0";
                newFileLoc.replace(histbug, diff, val);
            }
        }
        final String[] pdbf = pdbfilenames.toArray(new String[pdbfilenames.size()]);
        final String[] id = pdbids.toArray(new String[pdbids.size()]);
        final SequenceI[][] sq = (SequenceI[][])seqmaps.toArray((T[])new SequenceI[seqmaps.size()][]);
        final String fileloc = newFileLoc.toString();
        final String sviewid = viewerData.getKey();
        final AlignFrame alf = af;
        final Rectangle rect = new Rectangle(svattrib.getX(), svattrib.getY(), svattrib.getWidth(), svattrib.getHeight());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        JalviewStructureDisplayI sview = null;
                        try {
                            sview = new StructureViewer(alf.alignPanel.getStructureSelectionManager()).createView(StructureViewer.ViewerType.JMOL, pdbf, id, sq, alf.alignPanel, svattrib, fileloc, rect, sviewid);
                            Jalview2XML.this.addNewStructureViewer(sview);
                        }
                        catch (OutOfMemoryError ex) {
                            new OOMWarning("restoring structure view for PDB id " + id, (OutOfMemoryError)ex.getCause());
                            if (sview == null || !sview.isVisible()) break block2;
                            sview.closeViewer(false);
                            sview.setVisible(false);
                            sview.dispose();
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            this.warn("Unexpected error when opening Jmol view.", ex);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String getViewerJarEntryName(String viewId) {
        return VIEWER_PREFIX + viewId;
    }

    protected StructureViewerBase findMatchingViewer(Map.Entry<String, StructureViewerModel> viewerData) {
        JInternalFrame[] frames;
        String sviewid = viewerData.getKey();
        StructureViewerModel svattrib = viewerData.getValue();
        StructureViewerBase comp = null;
        for (JInternalFrame frame : frames = this.getAllFrames()) {
            if (!(frame instanceof StructureViewerBase)) continue;
            if (sviewid != null && ((StructureViewerBase)frame).getViewId().equals(sviewid)) {
                comp = (StructureViewerBase)frame;
                break;
            }
            if (frame.getX() != svattrib.getX() || frame.getY() != svattrib.getY() || frame.getHeight() != svattrib.getHeight() || frame.getWidth() != svattrib.getWidth()) continue;
            comp = (StructureViewerBase)frame;
        }
        return comp;
    }

    protected void linkStructureViewer(AlignmentPanel ap, StructureViewerBase viewer, StructureViewerModel stateData) {
        boolean useinViewerSuperpos = stateData.isAlignWithPanel();
        boolean usetoColourbyseq = stateData.isColourWithAlignPanel();
        boolean viewerColouring = stateData.isColourByViewer();
        Map<File, StructureViewerModel.StructureData> oldFiles = stateData.getFileData();
        AAStructureBindingModel binding = viewer.getBinding();
        for (File id : oldFiles.keySet()) {
            StructureViewerModel.StructureData filedat = oldFiles.get(id);
            String pdbFile = filedat.getFilePath();
            SequenceI[] seq = filedat.getSeqList().toArray(new SequenceI[0]);
            binding.getSsm().setMapping(seq, null, pdbFile, DataSourceType.FILE, null);
            binding.addSequenceForStructFile(pdbFile, seq);
        }
        viewer.addAlignmentPanel(ap);
        if (useinViewerSuperpos) {
            viewer.useAlignmentPanelForSuperposition(ap);
        } else {
            viewer.excludeAlignmentPanelForSuperposition(ap);
        }
        if (usetoColourbyseq) {
            viewer.useAlignmentPanelForColourbyseq(ap, !viewerColouring);
        } else {
            viewer.excludeAlignmentPanelForColourbyseq(ap);
        }
    }

    protected JInternalFrame[] getAllFrames() {
        JInternalFrame[] frames = null;
        do {
            try {
                frames = Desktop.desktop.getAllFrames();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (frames == null);
        return frames;
    }

    public static boolean isVersionStringLaterThan(String supported, String version) {
        if (supported == null || version == null || version.equalsIgnoreCase("DEVELOPMENT BUILD") || version.equalsIgnoreCase("Test") || version.equalsIgnoreCase("AUTOMATED BUILD")) {
            System.err.println("Assuming project file with " + (version == null ? "null" : version) + " is compatible with Jalview version " + supported);
            return true;
        }
        return StringUtils.compareVersions(version, supported, "b") >= 0;
    }

    protected void addNewStructureViewer(JalviewStructureDisplayI sview) {
        if (this.newStructureViewers != null) {
            sview.getBinding().setFinishedLoadingFromArchive(false);
            this.newStructureViewers.add(sview);
        }
    }

    protected void setLoadingFinishedForNewStructureViewers() {
        if (this.newStructureViewers != null) {
            for (JalviewStructureDisplayI sview : this.newStructureViewers) {
                sview.getBinding().setFinishedLoadingFromArchive(true);
            }
            this.newStructureViewers.clear();
            this.newStructureViewers = null;
        }
    }

    AlignFrame loadViewport(String file, List<JalviewModel.JSeq> JSEQ, List<SequenceI> hiddenSeqs, AlignmentI al, JalviewModel jm, JalviewModel.Viewport view, String uniqueSeqSetId, String viewId, List<JvAnnotRow> autoAlan) {
        AlignFrame af = null;
        af = new AlignFrame(al, Jalview2XML.safeInt(view.getWidth()), Jalview2XML.safeInt(view.getHeight()), uniqueSeqSetId, viewId);
        af.setFileName(file, FileFormat.Jalview);
        AlignViewport viewport = af.getViewport();
        for (int i = 0; i < JSEQ.size(); ++i) {
            int colour = Jalview2XML.safeInt(JSEQ.get(i).getColour());
            viewport.setSequenceColour(viewport.getAlignment().getSequenceAt(i), new Color(colour));
        }
        if (al.hasSeqrep()) {
            viewport.setColourByReferenceSeq(true);
            viewport.setDisplayReferenceSeq(true);
        }
        viewport.setGatherViewsHere(Jalview2XML.safeBoolean(view.isGatheredViews()));
        if (view.getSequenceSetId() != null) {
            AlignmentViewport av = this.viewportsAdded.get(uniqueSeqSetId);
            viewport.setSequenceSetId(uniqueSeqSetId);
            if (av != null) {
                viewport.setHistoryList(av.getHistoryList());
                viewport.setRedoList(av.getRedoList());
            } else {
                this.viewportsAdded.put(uniqueSeqSetId, viewport);
            }
            PaintRefresher.Register(af.alignPanel, uniqueSeqSetId);
        }
        if (hiddenSeqs != null) {
            for (int s = 0; s < JSEQ.size(); ++s) {
                SequenceGroup hidden = new SequenceGroup();
                boolean isRepresentative = false;
                for (int r = 0; r < JSEQ.get(s).getHiddenSequences().size(); ++r) {
                    isRepresentative = true;
                    SequenceI sequenceToHide = al.getSequenceAt(JSEQ.get(s).getHiddenSequences().get(r));
                    hidden.addSequence(sequenceToHide, false);
                    hiddenSeqs.remove(sequenceToHide);
                }
                if (!isRepresentative) continue;
                SequenceI representativeSequence = al.getSequenceAt(s);
                hidden.addSequence(representativeSequence, false);
                viewport.hideRepSequences(representativeSequence, hidden);
            }
            SequenceI[] hseqs = hiddenSeqs.toArray(new SequenceI[hiddenSeqs.size()]);
            viewport.hideSequence(hseqs);
        }
        viewport.setShowAnnotation(Jalview2XML.safeBoolean(view.isShowAnnotation()));
        viewport.setAbovePIDThreshold(Jalview2XML.safeBoolean(view.isPidSelected()));
        int pidThreshold = Jalview2XML.safeInt(view.getPidThreshold());
        viewport.setThreshold(pidThreshold);
        viewport.setColourText(Jalview2XML.safeBoolean(view.isShowColourText()));
        viewport.setConservationSelected(Jalview2XML.safeBoolean(view.isConservationSelected()));
        viewport.setIncrement(Jalview2XML.safeInt(view.getConsThreshold()));
        viewport.setShowJVSuffix(Jalview2XML.safeBoolean(view.isShowFullId()));
        viewport.setRightAlignIds(Jalview2XML.safeBoolean(view.isRightAlignIds()));
        viewport.setFont(new Font(view.getFontName(), Jalview2XML.safeInt(view.getFontStyle()), Jalview2XML.safeInt(view.getFontSize())), true);
        ViewStyleI vs = viewport.getViewStyle();
        vs.setScaleProteinAsCdna(view.isScaleProteinAsCdna());
        viewport.setViewStyle(vs);
        viewport.setRenderGaps(Jalview2XML.safeBoolean(view.isRenderGaps()));
        viewport.setWrapAlignment(Jalview2XML.safeBoolean(view.isWrapAlignment()));
        viewport.setShowAnnotation(Jalview2XML.safeBoolean(view.isShowAnnotation()));
        viewport.setShowBoxes(Jalview2XML.safeBoolean(view.isShowBoxes()));
        viewport.setShowText(Jalview2XML.safeBoolean(view.isShowText()));
        viewport.setTextColour(new Color(Jalview2XML.safeInt(view.getTextCol1())));
        viewport.setTextColour2(new Color(Jalview2XML.safeInt(view.getTextCol2())));
        viewport.setThresholdTextColour(Jalview2XML.safeInt(view.getTextColThreshold()));
        viewport.setShowUnconserved(view.isShowUnconserved());
        viewport.getRanges().setStartRes(Jalview2XML.safeInt(view.getStartRes()));
        if (view.getViewName() != null) {
            viewport.setViewName(view.getViewName());
            af.setInitialTabVisible();
        }
        af.setBounds(Jalview2XML.safeInt(view.getXpos()), Jalview2XML.safeInt(view.getYpos()), Jalview2XML.safeInt(view.getWidth()), Jalview2XML.safeInt(view.getHeight()));
        af.alignPanel.updateLayout();
        ColourSchemeI cs = null;
        if (view.getBgColour() != null) {
            if (view.getBgColour().startsWith("ucs")) {
                cs = this.getUserColourScheme(jm, view.getBgColour());
            } else if (view.getBgColour().startsWith("Annotation")) {
                AnnotationColourScheme viewAnnColour = view.getAnnotationColours();
                cs = this.constructAnnotationColour(viewAnnColour, af, al, jm, true);
            } else {
                cs = ColourSchemeProperty.getColourScheme(af.getViewport(), al, view.getBgColour());
            }
        }
        viewport.setColourAppliesToAllGroups(false);
        viewport.setGlobalColourScheme(cs);
        viewport.getResidueShading().setThreshold(pidThreshold, view.isIgnoreGapsinConsensus());
        viewport.getResidueShading().setConsensus(viewport.getSequenceConsensusHash());
        if (Jalview2XML.safeBoolean(view.isConservationSelected()) && cs != null) {
            viewport.getResidueShading().setConservationInc(Jalview2XML.safeInt(view.getConsThreshold()));
        }
        af.changeColour(cs);
        viewport.setColourAppliesToAllGroups(true);
        viewport.setShowSequenceFeatures(Jalview2XML.safeBoolean(view.isShowSequenceFeatures()));
        viewport.setCentreColumnLabels(view.isCentreColumnLabels());
        viewport.setIgnoreGapsConsensus(view.isIgnoreGapsinConsensus(), null);
        viewport.setFollowHighlight(view.isFollowHighlight());
        viewport.followSelection = view.isFollowSelection();
        viewport.setShowConsensusHistogram(view.isShowConsensusHistogram());
        viewport.setShowSequenceLogo(view.isShowSequenceLogo());
        viewport.setNormaliseSequenceLogo(view.isNormaliseSequenceLogo());
        viewport.setShowDBRefs(Jalview2XML.safeBoolean(view.isShowDbRefTooltip()));
        viewport.setShowNPFeats(Jalview2XML.safeBoolean(view.isShowNPfeatureTooltip()));
        viewport.setShowGroupConsensus(view.isShowGroupConsensus());
        viewport.setShowGroupConservation(view.isShowGroupConservation());
        viewport.setShowComplementFeatures(view.isShowComplementFeatures());
        viewport.setShowComplementFeaturesOnTop(view.isShowComplementFeaturesOnTop());
        if (jm.getFeatureSettings() != null) {
            FeatureRenderer fr = af.alignPanel.getSeqPanel().seqCanvas.getFeatureRenderer();
            FeaturesDisplayed fdi = new FeaturesDisplayed();
            viewport.setFeaturesDisplayed(fdi);
            String[] renderOrder = new String[jm.getFeatureSettings().getSetting().size()];
            Hashtable<String, FeatureColourI> featureColours = new Hashtable<String, FeatureColourI>();
            Hashtable<String, Float> featureOrder = new Hashtable<String, Float>();
            for (int fs = 0; fs < jm.getFeatureSettings().getSetting().size(); ++fs) {
                FeatureMatcherSetI filter;
                JalviewModel.FeatureSettings.Setting setting = jm.getFeatureSettings().getSetting().get(fs);
                String featureType = setting.getType();
                jalview.xml.binding.jalview.FeatureMatcherSet filters = setting.getMatcherSet();
                if (filters != null && !(filter = Jalview2XML.parseFilter(featureType, filters)).isEmpty()) {
                    fr.setFeatureFilter(featureType, filter);
                }
                Color maxColour = new Color(setting.getColour());
                if (setting.getMincolour() != null) {
                    Color minColour;
                    Color noValueColour = minColour = new Color(setting.getMincolour());
                    NoValueColour noColour = setting.getNoValueColour();
                    if (noColour == NoValueColour.NONE) {
                        noValueColour = null;
                    } else if (noColour == NoValueColour.MAX) {
                        noValueColour = maxColour;
                    }
                    float min = Jalview2XML.safeFloat(Float.valueOf(Jalview2XML.safeFloat(setting.getMin())));
                    float max = setting.getMax() == null ? 1.0f : setting.getMax().floatValue();
                    FeatureColour gc = new FeatureColour(maxColour, minColour, maxColour, noValueColour, min, max);
                    if (setting.getAttributeName().size() > 0) {
                        gc.setAttributeName(setting.getAttributeName().toArray(new String[setting.getAttributeName().size()]));
                    }
                    if (setting.getThreshold() != null) {
                        gc.setThreshold(setting.getThreshold().floatValue());
                        int threshstate = Jalview2XML.safeInt(setting.getThreshstate());
                        if (threshstate == 0) {
                            gc.setBelowThreshold(true);
                        } else if (threshstate == 1) {
                            gc.setAboveThreshold(true);
                        }
                    }
                    gc.setAutoScaled(true);
                    if (setting.isAutoScale() != null) {
                        gc.setAutoScaled(setting.isAutoScale());
                    }
                    if (setting.isColourByLabel() != null) {
                        gc.setColourByLabel(setting.isColourByLabel());
                    }
                    featureColours.put(featureType, gc);
                } else {
                    featureColours.put(featureType, new FeatureColour(maxColour));
                }
                renderOrder[fs] = featureType;
                if (setting.getOrder() != null) {
                    featureOrder.put(featureType, Float.valueOf(setting.getOrder().floatValue()));
                } else {
                    featureOrder.put(featureType, Float.valueOf(fs / jm.getFeatureSettings().getSetting().size()));
                }
                if (!Jalview2XML.safeBoolean(setting.isDisplay())) continue;
                fdi.setVisible(featureType);
            }
            Hashtable<String, Boolean> fgtable = new Hashtable<String, Boolean>();
            for (int gs = 0; gs < jm.getFeatureSettings().getGroup().size(); ++gs) {
                JalviewModel.FeatureSettings.Group grp = jm.getFeatureSettings().getGroup().get(gs);
                fgtable.put(grp.getName(), grp.isDisplay());
            }
            FeatureRendererSettings frs = new FeatureRendererSettings(renderOrder, fgtable, featureColours, 1.0f, featureOrder);
            fr.transferSettings(frs);
        }
        if (view.getHiddenColumns().size() > 0) {
            for (int c = 0; c < view.getHiddenColumns().size(); ++c) {
                JalviewModel.Viewport.HiddenColumns hc = view.getHiddenColumns().get(c);
                viewport.hideColumns(Jalview2XML.safeInt(hc.getStart()), Jalview2XML.safeInt(hc.getEnd()));
            }
        }
        if (view.getCalcIdParam() != null) {
            for (JalviewModel.Viewport.CalcIdParam calcIdParam : view.getCalcIdParam()) {
                if (calcIdParam == null || this.recoverCalcIdParam(calcIdParam, viewport)) continue;
                this.warn("Couldn't recover parameters for " + calcIdParam.getCalcId());
            }
        }
        af.setMenusFromViewport(viewport);
        af.setTitle(view.getTitle());
        String complementaryViewId = view.getComplementId();
        if (complementaryViewId == null) {
            Desktop.addInternalFrame(af, view.getTitle(), Jalview2XML.safeInt(view.getWidth()), Jalview2XML.safeInt(view.getHeight()));
            af.alignPanel.updateAnnotation(false, true);
            this.reorderAutoannotation(af, al, autoAlan);
            af.alignPanel.alignmentChanged();
        } else {
            this.splitFrameCandidates.put(view, af);
        }
        return af;
    }

    private ColourSchemeI constructAnnotationColour(AnnotationColourScheme viewAnnColour, AlignFrame af, AlignmentI al, JalviewModel model, boolean checkGroupAnnColour) {
        String annotationId;
        AlignmentAnnotation matchedAnnotation;
        AlignmentI annAlignment;
        boolean propagateAnnColour = false;
        AlignmentI alignmentI = annAlignment = af != null ? af.getViewport().getAlignment() : al;
        if (checkGroupAnnColour && al.getGroups() != null && al.getGroups().size() > 0) {
            propagateAnnColour = true;
            for (SequenceGroup sg : al.getGroups()) {
                if (!(sg.getColourScheme() instanceof AnnotationColourGradient)) continue;
                propagateAnnColour = false;
            }
        }
        if ((matchedAnnotation = this.annotationIds.get(annotationId = viewAnnColour.getAnnotation())) == null && annAlignment.getAlignmentAnnotation() != null) {
            for (int i = 0; i < annAlignment.getAlignmentAnnotation().length; ++i) {
                if (!annotationId.equals(annAlignment.getAlignmentAnnotation()[i].label)) continue;
                matchedAnnotation = annAlignment.getAlignmentAnnotation()[i];
                break;
            }
        }
        if (matchedAnnotation == null) {
            System.err.println("Failed to match annotation colour scheme for " + annotationId);
            return null;
        }
        if (matchedAnnotation.getThreshold() == null) {
            matchedAnnotation.setThreshold(new GraphLine(Jalview2XML.safeFloat(viewAnnColour.getThreshold()), "Threshold", Color.black));
        }
        AnnotationColourGradient cs = null;
        cs = viewAnnColour.getColourScheme().equals("None") ? new AnnotationColourGradient(matchedAnnotation, new Color(Jalview2XML.safeInt(viewAnnColour.getMinColour())), new Color(Jalview2XML.safeInt(viewAnnColour.getMaxColour())), Jalview2XML.safeInt(viewAnnColour.getAboveThreshold())) : (viewAnnColour.getColourScheme().startsWith("ucs") ? new AnnotationColourGradient(matchedAnnotation, this.getUserColourScheme(model, viewAnnColour.getColourScheme()), Jalview2XML.safeInt(viewAnnColour.getAboveThreshold())) : new AnnotationColourGradient(matchedAnnotation, ColourSchemeProperty.getColourScheme(af.getViewport(), al, viewAnnColour.getColourScheme()), Jalview2XML.safeInt(viewAnnColour.getAboveThreshold())));
        boolean perSequenceOnly = Jalview2XML.safeBoolean(viewAnnColour.isPerSequence());
        boolean useOriginalColours = Jalview2XML.safeBoolean(viewAnnColour.isPredefinedColours());
        cs.setSeqAssociated(perSequenceOnly);
        cs.setPredefinedColours(useOriginalColours);
        if (propagateAnnColour && al.getGroups() != null) {
            for (int g = 0; g < al.getGroups().size(); ++g) {
                SequenceGroup sg = al.getGroups().get(g);
                if (sg.getGroupColourScheme() == null) continue;
                AnnotationColourGradient groupScheme = new AnnotationColourGradient(matchedAnnotation, sg.getColourScheme(), Jalview2XML.safeInt(viewAnnColour.getAboveThreshold()));
                sg.setColourScheme(groupScheme);
                groupScheme.setSeqAssociated(perSequenceOnly);
                groupScheme.setPredefinedColours(useOriginalColours);
            }
        }
        return cs;
    }

    private void reorderAutoannotation(AlignFrame af, AlignmentI al, List<JvAnnotRow> autoAlan) {
        if (al.getAlignmentAnnotation() != null) {
            String[] magicNames = new String[]{"Consensus", "Quality", "Conservation"};
            JvAnnotRow nullAnnot = new JvAnnotRow(-1, null);
            Hashtable<Object, JvAnnotRow> visan = new Hashtable<Object, JvAnnotRow>();
            for (String nm : magicNames) {
                visan.put(nm, nullAnnot);
            }
            for (JvAnnotRow auan : autoAlan) {
                visan.put(auan.template.label + (String)(auan.template.getCalcId() == null ? "" : "\t" + auan.template.getCalcId()), auan);
            }
            int hSize = al.getAlignmentAnnotation().length;
            ArrayList<JvAnnotRow> reorder = new ArrayList<JvAnnotRow>();
            ArrayList remains = new ArrayList(visan.keySet());
            for (int h = 0; h < hSize; ++h) {
                AlignmentAnnotation jalan = al.getAlignmentAnnotation()[h];
                if (!jalan.autoCalculated) continue;
                Object k = jalan.label;
                JvAnnotRow valan = (JvAnnotRow)visan.get(k);
                if (jalan.getCalcId() != null) {
                    k = jalan.label + "\t" + jalan.getCalcId();
                    valan = (JvAnnotRow)visan.get(k);
                }
                if (valan == null) continue;
                al.deleteAnnotation(jalan, false);
                remains.remove(k);
                --hSize;
                --h;
                if (valan == nullAnnot) continue;
                if (jalan != valan.template) {
                    if (valan.template.graphHeight >= 0) {
                        jalan.graphHeight = valan.template.graphHeight;
                    }
                    jalan.visible = valan.template.visible;
                }
                reorder.add(new JvAnnotRow(valan.order, jalan));
            }
            for (String other : remains) {
                JvAnnotRow othera = (JvAnnotRow)visan.get(other);
                if (othera == nullAnnot || othera.template.getCalcId() == null || othera.template.getCalcId().length() <= 0) continue;
                reorder.add(othera);
            }
            int s = 0;
            int[] srt = new int[reorder.size()];
            Object[] rws = new JvAnnotRow[reorder.size()];
            for (JvAnnotRow jvar : reorder) {
                rws[s] = jvar;
                srt[s++] = jvar.order;
            }
            reorder.clear();
            QuickSort.sort(srt, rws);
            for (Object jvar : rws) {
                al.addAnnotation(((JvAnnotRow)jvar).template, ((JvAnnotRow)jvar).order);
            }
            af.alignPanel.adjustAnnotationHeight();
        }
    }

    private boolean skipViewport(JalviewModel object) {
        if (this.skipList == null) {
            return false;
        }
        String id = object.getViewport().get(0).getSequenceSetId();
        if (this.skipList.containsKey(id)) {
            if (Cache.log != null && Cache.log.isDebugEnabled()) {
                Cache.log.debug((Object)("Skipping seuqence set id " + id));
            }
            return true;
        }
        return false;
    }

    public void addToSkipList(AlignFrame af) {
        if (this.skipList == null) {
            this.skipList = new Hashtable();
        }
        this.skipList.put(af.getViewport().getSequenceSetId(), af);
    }

    public void clearSkipList() {
        if (this.skipList != null) {
            this.skipList.clear();
            this.skipList = null;
        }
    }

    private void recoverDatasetFor(SequenceSet vamsasSet, AlignmentI al, boolean ignoreUnrefed, String uniqueSeqSetId) {
        AlignmentI seqSetDS;
        AlignmentI ds = this.getDatasetFor(vamsasSet.getDatasetId());
        AlignmentI xtant_ds = ds;
        if (xtant_ds == null && (xtant_ds = this.checkIfHasDataset(vamsasSet.getSequence())) != null) {
            ds = xtant_ds;
            this.addDatasetRef(vamsasSet.getDatasetId(), ds);
        }
        Vector dseqs = null;
        if (!ignoreUnrefed && (seqSetDS = this.getDatasetFor(UNIQSEQSETID + uniqueSeqSetId)) != null) {
            if (ds != null && ds != seqSetDS) {
                this.warn("JAL-3171 regression: Overwriting a dataset reference for an alignment - CDS/Protein crossreference data may be lost");
                if (xtant_ds != null) {
                    this.warn("JAL-3171 SERIOUS!  TOTAL CONFUSION - please consider contacting the Jalview Development team so they can investigate why your project caused this message to be displayed.");
                }
            }
            ds = seqSetDS;
            this.addDatasetRef(vamsasSet.getDatasetId(), ds);
        }
        if (ds == null) {
            AlignmentI xtantDS = this.checkIfHasDataset(vamsasSet.getSequence());
            dseqs = new Vector();
        }
        int iSize = vamsasSet.getSequence().size();
        for (int i = 0; i < iSize; ++i) {
            Sequence vamsasSeq = vamsasSet.getSequence().get(i);
            this.ensureJalviewDatasetSequence(vamsasSeq, ds, dseqs, ignoreUnrefed, i);
        }
        if (ds == null) {
            Object[] dsseqs = new SequenceI[dseqs.size()];
            dseqs.copyInto(dsseqs);
            ds = new Alignment((SequenceI[])dsseqs);
            this.debug("Created new dataset " + vamsasSet.getDatasetId() + " for alignment " + System.identityHashCode(al));
            this.addDatasetRef(vamsasSet.getDatasetId(), ds);
        }
        if (al.getDataset() == null && !ignoreUnrefed) {
            al.setDataset(ds);
            this.addDatasetRef(UNIQSEQSETID + uniqueSeqSetId, ds);
        }
        this.updateSeqDatasetBinding(vamsasSet.getSequence(), ds);
    }

    AlignmentI checkIfHasDataset(List<Sequence> list) {
        for (Sequence restoredSeq : list) {
            AlignmentI datasetFor = this.seqToDataset.get(restoredSeq.getDsseqid());
            if (datasetFor == null) continue;
            return datasetFor;
        }
        return null;
    }

    void updateSeqDatasetBinding(List<Sequence> list, AlignmentI ds) {
        for (Sequence restoredSeq : list) {
            AlignmentI prevDS = this.seqToDataset.put(restoredSeq.getDsseqid(), ds);
            if (prevDS == null || prevDS == ds) continue;
            this.warn("Dataset sequence appears in many datasets: " + restoredSeq.getDsseqid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureJalviewDatasetSequence(Sequence vamsasSeq, AlignmentI ds, Vector dseqs, boolean ignoreUnrefed, int vseqpos) {
        SequenceI sq = this.seqRefIds.get(vamsasSeq.getId());
        boolean reorder = false;
        SequenceI dsq = null;
        if (sq != null && sq.getDatasetSequence() != null) {
            dsq = sq.getDatasetSequence();
        } else {
            reorder = true;
        }
        if (sq == null && ignoreUnrefed) {
            return;
        }
        String sqid = vamsasSeq.getDsseqid();
        if (dsq == null) {
            if (sqid != null) {
                dsq = this.seqRefIds.get(sqid);
            }
            if (dsq == null) {
                dsq = sq.createDatasetSequence();
                if (sqid == null) {
                    sqid = this.seqHash(dsq);
                }
                dsq.setVamsasId(this.uniqueSetSuffix + sqid);
                this.seqRefIds.put(sqid, dsq);
                if (ds == null) {
                    if (dseqs != null) {
                        dseqs.addElement(dsq);
                    }
                } else {
                    ds.addSequence(dsq);
                }
            } else if (sq != dsq) {
                sq.setDatasetSequence(dsq);
                if (ds == null) {
                    if (dseqs != null) {
                        if (!dseqs.contains(dsq)) {
                            dseqs.add(dsq);
                        }
                    } else if (ds.findIndex(dsq) < 0) {
                        ds.addSequence(dsq);
                    }
                }
            }
        }
        if (sq != dsq) {
            String newres = AlignSeq.extractGaps(Comparison.GapChars, sq.getSequenceAsString());
            if (!newres.equalsIgnoreCase(dsq.getSequenceAsString()) && newres.length() > dsq.getLength()) {
                SequenceI sequenceI = dsq;
                synchronized (sequenceI) {
                    dsq.setSequence(newres);
                }
                System.err.println("DEBUG Notice:  Merged dataset sequence (if you see this often, post at http://issues.jalview.org/browse/JAL-1474)");
            }
        } else if (ds != null && dseqs == null) {
            int opos = ds.findIndex(dsq);
            SequenceI tseq = null;
            if (opos != -1 && vseqpos != opos) {
                ds.deleteSequence(dsq);
            }
            if (vseqpos < ds.getHeight()) {
                if (vseqpos != opos) {
                    tseq = ds.getSequenceAt(vseqpos);
                    ds.replaceSequenceAt(vseqpos, dsq);
                    ds.addSequence(tseq);
                }
            } else {
                ds.addSequence(dsq);
            }
        }
    }

    private AlignmentI getDatasetFor(String datasetId) {
        if (this.datasetIds == null) {
            this.datasetIds = new Hashtable();
            return null;
        }
        if (this.datasetIds.containsKey(datasetId)) {
            return this.datasetIds.get(datasetId);
        }
        return null;
    }

    private void addDatasetRef(String datasetId, AlignmentI dataset) {
        if (this.datasetIds == null) {
            this.datasetIds = new Hashtable();
        }
        this.datasetIds.put(datasetId, dataset);
    }

    private String getDatasetIdRef(AlignmentI dataset) {
        Object datasetId;
        if (dataset.getDataset() != null) {
            this.warn("Serious issue!  Dataset Object passed to getDatasetIdRef is not a Jalview DATASET alignment...");
        }
        if ((datasetId = this.makeHashCode(dataset, null)) == null) {
            if (this.dataset2Ids == null) {
                this.dataset2Ids = new IdentityHashMap();
            } else {
                datasetId = this.dataset2Ids.get(dataset);
            }
            if (datasetId == null) {
                datasetId = "ds" + this.dataset2Ids.size() + "1";
                this.dataset2Ids.put(dataset, (String)datasetId);
            }
        }
        return datasetId;
    }

    private void addDBRefs(SequenceI datasetSequence, Sequence sequence) {
        for (int d = 0; d < sequence.getDBRef().size(); ++d) {
            Sequence.DBRef dr = sequence.getDBRef().get(d);
            DBRefEntry entry = dr.isLocus() ? new GeneLocus(dr.getSource(), dr.getVersion(), dr.getAccessionId()) : new DBRefEntry(dr.getSource(), dr.getVersion(), dr.getAccessionId());
            if (dr.getMapping() != null) {
                entry.setMap(this.addMapping(dr.getMapping()));
            }
            datasetSequence.addDBRef(entry);
        }
    }

    private Mapping addMapping(jalview.xml.binding.jalview.Mapping m) {
        SequenceI dsto = null;
        int[] fr = new int[m.getMapListFrom().size() * 2];
        Iterator<MapListType.MapListFrom> from = m.getMapListFrom().iterator();
        int _i = 0;
        while (from.hasNext()) {
            MapListType.MapListFrom mf = from.next();
            fr[_i] = mf.getStart();
            fr[_i + 1] = mf.getEnd();
            _i += 2;
        }
        int[] fto = new int[m.getMapListTo().size() * 2];
        Iterator<MapListType.MapListTo> to = m.getMapListTo().iterator();
        int _i2 = 0;
        while (to.hasNext()) {
            MapListType.MapListTo mf = to.next();
            fto[_i2] = mf.getStart();
            fto[_i2 + 1] = mf.getEnd();
            _i2 += 2;
        }
        Mapping jmap = new Mapping(dsto, fr, fto, m.getMapFromUnit().intValue(), m.getMapToUnit().intValue());
        if (m.getDseqFor() != null) {
            String dsfor = m.getDseqFor();
            if (this.seqRefIds.containsKey(dsfor)) {
                jmap.setTo(this.seqRefIds.get(dsfor));
            } else {
                this.frefedSequence.add(this.newMappingRef(dsfor, jmap));
            }
        } else if (m.getSequence() != null) {
            Sequence ms = m.getSequence();
            SequenceI djs = null;
            String sqid = ms.getDsseqid();
            if (sqid != null && sqid.length() > 0) {
                djs = this.seqRefIds.get(sqid);
            } else {
                System.err.println("Warning - making up dataset sequence id for DbRef sequence map reference");
                sqid = ms.toString();
            }
            if (djs == null) {
                djs = new jalview.datamodel.Sequence(ms.getName(), ms.getSequence());
                djs.setStart(jmap.getMap().getToLowest());
                djs.setEnd(jmap.getMap().getToHighest());
                djs.setVamsasId(this.uniqueSetSuffix + sqid);
                jmap.setTo(djs);
                this.incompleteSeqs.put(sqid, djs);
                this.seqRefIds.put(sqid, djs);
            }
            Cache.log.debug((Object)"about to recurse on addDBRefs.");
            this.addDBRefs(djs, ms);
        }
        return jmap;
    }

    public AlignmentPanel copyAlignPanel(AlignmentPanel ap) {
        this.initSeqRefs();
        JalviewModel jm = this.saveState(ap, null, null, null);
        this.addDatasetRef(jm.getVamsasModel().getSequenceSet().get(0).getDatasetId(), ap.getAlignment().getDataset());
        this.uniqueSetSuffix = "";
        jm.getViewport().get(0).setId(null);
        if (this.frefedSequence == null) {
            this.frefedSequence = new Vector<SeqFref>();
        }
        this.viewportsAdded.clear();
        AlignFrame af = this.loadFromObject(jm, null, false, null);
        af.getAlignPanels().clear();
        af.closeMenuItem_actionPerformed(true);
        return af.alignPanel;
    }

    private void warn(String msg) {
        this.warn(msg, null);
    }

    private void warn(String msg, Exception e) {
        if (Cache.log != null) {
            if (e != null) {
                Cache.log.warn((Object)msg, (Throwable)e);
            } else {
                Cache.log.warn((Object)msg);
            }
        } else {
            System.err.println("Warning: " + msg);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    private void debug(String string) {
        this.debug(string, null);
    }

    private void debug(String msg, Exception e) {
        if (Cache.log != null) {
            if (e != null) {
                Cache.log.debug((Object)msg, (Throwable)e);
            } else {
                Cache.log.debug((Object)msg);
            }
        } else {
            System.err.println("Warning: " + msg);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public void setObjectMappingTables(Hashtable vobj2jv, IdentityHashMap jv2vobj) {
        this.jv2vobj = jv2vobj;
        this.vobj2jv = vobj2jv;
        for (Object jvobj : jv2vobj.keySet()) {
            String id = jv2vobj.get(jvobj).toString();
            if (jvobj instanceof Alignment) {
                if (((Alignment)jvobj).getDataset() != null) continue;
                this.addDatasetRef(id, (Alignment)jvobj);
                continue;
            }
            if (jvobj instanceof jalview.datamodel.Sequence) {
                if (this.seqRefIds == null) {
                    this.seqRefIds = new HashMap<String, SequenceI>();
                }
                if (this.seqsToIds == null) {
                    this.seqsToIds = new IdentityHashMap();
                }
                this.seqRefIds.put(jv2vobj.get(jvobj).toString(), (SequenceI)jvobj);
                this.seqsToIds.put((SequenceI)jvobj, id);
                continue;
            }
            if (jvobj instanceof AlignmentAnnotation) {
                AlignmentAnnotation jvann = (AlignmentAnnotation)jvobj;
                String anid = jv2vobj.get(jvobj).toString();
                this.annotationIds.put(anid, jvann);
                if (jvann.annotationId == null) {
                    jvann.annotationId = anid;
                }
                if (jvann.annotationId.equals(anid)) continue;
                this.warn("Overriding Annotation ID for " + anid + " from different id : " + jvann.annotationId);
                jvann.annotationId = anid;
                continue;
            }
            if (jvobj instanceof String) {
                if (this.jvids2vobj != null) continue;
                this.jvids2vobj = new Hashtable();
                this.jvids2vobj.put(jvobj, jv2vobj.get(jvobj).toString());
                continue;
            }
            Cache.log.debug((Object)("Ignoring " + jvobj.getClass() + " (ID = " + id));
        }
    }

    public void setUniqueSetSuffix(String string) {
        this.uniqueSetSuffix = string;
    }

    public void setSkipList(Hashtable skipList2) {
        this.skipList = skipList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readJarEntry(jarInputStreamProvider jprovider, String jarEntryName) {
        String result = null;
        BufferedReader in = null;
        try {
            JarInputStream jin = jprovider.getJarInputStream();
            JarEntry entry = null;
            while ((entry = jin.getNextJarEntry()) != null && !entry.getName().equals(jarEntryName)) {
            }
            if (entry != null) {
                String data;
                StringBuilder out = new StringBuilder(256);
                in = new BufferedReader(new InputStreamReader((InputStream)jin, UTF_8));
                while ((data = in.readLine()) != null) {
                    out.append(data);
                }
                result = out.toString();
            } else {
                this.warn("Couldn't find entry in Jalview Jar for " + jarEntryName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private synchronized int nextCounter() {
        return this.counter++;
    }

    protected void loadPCAViewers(JalviewModel model, AlignmentPanel ap) {
        try {
            List<JalviewModel.PcaViewer> pcaviewers = model.getPcaViewer();
            for (JalviewModel.PcaViewer viewer : pcaviewers) {
                String modelName = viewer.getScoreModelName();
                SimilarityParams params = new SimilarityParams(viewer.isIncludeGappedColumns(), viewer.isMatchGaps(), viewer.isIncludeGaps(), viewer.isDenominateByShortestLength());
                PCAPanel panel = new PCAPanel(ap, modelName, params);
                panel.setTitle(viewer.getTitle());
                panel.setBounds(new Rectangle(viewer.getXpos(), viewer.getYpos(), viewer.getWidth(), viewer.getHeight()));
                boolean showLabels = viewer.isShowLabels();
                panel.setShowLabels(showLabels);
                panel.getRotatableCanvas().setShowLabels(showLabels);
                panel.getRotatableCanvas().setBgColour(new Color(viewer.getBgColour()));
                panel.getRotatableCanvas().setApplyToAllViews(viewer.isLinkToAllViews());
                ScoreModelI scoreModel = ScoreModels.getInstance().getScoreModel(modelName, ap);
                PCA pca = new PCA(null, scoreModel, params);
                PcaDataType pcaData = viewer.getPcaData();
                MatrixI pairwise = this.loadDoubleMatrix(pcaData.getPairwiseMatrix());
                pca.setPairwiseScores(pairwise);
                MatrixI triDiag = this.loadDoubleMatrix(pcaData.getTridiagonalMatrix());
                pca.setTridiagonal(triDiag);
                MatrixI result = this.loadDoubleMatrix(pcaData.getEigenMatrix());
                pca.setEigenmatrix(result);
                panel.getPcaModel().setPCA(pca);
                panel.setInputData(null);
                ArrayList<SequencePoint> seqPoints = new ArrayList<SequencePoint>();
                for (JalviewModel.PcaViewer.SequencePoint sp : viewer.getSequencePoint()) {
                    String seqId = sp.getSequenceRef();
                    SequenceI seq = this.seqRefIds.get(seqId);
                    if (seq == null) {
                        throw new IllegalStateException("Unmatched seqref for PCA: " + seqId);
                    }
                    Point pt = new Point(sp.getXPos().floatValue(), sp.getYPos().floatValue(), sp.getZPos().floatValue());
                    SequencePoint seqPoint = new SequencePoint(seq, pt);
                    seqPoints.add(seqPoint);
                }
                panel.getRotatableCanvas().setPoints(seqPoints, seqPoints.size());
                panel.getRotatableCanvas().setScaleFactor(viewer.getScaleFactor().floatValue());
                JalviewModel.PcaViewer.SeqPointMin spMin = viewer.getSeqPointMin();
                float[] min = new float[]{spMin.getXPos().floatValue(), spMin.getYPos().floatValue(), spMin.getZPos().floatValue()};
                JalviewModel.PcaViewer.SeqPointMax spMax = viewer.getSeqPointMax();
                float[] max = new float[]{spMax.getXPos().floatValue(), spMax.getYPos().floatValue(), spMax.getZPos().floatValue()};
                panel.getRotatableCanvas().setSeqMinMax(min, max);
                panel.getPcaModel().setSequencePoints(seqPoints);
                panel.setSelectedDimensionIndex(viewer.getXDim(), RotatableMatrix.Axis.X);
                panel.setSelectedDimensionIndex(viewer.getYDim(), RotatableMatrix.Axis.Y);
                panel.setSelectedDimensionIndex(viewer.getZDim(), RotatableMatrix.Axis.Z);
                panel.setTop(seqPoints.size() - 1);
                panel.getPcaModel().setTop(seqPoints.size() - 1);
                for (int i = 0; i < 3; ++i) {
                    JalviewModel.PcaViewer.Axis axis = viewer.getAxis().get(i);
                    panel.getRotatableCanvas().getAxisEndPoints()[i] = new Point(axis.getXPos().floatValue(), axis.getYPos().floatValue(), axis.getZPos().floatValue());
                }
                Desktop.addInternalFrame(panel, MessageManager.formatMessage("label.calc_title", "PCA", modelName), 475, 450);
            }
        }
        catch (Exception ex) {
            Cache.log.error((Object)("Error loading PCA: " + ex.toString()));
        }
    }

    public static JalviewUserColours.Colour marshalColour(String featureType, FeatureColourI fcol) {
        JalviewUserColours.Colour col = new JalviewUserColours.Colour();
        if (fcol.isSimpleColour()) {
            col.setRGB(Format.getHexString(fcol.getColour()));
        } else {
            Color noColour;
            col.setRGB(Format.getHexString(fcol.getMaxColour()));
            col.setMin(Float.valueOf(fcol.getMin()));
            col.setMax(Float.valueOf(fcol.getMax()));
            col.setMinRGB(Format.getHexString(fcol.getMinColour()));
            col.setAutoScale(fcol.isAutoScaled());
            col.setThreshold(Float.valueOf(fcol.getThreshold()));
            col.setColourByLabel(fcol.isColourByLabel());
            col.setThreshType(fcol.isAboveThreshold() ? ThresholdType.ABOVE : (fcol.isBelowThreshold() ? ThresholdType.BELOW : ThresholdType.NONE));
            if (fcol.isColourByAttribute()) {
                String[] attName = fcol.getAttributeName();
                col.getAttributeName().add(attName[0]);
                if (attName.length > 1) {
                    col.getAttributeName().add(attName[1]);
                }
            }
            if ((noColour = fcol.getNoColour()) == null) {
                col.setNoValueColour(NoValueColour.NONE);
            } else if (noColour == fcol.getMaxColour()) {
                col.setNoValueColour(NoValueColour.MAX);
            } else {
                col.setNoValueColour(NoValueColour.MIN);
            }
        }
        col.setName(featureType);
        return col;
    }

    public static jalview.xml.binding.jalview.FeatureMatcherSet marshalFilter(FeatureMatcherI firstMatcher, Iterator<FeatureMatcherI> filters, boolean and) {
        jalview.xml.binding.jalview.FeatureMatcherSet result = new jalview.xml.binding.jalview.FeatureMatcherSet();
        if (filters.hasNext()) {
            FeatureMatcherSet.CompoundMatcher compound = new FeatureMatcherSet.CompoundMatcher();
            compound.setAnd(and);
            jalview.xml.binding.jalview.FeatureMatcherSet matcher1 = Jalview2XML.marshalFilter(firstMatcher, Collections.emptyIterator(), and);
            compound.getMatcherSet().add(matcher1);
            FeatureMatcherI nextMatcher = filters.next();
            jalview.xml.binding.jalview.FeatureMatcherSet matcher2 = Jalview2XML.marshalFilter(nextMatcher, filters, and);
            compound.getMatcherSet().add(matcher2);
            result.setCompoundMatcher(compound);
        } else {
            FeatureMatcher matcherModel = new FeatureMatcher();
            matcherModel.setCondition(firstMatcher.getMatcher().getCondition().getStableName());
            matcherModel.setValue(firstMatcher.getMatcher().getPattern());
            if (firstMatcher.isByAttribute()) {
                matcherModel.setBy(FilterBy.BY_ATTRIBUTE);
                String[] attName = firstMatcher.getAttribute();
                matcherModel.getAttributeName().add(attName[0]);
                if (attName.length > 1) {
                    matcherModel.getAttributeName().add(attName[1]);
                }
            } else if (firstMatcher.isByLabel()) {
                matcherModel.setBy(FilterBy.BY_LABEL);
            } else if (firstMatcher.isByScore()) {
                matcherModel.setBy(FilterBy.BY_SCORE);
            }
            result.setMatchCondition(matcherModel);
        }
        return result;
    }

    public static FeatureMatcherSetI parseFilter(String featureType, jalview.xml.binding.jalview.FeatureMatcherSet matcherSetModel) {
        FeatureMatcherSet result = new FeatureMatcherSet();
        try {
            Jalview2XML.parseFilterConditions(result, matcherSetModel, true);
        }
        catch (IllegalStateException e) {
            System.err.println(String.format("Error reading filter conditions for '%s': %s", featureType, e.getMessage()));
        }
        return result;
    }

    protected static void parseFilterConditions(FeatureMatcherSetI matcherSet, jalview.xml.binding.jalview.FeatureMatcherSet matcherSetModel, boolean and) {
        FeatureMatcher mc = matcherSetModel.getMatchCondition();
        if (mc != null) {
            FilterBy filterBy = mc.getBy();
            Condition cond = Condition.fromString(mc.getCondition());
            String pattern = mc.getValue();
            jalview.datamodel.features.FeatureMatcher matchCondition = null;
            if (filterBy == FilterBy.BY_LABEL) {
                matchCondition = jalview.datamodel.features.FeatureMatcher.byLabel(cond, pattern);
            } else if (filterBy == FilterBy.BY_SCORE) {
                matchCondition = jalview.datamodel.features.FeatureMatcher.byScore(cond, pattern);
            } else if (filterBy == FilterBy.BY_ATTRIBUTE) {
                List<String> attributeName = mc.getAttributeName();
                String[] attNames = attributeName.toArray(new String[attributeName.size()]);
                matchCondition = jalview.datamodel.features.FeatureMatcher.byAttribute(cond, pattern, attNames);
            }
            if (and) {
                matcherSet.and(matchCondition);
            } else {
                matcherSet.or(matchCondition);
            }
        } else {
            List<jalview.xml.binding.jalview.FeatureMatcherSet> matchers = matcherSetModel.getCompoundMatcher().getMatcherSet();
            boolean anded = matcherSetModel.getCompoundMatcher().isAnd();
            if (matchers.size() == 2) {
                Jalview2XML.parseFilterConditions(matcherSet, matchers.get(0), anded);
                Jalview2XML.parseFilterConditions(matcherSet, matchers.get(1), anded);
            } else {
                System.err.println("Malformed compound filter condition");
            }
        }
    }

    public static FeatureColourI parseColour(JalviewUserColours.Colour colourModel) {
        FeatureColour colour = null;
        if (colourModel.getMax() != null) {
            ThresholdType ttyp;
            Color mincol = null;
            Color maxcol = null;
            Color noValueColour = null;
            try {
                mincol = new Color(Integer.parseInt(colourModel.getMinRGB(), 16));
                maxcol = new Color(Integer.parseInt(colourModel.getRGB(), 16));
            }
            catch (Exception e) {
                Cache.log.warn((Object)"Couldn't parse out graduated feature color.", (Throwable)e);
            }
            NoValueColour noCol = colourModel.getNoValueColour();
            if (noCol == NoValueColour.MIN) {
                noValueColour = mincol;
            } else if (noCol == NoValueColour.MAX) {
                noValueColour = maxcol;
            }
            colour = new FeatureColour(maxcol, mincol, maxcol, noValueColour, Jalview2XML.safeFloat(colourModel.getMin()), Jalview2XML.safeFloat(colourModel.getMax()));
            List<String> attributeName = colourModel.getAttributeName();
            String[] attributes = attributeName.toArray(new String[attributeName.size()]);
            if (attributes != null && attributes.length > 0) {
                colour.setAttributeName(attributes);
            }
            if (colourModel.isAutoScale() != null) {
                colour.setAutoScaled(colourModel.isAutoScale());
            }
            if (colourModel.isColourByLabel() != null) {
                colour.setColourByLabel(colourModel.isColourByLabel());
            }
            if (colourModel.getThreshold() != null) {
                colour.setThreshold(colourModel.getThreshold().floatValue());
            }
            if ((ttyp = colourModel.getThreshType()) == ThresholdType.ABOVE) {
                colour.setAboveThreshold(true);
            } else if (ttyp == ThresholdType.BELOW) {
                colour.setBelowThreshold(true);
            }
        } else {
            Color color = new Color(Integer.parseInt(colourModel.getRGB(), 16));
            colour = new FeatureColour(color);
        }
        return colour;
    }

    private class JvAnnotRow {
        public AlignmentAnnotation template;
        public int order;

        public JvAnnotRow(int i, AlignmentAnnotation jaa) {
            this.order = i;
            this.template = jaa;
        }
    }

    abstract class SeqFref {
        String sref;
        String type;

        public SeqFref(String _sref, String type) {
            this.sref = _sref;
            this.type = type;
        }

        public String getSref() {
            return this.sref;
        }

        public SequenceI getSrefSeq() {
            return Jalview2XML.this.seqRefIds.get(this.sref);
        }

        public boolean isResolvable() {
            return Jalview2XML.this.seqRefIds.get(this.sref) != null;
        }

        public SequenceI getSrefDatasetSeq() {
            SequenceI sq = Jalview2XML.this.seqRefIds.get(this.sref);
            if (sq != null) {
                while (sq.getDatasetSequence() != null) {
                    sq = sq.getDatasetSequence();
                }
            }
            return sq;
        }

        abstract boolean resolve();

        public String toString() {
            return this.type + " reference to " + this.sref;
        }
    }
}

