/*
 * Decompiled with CFR 0.152.
 */
package jalview.math;

import jalview.datamodel.Point;
import java.util.HashMap;
import java.util.Map;

public class RotatableMatrix {
    private static final int DIMS = 3;
    private static Map<Axis, Map<Float, float[][]>> cachedRotations = new HashMap<Axis, Map<Float, float[][]>>();
    float[][] matrix = new float[3][3];

    public RotatableMatrix() {
        for (int j = 0; j < 3; ++j) {
            this.matrix[j][j] = 1.0f;
        }
    }

    public void setValue(int i, int j, float value) {
        this.matrix[i][j] = value;
    }

    public float getValue(int i, int j) {
        return this.matrix[i][j];
    }

    public void print() {
        System.out.println(this.matrix[0][0] + " " + this.matrix[0][1] + " " + this.matrix[0][2]);
        System.out.println(this.matrix[1][0] + " " + this.matrix[1][1] + " " + this.matrix[1][2]);
        System.out.println(this.matrix[2][0] + " " + this.matrix[2][1] + " " + this.matrix[2][2]);
    }

    public void rotate(float degrees, Axis axis) {
        float[][] rot = RotatableMatrix.getRotation(degrees, axis);
        this.preMultiply(rot);
    }

    protected static float[][] getRotation(float degrees, Axis axis) {
        Float floatValue = Float.valueOf(degrees);
        if (cachedRotations.get((Object)axis).containsKey(floatValue)) {
            return cachedRotations.get((Object)axis).get(floatValue);
        }
        float costheta = (float)Math.cos((double)degrees * Math.PI / 180.0);
        float sintheta = (float)Math.sin((double)degrees * Math.PI / 180.0);
        float[][] rot = new float[3][3];
        switch (axis) {
            case X: {
                rot[0][0] = 1.0f;
                rot[1][1] = costheta;
                rot[1][2] = sintheta;
                rot[2][1] = -sintheta;
                rot[2][2] = costheta;
                break;
            }
            case Y: {
                rot[0][0] = costheta;
                rot[0][2] = -sintheta;
                rot[1][1] = 1.0f;
                rot[2][0] = sintheta;
                rot[2][2] = costheta;
                break;
            }
            case Z: {
                rot[0][0] = costheta;
                rot[0][1] = -sintheta;
                rot[1][0] = sintheta;
                rot[1][1] = costheta;
                rot[2][2] = 1.0f;
            }
        }
        return rot;
    }

    public float[] vectorMultiply(float[] vect) {
        float[] result = new float[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = this.matrix[i][0] * vect[0] + this.matrix[i][1] * vect[1] + this.matrix[i][2] * vect[2];
        }
        return result;
    }

    public void preMultiply(float[][] mat) {
        float[][] tmp = new float[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                tmp[i][j] = mat[i][0] * this.matrix[0][j] + mat[i][1] * this.matrix[1][j] + mat[i][2] * this.matrix[2][j];
            }
        }
        this.matrix = tmp;
    }

    public void postMultiply(float[][] mat) {
        float[][] tmp = new float[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                tmp[i][j] = this.matrix[i][0] * mat[0][j] + this.matrix[i][1] * mat[1][j] + this.matrix[i][2] * mat[2][j];
            }
        }
        this.matrix = tmp;
    }

    public static void main(String[] args) {
        RotatableMatrix m = new RotatableMatrix();
        m.setValue(0, 0, 1.0f);
        m.setValue(0, 1, 0.0f);
        m.setValue(0, 2, 0.0f);
        m.setValue(1, 0, 0.0f);
        m.setValue(1, 1, 2.0f);
        m.setValue(1, 2, 0.0f);
        m.setValue(2, 0, 0.0f);
        m.setValue(2, 1, 0.0f);
        m.setValue(2, 2, 1.0f);
        m.print();
        RotatableMatrix n = new RotatableMatrix();
        n.setValue(0, 0, 2.0f);
        n.setValue(0, 1, 1.0f);
        n.setValue(0, 2, 1.0f);
        n.setValue(1, 0, 2.0f);
        n.setValue(1, 1, 1.0f);
        n.setValue(1, 2, 1.0f);
        n.setValue(2, 0, 2.0f);
        n.setValue(2, 1, 1.0f);
        n.setValue(2, 2, 1.0f);
        n.print();
        float[] vect = new float[]{2.0f, 4.0f, 6.0f};
        vect = m.vectorMultiply(vect);
        System.out.println(vect[0] + " " + vect[1] + " " + vect[2]);
    }

    public Point vectorMultiply(Point coord) {
        float[] v = this.vectorMultiply(new float[]{coord.x, coord.y, coord.z});
        return new Point(v[0], v[1], v[2]);
    }

    static {
        for (Axis axis : Axis.values()) {
            HashMap<Float, float[][]> map = new HashMap<Float, float[][]>();
            cachedRotations.put(axis, map);
            for (int deg = 1; deg < 5; ++deg) {
                float[][] rotation = RotatableMatrix.getRotation(deg, axis);
                map.put(Float.valueOf(deg), rotation);
                rotation = RotatableMatrix.getRotation(-deg, axis);
                map.put(Float.valueOf(-deg), rotation);
            }
        }
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

