/*
 * Decompiled with CFR 0.152.
 */
package jalview.jbgui;

import jalview.datamodel.SequenceI;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.core.FTSDataColumnPreferences;
import jalview.fts.service.pdb.PDBFTSRestClient;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.gui.StructureViewer;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public abstract class GStructureChooser
extends JPanel
implements ItemListener {
    private static final Font VERDANA_12 = new Font("Verdana", 0, 12);
    protected static final String VIEWS_FILTER = "VIEWS_FILTER";
    protected static final String VIEWS_FROM_FILE = "VIEWS_FROM_FILE";
    protected static final String VIEWS_ENTER_ID = "VIEWS_ENTER_ID";
    protected static final String VIEWS_LOCAL_PDB = "VIEWS_LOCAL_PDB";
    protected JPanel statusPanel = new JPanel();
    public JLabel statusBar = new JLabel();
    protected String frameTitle = MessageManager.getString("label.structure_chooser");
    protected JInternalFrame mainFrame = new JInternalFrame(this.frameTitle);
    protected JComboBox<FilterOption> cmb_filterOption = new JComboBox();
    protected AlignmentPanel ap;
    protected StringBuilder errorWarning = new StringBuilder();
    protected JButton btn_add;
    protected JButton btn_newView;
    protected JButton btn_pdbFromFile = new JButton();
    protected JCheckBox chk_superpose = new JCheckBox(MessageManager.getString("label.superpose_structures"));
    protected JTextField txt_search = new JTextField(14);
    protected JPanel pnl_switchableViews = new JPanel(new CardLayout());
    protected CardLayout layout_switchableViews = (CardLayout)this.pnl_switchableViews.getLayout();
    protected JCheckBox chk_invertFilter = new JCheckBox(MessageManager.getString("label.invert"));
    protected ImageIcon loadingImage = new ImageIcon(this.getClass().getResource("/images/loading.gif"));
    protected ImageIcon goodImage = new ImageIcon(this.getClass().getResource("/images/good.png"));
    protected ImageIcon errorImage = new ImageIcon(this.getClass().getResource("/images/error.png"));
    protected ImageIcon warningImage = new ImageIcon(this.getClass().getResource("/images/warning.gif"));
    protected JLabel lbl_loading = new JLabel(this.loadingImage);
    protected JLabel lbl_pdbManualFetchStatus = new JLabel(this.errorImage);
    protected JLabel lbl_fromFileStatus = new JLabel(this.errorImage);
    protected AssociateSeqPanel idInputAssSeqPanel = new AssociateSeqPanel();
    protected AssociateSeqPanel fileChooserAssSeqPanel = new AssociateSeqPanel();
    protected JComboBox<StructureViewer> targetView = new JComboBox();
    protected JTable tbl_local_pdb = new JTable();
    protected JTabbedPane pnl_filter = new JTabbedPane();
    protected FTSDataColumnPreferences pdbDocFieldPrefs = new FTSDataColumnPreferences(FTSDataColumnPreferences.PreferenceSource.STRUCTURE_CHOOSER, PDBFTSRestClient.getInstance());
    protected FTSDataColumnI[] previousWantedFields;
    protected static Map<String, Integer> tempUserPrefs = new HashMap<String, Integer>();
    private JTable tbl_summary = new JTable(){
        private boolean inLayout;

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.hasExcessWidth();
        }

        @Override
        public void doLayout() {
            if (this.hasExcessWidth()) {
                this.autoResizeMode = 2;
            }
            this.inLayout = true;
            super.doLayout();
            this.inLayout = false;
            this.autoResizeMode = 0;
        }

        protected boolean hasExcessWidth() {
            return this.getPreferredSize().width < this.getParent().getWidth();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            TableColumn resizingColumn;
            if (this.isEditing()) {
                this.removeEditor();
            }
            if ((resizingColumn = this.getTableHeader().getResizingColumn()) != null && this.autoResizeMode == 0 && !this.inLayout) {
                resizingColumn.setPreferredWidth(resizingColumn.getWidth());
                String colHeader = resizingColumn.getHeaderValue().toString();
                tempUserPrefs.put(colHeader, resizingColumn.getWidth());
            }
            this.resizeAndRepaint();
        }

        @Override
        public String getToolTipText(MouseEvent evt) {
            String toolTipText = null;
            Point pnt = evt.getPoint();
            int rowIndex = this.rowAtPoint(pnt);
            int colIndex = this.columnAtPoint(pnt);
            try {
                if (this.getValueAt(rowIndex, colIndex) == null) {
                    return null;
                }
                toolTipText = this.getValueAt(rowIndex, colIndex).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            toolTipText = toolTipText == null ? null : (toolTipText.length() > 500 ? JvSwingUtils.wrapTooltip(true, "\"" + toolTipText.subSequence(0, 500) + "...\"") : JvSwingUtils.wrapTooltip(true, toolTipText));
            return toolTipText;
        }
    };

    public GStructureChooser() {
        try {
            this.jbInit();
            this.mainFrame.setVisible(false);
            this.mainFrame.invalidate();
            this.mainFrame.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Integer width = tempUserPrefs.get("structureChooser.width") == null ? 800 : tempUserPrefs.get("structureChooser.width");
        Integer height = tempUserPrefs.get("structureChooser.height") == null ? 400 : tempUserPrefs.get("structureChooser.height");
        this.tbl_summary.setAutoCreateRowSorter(true);
        this.tbl_summary.getTableHeader().setReorderingAllowed(false);
        this.tbl_summary.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GStructureChooser.this.validateSelections();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GStructureChooser.this.validateSelections();
            }
        });
        this.tbl_summary.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GStructureChooser.this.validateSelections();
                switch (evt.getKeyCode()) {
                    case 27: {
                        GStructureChooser.this.mainFrame.dispose();
                        break;
                    }
                    case 10: {
                        if (!GStructureChooser.this.btn_add.isEnabled()) break;
                        GStructureChooser.this.add_ActionPerformed();
                        break;
                    }
                    case 9: {
                        if (evt.isShiftDown()) {
                            GStructureChooser.this.pnl_filter.requestFocus();
                        } else {
                            GStructureChooser.this.btn_add.requestFocus();
                        }
                        evt.consume();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        });
        final JButton btn_cancel = new JButton(MessageManager.getString("action.cancel"));
        btn_cancel.setFont(VERDANA_12);
        btn_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GStructureChooser.this.closeAction(GStructureChooser.this.pnl_filter.getHeight());
            }
        });
        btn_cancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    GStructureChooser.this.closeAction(GStructureChooser.this.pnl_filter.getHeight());
                }
            }
        });
        this.tbl_local_pdb.setAutoCreateRowSorter(true);
        this.tbl_local_pdb.getTableHeader().setReorderingAllowed(false);
        this.tbl_local_pdb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GStructureChooser.this.validateSelections();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GStructureChooser.this.validateSelections();
            }
        });
        this.tbl_local_pdb.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GStructureChooser.this.validateSelections();
                switch (evt.getKeyCode()) {
                    case 27: {
                        GStructureChooser.this.mainFrame.dispose();
                        break;
                    }
                    case 10: {
                        if (!GStructureChooser.this.btn_add.isEnabled()) break;
                        GStructureChooser.this.add_ActionPerformed();
                        break;
                    }
                    case 9: {
                        if (evt.isShiftDown()) {
                            GStructureChooser.this.cmb_filterOption.requestFocus();
                        } else if (GStructureChooser.this.btn_add.isEnabled()) {
                            GStructureChooser.this.btn_add.requestFocus();
                        } else {
                            btn_cancel.requestFocus();
                        }
                        evt.consume();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        });
        this.btn_newView = new JButton(MessageManager.getString("action.new_view"));
        this.btn_newView.setFont(VERDANA_12);
        this.btn_newView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GStructureChooser.this.newView_ActionPerformed();
            }
        });
        this.btn_newView.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    GStructureChooser.this.newView_ActionPerformed();
                }
            }
        });
        this.btn_add = new JButton(MessageManager.getString("action.add"));
        this.btn_add.setFont(VERDANA_12);
        this.btn_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GStructureChooser.this.add_ActionPerformed();
            }
        });
        this.btn_add.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    GStructureChooser.this.add_ActionPerformed();
                }
            }
        });
        this.btn_pdbFromFile.setFont(VERDANA_12);
        String btn_title = MessageManager.getString("label.select_pdb_file");
        this.btn_pdbFromFile.setText(btn_title + "              ");
        this.btn_pdbFromFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GStructureChooser.this.pdbFromFile_actionPerformed();
            }
        });
        this.btn_pdbFromFile.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    GStructureChooser.this.pdbFromFile_actionPerformed();
                }
            }
        });
        JScrollPane scrl_foundStructures = new JScrollPane(this.tbl_summary);
        scrl_foundStructures.setPreferredSize(new Dimension(width, height));
        JScrollPane scrl_localPDB = new JScrollPane(this.tbl_local_pdb);
        scrl_localPDB.setPreferredSize(new Dimension(width, height));
        scrl_localPDB.setHorizontalScrollBarPolicy(31);
        this.chk_invertFilter.setFont(VERDANA_12);
        this.txt_search.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.enter_pdb_id_tip")));
        this.txt_search.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GStructureChooser.this.txt_search_ActionPerformed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GStructureChooser.this.txt_search_ActionPerformed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GStructureChooser.this.txt_search_ActionPerformed();
            }
        });
        this.cmb_filterOption.setFont(VERDANA_12);
        this.cmb_filterOption.setToolTipText(MessageManager.getString("info.select_filter_option"));
        this.cmb_filterOption.addItemListener(this);
        this.cmb_filterOption.setRenderer(new CustomComboSeparatorsRenderer(this.cmb_filterOption.getRenderer()){

            @Override
            protected boolean addSeparatorAfter(JList list, FilterOption value, int index) {
                return value.isAddSeparatorAfter();
            }
        });
        this.chk_invertFilter.addItemListener(this);
        this.targetView.setVisible(false);
        JPanel actionsPanel = new JPanel((LayoutManager)new MigLayout());
        actionsPanel.add(this.targetView, "left");
        actionsPanel.add((Component)this.btn_add, "wrap");
        actionsPanel.add((Component)this.chk_superpose, "left");
        actionsPanel.add(this.btn_newView);
        actionsPanel.add((Component)btn_cancel, "right");
        JPanel pnl_main = new JPanel();
        pnl_main.add(this.cmb_filterOption);
        pnl_main.add(this.lbl_loading);
        pnl_main.add(this.chk_invertFilter);
        this.lbl_loading.setVisible(false);
        JPanel pnl_fileChooser = new JPanel(new FlowLayout());
        pnl_fileChooser.add(this.btn_pdbFromFile);
        pnl_fileChooser.add(this.lbl_fromFileStatus);
        JPanel pnl_fileChooserBL = new JPanel(new BorderLayout());
        pnl_fileChooserBL.add((Component)this.fileChooserAssSeqPanel, "North");
        pnl_fileChooserBL.add((Component)pnl_fileChooser, "Center");
        JPanel pnl_idInput = new JPanel(new FlowLayout());
        pnl_idInput.add(this.txt_search);
        pnl_idInput.add(this.lbl_pdbManualFetchStatus);
        JPanel pnl_idInputBL = new JPanel(new BorderLayout());
        pnl_idInputBL.add((Component)this.idInputAssSeqPanel, "North");
        pnl_idInputBL.add((Component)pnl_idInput, "Center");
        final String foundStructureSummary = MessageManager.getString("label.found_structures_summary");
        final String configureCols = MessageManager.getString("label.configure_displayed_columns");
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane sourceTabbedPane = (JTabbedPane)changeEvent.getSource();
                int index = sourceTabbedPane.getSelectedIndex();
                GStructureChooser.this.btn_add.setVisible(GStructureChooser.this.targetView.isVisible());
                GStructureChooser.this.btn_newView.setVisible(true);
                btn_cancel.setVisible(true);
                if (sourceTabbedPane.getTitleAt(index).equals(configureCols)) {
                    GStructureChooser.this.btn_add.setEnabled(false);
                    btn_cancel.setEnabled(false);
                    GStructureChooser.this.btn_add.setVisible(false);
                    GStructureChooser.this.btn_newView.setEnabled(false);
                    btn_cancel.setVisible(false);
                    GStructureChooser.this.previousWantedFields = GStructureChooser.this.pdbDocFieldPrefs.getStructureSummaryFields().toArray(new FTSDataColumnI[0]);
                }
                if (sourceTabbedPane.getTitleAt(index).equals(foundStructureSummary)) {
                    btn_cancel.setEnabled(true);
                    if (GStructureChooser.this.wantedFieldsUpdated()) {
                        GStructureChooser.this.tabRefresh();
                    } else {
                        GStructureChooser.this.validateSelections();
                    }
                }
            }
        };
        this.pnl_filter.addChangeListener(changeListener);
        this.pnl_filter.setPreferredSize(new Dimension(width, height));
        this.pnl_filter.add(foundStructureSummary, scrl_foundStructures);
        this.pnl_filter.add(configureCols, this.pdbDocFieldPrefs);
        JPanel pnl_locPDB = new JPanel(new BorderLayout());
        pnl_locPDB.add(scrl_localPDB);
        this.pnl_switchableViews.add((Component)pnl_fileChooserBL, VIEWS_FROM_FILE);
        this.pnl_switchableViews.add((Component)pnl_idInputBL, VIEWS_ENTER_ID);
        this.pnl_switchableViews.add((Component)this.pnl_filter, VIEWS_FILTER);
        this.pnl_switchableViews.add((Component)pnl_locPDB, VIEWS_LOCAL_PDB);
        this.setLayout(new BorderLayout());
        this.add((Component)pnl_main, "North");
        this.add((Component)this.pnl_switchableViews, "Center");
        this.statusPanel.setLayout(new GridLayout());
        JPanel pnl_actionsAndStatus = new JPanel(new BorderLayout());
        pnl_actionsAndStatus.add((Component)actionsPanel, "Center");
        pnl_actionsAndStatus.add((Component)this.statusPanel, "South");
        this.statusPanel.add((Component)this.statusBar, null);
        this.add((Component)pnl_actionsAndStatus, "South");
        this.mainFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                GStructureChooser.this.closeAction(GStructureChooser.this.pnl_filter.getHeight());
            }
        });
        this.mainFrame.setVisible(true);
        this.mainFrame.setContentPane(this);
        this.mainFrame.setDefaultCloseOperation(2);
        Integer x = tempUserPrefs.get("structureChooser.x");
        Integer y = tempUserPrefs.get("structureChooser.y");
        if (x != null && y != null) {
            this.mainFrame.setLocation(x, y);
        }
        Desktop.addInternalFrame(this.mainFrame, this.frameTitle, width, height);
    }

    protected void closeAction(int preferredHeight) {
        tempUserPrefs.put("structureChooser.width", this.pnl_filter.getWidth());
        tempUserPrefs.put("structureChooser.height", preferredHeight);
        tempUserPrefs.put("structureChooser.x", this.mainFrame.getX());
        tempUserPrefs.put("structureChooser.y", this.mainFrame.getY());
        this.mainFrame.dispose();
    }

    public boolean wantedFieldsUpdated() {
        if (this.previousWantedFields == null) {
            return true;
        }
        Object[] currentWantedFields = this.pdbDocFieldPrefs.getStructureSummaryFields().toArray(new FTSDataColumnI[0]);
        return !Arrays.equals(currentWantedFields, this.previousWantedFields);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.stateChanged(e);
    }

    public JTable getResultTable() {
        return this.tbl_summary;
    }

    public JComboBox<FilterOption> getCmbFilterOption() {
        return this.cmb_filterOption;
    }

    protected abstract void stateChanged(ItemEvent var1);

    protected abstract void add_ActionPerformed();

    protected abstract void newView_ActionPerformed();

    protected abstract void pdbFromFile_actionPerformed();

    protected abstract void txt_search_ActionPerformed();

    protected abstract void populateCmbAssociateSeqOptions(JComboBox<AssociateSeqOptions> var1, JLabel var2);

    protected abstract void cmbAssSeqStateChanged();

    protected abstract void tabRefresh();

    protected abstract void validateSelections();

    public abstract class CustomComboSeparatorsRenderer
    implements ListCellRenderer<Object> {
        private ListCellRenderer<Object> regent;
        private JPanel separatorPanel = new JPanel(new BorderLayout());
        private JSeparator jSeparator = new JSeparator();

        public CustomComboSeparatorsRenderer(ListCellRenderer<Object> listCellRenderer) {
            this.regent = listCellRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.regent.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (index != -1 && this.addSeparatorAfter(list, (FilterOption)value, index)) {
                this.separatorPanel.removeAll();
                this.separatorPanel.add(comp, "Center");
                this.separatorPanel.add((Component)this.jSeparator, "South");
                return this.separatorPanel;
            }
            return comp;
        }

        protected abstract boolean addSeparatorAfter(JList var1, FilterOption var2, int var3);
    }

    public class AssociateSeqPanel
    extends JPanel
    implements ItemListener {
        private JComboBox<AssociateSeqOptions> cmb_assSeq = new JComboBox();
        private JLabel lbl_associateSeq = new JLabel();

        public AssociateSeqPanel() {
            this.setLayout(new FlowLayout());
            this.add(this.cmb_assSeq);
            this.add(this.lbl_associateSeq);
            this.cmb_assSeq.setToolTipText(MessageManager.getString("info.associate_wit_sequence"));
            this.cmb_assSeq.addItemListener(this);
        }

        public void loadCmbAssSeq() {
            GStructureChooser.this.populateCmbAssociateSeqOptions(this.cmb_assSeq, this.lbl_associateSeq);
        }

        public JComboBox<AssociateSeqOptions> getCmb_assSeq() {
            return this.cmb_assSeq;
        }

        public void setCmb_assSeq(JComboBox<AssociateSeqOptions> cmb_assSeq) {
            this.cmb_assSeq = cmb_assSeq;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                GStructureChooser.this.cmbAssSeqStateChanged();
            }
        }
    }

    public class AssociateSeqOptions {
        private SequenceI sequence;
        private String name;

        public AssociateSeqOptions(SequenceI seq) {
            this.sequence = seq;
            this.name = seq.getName().length() >= 23 ? seq.getName().substring(0, 23) : seq.getName();
        }

        public AssociateSeqOptions(String name, SequenceI seq) {
            this.name = name;
            this.sequence = seq;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public SequenceI getSequence() {
            return this.sequence;
        }

        public void setSequence(SequenceI sequence) {
            this.sequence = sequence;
        }
    }

    public class FilterOption {
        private String name;
        private String value;
        private String view;
        private boolean addSeparatorAfter;

        public FilterOption(String name, String value, String view, boolean addSeparatorAfter) {
            this.name = name;
            this.value = value;
            this.view = view;
            this.addSeparatorAfter = addSeparatorAfter;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getView() {
            return this.view;
        }

        public void setView(String view) {
            this.view = view;
        }

        public String toString() {
            return this.name;
        }

        public boolean isAddSeparatorAfter() {
            return this.addSeparatorAfter;
        }

        public void setAddSeparatorAfter(boolean addSeparatorAfter) {
            this.addSeparatorAfter = addSeparatorAfter;
        }
    }
}

