/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.vamsas;

import jalview.analysis.TreeModel;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.BinaryNode;
import jalview.datamodel.CigarArray;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.gui.AlignFrame;
import jalview.gui.TreePanel;
import jalview.io.NewickFile;
import jalview.io.VamsasAppDatastore;
import jalview.io.vamsas.DatastoreItem;
import jalview.viewmodel.AlignmentViewport;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.objects.core.AlignmentSequence;
import uk.ac.vamsas.objects.core.Entry;
import uk.ac.vamsas.objects.core.Input;
import uk.ac.vamsas.objects.core.Newick;
import uk.ac.vamsas.objects.core.Param;
import uk.ac.vamsas.objects.core.Provenance;
import uk.ac.vamsas.objects.core.Seg;
import uk.ac.vamsas.objects.core.Treenode;
import uk.ac.vamsas.objects.core.Vref;

public class Tree
extends DatastoreItem {
    AlignmentI jal;
    TreePanel tp;
    uk.ac.vamsas.objects.core.Tree tree;
    uk.ac.vamsas.objects.core.Alignment alignment;
    private NewickFile ntree;
    private String title;
    private AlignmentView inputData = null;

    public static void updateFrom(VamsasAppDatastore datastore, AlignFrame alignFrame, uk.ac.vamsas.objects.core.Tree vtree) {
        Tree toTree = new Tree(datastore, alignFrame, vtree);
    }

    public Tree(VamsasAppDatastore datastore, AlignFrame alignFrame, uk.ac.vamsas.objects.core.Tree vtree) {
        super(datastore, (Vobject)vtree, TreePanel.class);
        this.doJvUpdate();
    }

    private NewickFile getNtree() throws IOException {
        return new NewickFile(this.tree.getNewick(0).getContent());
    }

    public Tree(VamsasAppDatastore datastore, TreePanel tp2, AlignmentI jal2, uk.ac.vamsas.objects.core.Alignment alignment2) {
        super(datastore, tp2, uk.ac.vamsas.objects.core.Tree.class);
        this.jal = jal2;
        this.tp = (TreePanel)this.jvobj;
        this.alignment = alignment2;
        this.tree = (uk.ac.vamsas.objects.core.Tree)this.vobj;
        this.doSync();
    }

    @Override
    public void addFromDocument() {
        this.tree = (uk.ac.vamsas.objects.core.Tree)this.vobj;
        TreePanel tp = (TreePanel)this.jvobj;
        Object[] idata = this.recoverInputData(this.tree.getProvenance());
        try {
            if (idata != null && idata[0] != null) {
                this.inputData = (AlignmentView)idata[0];
            }
            this.ntree = this.getNtree();
            this.title = this.tree.getNewick(0).getTitle();
            if (this.title == null || this.title.length() == 0) {
                this.title = this.tree.getTitle();
            }
        }
        catch (Exception e) {
            Cache.log.warn((Object)("Problems parsing treefile '" + this.tree.getNewick(0).getContent() + "'"), (Throwable)e);
        }
    }

    @Override
    public void conflict() {
        Cache.log.info((Object)"Update (with conflict) from vamsas document to alignment associated tree not implemented yet.");
    }

    @Override
    public void updateToDoc() {
        if (this.isModifiable(this.tree.getModifiable())) {
            log.info((Object)"TODO: Update tree in document from jalview.");
        } else {
            log.info((Object)"TODO: Add the locally modified tree in Jalview as a new tree in document, leaving locked tree unchanged.");
        }
    }

    @Override
    public void updateFromDoc() {
        log.debug((Object)"Update the local tree in jalview from the document.");
        if (this.isModifiable(this.tree.getModifiable())) {
            log.debug((Object)"Update tree in document from jalview.");
        } else {
            log.debug((Object)"Add modified jalview tree as new tree in document.");
        }
    }

    private Provenance makeTreeProvenance(AlignmentI jal, TreePanel tp) {
        Cache.log.debug((Object)("Making Tree provenance for " + tp.getTitle()));
        Provenance prov = new Provenance();
        prov.addEntry(new Entry());
        prov.getEntry(0).setAction("imported " + tp.getTitle());
        prov.getEntry(0).setUser(this.provEntry.getUser());
        prov.getEntry(0).setApp(this.provEntry.getApp());
        prov.getEntry(0).setDate(this.provEntry.getDate());
        AlignmentView originalData = tp.getTree().getOriginalData();
        if (originalData != null) {
            Input vInput = new Input();
            Vector alsqrefs = this.getjv2vObjs(this.findAlignmentSequences(jal, tp.getTree().getOriginalData().getSequences()));
            Object[] alsqs = new Object[alsqrefs.size()];
            alsqrefs.copyInto(alsqs);
            vInput.setObjRef(alsqs);
            prov.getEntry(0).setAction("created " + tp.getTitle());
            prov.getEntry(0).addInput(vInput);
            vInput.setName("jalview:seqdist");
            prov.getEntry(0).addParam(new Param());
            prov.getEntry(0).getParam(0).setName("treeType");
            prov.getEntry(0).getParam(0).setType("utf8");
            prov.getEntry(0).getParam(0).setContent("NJ");
            int[] ranges = originalData.getVisibleContigs();
            int start = tp.getTree().getOriginalData().getAlignmentOrigin();
            for (int r = 0; r < ranges.length; r += 2) {
                Seg visSeg = new Seg();
                visSeg.setStart(1 + start + ranges[r]);
                visSeg.setEnd(start + ranges[r + 1]);
                visSeg.setInclusive(true);
                vInput.addSeg(visSeg);
            }
        }
        Cache.log.debug((Object)("Finished Tree provenance for " + tp.getTitle()));
        return prov;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector findAlignmentSequences(AlignmentI jal, SeqCigar[] sequences) {
        List<SequenceI> jalsqs;
        SeqCigar[] tseqs = new SeqCigar[sequences.length];
        System.arraycopy(sequences, 0, tseqs, 0, sequences.length);
        Vector<SequenceI> alsq = new Vector<SequenceI>();
        List<SequenceI> list = jalsqs = jal.getSequences();
        synchronized (jalsqs) {
            for (SequenceI asq : jalsqs) {
                for (int t = 0; t < sequences.length; ++t) {
                    if (tseqs[t] == null || tseqs[t].getRefSeq() != asq && tseqs[t].getRefSeq() != asq.getDatasetSequence()) continue;
                    tseqs[t] = null;
                    alsq.add(asq);
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (alsq.size() < sequences.length) {
                Cache.log.warn((Object)"Not recovered all alignment sequences for given set of input sequence CIGARS");
            }
            return alsq;
        }
    }

    public void UpdateSequenceTreeMap(TreePanel tp) {
        if (tp == null || this.tree == null) {
            return;
        }
        if (tp.getTree() == null) {
            Cache.log.warn((Object)("Not updating SequenceTreeMap for " + this.tree.getVorbaId()));
            return;
        }
        Vector<SequenceNode> leaves = tp.getTree().findLeaves(tp.getTree().getTopNode());
        Treenode[] tn = this.tree.getTreenode();
        int sz = tn.length;
        int i = 0;
        while (i < sz) {
            Treenode node;
            BinaryNode mappednode;
            if ((mappednode = this.findNodeSpec((node = tn[i++]).getNodespec(), leaves)) == null || !(mappednode instanceof SequenceNode)) continue;
            SequenceNode leaf = (SequenceNode)mappednode;
            Object jvseq = null;
            int vrf = 0;
            int refv = 0;
            while (jvseq == null && vrf < node.getVrefCount()) {
                if (refv < node.getVref(vrf).getRefsCount()) {
                    Object noderef = node.getVref(vrf).getRefs(refv++);
                    if (!(noderef instanceof AlignmentSequence)) continue;
                    jvseq = this.getvObj2jv((Vobject)noderef);
                    continue;
                }
                refv = 0;
                ++vrf;
            }
            if (jvseq instanceof SequenceI) {
                leaf.setElement(jvseq);
                leaf.setPlaceholder(false);
                continue;
            }
            leaf.setPlaceholder(true);
            leaf.setElement(new Sequence(leaf.getName(), "THISISAPLACEHLDER"));
        }
    }

    public Treenode[] makeTreeNodes(TreeModel treeModel, Newick newick) {
        Vector<SequenceNode> leaves = treeModel.findLeaves(treeModel.getTopNode());
        Vector<Treenode> tnv = new Vector<Treenode>();
        Enumeration<SequenceNode> l = leaves.elements();
        Hashtable nodespecs = new Hashtable();
        while (l.hasMoreElements()) {
            Object assocseq;
            BinaryNode tnode = l.nextElement();
            if (!(tnode instanceof SequenceNode) || ((SequenceNode)tnode).isPlaceholder() || !((assocseq = ((SequenceNode)tnode).element()) instanceof SequenceI)) continue;
            Vobject vobj = this.getjv2vObj(assocseq);
            if (vobj != null) {
                Treenode node = new Treenode();
                if (newick.isRegisterable()) {
                    this.cdoc.registerObject((Vobject)newick);
                    node.addTreeId((Object)newick);
                }
                node.setNodespec(this.makeNodeSpec(nodespecs, tnode));
                node.setName(tnode.getName());
                Vref vr = new Vref();
                vr.addRefs((Object)vobj);
                node.addVref(vr);
                tnv.addElement(node);
                continue;
            }
            System.err.println("WARNING: Unassociated treeNode " + tnode.element().toString() + " " + (String)(tnode.getName() != null ? " label " + tnode.getName() : ""));
        }
        if (tnv.size() > 0) {
            Object[] tn = new Treenode[tnv.size()];
            tnv.copyInto(tn);
            return tn;
        }
        return new Treenode[0];
    }

    private String makeNodeSpec(Hashtable nodespecs, BinaryNode tnode) {
        Object nname = new String(tnode.getName());
        Integer nindx = (Integer)nodespecs.get(nname);
        if (nindx == null) {
            nindx = 1;
        }
        nname = nindx.toString() + " " + (String)nname;
        return nname;
    }

    private BinaryNode findNodeSpec(String nodespec, Vector leaves) {
        int occurence = -1;
        String nspec = nodespec.substring(nodespec.indexOf(32) + 1);
        String oval = nodespec.substring(0, nodespec.indexOf(32));
        try {
            occurence = Integer.valueOf(oval);
        }
        catch (Exception e) {
            System.err.println("Invalid nodespec '" + nodespec + "'");
            return null;
        }
        BinaryNode bn = null;
        int nocc = 0;
        Enumeration en = leaves.elements();
        while (en.hasMoreElements() && nocc < occurence) {
            bn = (BinaryNode)en.nextElement();
            if (bn instanceof SequenceNode && bn.getName().equals(nspec)) {
                --occurence;
                continue;
            }
            bn = null;
        }
        return bn;
    }

    @Override
    public void addToDocument() {
        this.tree = new uk.ac.vamsas.objects.core.Tree();
        this.bindjvvobj(this.tp, (Vobject)this.tree);
        this.tree.setTitle(this.tp.getTitle());
        Newick newick = new Newick();
        newick.setContent(this.tp.getTree().print());
        newick.setTitle(this.tp.getTitle());
        this.tree.addNewick(newick);
        this.tree.setProvenance(this.makeTreeProvenance(this.jal, this.tp));
        this.tree.setTreenode(this.makeTreeNodes(this.tp.getTree(), newick));
        this.alignment.addTree(this.tree);
    }

    public Object[] recoverInputData(Provenance tp) {
        AlignmentViewport javport = null;
        AlignmentI jal = null;
        CigarArray view = null;
        for (int pe = 0; pe < tp.getEntryCount(); ++pe) {
            Input vInput;
            if (tp.getEntry(pe).getInputCount() <= 0) continue;
            if (tp.getEntry(pe).getInputCount() > 1) {
                Cache.log.warn((Object)("Ignoring additional input spec in provenance entry " + tp.getEntry(pe).toString()));
            }
            if ((vInput = tp.getEntry(pe).getInput(0)).getObjRefCount() == 0) {
                if (this.tree.getV_parent() != null && this.tree.getV_parent() instanceof uk.ac.vamsas.objects.core.Alignment) {
                    javport = this.getViewport(this.tree.getV_parent());
                    jal = javport.getAlignment();
                    view = javport.getAlignment().getCompactAlignment();
                }
            } else if (vInput.getObjRefCount() == 1 && vInput.getObjRef(0) instanceof uk.ac.vamsas.objects.core.Alignment) {
                javport = this.getViewport((Vobject)vInput.getObjRef(0));
                jal = javport.getAlignment();
                view = javport.getAlignment().getCompactAlignment();
            } else if (vInput.getObjRef(0) instanceof AlignmentSequence) {
                javport = this.getViewport(((Vobject)vInput.getObjRef(0)).getV_parent());
                jal = javport.getAlignment();
                SequenceI[] seqs = new SequenceI[vInput.getObjRefCount()];
                int iSize = vInput.getObjRefCount();
                for (int i = 0; i < iSize; ++i) {
                    SequenceI seq;
                    seqs[i] = seq = (SequenceI)this.getvObj2jv((Vobject)vInput.getObjRef(i));
                }
                view = new Alignment(seqs).getCompactAlignment();
            }
            int from = 1;
            int to = jal.getWidth();
            int offset = 0;
            int s = vInput.getSegCount();
            for (int r = 0; r < s; ++r) {
                Seg visSeg = vInput.getSeg(r);
                int[] se = this.getSegRange(visSeg, true);
                if (to < se[1]) {
                    Cache.log.warn((Object)"Ignoring invalid segment in InputData spec.");
                    continue;
                }
                if (se[0] > from) {
                    view.deleteRange(offset + from - 1, offset + se[0] - 2);
                    offset -= se[0] - from;
                }
                from = se[1] + 1;
            }
            if (from < to) {
                view.deleteRange(offset + from - 1, offset + to - 1);
            }
            return new Object[]{new AlignmentView(view), jal};
        }
        Cache.log.debug((Object)"Returning null for input data recovery from provenance.");
        return null;
    }

    private AlignmentViewport getViewport(Vobject v_parent) {
        if (v_parent instanceof uk.ac.vamsas.objects.core.Alignment) {
            return this.datastore.findViewport((uk.ac.vamsas.objects.core.Alignment)v_parent);
        }
        return null;
    }

    public NewickFile getNewickTree() {
        return this.ntree;
    }

    public String getTitle() {
        return this.title;
    }

    public AlignmentView getInputData() {
        return this.inputData;
    }

    public boolean isValidTree() {
        try {
            if (this.ntree == null) {
                return false;
            }
            this.ntree.parse();
            if (this.ntree.getTree() != null) {
                this.ntree = this.getNtree();
            }
            return true;
        }
        catch (Exception e) {
            Cache.log.debug((Object)"Failed to parse newick tree string", (Throwable)e);
            return false;
        }
    }
}

