/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.packed;

import jalview.api.FeatureColourI;
import jalview.datamodel.AlignmentI;
import jalview.io.AnnotationFile;
import jalview.io.AppletFormatAdapter;
import jalview.io.FeaturesFile;
import jalview.io.FileFormatI;
import jalview.io.FileParse;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.io.NewickFile;
import jalview.io.packed.DataProvider;
import jalview.io.packed.JalviewDataset;
import jalview.io.packed.SimpleDataProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class ParsePackedSet {
    public Object[] getAlignment(JalviewDataset context, Iterable<DataProvider> files) throws Exception {
        ArrayList<Object> rslt = new ArrayList<Object>();
        if (context == null) {
            context = new JalviewDataset();
        }
        boolean deuniquify = false;
        for (DataProvider dta : files) {
            Exception exerror = null;
            Object errmsg = null;
            FileParse src = dta.getDataSource();
            if (dta.getType().equals((Object)DataProvider.JvDataType.ALIGNMENT)) {
                FileFormatI fmt = null;
                try {
                    fmt = new IdentifyFile().identify(src, false);
                }
                catch (Exception ex) {
                    exerror = ex;
                    errmsg = "Couldn't identify alignment format.";
                }
                if (fmt != null) {
                    AlignmentI al = null;
                    try {
                        al = new FormatAdapter().readFromFile(src, fmt);
                    }
                    catch (Exception e) {
                        errmsg = "Failed to parse alignment from result set";
                        exerror = e;
                    }
                    if (al != null) {
                        context.addAlignment(al);
                        context.updateSetModified(true);
                        rslt.add(al);
                        deuniquify = true;
                    }
                }
            }
            if (dta.getType().equals((Object)DataProvider.JvDataType.ANNOTATION)) {
                if (!context.hasAlignments()) {
                    errmsg = "No alignment or sequence dataset to associate annotation with.";
                }
                try {
                    BufferedReader br = src.getReader() instanceof BufferedReader ? (BufferedReader)src.getReader() : new BufferedReader(src.getReader());
                    if (new AnnotationFile().parseAnnotationFrom(context.getLastAlignment(), null, br)) {
                        context.updateSetModified(true);
                    } else {
                        errmsg = "Annotation file contained no data.";
                    }
                }
                catch (Exception e) {
                    errmsg = (String)(errmsg == null ? "" : errmsg) + "Failed to parse the annotation file associated with the alignment.";
                    exerror = e;
                }
            }
            if (dta.getType().equals((Object)DataProvider.JvDataType.SEQASSOCATED)) {
                if (!context.hasSequenceAssoc()) {
                    errmsg = "No sequence to associate data with.";
                }
                errmsg = "parsing of sequence associated data is not implemented";
                exerror = new Exception((String)errmsg);
            }
            if (dta.getType().equals((Object)DataProvider.JvDataType.FEATURES)) {
                if (context.featureColours == null) {
                    context.featureColours = new HashMap<String, FeatureColourI>();
                }
                try {
                    FeaturesFile ff = new FeaturesFile(src);
                    context.updateSetModified(ff.parse(context.getLastAlignment(), context.featureColours, false, context.relaxedIdMatching));
                }
                catch (Exception e) {
                    errmsg = "Failed to parse the Features file associated with the alignment.";
                    exerror = e;
                }
            }
            if (dta.getType().equals((Object)DataProvider.JvDataType.TREE)) {
                try {
                    NewickFile nf = new NewickFile(src);
                    if (!nf.isValid()) {
                        nf.close();
                        nf = null;
                    } else {
                        context.addTreeFromFile(nf);
                        rslt.add(nf);
                        context.updateSetModified(true);
                    }
                }
                catch (Exception e) {
                    errmsg = "Failed to parse the treeFile associated with the result.";
                    exerror = e;
                }
            }
            if (exerror != null) {
                if (errmsg != null && ((String)errmsg).length() > 0) {
                    throw new IOException((String)errmsg, exerror);
                }
                throw new IOException((String)errmsg, exerror);
            }
            if (errmsg == null || ((String)errmsg).length() <= 0) continue;
            throw new IOException((String)errmsg);
        }
        if (deuniquify) {
            context.getLastAlignmentSet().deuniquifyAlignment();
        }
        return rslt.toArray();
    }

    public static void main(String[] args) {
        Object[] newdm;
        JalviewDataset context;
        int i = 0;
        ArrayList<DataProvider> dp = new ArrayList<DataProvider>();
        while (i + 1 < args.length) {
            String type = args[i++];
            String file = args[i++];
            DataProvider.JvDataType jtype = DataProvider.JvDataType.valueOf(type.toUpperCase());
            if (jtype != null) {
                FileParse fp;
                try {
                    fp = new FileParse(file, AppletFormatAdapter.checkProtocol(file));
                }
                catch (Exception e) {
                    System.err.println("Couldn't handle datasource of type " + jtype + " using URI " + file);
                    e.printStackTrace();
                    return;
                }
                dp.add(new SimpleDataProvider(jtype, fp, null));
                continue;
            }
            System.out.println("Couldn't parse source type token '" + type.toUpperCase() + "'");
        }
        if (i < args.length) {
            System.out.print("** WARNING\nIgnoring unused arguments:\n");
            while (i < args.length) {
                System.out.print(" " + args[i]);
            }
            System.out.print("\n");
        }
        System.out.println("Now trying to parse set:");
        try {
            ParsePackedSet pps = new ParsePackedSet();
            context = new JalviewDataset();
            newdm = pps.getAlignment(context, dp);
        }
        catch (Exception e) {
            System.out.println("Test failed for these arguments.\n");
            e.printStackTrace(System.out);
            return;
        }
        if (newdm != null) {
            for (Object o : newdm) {
                System.out.println("Will need to create an " + o.getClass());
            }
        } else if (context.getLastAlignmentSet().isModified()) {
            System.err.println("Initial alignment set was modified and any associated views should be updated.");
        }
    }
}

