/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import java.io.IOException;

public class PhylipFile
extends AlignFile {
    public static final String FILE_DESC = "PHYLIP";

    public PhylipFile() {
    }

    public PhylipFile(FileParse source) throws IOException {
        super(source);
    }

    public PhylipFile(String inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    @Override
    public void parse() throws IOException {
        try {
            int i;
            String line = this.nextLine();
            String[] lineElements = line.trim().split("\\s+");
            if (lineElements.length < 2) {
                throw new IOException("First line must contain the number of specifies and number of characters");
            }
            int numberSpecies = Integer.parseInt(lineElements[0]);
            int numberCharacters = Integer.parseInt(lineElements[1]);
            if (numberSpecies <= 0) {
                return;
            }
            Sequence[] sequenceElements = new Sequence[numberSpecies];
            StringBuffer[] sequences = new StringBuffer[numberSpecies];
            for (i = 0; i < numberSpecies; ++i) {
                line = this.nextLine();
                String potentialName = line.substring(0, 10);
                int tabIndex = potentialName.indexOf(9);
                if (tabIndex == -1) {
                    sequenceElements[i] = this.parseId(this.validateName(potentialName));
                    sequences[i] = new StringBuffer(this.removeWhitespace(line.substring(10)));
                    continue;
                }
                sequenceElements[i] = this.parseId(this.validateName(potentialName.substring(0, tabIndex)));
                sequences[i] = new StringBuffer(this.removeWhitespace(line.substring(tabIndex)));
            }
            if (sequences[0].length() != numberCharacters) {
                i = 0;
                line = this.nextLine();
                while (line != null) {
                    if (line.length() > 0) {
                        sequences[i++].append(this.removeWhitespace(line));
                    }
                    if (i == sequences.length) {
                        i = 0;
                    }
                    line = this.nextLine();
                }
            }
            for (i = 0; i < numberSpecies; ++i) {
                if (sequences[i].length() != numberCharacters) {
                    throw new IOException(sequenceElements[i].getName() + " sequence is incorrect length - should be " + numberCharacters + " but is " + sequences[i].length());
                }
                sequenceElements[i].setSequence(sequences[i].toString());
                this.seqs.add(sequenceElements[i]);
            }
        }
        catch (IOException e) {
            System.err.println("Exception parsing PHYLIP file " + e);
            e.printStackTrace(System.err);
            throw e;
        }
    }

    private String removeWhitespace(String txt) {
        return txt.replaceAll("\\s*", "");
    }

    private String validateName(String name) throws IOException {
        char[] invalidCharacters;
        for (char c : invalidCharacters = new char[]{'(', ')', '[', ']', ':', ';', ','}) {
            if (name.indexOf(c) <= -1) continue;
            throw new IOException("Species name contains illegal character " + c);
        }
        return name;
    }

    @Override
    public String print(SequenceI[] sqs, boolean jvsuffix) {
        StringBuffer sb = new StringBuffer(Integer.toString(sqs.length));
        sb.append(" ");
        sb.append(sqs.length > 0 ? Integer.toString(sqs[0].getLength()) : "0").append(this.newline);
        boolean sequential = false;
        int numInterleavedColumns = 60;
        int sequenceLength = 0;
        for (SequenceI s : sqs) {
            String name = s.getName();
            name = name.length() > 10 ? name.substring(0, 10) : String.format("%1$-10s", s.getName());
            sb.append(name);
            if (sequential) {
                sb.append(s.getSequenceAsString());
            } else {
                sequenceLength = s.getLength();
                sb.append(s.getSequence(0, Math.min(numInterleavedColumns, sequenceLength)));
            }
            sb.append(this.newline);
        }
        if (!sequential && sequenceLength > numInterleavedColumns) {
            int numMatrics = sequenceLength / numInterleavedColumns;
            if (sequenceLength % numInterleavedColumns > 0) {
                ++numMatrics;
            }
            for (int i = 1; i < numMatrics; ++i) {
                sb.append(this.newline);
                int start = i * numInterleavedColumns;
                for (SequenceI s : sqs) {
                    sb.append(s.getSequence(start, Math.min(start + numInterleavedColumns, sequenceLength))).append(this.newline);
                }
            }
        }
        return sb.toString();
    }
}

