/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.api.AlignExportSettingI;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentExportData;
import jalview.exceptions.NoFileSelectedException;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.gui.IProgressIndicator;
import jalview.io.FileFormat;
import jalview.io.FormatAdapter;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.util.BrowserLauncher;
import jalview.util.MessageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Objects;

public abstract class HTMLOutput
implements Runnable {
    protected AlignmentPanel ap;
    protected long pSessionId;
    protected IProgressIndicator pIndicator;
    protected File generatedFile;

    public HTMLOutput(AlignmentPanel ap) {
        if (ap != null) {
            this.ap = ap;
            this.pIndicator = ap.alignFrame;
        }
    }

    public String getBioJSONData() {
        return this.getBioJSONData(null);
    }

    public String getBioJSONData(AlignExportSettingI exportSettings) {
        if (!this.isEmbedData()) {
            return null;
        }
        if (exportSettings == null) {
            exportSettings = new AlignExportSettingI(){

                @Override
                public boolean isExportHiddenSequences() {
                    return true;
                }

                @Override
                public boolean isExportHiddenColumns() {
                    return true;
                }

                @Override
                public boolean isExportAnnotations() {
                    return true;
                }

                @Override
                public boolean isExportFeatures() {
                    return true;
                }

                @Override
                public boolean isExportGroups() {
                    return true;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }
            };
        }
        AlignmentExportData exportData = AlignFrame.getAlignmentForExport(FileFormat.Json, this.ap.getAlignViewport(), exportSettings);
        String bioJSON = new FormatAdapter(this.ap, exportData.getSettings()).formatSequences(FileFormat.Json, exportData.getAlignment(), exportData.getOmitHidden(), exportData.getStartEndPostions(), this.ap.getAlignViewport().getAlignment().getHiddenColumns());
        return bioJSON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File file) throws IOException {
        InputStreamReader isReader = null;
        BufferedReader buffReader = null;
        StringBuilder sb = new StringBuilder();
        Objects.requireNonNull(file, "File must not be null!");
        URL url = file.toURL();
        if (url != null) {
            try {
                String line;
                isReader = new InputStreamReader(url.openStream());
                buffReader = new BufferedReader(isReader);
                String lineSeparator = System.getProperty("line.separator");
                while ((line = buffReader.readLine()) != null) {
                    sb.append(line).append(lineSeparator);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (isReader != null) {
                    isReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
            }
        }
        return sb.toString();
    }

    public static String getImageMapHTML() {
        return new String("<html>\n<head>\n<script language=\"JavaScript\">\nvar ns4 = document.layers;\nvar ns6 = document.getElementById && !document.all;\nvar ie4 = document.all;\noffsetX = 0;\noffsetY = 20;\nvar toolTipSTYLE=\"\";\nfunction initToolTips()\n{\n  if(ns4||ns6||ie4)\n  {\n    if(ns4) toolTipSTYLE = document.toolTipLayer;\n    else if(ns6) toolTipSTYLE = document.getElementById(\"toolTipLayer\").style;\n    else if(ie4) toolTipSTYLE = document.all.toolTipLayer.style;\n    if(ns4) document.captureEvents(Event.MOUSEMOVE);\n    else\n    {\n      toolTipSTYLE.visibility = \"visible\";\n      toolTipSTYLE.display = \"none\";\n    }\n    document.onmousemove = moveToMouseLoc;\n  }\n}\nfunction toolTip(msg, fg, bg)\n{\n  if(toolTip.arguments.length < 1) // hide\n  {\n    if(ns4) toolTipSTYLE.visibility = \"hidden\";\n    else toolTipSTYLE.display = \"none\";\n  }\n  else // show\n  {\n    if(!fg) fg = \"#555555\";\n    if(!bg) bg = \"#FFFFFF\";\n    var content =\n    '<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" bgcolor=\"' + fg + '\"><td>' +\n    '<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" bgcolor=\"' + bg + \n    '\"><td align=\"center\"><font face=\"sans-serif\" color=\"' + fg +\n    '\" size=\"-2\">&nbsp;' + msg +\n    '&nbsp;</font></td></table></td></table>';\n    if(ns4)\n    {\n      toolTipSTYLE.document.write(content);\n      toolTipSTYLE.document.close();\n      toolTipSTYLE.visibility = \"visible\";\n    }\n    if(ns6)\n    {\n      document.getElementById(\"toolTipLayer\").innerHTML = content;\n      toolTipSTYLE.display='block'\n    }\n    if(ie4)\n    {\n      document.all(\"toolTipLayer\").innerHTML=content;\n      toolTipSTYLE.display='block'\n    }\n  }\n}\nfunction moveToMouseLoc(e)\n{\n  if(ns4||ns6)\n  {\n    x = e.pageX;\n    y = e.pageY;\n  }\n  else\n  {\n    x = event.x + document.body.scrollLeft;\n    y = event.y + document.body.scrollTop;\n  }\n  toolTipSTYLE.left = x + offsetX;\n  toolTipSTYLE.top = y + offsetY;\n  return true;\n}\n</script>\n</head>\n<body>\n<div id=\"toolTipLayer\" style=\"position:absolute; visibility: hidden\"></div>\n<script language=\"JavaScript\"><!--\ninitToolTips(); //--></script>\n");
    }

    public String getOutputFile() throws NoFileSelectedException {
        String selectedFile = null;
        if (this.pIndicator != null && !this.isHeadless()) {
            this.pIndicator.setProgressBar(MessageManager.formatMessage("status.waiting_for_user_to_select_output_file", "HTML"), this.pSessionId);
        }
        JalviewFileChooser jvFileChooser = new JalviewFileChooser("html", "HTML files");
        jvFileChooser.setFileView(new JalviewFileView());
        jvFileChooser.setDialogTitle(MessageManager.getString("label.save_as_html"));
        jvFileChooser.setToolTipText(MessageManager.getString("action.save"));
        int fileChooserOpt = jvFileChooser.showSaveDialog(null);
        if (fileChooserOpt != 0) {
            throw new NoFileSelectedException("No file was selected.");
        }
        Cache.setProperty("LAST_DIRECTORY", jvFileChooser.getSelectedFile().getParent());
        selectedFile = jvFileChooser.getSelectedFile().getPath();
        return selectedFile;
    }

    protected void setProgressMessage(String message) {
        if (this.pIndicator != null && !this.isHeadless()) {
            this.pIndicator.setProgressBar(message, this.pSessionId);
        } else {
            System.out.println(message);
        }
    }

    protected boolean isHeadless() {
        return System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true");
    }

    protected void exportStarted() {
        this.pSessionId = System.currentTimeMillis();
    }

    protected void exportCompleted() {
        if (this.isLaunchInBrowserAfterExport() && !this.isHeadless()) {
            try {
                BrowserLauncher.openURL("file:///" + this.getExportedFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public abstract boolean isEmbedData();

    public abstract boolean isLaunchInBrowserAfterExport();

    public abstract File getExportedFile();

    public abstract void exportHTML(String var1);
}

